/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.client.spaceproxy.events;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.events.GSEventRegistration;
import com.gigaspaces.events.ManagedRemoteEventListener;
import com.gigaspaces.events.batching.BatchRemoteEvent;
import com.gigaspaces.events.batching.BatchRemoteEventListener;
import com.j_spaces.core.client.EntryArrivedRemoteEvent;
import java.rmi.RemoteException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jini.core.event.RemoteEvent;
import net.jini.core.event.UnknownEventException;

@InternalApi
public class MultiplexDataEventListener
implements ManagedRemoteEventListener,
BatchRemoteEventListener {
    private static final Logger logger = Logger.getLogger("com.gigaspaces.spaceproxy.data_events.listener");
    private final Map<String, RegistrationInfo> _registrations = new ConcurrentHashMap<String, RegistrationInfo>();

    public void close() {
        int remains = this._registrations.size();
        for (RegistrationInfo regInfo : this._registrations.values()) {
            --remains;
            try {
                regInfo.getEventRegistration().getLease().cancel();
            }
            catch (RemoteException ex) {
                logger.log(Level.WARNING, "Failed to close event registration " + regInfo.getEventRegistration() + " skipping more " + remains + " registrations");
                break;
            }
            catch (Exception ex) {
                logger.log(Level.CONFIG, "Failed to close event registration ", ex);
            }
        }
        this._registrations.clear();
    }

    public void add(String templateId, ManagedRemoteEventListener localListener) {
        this._registrations.put(templateId, new RegistrationInfo(localListener));
    }

    @Override
    public void init(GSEventRegistration registration) {
        RegistrationInfo regInfo = this._registrations.get(registration.getKey());
        regInfo.setEventRegistration(registration);
        regInfo.getListener().init(registration);
    }

    @Override
    public void shutdown(GSEventRegistration registration) {
        RegistrationInfo regInfo = this._registrations.remove(registration.getTemplateID());
        if (regInfo != null) {
            regInfo.getListener().shutdown(registration);
        }
    }

    public void notify(RemoteEvent event) throws UnknownEventException, RemoteException {
        RegistrationInfo regInfo = this._registrations.get(((EntryArrivedRemoteEvent)event).getKey());
        if (regInfo != null) {
            regInfo.getListener().notify(event);
        }
    }

    @Override
    public void notifyBatch(BatchRemoteEvent batchEvent) throws UnknownEventException, RemoteException {
        RegistrationInfo regInfo = this._registrations.get(batchEvent.getTemplateUID());
        if (regInfo != null) {
            ((BatchRemoteEventListener)((Object)regInfo.getListener())).notifyBatch(batchEvent);
        }
    }

    private static class RegistrationInfo {
        private final ManagedRemoteEventListener listener;
        private GSEventRegistration eventRegistration;

        public RegistrationInfo(ManagedRemoteEventListener listener) {
            this.listener = listener;
        }

        public ManagedRemoteEventListener getListener() {
            return this.listener;
        }

        public GSEventRegistration getEventRegistration() {
            return this.eventRegistration;
        }

        public void setEventRegistration(GSEventRegistration eventRegistration) {
            this.eventRegistration = eventRegistration;
        }
    }
}

