/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.client.spaceproxy.events;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.events.GSEventRegistration;
import com.gigaspaces.events.batching.BatchRemoteEvent;
import com.gigaspaces.internal.client.spaceproxy.events.DataEventListener;
import com.gigaspaces.lrmi.GenericExporter;
import com.j_spaces.core.IJSpace;
import com.j_spaces.core.client.EntryArrivedRemoteEvent;
import java.lang.ref.WeakReference;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.util.concurrent.ExecutorService;
import net.jini.core.event.RemoteEvent;
import net.jini.core.event.RemoteEventListener;
import net.jini.core.event.UnknownEventException;

@InternalApi
public class SpaceProxyDataEventListener
extends DataEventListener {
    private final WeakReference<IJSpace> _space;
    private final GenericExporter _exporter;

    public SpaceProxyDataEventListener(RemoteEventListener listener, ExecutorService threadPool, IJSpace space, GenericExporter exporter) {
        super(listener, threadPool);
        this._space = new WeakReference<IJSpace>(space);
        this._exporter = exporter;
    }

    @Override
    public void shutdown(GSEventRegistration registration) {
        try {
            if (this._exporter != null) {
                this._exporter.unexport((Remote)((Object)this));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        super.shutdown(registration);
    }

    @Override
    public void notify(RemoteEvent event) throws UnknownEventException, RemoteException {
        IJSpace space = (IJSpace)this._space.get();
        if (space != null) {
            ((EntryArrivedRemoteEvent)event).setSpaceProxy(space);
            super.notify(event);
        }
    }

    @Override
    public void notifyBatch(BatchRemoteEvent batchEvent) throws UnknownEventException, RemoteException {
        IJSpace space = (IJSpace)this._space.get();
        if (space != null) {
            batchEvent.setSpaceProxy(space);
            super.notifyBatch(batchEvent);
        }
    }
}

