/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.client.spaceproxy.events;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.config.lrmi.ITransportConfig;
import com.gigaspaces.config.lrmi.nio.NIOConfiguration;
import com.gigaspaces.events.GSEventRegistration;
import com.gigaspaces.events.ManagedRemoteEventListener;
import com.gigaspaces.events.NotifyInfo;
import com.gigaspaces.events.batching.BatchRemoteEventListener;
import com.gigaspaces.events.batching.LRMIBatchNotifyDelegatorListener;
import com.gigaspaces.events.lease.EventLeaseRenewalManager;
import com.gigaspaces.internal.client.spaceproxy.SpaceProxyImpl;
import com.gigaspaces.internal.client.spaceproxy.actioninfo.NotifyProxyActionInfo;
import com.gigaspaces.internal.client.spaceproxy.events.BatchLeaseRenewalManager;
import com.gigaspaces.internal.client.spaceproxy.events.FifoDataEventListener;
import com.gigaspaces.internal.client.spaceproxy.events.MultiplexDataEventListener;
import com.gigaspaces.internal.client.spaceproxy.events.SpaceProxyDataEventListener;
import com.gigaspaces.internal.client.spaceproxy.operations.RegisterEntriesListenerSpaceOperationRequest;
import com.gigaspaces.internal.client.spaceproxy.operations.RegisterEntriesListenerSpaceOperationResult;
import com.gigaspaces.internal.lease.SpaceNotifyLease;
import com.gigaspaces.internal.lrmi.stubs.LRMINotifyDelegatorListener;
import com.gigaspaces.internal.transport.ITemplatePacket;
import com.gigaspaces.lrmi.GenericExporter;
import com.j_spaces.core.LeaseContext;
import com.j_spaces.core.exception.internal.InterruptedSpaceException;
import com.j_spaces.core.service.ServiceConfigLoader;
import com.j_spaces.jdbc.builder.SQLQueryTemplatePacket;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.server.ExportException;
import java.util.concurrent.ExecutorService;
import java.util.logging.Logger;
import net.jini.core.event.EventRegistration;
import net.jini.core.event.RemoteEventListener;
import net.jini.export.Exporter;

@InternalApi
public class SpaceProxyDataEventsManager {
    private final Logger _logger;
    private final SpaceProxyImpl _spaceProxy;
    private final MultiplexDataEventListener _multiplexListener;
    private final EventLeaseRenewalManager _renewalManager;
    private final GenericExporter _exporter;
    private final ITransportConfig _remoteTransportConfiguration;
    private final ExecutorService _threadPool;
    private final boolean _slowConsumer;

    public SpaceProxyDataEventsManager(SpaceProxyImpl spaceProxy, ITransportConfig remoteTransportConfig) {
        this._logger = Logger.getLogger("com.gigaspaces.spaceproxy.data_events." + spaceProxy.getName());
        this._spaceProxy = spaceProxy;
        this._multiplexListener = new MultiplexDataEventListener();
        Exporter exporter = ServiceConfigLoader.getExporter();
        if (!(exporter instanceof GenericExporter)) {
            throw new IllegalArgumentException("Encountered usage of an Exporter which is not GenericExporter");
        }
        this._exporter = (GenericExporter)exporter;
        this._remoteTransportConfiguration = remoteTransportConfig;
        this._slowConsumer = this._remoteTransportConfiguration.getSlowConsumerThroughput() > 0;
        this._threadPool = this._spaceProxy.getThreadPool();
        this._renewalManager = new BatchLeaseRenewalManager(this._spaceProxy, this._logger);
    }

    public void close() {
        this._renewalManager.close();
        this._multiplexListener.close();
        this._spaceProxy.getStubHandler().unexportObject((Remote)((Object)this._multiplexListener));
    }

    public Logger getLogger() {
        return this._logger;
    }

    public EventLeaseRenewalManager getRenewalManager() {
        return this._renewalManager;
    }

    public EventRegistration addListener(Object template, long lease, NotifyInfo notifyInfo, boolean isMultiplex) throws RemoteException {
        try {
            this._spaceProxy.beforeSpaceAction();
            ITemplatePacket templatePacket = this.createTemplatePacket(template);
            if (!notifyInfo.isFifo() && (this._spaceProxy.isFifo() || templatePacket.getTypeDescriptor() != null && templatePacket.getTypeDescriptor().isFifoDefault())) {
                notifyInfo.setFifo(true);
            }
            this.wrapAndExportListener(notifyInfo, isMultiplex);
            RegisterEntriesListenerSpaceOperationRequest request = new RegisterEntriesListenerSpaceOperationRequest(templatePacket, notifyInfo, lease);
            this._spaceProxy.getProxyRouter().execute(request);
            RegisterEntriesListenerSpaceOperationResult result = request.getFinalResult();
            result.processExecutionException();
            GSEventRegistration eventRegistration = result.getEventRegistration();
            eventRegistration.setLease(new SpaceNotifyLease(this._spaceProxy, templatePacket.getTypeName(), ((LeaseContext)eventRegistration.getLease()).getUID(), templatePacket.getRoutingFieldValue(), eventRegistration.getLease().getExpiration(), (ManagedRemoteEventListener)notifyInfo.getListener(), eventRegistration));
            return eventRegistration;
        }
        catch (InterruptedException e) {
            throw new InterruptedSpaceException(e);
        }
    }

    private ITemplatePacket createTemplatePacket(Object template) {
        NotifyProxyActionInfo actionInfo = new NotifyProxyActionInfo(this._spaceProxy, template);
        if (actionInfo.isSqlQuery) {
            return this._spaceProxy.getQueryManager().getSQLTemplate((SQLQueryTemplatePacket)actionInfo.queryPacket, null);
        }
        return actionInfo.queryPacket;
    }

    private void wrapAndExportListener(NotifyInfo info, boolean isMultiplex) throws ExportException {
        ManagedRemoteEventListener listenerToExport;
        String templateId = info.getOrInitTemplateUID();
        if (info.isFifo()) {
            info.setListener(new FifoDataEventListener(info.getListener(), this._threadPool, info));
        }
        if (isMultiplex) {
            this._multiplexListener.add(templateId, new SpaceProxyDataEventListener(info.getListener(), this._threadPool, this._spaceProxy, null));
            listenerToExport = this._multiplexListener;
        } else {
            listenerToExport = new SpaceProxyDataEventListener(info.getListener(), this._threadPool, this._spaceProxy, this._exporter);
        }
        info.setListener(this.export(listenerToExport, info));
    }

    private ManagedRemoteEventListener export(ManagedRemoteEventListener remoteListener, NotifyInfo info) throws ExportException {
        ITransportConfig localLRMIConfig;
        ITransportConfig config = localLRMIConfig = this._exporter.getConfiguration();
        if (this._slowConsumer && this._remoteTransportConfiguration instanceof NIOConfiguration) {
            config = this._remoteTransportConfiguration.clone();
            ((NIOConfiguration)config).setBindHost(((NIOConfiguration)localLRMIConfig).getBindHostName());
            ((NIOConfiguration)config).setBindPort(((NIOConfiguration)localLRMIConfig).getBindPort());
            ((NIOConfiguration)config).setBlockingConnection(false);
        }
        RemoteEventListener rel = (RemoteEventListener)this._exporter.export((Remote)((Object)remoteListener), config, false);
        return info.isBatching() ? new LRMIBatchNotifyDelegatorListener((BatchRemoteEventListener)((Object)remoteListener), (BatchRemoteEventListener)rel) : new LRMINotifyDelegatorListener(remoteListener, rel);
    }
}

