/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.client.spaceproxy.executors;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.async.AsyncFuture;
import com.gigaspaces.async.AsyncFutureListener;
import com.gigaspaces.async.AsyncResult;
import com.gigaspaces.internal.client.spaceproxy.SpaceProxyImpl;
import com.gigaspaces.internal.client.spaceproxy.executors.AddTypeIndexesTask;
import com.gigaspaces.internal.client.spaceproxy.executors.TypeDescriptorActionsProxyExecutor;
import com.gigaspaces.internal.metadata.ITypeDesc;
import com.gigaspaces.internal.space.actions.GetTypeDescriptorActionInfo;
import com.gigaspaces.internal.space.requests.AddTypeIndexesRequestInfo;
import com.gigaspaces.internal.space.requests.RegisterTypeDescriptorRequestInfo;
import com.gigaspaces.internal.space.responses.AddTypeIndexesResponseInfo;
import com.gigaspaces.metadata.SpaceMetadataException;
import com.gigaspaces.metadata.index.AddTypeIndexesResult;
import java.rmi.RemoteException;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jini.core.transaction.TransactionException;

@InternalApi
public class SpaceProxyImplTypeDescriptorActionsExecutor
extends TypeDescriptorActionsProxyExecutor<SpaceProxyImpl> {
    private static final Logger _logger = Logger.getLogger("com.gigaspaces.space.typemanager");

    @Override
    public ITypeDesc getTypeDescriptor(SpaceProxyImpl spaceProxy, GetTypeDescriptorActionInfo actionInfo) throws RemoteException {
        return spaceProxy.getTypeManager().getTypeDescByNameIfExists(actionInfo.typeName);
    }

    @Override
    public void registerTypeDescriptor(SpaceProxyImpl spaceProxy, RegisterTypeDescriptorRequestInfo requestInfo) throws RemoteException {
        spaceProxy.getTypeManager().registerTypeDesc(requestInfo.typeDescriptor);
    }

    @Override
    public ITypeDesc registerTypeDescriptor(SpaceProxyImpl spaceProxy, Class<?> type) throws RemoteException {
        return spaceProxy.getTypeManager().getTypeDescByName(type.getName());
    }

    @Override
    public AsyncFuture<AddTypeIndexesResult> asyncAddIndexes(SpaceProxyImpl spaceProxy, AddTypeIndexesRequestInfo requestInfo) throws RemoteException {
        ITypeDesc typeDesc = spaceProxy.getTypeDescriptor(requestInfo.getTypeName());
        if (typeDesc == null) {
            throw new SpaceMetadataException("Cannot add indexes  - type is not registered [" + requestInfo.getTypeName() + "].");
        }
        try {
            AsyncFuture result = spaceProxy.execute(new AddTypeIndexesTask(requestInfo), null, null, null);
            result.setListener(new AsyncAddIndexesListener(spaceProxy, requestInfo));
            return result;
        }
        catch (TransactionException e) {
            throw new SpaceMetadataException("Error adding new index to type [" + requestInfo.getTypeName() + "]", e);
        }
    }

    private static class AsyncAddIndexesListener
    implements AsyncFutureListener<AddTypeIndexesResult> {
        private final SpaceProxyImpl _spaceProxy;
        private final AddTypeIndexesRequestInfo _requestInfo;

        public AsyncAddIndexesListener(SpaceProxyImpl spaceProxy, AddTypeIndexesRequestInfo requestInfo) {
            this._spaceProxy = spaceProxy;
            this._requestInfo = requestInfo;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onResult(AsyncResult<AddTypeIndexesResult> result) {
            block11: {
                try {
                    AddTypeIndexesResponseInfo responseInfo;
                    if (result.getException() != null || (responseInfo = (AddTypeIndexesResponseInfo)result.getResult()).getMetadataException() != null) break block11;
                    Object object = this._spaceProxy.getTypeManager().getLockObject();
                    synchronized (object) {
                        for (ITypeDesc updatedTypeDesc : responseInfo.getUpdatedTypeDescriptors()) {
                            this._spaceProxy.getTypeManager().registerTypeDesc(updatedTypeDesc);
                        }
                        this._spaceProxy.getQueryManager().clean();
                    }
                }
                catch (RuntimeException e) {
                    if (_logger.isLoggable(Level.SEVERE)) {
                        _logger.log(Level.SEVERE, "Failed to add index.", e);
                    }
                    throw e;
                }
                finally {
                    if (this._requestInfo.getListener() != null) {
                        this._requestInfo.getListener().onResult(result);
                    }
                }
            }
        }
    }
}

