/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.client.spaceproxy.metadata;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.document.SpaceDocument;
import com.gigaspaces.internal.client.spaceproxy.IDirectSpaceProxy;
import com.gigaspaces.internal.client.spaceproxy.metadata.ObjectType;
import com.gigaspaces.internal.client.spaceproxy.metadata.TypeDescFactory;
import com.gigaspaces.internal.metadata.ITypeDesc;
import com.gigaspaces.internal.reflection.ReflectionUtil;
import com.gigaspaces.internal.transport.IEntryPacket;
import com.gigaspaces.internal.transport.ITransportPacket;
import com.gigaspaces.internal.utils.ClassLoaderUtils;
import com.gigaspaces.internal.utils.collections.CopyOnUpdateMap;
import com.gigaspaces.metadata.SpaceMetadataException;
import com.j_spaces.core.UidQueryPacket;
import com.j_spaces.core.UnknownTypeException;
import com.j_spaces.core.client.ExternalEntry;
import com.j_spaces.core.client.SQLQuery;
import com.j_spaces.kernel.ClassLoaderHelper;
import java.net.MalformedURLException;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jini.core.entry.Entry;
import org.jini.rio.boot.CodeChangeClassLoader;

@InternalApi
public class ClientTypeDescRepository {
    private static final Logger _logger = Logger.getLogger("com.gigaspaces.metadata");
    private final IDirectSpaceProxy _spaceProxy;
    private final Map<String, ITypeDesc> _typeMap;
    private final TypeDescFactory _typeDescFactory;
    private final Object _lock;
    private final String _defaultCodebase;

    public ClientTypeDescRepository(IDirectSpaceProxy spaceProxy) {
        ClientTypeDescRepository.logEnter("ClientTypeDescRepository.ctor", "spaceProxy.getClientID()", spaceProxy.getClientID());
        this._spaceProxy = spaceProxy;
        this._typeMap = new CopyOnUpdateMap<String, ITypeDesc>();
        this._typeDescFactory = new TypeDescFactory(spaceProxy);
        this._lock = new Object();
        this._defaultCodebase = this._spaceProxy.getProxySettings().getCodebase();
        ClientTypeDescRepository.logExit("ClientTypeDescRepository.ctor", "spaceProxy.getClientID()", spaceProxy.getClientID());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerTypeDesc(ITypeDesc typeDesc) {
        if (typeDesc == null) {
            throw new IllegalArgumentException("Argument cannot be null - 'typeDesc'.");
        }
        String typeName = typeDesc.getTypeName();
        ClientTypeDescRepository.logEnter("ClientTypeDescRepository.registerTypeDesc", "typeName", typeName);
        ITypeDesc oldTypeDesc = this._typeMap.get(typeName);
        if (oldTypeDesc != typeDesc) {
            Object object = this._lock;
            synchronized (object) {
                this.registerTypeDesc(typeName, typeDesc, false);
            }
        }
        ClientTypeDescRepository.logExit("ClientTypeDescRepository.registerTypeDesc", "typeName", typeName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(String typeName) {
        ClientTypeDescRepository.logEnter("ClientTypeDescRepository.remove", "typeName", typeName);
        Object object = this._lock;
        synchronized (object) {
            this._typeMap.remove(typeName);
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "Removed type '" + typeName + "' from proxy type manager.");
            }
        }
        ClientTypeDescRepository.logExit("ClientTypeDescRepository.remove", "typeName", typeName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        ClientTypeDescRepository.logEnter("ClientTypeDescRepository.clear", "", "");
        Object object = this._lock;
        synchronized (object) {
            this._typeMap.clear();
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "Cleared all types from proxy type manager.");
            }
        }
        ClientTypeDescRepository.logExit("ClientTypeDescRepository.clear", "", "");
    }

    public ITypeDesc getTypeDescIfExistsInProxy(String typeName) {
        ClientTypeDescRepository.logEnter("ClientTypeDescRepository.getTypeDescIfExistsInProxy", "typeName", typeName);
        ITypeDesc typeDesc = this._typeMap.get(typeName);
        if (typeDesc == null && _logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "Proxy type manager does not contain type descriptor for type '" + typeName + "'.");
        }
        ClientTypeDescRepository.logExit("ClientTypeDescRepository.getTypeDescIfExistsInProxy", "typeName", typeName);
        return typeDesc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public ITypeDesc getTypeDescIfExistsInServer(String typeName) {
        ITypeDesc typeDesc;
        block12: {
            block11: {
                ITypeDesc iTypeDesc;
                ClientTypeDescRepository.logEnter("ClientTypeDescRepository.getTypeDescIfExistsInServer", "typeName", typeName);
                try {
                    typeDesc = this._typeMap.get(typeName);
                    if (!ClientTypeDescRepository.isValid(typeDesc)) break block11;
                    iTypeDesc = typeDesc;
                }
                catch (Throwable throwable) {
                    ClientTypeDescRepository.logExit("ClientTypeDescRepository.getTypeDescIfExistsInServer", "typeName", typeName);
                    throw throwable;
                }
                ClientTypeDescRepository.logExit("ClientTypeDescRepository.getTypeDescIfExistsInServer", "typeName", typeName);
                return iTypeDesc;
            }
            Object object = this._lock;
            // MONITORENTER : object
            typeDesc = this._typeMap.get(typeName);
            if (!ClientTypeDescRepository.isValid(typeDesc)) break block12;
            ITypeDesc iTypeDesc = typeDesc;
            // MONITOREXIT : object
            ClientTypeDescRepository.logExit("ClientTypeDescRepository.getTypeDescIfExistsInServer", "typeName", typeName);
            return iTypeDesc;
        }
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "Proxy type manager does not contain type descriptor for type '" + typeName + "', searching server.");
        }
        if (ClientTypeDescRepository.isValid(typeDesc = this._spaceProxy.getTypeDescFromServer(typeName))) {
            this._typeMap.put(typeName, typeDesc);
        } else if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "Server type manager does not contain type descriptor for type '" + typeName + "'.");
        }
        ITypeDesc iTypeDesc = typeDesc;
        // MONITOREXIT : object
        ClientTypeDescRepository.logExit("ClientTypeDescRepository.getTypeDescIfExistsInServer", "typeName", typeName);
        return iTypeDesc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public ITypeDesc getTypeDescByName(String typeName, String codebase) {
        ITypeDesc typeDesc;
        block8: {
            block7: {
                ITypeDesc iTypeDesc;
                ClientTypeDescRepository.logEnter("ClientTypeDescRepository.getTypeDescByName", "typeName", typeName);
                try {
                    typeDesc = this._typeMap.get(typeName);
                    if (!ClientTypeDescRepository.isValid(typeDesc)) break block7;
                    iTypeDesc = typeDesc;
                }
                catch (Throwable throwable) {
                    ClientTypeDescRepository.logExit("ClientTypeDescRepository.getTypeDescByName", "typeName", typeName);
                    throw throwable;
                }
                ClientTypeDescRepository.logExit("ClientTypeDescRepository.getTypeDescByName", "typeName", typeName);
                return iTypeDesc;
            }
            Object object = this._lock;
            // MONITORENTER : object
            typeDesc = this._typeMap.get(typeName);
            if (!ClientTypeDescRepository.isValid(typeDesc)) break block8;
            ITypeDesc iTypeDesc = typeDesc;
            // MONITOREXIT : object
            ClientTypeDescRepository.logExit("ClientTypeDescRepository.getTypeDescByName", "typeName", typeName);
            return iTypeDesc;
        }
        typeDesc = this.loadTypeDesc(typeName, codebase, null);
        this.registerTypeDesc(typeName, typeDesc, true);
        ITypeDesc iTypeDesc = typeDesc;
        // MONITOREXIT : object
        ClientTypeDescRepository.logExit("ClientTypeDescRepository.getTypeDescByName", "typeName", typeName);
        return iTypeDesc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public ITypeDesc getTypeDescByExternalEntry(ExternalEntry externalEntry) {
        ITypeDesc typeDesc;
        String typeName;
        block9: {
            block8: {
                ITypeDesc iTypeDesc;
                typeName = externalEntry.getClassName();
                if (typeName == null) throw new IllegalArgumentException("Cannot get type descriptor from external entry because the class name was not set.");
                if (typeName.length() == 0) {
                    throw new IllegalArgumentException("Cannot get type descriptor from external entry because the class name was not set.");
                }
                ClientTypeDescRepository.logEnter("ClientTypeDescRepository.getTypeDescByExternalEntry", "typeName", typeName);
                try {
                    typeDesc = this._typeMap.get(typeName);
                    if (!ClientTypeDescRepository.isValid(typeDesc)) break block8;
                    iTypeDesc = typeDesc;
                }
                catch (Throwable throwable) {
                    ClientTypeDescRepository.logExit("ClientTypeDescRepository.getTypeDescByExternalEntry", "typeName", typeName);
                    throw throwable;
                }
                ClientTypeDescRepository.logExit("ClientTypeDescRepository.getTypeDescByExternalEntry", "typeName", typeName);
                return iTypeDesc;
            }
            Object object = this._lock;
            // MONITORENTER : object
            typeDesc = this._typeMap.get(typeName);
            if (!ClientTypeDescRepository.isValid(typeDesc)) break block9;
            ITypeDesc iTypeDesc = typeDesc;
            // MONITOREXIT : object
            ClientTypeDescRepository.logExit("ClientTypeDescRepository.getTypeDescByExternalEntry", "typeName", typeName);
            return iTypeDesc;
        }
        typeDesc = this.loadTypeDesc(typeName, externalEntry.getCodebase(), externalEntry);
        this.registerTypeDesc(typeName, typeDesc, true);
        ITypeDesc iTypeDesc = typeDesc;
        // MONITOREXIT : object
        ClientTypeDescRepository.logExit("ClientTypeDescRepository.getTypeDescByExternalEntry", "typeName", typeName);
        return iTypeDesc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public ITypeDesc getTypeDescByJavaObject(Object object, ObjectType objectType) {
        ITypeDesc typeDesc;
        String typeName;
        Class<?> type;
        block13: {
            block12: {
                ITypeDesc iTypeDesc;
                type = object.getClass();
                typeName = type.getName();
                ClientTypeDescRepository.logEnter("ClientTypeDescRepository.getTypeDescByJavaObject", "typeName", typeName);
                try {
                    typeDesc = this._typeMap.get(typeName);
                    if (!ClientTypeDescRepository.isValid(typeDesc) || !ClientTypeDescRepository.hasRequiredIntrospector(typeDesc, objectType)) break block12;
                    iTypeDesc = typeDesc;
                }
                catch (Throwable throwable) {
                    ClientTypeDescRepository.logExit("ClientTypeDescRepository.getTypeDescByJavaObject", "typeName", typeName);
                    throw throwable;
                }
                ClientTypeDescRepository.logExit("ClientTypeDescRepository.getTypeDescByJavaObject", "typeName", typeName);
                return iTypeDesc;
            }
            Object object2 = this._lock;
            // MONITORENTER : object2
            typeDesc = this._typeMap.get(typeName);
            if (!ClientTypeDescRepository.isValid(typeDesc) || !ClientTypeDescRepository.hasRequiredIntrospector(typeDesc, objectType)) break block13;
            ITypeDesc iTypeDesc = typeDesc;
            // MONITOREXIT : object2
            ClientTypeDescRepository.logExit("ClientTypeDescRepository.getTypeDescByJavaObject", "typeName", typeName);
            return iTypeDesc;
        }
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "Proxy type manager does not contain type descriptor for type '" + typeName + "', creating type descriptor from " + (Object)((Object)objectType) + ".");
        }
        String codebase = this._defaultCodebase;
        switch (objectType) {
            case POJO: {
                typeDesc = this.loadPojoTypeDesc(type, codebase);
                break;
            }
            case ENTRY: {
                typeDesc = this._typeDescFactory.createEntryTypeDesc((Entry)object, type.getName(), codebase, type);
                break;
            }
            default: {
                throw new UnsupportedOperationException("This operation is not supported for ObjectType " + (Object)((Object)objectType));
            }
        }
        this.registerTypeDesc(typeName, typeDesc, true);
        ITypeDesc iTypeDesc = typeDesc;
        // MONITOREXIT : object2
        ClientTypeDescRepository.logExit("ClientTypeDescRepository.getTypeDescByJavaObject", "typeName", typeName);
        return iTypeDesc;
    }

    public ITypeDesc getTypeDescByObject(Object object, ObjectType objectType) {
        ClientTypeDescRepository.logEnter("ClientTypeDescRepository.getTypeDescByObject", "objectType", (Object)objectType);
        try {
            if (objectType.isConcrete()) {
                ITypeDesc iTypeDesc = this.getTypeDescByJavaObject(object, objectType);
                return iTypeDesc;
            }
            switch (objectType) {
                case DOCUMENT: {
                    ITypeDesc iTypeDesc = this.getTypeDescByName(((SpaceDocument)object).getTypeName(), null);
                    return iTypeDesc;
                }
                case EXTERNAL_ENTRY: {
                    ITypeDesc iTypeDesc = this.getTypeDescByExternalEntry((ExternalEntry)object);
                    return iTypeDesc;
                }
                case ENTRY_PACKET: 
                case TEMPLATE_PACKET: {
                    IEntryPacket packet = (IEntryPacket)object;
                    this.loadTypeDescToPacket(packet);
                    ITypeDesc iTypeDesc = packet.getTypeDescriptor();
                    return iTypeDesc;
                }
            }
            throw new IllegalArgumentException("Unsupported object type: " + (Object)((Object)objectType));
        }
        finally {
            ClientTypeDescRepository.logExit("ClientTypeDescRepository.getTypeDescByObject", "objectType", (Object)objectType);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ITypeDesc getTypeDescBySQLQuery(SQLQuery<?> sqlQuery) {
        String typeName = sqlQuery.getTypeName();
        ClientTypeDescRepository.logEnter("ClientTypeDescRepository.getTypeDescBySQLQuery", "typeName", typeName);
        try {
            Object template = sqlQuery.getObject();
            if (template == null) {
                ITypeDesc iTypeDesc = this.getTypeDescByName(sqlQuery.getTypeName(), null);
                return iTypeDesc;
            }
            ITypeDesc iTypeDesc = this.getTypeDescByObject(template, ObjectType.fromObject(template));
            return iTypeDesc;
        }
        finally {
            ClientTypeDescRepository.logExit("ClientTypeDescRepository.getTypeDescBySQLQuery", "typeName", sqlQuery.getTypeName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void loadTypeDescToPacket(ITransportPacket packet) {
        String typeName = packet.getTypeName();
        ClientTypeDescRepository.logEnter("ClientTypeDescRepository.loadTypeDescToPacket", "typeName", typeName);
        try {
            if (typeName == null) {
                if (!(packet instanceof UidQueryPacket)) throw new IllegalArgumentException("packet.getClassName() cannot be null. packet type: " + packet.getClass().getName());
                return;
            }
            ITypeDesc packetTypeDesc = packet.getTypeDescriptor();
            ITypeDesc typeDesc = null;
            try {
                typeDesc = this._typeMap.get(typeName);
                if (ClientTypeDescRepository.isValid(typeDesc)) {
                    return;
                }
                Object object = this._lock;
                synchronized (object) {
                    typeDesc = this._typeMap.get(typeName);
                    if (ClientTypeDescRepository.isValid(typeDesc)) {
                        return;
                    }
                    if (_logger.isLoggable(Level.FINE)) {
                        _logger.log(Level.FINE, "Proxy type manager does not contain type descriptor for type '" + typeName + "', using packet's type descriptor.");
                    }
                    if ((typeDesc = packetTypeDesc) == null) {
                        if (_logger.isLoggable(Level.FINE)) {
                            _logger.log(Level.FINE, "Packet's type descriptor is null, loading type '" + typeName + "' by name.");
                        }
                        typeDesc = this.getTypeDescByName(typeName, null);
                    }
                    this.registerTypeDesc(typeName, typeDesc, true);
                    return;
                }
            }
            finally {
                if (typeDesc != null && typeDesc != packetTypeDesc) {
                    if (packetTypeDesc != null) {
                        // empty if block
                    }
                    packet.setTypeDesc(typeDesc, packet.isSerializeTypeDesc());
                }
            }
        }
        finally {
            ClientTypeDescRepository.logExit("ClientTypeDescRepository.loadTypeDescToPacket", "typeName", typeName);
        }
    }

    public String getCommonSuperTypeName(ITypeDesc typeDesc1, ITypeDesc typeDesc2) {
        if (typeDesc1 == null || typeDesc2 == null) {
            return null;
        }
        if (typeDesc1 == typeDesc2 || typeDesc1.getTypeName().equals(typeDesc2.getTypeName())) {
            return typeDesc1.getTypeName();
        }
        String[] types1 = typeDesc1.getSuperClassesNames();
        String[] types2 = typeDesc2.getSuperClassesNames();
        String result = null;
        int i1 = types1.length - 1;
        for (int i2 = types2.length - 1; i1 >= 0 && i2 >= 0 && types1[i1].equals(types2[i2]); --i1, --i2) {
            result = types1[i1];
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ITypeDesc loadPojoTypeDesc(Class<?> type, String codebase) {
        String typeName = type.getName();
        ClientTypeDescRepository.logEnter("ClientTypeDescRepository.loadPojoTypeDesc", "typeName", typeName);
        try {
            ITypeDesc typeDesc = this._typeMap.get(type.getName());
            if (ClientTypeDescRepository.isValid(typeDesc) && typeDesc.isConcreteType()) {
                ITypeDesc iTypeDesc = typeDesc;
                return iTypeDesc;
            }
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "Proxy type manager does not contain type descriptor for POJO class '" + typeName + "', creating it.");
            }
            if (this._spaceProxy.isEmbedded() && ClassLoaderUtils.isUnderClassLoader(type, CodeChangeClassLoader.class) && this._spaceProxy.getSpaceImplIfEmbedded().getEngine().getTypeManager().getServerTypeDesc(type.getName()) == null) {
                throw new UnsupportedOperationException("Cannot introduce Class [" + type.getName() + "] to the space because it was loaded via a class annotated with @SupportCodeChange");
            }
            Class<?> superType = type.getSuperclass();
            ITypeDesc superTypeDesc = superType == null ? null : this.loadPojoTypeDesc(superType, codebase);
            typeDesc = this._typeDescFactory.createPojoTypeDesc(type, codebase, superTypeDesc);
            this.registerTypeDesc(typeDesc.getTypeName(), typeDesc, true);
            ITypeDesc iTypeDesc = typeDesc;
            return iTypeDesc;
        }
        finally {
            ClientTypeDescRepository.logExit("ClientTypeDescRepository.loadPojoTypeDesc", "typeName", typeName);
        }
    }

    private ITypeDesc loadTypeDesc(String typeName, String codebase, ExternalEntry externalEntry) {
        ClientTypeDescRepository.logEnter("ClientTypeDescRepository.loadTypeDesc", "typeName", typeName);
        try {
            ITypeDesc serverTypeDesc;
            Class<?> realClass;
            if (codebase == null) {
                codebase = this._defaultCodebase;
            }
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "Proxy type manager does not contain type descriptor for type '" + typeName + "', searching for a java class by the same name.");
            }
            if ((realClass = ClientTypeDescRepository.getRealClass(typeName, codebase)) != null) {
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.log(Level.FINE, "Java class '" + typeName + "' was found, creating space type descriptor.");
                }
                if (Entry.class.isAssignableFrom(realClass)) {
                    ITypeDesc iTypeDesc = this._typeDescFactory.createEntryTypeDesc(null, typeName, codebase, realClass);
                    return iTypeDesc;
                }
                ITypeDesc iTypeDesc = this.loadPojoTypeDesc(realClass, codebase);
                return iTypeDesc;
            }
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "Java class '" + typeName + "' was not found, searching server.");
            }
            if (ClientTypeDescRepository.isValid(serverTypeDesc = this._spaceProxy.getTypeDescFromServer(typeName))) {
                ITypeDesc iTypeDesc = serverTypeDesc;
                return iTypeDesc;
            }
            if (externalEntry != null) {
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.log(Level.FINE, "Server type manager does not contain type descriptor for type '" + typeName + "', loading type descriptor from ExternalEntry.");
                }
                ITypeDesc iTypeDesc = this._typeDescFactory.createExternalEntryTypeDesc(externalEntry, codebase);
                return iTypeDesc;
            }
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "Server type manager does not contain type descriptor for type '" + typeName + "'.");
            }
            String message = "Failed to load space type descriptor for type '" + typeName + "'.";
            throw new SpaceMetadataException(message, new UnknownTypeException(message, typeName));
        }
        finally {
            ClientTypeDescRepository.logExit("ClientTypeDescRepository.loadTypeDesc", "typeName", typeName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerTypeDesc(String typeName, ITypeDesc typeDesc, boolean ignoreException) {
        block11: {
            ClientTypeDescRepository.logEnter("ClientTypeDescRepository.registerTypeDesc", "typeName", typeName);
            try {
                if (typeDesc == null) {
                    throw new SpaceMetadataException("Failed to load space type descriptor for type '" + typeName + "'.");
                }
                ITypeDesc oldTypeDesc = this._typeMap.get(typeDesc.getTypeName());
                if (oldTypeDesc == typeDesc) break block11;
                if (oldTypeDesc != null) {
                    // empty if block
                }
                try {
                    ITypeDesc typeDescFromServer = this._spaceProxy.getTypeDescFromServer(typeName);
                    if (typeDescFromServer == null) {
                        this._spaceProxy.registerTypeDescInServers(typeDesc);
                    }
                }
                catch (SpaceMetadataException e) {
                    if (ignoreException) {
                        if (_logger.isLoggable(Level.FINE)) {
                            _logger.log(Level.FINE, "Failed to register type descriptor in server", e);
                        }
                    }
                    throw e;
                }
                this._typeMap.put(typeDesc.getTypeName(), typeDesc);
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.log(Level.FINE, "Created type descriptor " + typeDesc);
                }
            }
            finally {
                ClientTypeDescRepository.logExit("ClientTypeDescRepository.registerTypeDesc", "typeName", typeName);
            }
        }
    }

    public static Class<?> getRealClass(String className, String codebase) {
        Class realClass;
        block10: {
            ClientTypeDescRepository.logEnter("ClientTypeDescRepository.getRealClass", "className", className);
            if (className == null || className.length() == 0) {
                throw new IllegalArgumentException("Argument 'className' cannot be null or empty.");
            }
            realClass = null;
            try {
                realClass = ClassLoaderHelper.loadClass(codebase, className, null, false);
                if (ExternalEntry.class.isAssignableFrom(realClass)) {
                    realClass = null;
                    if (_logger.isLoggable(Level.FINE)) {
                        _logger.log(Level.FINE, "Class '" + className + "'' was loaded successfully but ignored since it extends ExternalEntry.");
                    }
                } else if (_logger.isLoggable(Level.FINE)) {
                    _logger.log(Level.FINE, "Class '" + className + "'' was loaded successfully.");
                }
            }
            catch (ClassNotFoundException e) {
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.log(Level.FINE, "Class '" + className + "'' could not be loaded since it was not found.", e);
                }
            }
            catch (MalformedURLException e) {
                if (!_logger.isLoggable(Level.FINE)) break block10;
                _logger.log(Level.FINE, "Class '" + className + "'' could not be loaded since the codebase [" + codebase + "] is malformed.", e);
            }
        }
        if (realClass != null) {
            ReflectionUtil.assertIsPublic(realClass);
        }
        ClientTypeDescRepository.logExit("ClientTypeDescRepository.getRealClass", "className", className);
        return realClass;
    }

    private static boolean isValid(ITypeDesc typeDesc) {
        return typeDesc != null && !typeDesc.isInactive();
    }

    private static boolean hasRequiredIntrospector(ITypeDesc typeDesc, ObjectType objectType) {
        return typeDesc.isConcreteType() || !objectType.isConcrete();
    }

    private static void logEnter(String methodName, String argName, Object argValue) {
        if (_logger.isLoggable(Level.FINER)) {
            _logger.log(Level.FINER, "Entered " + methodName + ", " + argName + "=[" + argValue + "].");
        }
    }

    private static void logExit(String methodName, String argName, Object argValue) {
        if (_logger.isLoggable(Level.FINER)) {
            _logger.log(Level.FINER, "Finished " + methodName + ", " + argName + "=[" + argValue + "].");
        }
    }
}

