/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.client.spaceproxy.metadata;

import com.gigaspaces.document.SpaceDocument;
import com.gigaspaces.entry.VirtualEntry;
import com.gigaspaces.internal.transport.IEntryPacket;
import com.gigaspaces.internal.transport.ITemplatePacket;
import com.gigaspaces.internal.transport.ITransportPacket;
import com.gigaspaces.query.ISpaceQuery;
import com.gigaspaces.query.IdQuery;
import com.gigaspaces.query.IdsQuery;
import com.j_spaces.core.client.EntrySnapshot;
import com.j_spaces.core.client.ExternalEntry;
import com.j_spaces.core.client.SQLQuery;
import net.jini.core.entry.Entry;

public enum ObjectType {
    NULL,
    POJO,
    ENTRY,
    METADATA_ENTRY,
    EXTERNAL_ENTRY,
    DOCUMENT,
    SQL,
    ENTRY_SNAPSHOT,
    ENTRY_PACKET,
    TEMPLATE_PACKET,
    SPACE_TASK,
    ID_QUERY,
    IDS_QUERY;


    public static ObjectType fromObject(Object object) {
        return ObjectType.fromObject(object, false);
    }

    public static ObjectType fromObject(Object object, boolean supportIdsQuery) {
        if (object == null) {
            return NULL;
        }
        if (object instanceof ITransportPacket) {
            if (object instanceof ITemplatePacket) {
                return TEMPLATE_PACKET;
            }
            if (object instanceof IEntryPacket) {
                return ENTRY_PACKET;
            }
            throw new IllegalArgumentException("Unsupported ITransportPacket class: " + object.getClass().getName());
        }
        if (object instanceof VirtualEntry) {
            if (object instanceof SpaceDocument) {
                return DOCUMENT;
            }
            throw new IllegalArgumentException("Unsupported VirtualEntry class: " + object.getClass().getName());
        }
        if (object instanceof ISpaceQuery) {
            if (object instanceof EntrySnapshot) {
                return ENTRY_SNAPSHOT;
            }
            if (object instanceof SQLQuery) {
                return SQL;
            }
            if (object instanceof IdQuery) {
                return ID_QUERY;
            }
            if (supportIdsQuery && object instanceof IdsQuery) {
                return IDS_QUERY;
            }
            throw new IllegalArgumentException("Unsupported ISpaceQuery class: " + object.getClass().getName());
        }
        if (object instanceof Entry) {
            if (object instanceof ExternalEntry) {
                return EXTERNAL_ENTRY;
            }
            return ENTRY;
        }
        return POJO;
    }

    public boolean isConcrete() {
        return this == POJO || this == ENTRY;
    }
}

