/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.client.spaceproxy.metadata;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.cluster.replication.WriteConsistencyLevelCompromisedException;
import com.gigaspaces.document.SpaceDocument;
import com.gigaspaces.internal.client.QueryResultTypeInternal;
import com.gigaspaces.internal.client.StorageTypeDeserialization;
import com.gigaspaces.internal.client.spaceproxy.IDirectSpaceProxy;
import com.gigaspaces.internal.client.spaceproxy.actioninfo.ReadTakeByIdsProxyActionInfo;
import com.gigaspaces.internal.client.spaceproxy.metadata.ClientTypeDescRepository;
import com.gigaspaces.internal.client.spaceproxy.metadata.ISpaceProxyTypeManager;
import com.gigaspaces.internal.client.spaceproxy.metadata.ObjectType;
import com.gigaspaces.internal.lease.SpaceEntryLease;
import com.gigaspaces.internal.metadata.EntryType;
import com.gigaspaces.internal.metadata.ITypeDesc;
import com.gigaspaces.internal.metadata.ITypeIntrospector;
import com.gigaspaces.internal.metadata.SpaceTypeInfoRepository;
import com.gigaspaces.internal.query.PropertiesQuery;
import com.gigaspaces.internal.server.space.SpaceUidFactory;
import com.gigaspaces.internal.server.space.operations.WriteEntryResult;
import com.gigaspaces.internal.transport.AbstractProjectionTemplate;
import com.gigaspaces.internal.transport.EntryPacket;
import com.gigaspaces.internal.transport.EntryPacketFactory;
import com.gigaspaces.internal.transport.IEntryPacket;
import com.gigaspaces.internal.transport.ITemplatePacket;
import com.gigaspaces.internal.transport.ITransportPacket;
import com.gigaspaces.internal.transport.ProjectionTemplate;
import com.gigaspaces.internal.transport.TemplatePacketFactory;
import com.gigaspaces.internal.utils.ObjectUtils;
import com.gigaspaces.lrmi.classloading.LRMIClassLoadersHolder;
import com.gigaspaces.query.IdQuery;
import com.gigaspaces.query.IdsQuery;
import com.j_spaces.core.IGSEntry;
import com.j_spaces.core.LeaseContext;
import com.j_spaces.core.LeaseInitializer;
import com.j_spaces.core.client.EntrySnapshot;
import com.j_spaces.core.client.ExternalEntry;
import com.j_spaces.core.client.Modifiers;
import com.j_spaces.core.client.OperationTimeoutException;
import com.j_spaces.core.client.SQLQuery;
import com.j_spaces.core.client.UpdateModifiers;
import com.j_spaces.jdbc.builder.SQLQueryTemplatePacket;
import java.lang.reflect.Array;
import java.util.Map;
import net.jini.core.entry.UnusableEntryException;

@InternalApi
public class SpaceProxyTypeManager
implements ISpaceProxyTypeManager {
    private static final IEntryPacket DUMMY_PACKET = new EntryPacket();
    private static final int _requiredConsistencyLevel = Integer.getInteger("com.gs.replication.required_consistency_level", 1);
    private final IDirectSpaceProxy _proxy;
    private final ClientTypeDescRepository _typeDescRepository;

    public SpaceProxyTypeManager(IDirectSpaceProxy proxy) {
        this._proxy = proxy;
        this._typeDescRepository = new ClientTypeDescRepository(proxy);
    }

    @Override
    public Object getLockObject() {
        return this._typeDescRepository;
    }

    @Override
    public void close() {
        this._typeDescRepository.clear();
    }

    @Override
    public ITypeDesc getTypeDescIfExistsInProxy(String className) {
        return this._typeDescRepository.getTypeDescIfExistsInProxy(className);
    }

    @Override
    public ITypeDesc getTypeDescByName(String typeName) {
        return this._typeDescRepository.getTypeDescByName(typeName, null);
    }

    @Override
    public ITypeDesc getTypeDescByName(String typeName, String codebase) {
        return this._typeDescRepository.getTypeDescByName(typeName, codebase);
    }

    @Override
    public ITypeDesc getTypeDescByNameIfExists(String typeName) {
        return this._typeDescRepository.getTypeDescIfExistsInServer(typeName);
    }

    @Override
    public void loadTypeDescToPacket(ITransportPacket packet) {
        this._typeDescRepository.loadTypeDescToPacket(packet);
    }

    @Override
    public void registerTypeDesc(ITypeDesc typeDesc) {
        this._typeDescRepository.registerTypeDesc(typeDesc);
    }

    @Override
    public void deleteTypeDesc(String className) {
        this._typeDescRepository.remove(className);
    }

    @Override
    public void deleteAllTypeDescs() {
        this._typeDescRepository.clear();
        LRMIClassLoadersHolder.dropAllClasses();
    }

    @Override
    public String getCommonSuperTypeName(ITypeDesc typeDesc1, ITypeDesc typeDesc2) {
        return this._typeDescRepository.getCommonSuperTypeName(typeDesc1, typeDesc2);
    }

    @Override
    public SpaceTypeInfoRepository getSpaceTypeInfoRepository() {
        return SpaceTypeInfoRepository.getGlobalRepository();
    }

    @Override
    public Object getObjectFromEntryPacket(IEntryPacket entryPacket, QueryResultTypeInternal resultType, boolean returnPacket) {
        return this.getObjectFromEntryPacket(entryPacket, resultType, returnPacket, StorageTypeDeserialization.EAGER, null);
    }

    @Override
    public Object getObjectFromEntryPacket(IEntryPacket entryPacket, QueryResultTypeInternal resultType, boolean returnPacket, AbstractProjectionTemplate projectionTemplate) {
        return this.getObjectFromEntryPacket(entryPacket, resultType, returnPacket, StorageTypeDeserialization.EAGER, projectionTemplate);
    }

    @Override
    public Object getObjectFromEntryPacket(IEntryPacket entryPacket, QueryResultTypeInternal resultType, boolean returnPacket, StorageTypeDeserialization storageTypeDeserialization, AbstractProjectionTemplate projectionTemplate) {
        if (entryPacket == null) {
            return null;
        }
        this.loadTypeDescToPacket(entryPacket);
        if (projectionTemplate != null) {
            projectionTemplate.filterOutNonProjectionProperties(entryPacket);
        }
        return returnPacket ? entryPacket : entryPacket.toObject(resultType, storageTypeDeserialization);
    }

    @Override
    public LeaseContext<?> convertWriteOrUpdateResult(LeaseContext<?> lease, Object entry, IEntryPacket entryPacekt, int modifiers) {
        Object oldValue;
        Object object = oldValue = lease == null ? null : (Object)lease.getObject();
        if (oldValue == null && lease != null) {
            lease = this.convertWriteResult(entry, entryPacekt, lease);
        } else if ((oldValue = this.convertUpdateResult((IEntryPacket)oldValue, entryPacekt, entry, modifiers)) != null) {
            LeaseInitializer.setPreviousObject(lease, oldValue);
        }
        return lease;
    }

    @Override
    public LeaseContext<?> convertWriteResult(Object entry, IEntryPacket entryPacket, LeaseContext<?> lease) {
        int version;
        String uid = lease != null ? lease.getUID() : entryPacket.getUID();
        int n = version = !this._proxy.isEmbedded() || this._proxy.isClustered() ? 1 : entryPacket.getVersion();
        if (entry instanceof IEntryPacket) {
            IEntryPacket ep = (IEntryPacket)entry;
            ep.setUID(uid);
            ep.setVersion(version);
        } else {
            this._typeDescRepository.loadTypeDescToPacket(entryPacket);
            ITypeIntrospector introspector = entryPacket.getTypeDescriptor().getIntrospector(entryPacket.getEntryType());
            introspector.setUID(entry, uid);
            introspector.setVersion(entry, version);
        }
        return lease == null || LeaseInitializer.isDummyLease(lease) ? null : lease;
    }

    private Object convertUpdateResult(IEntryPacket oldPacket, IEntryPacket newPacket, Object newEntry, int modifiers) {
        boolean returnPacket;
        Object oldEntry = null;
        boolean bl = returnPacket = newPacket == newEntry;
        if (oldPacket != null && oldPacket != DUMMY_PACKET) {
            oldEntry = this.getObjectFromEntryPacket(oldPacket, QueryResultTypeInternal.getUpdateResultType(newPacket), returnPacket);
            boolean overrideVersion = Modifiers.contains(modifiers, 524288);
            if (returnPacket) {
                if (!overrideVersion) {
                    newPacket.setVersion(oldPacket.getVersion() + 1);
                }
            } else {
                ITypeIntrospector introspector = oldPacket.getTypeDescriptor().getIntrospector(newPacket.getEntryType());
                int version = overrideVersion ? newPacket.getVersion() : oldPacket.getVersion() + 1;
                introspector.setEntryInfo(newEntry, oldPacket.getUID(), version, oldPacket.getTTL());
            }
        } else if (UpdateModifiers.isUpdateOrWrite(modifiers) || UpdateModifiers.isWriteOnly(modifiers)) {
            int newVer = !this._proxy.isEmbedded() || this._proxy.isClustered() ? 1 : newPacket.getVersion();
            this._typeDescRepository.loadTypeDescToPacket(newPacket);
            ITypeDesc typeDesc = newPacket.getTypeDescriptor();
            if (returnPacket) {
                if (oldPacket != null) {
                    oldPacket.setTypeDesc(typeDesc, false);
                }
                newPacket.setVersion(newVer);
                oldEntry = oldPacket;
            } else {
                typeDesc.getIntrospector(newPacket.getEntryType()).setEntryInfo(newEntry, newPacket.getUID(), newVer, newPacket.getTTL());
            }
        }
        return oldEntry;
    }

    @Override
    public Object convertQueryResult(IEntryPacket resultPacket, ITemplatePacket queryPacket, boolean returnEntryPacket) {
        return this.getObjectFromEntryPacket(resultPacket, queryPacket.getQueryResultType(), returnEntryPacket);
    }

    @Override
    public Object convertQueryResult(IEntryPacket resultPacket, ITemplatePacket queryPacket, boolean returnEntryPacket, AbstractProjectionTemplate projectionTemplate) {
        return this.getObjectFromEntryPacket(resultPacket, queryPacket.getQueryResultType(), returnEntryPacket, projectionTemplate);
    }

    @Override
    public Object[] convertQueryResults(IEntryPacket[] resultPackets, ITemplatePacket query, boolean returnEntryPacket, AbstractProjectionTemplate projectionTemplate) {
        Object[] results;
        if (resultPackets == null) {
            return null;
        }
        if (returnEntryPacket) {
            results = resultPackets;
        } else {
            Class<?> resultClass = this.getResultClass(query);
            results = (Object[])Array.newInstance(resultClass, resultPackets.length);
        }
        for (int i = 0; i < resultPackets.length; ++i) {
            results[i] = this.convertQueryResult(resultPackets[i], query, returnEntryPacket, projectionTemplate);
        }
        return results;
    }

    @Override
    public Class<?> getResultClass(ITemplatePacket templatePacket) {
        Class type = null;
        ITypeDesc typeDesc = templatePacket.getTypeDescriptor();
        if (typeDesc != null) {
            type = typeDesc.getIntrospector(templatePacket.getQueryResultType().getEntryType()).getType();
        }
        return type != null ? type : Object.class;
    }

    @Override
    public Object getObjectFromIGSEntry(IGSEntry entry) throws UnusableEntryException {
        ITypeDesc typeDesc = this.getTypeDescByName(entry.getClassName(), entry.getCodebase());
        ITypeIntrospector introspector = typeDesc.getIntrospector(typeDesc.getObjectType());
        return introspector.toObject(entry, typeDesc);
    }

    @Override
    public IEntryPacket getEntryPacketFromObject(Object object, ObjectType objectType) {
        IEntryPacket packet;
        if (objectType.isConcrete()) {
            ITypeDesc typeDesc = this._typeDescRepository.getTypeDescByJavaObject(object, objectType);
            packet = EntryPacketFactory.createFromObject(object, typeDesc, EntryType.OBJECT_JAVA, true);
        } else if (objectType == ObjectType.ENTRY_PACKET) {
            packet = (IEntryPacket)object;
            this.loadTypeDescToPacket(packet);
        } else if (objectType == ObjectType.DOCUMENT) {
            String typeName = ((SpaceDocument)object).getTypeName();
            ITypeDesc typeDesc = this._typeDescRepository.getTypeDescByName(typeName, null);
            packet = EntryPacketFactory.createFromObject(object, typeDesc, EntryType.DOCUMENT_JAVA, true);
        } else if (objectType == ObjectType.EXTERNAL_ENTRY) {
            ITypeDesc typeDesc = this._typeDescRepository.getTypeDescByExternalEntry((ExternalEntry)object);
            packet = EntryPacketFactory.createFromObject(object, typeDesc, EntryType.EXTERNAL_ENTRY, true);
        } else {
            if (objectType == ObjectType.NULL) {
                throw new IllegalArgumentException("Cannot create IEntryPacket from null.");
            }
            if (objectType == ObjectType.ENTRY_SNAPSHOT) {
                throw new IllegalArgumentException("Cannot create IEntryPacket from EntrySnapshot.");
            }
            if (objectType == ObjectType.SQL) {
                throw new IllegalArgumentException("Cannot create IEntryPacket from SQLQuery.");
            }
            if (objectType == ObjectType.ID_QUERY) {
                throw new IllegalArgumentException("Cannot create IEntryPacket from IdQuery.");
            }
            throw new IllegalArgumentException("Unsupported entry type: " + (Object)((Object)objectType));
        }
        packet.setSerializeTypeDesc(false);
        if (objectType != ObjectType.ENTRY_PACKET) {
            this.disablePacketVersionIfNotSupported(packet);
        }
        return packet;
    }

    @Override
    public ITemplatePacket getTemplatePacketFromObject(Object object, ObjectType objectType) {
        ITemplatePacket packet;
        if (objectType.isConcrete()) {
            ITypeDesc typeDesc = this._typeDescRepository.getTypeDescByJavaObject(object, objectType);
            packet = TemplatePacketFactory.createFromObject(object, typeDesc, EntryType.OBJECT_JAVA);
        } else if (objectType == ObjectType.TEMPLATE_PACKET) {
            packet = (ITemplatePacket)object;
            this.loadTypeDescToPacket(packet);
            Map<String, Object> dynamicProperties = packet.getDynamicProperties();
            if (dynamicProperties != null) {
                packet.setCustomQuery(new PropertiesQuery(dynamicProperties, packet.getTypeDescriptor()));
                packet.setDynamicProperties(null);
            }
        } else if (objectType == ObjectType.DOCUMENT) {
            String typeName = ((SpaceDocument)object).getTypeName();
            ITypeDesc typeDesc = this._typeDescRepository.getTypeDescByName(typeName, null);
            packet = TemplatePacketFactory.createFromObject(object, typeDesc, EntryType.DOCUMENT_JAVA);
        } else if (objectType == ObjectType.EXTERNAL_ENTRY) {
            packet = this.createTemplatePacketFromExternalEntry((ExternalEntry)object);
        } else if (objectType == ObjectType.ENTRY_SNAPSHOT) {
            packet = ((EntrySnapshot)object).getTemplatePacket();
            if (packet.getTypeDescriptor() == null) {
                this.loadTypeDescToPacket(packet);
            }
        } else if (objectType == ObjectType.SQL) {
            packet = this.getTemplatePacketFromSqlQuery((SQLQuery)object);
        } else if (objectType == ObjectType.ID_QUERY) {
            packet = this.getTemplatePacketFromIdQuery((IdQuery)object);
        } else if (objectType == ObjectType.IDS_QUERY) {
            IdsQuery idsQuery = (IdsQuery)object;
            ReadTakeByIdsProxyActionInfo actionInfo = new ReadTakeByIdsProxyActionInfo(this._proxy, idsQuery.getTypeName(), idsQuery.getIds(), null, idsQuery.getRoutings(), null, true, 0, QueryResultTypeInternal.NOT_SET, idsQuery.getProjections(), null);
            packet = actionInfo.queryPacket;
        } else if (objectType == ObjectType.NULL) {
            ITypeDesc objectTypeDesc = this._typeDescRepository.getTypeDescByName(Object.class.getName(), null);
            packet = TemplatePacketFactory.createEmptyPacket(objectTypeDesc);
        } else {
            throw new IllegalArgumentException("Unsupported entry type: " + (Object)((Object)objectType));
        }
        if (objectType != ObjectType.TEMPLATE_PACKET) {
            this.disablePacketVersionIfNotSupported(packet);
        }
        packet.validate();
        return packet;
    }

    private ITemplatePacket createTemplatePacketFromExternalEntry(ExternalEntry entry) {
        if (entry.getMultipleUIDs() != null) {
            QueryResultTypeInternal resultType = entry._returnTrueType ? QueryResultTypeInternal.NOT_SET : QueryResultTypeInternal.EXTERNAL_ENTRY;
            return TemplatePacketFactory.createUidsPacket(entry.getMultipleUIDs(), resultType, entry.m_ReturnOnlyUids);
        }
        if (entry.getClassName() == null) {
            if (entry.getUID() != null) {
                return TemplatePacketFactory.createUidPacket(entry.getUID(), entry.getVersion(), entry.m_ReturnOnlyUids);
            }
            ITypeDesc objectTypeDesc = this._typeDescRepository.getTypeDescByName(Object.class.getName(), null);
            return TemplatePacketFactory.createEmptyPacket(objectTypeDesc);
        }
        ITypeDesc typeDesc = this._typeDescRepository.getTypeDescByExternalEntry(entry);
        return TemplatePacketFactory.createFromObject(entry, typeDesc, EntryType.EXTERNAL_ENTRY);
    }

    private ITemplatePacket getTemplatePacketFromSqlQuery(SQLQuery<?> sqlQuery) {
        ITypeDesc typeDesc = this._typeDescRepository.getTypeDescBySQLQuery(sqlQuery);
        QueryResultTypeInternal resultType = this.getSqlQueryResultType(sqlQuery);
        return new SQLQueryTemplatePacket(sqlQuery, typeDesc, resultType);
    }

    private QueryResultTypeInternal getSqlQueryResultType(SQLQuery<?> sqlQuery) {
        switch (sqlQuery.getQueryResultType()) {
            case OBJECT: {
                return QueryResultTypeInternal.OBJECT_JAVA;
            }
            case DOCUMENT: {
                return QueryResultTypeInternal.DOCUMENT_ENTRY;
            }
            case DEFAULT: 
            case NOT_SET: {
                Object template = sqlQuery.getObject();
                if (template instanceof ITemplatePacket) {
                    return ((ITemplatePacket)template).getQueryResultType();
                }
                return QueryResultTypeInternal.NOT_SET;
            }
        }
        throw new IllegalStateException("Unsupported query result type: " + (Object)((Object)sqlQuery.getQueryResultType()));
    }

    private QueryResultTypeInternal getIdQueryResultType(IdQuery<?> idQuery) {
        switch (idQuery.getQueryResultType()) {
            case OBJECT: {
                return QueryResultTypeInternal.OBJECT_JAVA;
            }
            case DOCUMENT: {
                return QueryResultTypeInternal.DOCUMENT_ENTRY;
            }
            case DEFAULT: 
            case NOT_SET: {
                return QueryResultTypeInternal.NOT_SET;
            }
        }
        throw new IllegalStateException("Unsupported query result type: " + (Object)((Object)idQuery.getQueryResultType()));
    }

    private ITemplatePacket getTemplatePacketFromIdQuery(IdQuery<?> idQuery) {
        ITypeDesc typeDesc = this._typeDescRepository.getTypeDescByName(idQuery.getTypeName(), null);
        QueryResultTypeInternal resultType = this.getIdQueryResultType(idQuery);
        Object routing = idQuery.getRouting();
        Object id = idQuery.getId();
        int version = idQuery.getVersion();
        if (ObjectUtils.equals(typeDesc.getIdPropertyName(), typeDesc.getRoutingPropertyName()) && routing != null && !routing.equals(id)) {
            throw new IllegalArgumentException("routing must be null or same as id if routing property and id property are the same.");
        }
        ProjectionTemplate projectionTemplate = idQuery.getProjections() != null ? ProjectionTemplate.create(idQuery.getProjections(), typeDesc) : null;
        return TemplatePacketFactory.createIdOrUidPacket(typeDesc, resultType, routing, id, version, projectionTemplate);
    }

    private void disablePacketVersionIfNotSupported(ITransportPacket entryPacket) {
        boolean isTypeVersioned;
        ITypeDesc typeDesc = entryPacket.getTypeDescriptor();
        boolean bl = isTypeVersioned = typeDesc != null && typeDesc.supportsOptimisticLocking();
        if (!this._proxy.getProxySettings().isVersioned() || !isTypeVersioned) {
            entryPacket.setVersion(0);
        }
    }

    @Override
    public LeaseContext<?> processWriteResult(WriteEntryResult writeResult, Object entry, IEntryPacket entryPacket) {
        if (writeResult == null) {
            throw new OperationTimeoutException();
        }
        String writeResultUid = writeResult.getUid();
        if (entry == entryPacket) {
            if (writeResultUid != null) {
                entryPacket.setUID(writeResultUid);
            }
            entryPacket.setVersion(writeResult.getVersion());
        } else {
            ITypeIntrospector introspector = entryPacket.getTypeDescriptor().getIntrospector(entryPacket.getEntryType());
            if (writeResultUid != null) {
                introspector.setUID(entry, writeResultUid);
            }
            introspector.setVersion(entry, writeResult.getVersion());
        }
        Object prevEntry = this.getObjectFromEntryPacket(writeResult.getPrevEntry(), QueryResultTypeInternal.getUpdateResultType(entryPacket), entry == entryPacket);
        Object routingFieldValue = entryPacket.getRoutingFieldValue();
        if (routingFieldValue == null && writeResultUid != null && entryPacket.getTypeDescriptor().isAutoGenerateRouting()) {
            routingFieldValue = SpaceUidFactory.extractPartitionId(writeResultUid);
        }
        SpaceEntryLease<Object> objectSpaceEntryLease = new SpaceEntryLease<Object>(this._proxy, entryPacket.getTypeName(), writeResultUid != null ? writeResultUid : entryPacket.getUID(), writeResult.getVersion(), routingFieldValue, writeResult.getExpiration(), prevEntry);
        if (writeResult.getSyncReplicationLevel() + 1 < SpaceProxyTypeManager.requiredConsistencyLevel()) {
            throw new WriteConsistencyLevelCompromisedException(writeResult.getSyncReplicationLevel() + 1, objectSpaceEntryLease);
        }
        return objectSpaceEntryLease;
    }

    public static int requiredConsistencyLevel() {
        return _requiredConsistencyLevel;
    }
}

