/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.client.spaceproxy.metadata;

import com.gigaspaces.annotation.pojo.FifoSupport;
import com.gigaspaces.api.InternalApi;
import com.gigaspaces.document.SpaceDocument;
import com.gigaspaces.internal.client.spaceproxy.IDirectSpaceProxy;
import com.gigaspaces.internal.metadata.DotNetStorageType;
import com.gigaspaces.internal.metadata.EntryType;
import com.gigaspaces.internal.metadata.ITypeDesc;
import com.gigaspaces.internal.metadata.IndexTypeHelper;
import com.gigaspaces.internal.metadata.PropertyInfo;
import com.gigaspaces.internal.metadata.SpacePropertyInfo;
import com.gigaspaces.internal.metadata.SpaceTypeInfo;
import com.gigaspaces.internal.metadata.SpaceTypeInfoRepository;
import com.gigaspaces.internal.metadata.TypeDesc;
import com.gigaspaces.internal.metadata.converter.ConversionException;
import com.gigaspaces.internal.reflection.IField;
import com.gigaspaces.internal.reflection.ReflectionUtil;
import com.gigaspaces.metadata.SpaceDocumentSupport;
import com.gigaspaces.metadata.SpaceMetadataException;
import com.gigaspaces.metadata.StorageType;
import com.gigaspaces.metadata.index.SpaceIndex;
import com.gigaspaces.metadata.index.SpaceIndexType;
import com.gigaspaces.metadata.index.SpacePropertyIndex;
import com.gigaspaces.query.extension.metadata.impl.TypeQueryExtensionsImpl;
import com.j_spaces.core.client.ExternalEntry;
import com.j_spaces.core.client.IReplicatable;
import com.j_spaces.core.client.MetaDataEntry;
import com.j_spaces.core.client.ReadModifiers;
import java.io.Externalizable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jini.core.entry.Entry;

@InternalApi
public class TypeDescFactory {
    private static final Logger _logger = Logger.getLogger("com.gigaspaces.client");
    private static final Logger _deprecationLogger = Logger.getLogger("com.gigaspaces.metadata.deprecation");
    private final IDirectSpaceProxy _spaceProxy;
    private final StorageType _storageType;

    public TypeDescFactory() {
        this(null);
    }

    public TypeDescFactory(IDirectSpaceProxy spaceProxy) {
        this._spaceProxy = spaceProxy;
        this._storageType = spaceProxy != null ? StorageType.fromCode(spaceProxy.getProxySettings().getSerializationType()) : StorageType.OBJECT;
    }

    public ITypeDesc createPojoTypeDesc(Class<?> type, String codeBase, ITypeDesc superTypeDesc) {
        SpaceTypeInfo typeInfo = SpaceTypeInfoRepository.getTypeInfo(type);
        StorageType defaultStorageType = typeInfo.getStorageType();
        if (defaultStorageType == StorageType.DEFAULT) {
            defaultStorageType = this._storageType;
        }
        PropertyInfo[] properties = new PropertyInfo[typeInfo.getNumOfSpaceProperties()];
        for (int i = 0; i < properties.length; ++i) {
            SpacePropertyInfo property = typeInfo.getProperty(i);
            StorageType storageType = property.getStorageType();
            properties[i] = new PropertyInfo(property.getName(), property.getType(), property.getDocumentSupport(), storageType);
        }
        HashMap<String, SpaceIndex> indexes = new HashMap<String, SpaceIndex>(typeInfo.getIndexes());
        String fifoGroupingName = typeInfo.getFifoGroupingName();
        Set<String> fifoGroupingIndexes = typeInfo.getFifoGroupingIndexes();
        boolean supportsDynamicProperties = typeInfo.getDynamicPropertiesProperty() != null;
        boolean supportsOptimisticLocking = typeInfo.getVersionProperty() != null;
        String idPropertyName = typeInfo.getIdProperty() != null ? typeInfo.getIdProperty().getName() : null;
        String defaultPropertyName = null;
        String routingPropertyName = typeInfo.getRoutingProperty() != null ? typeInfo.getRoutingProperty().getName() : null;
        FifoSupport fifoSupport = this.isFifoProxy() ? FifoSupport.ALL : typeInfo.getFifoSupport();
        boolean blobstoreEnabled = typeInfo.isBlobstoreEnabled();
        String sequenceNumberPropertyName = typeInfo.getSequenceNumberPropertyName();
        TypeQueryExtensionsImpl queryExtensionsInfo = new TypeQueryExtensionsImpl(typeInfo);
        TypeDesc typeDesc = new TypeDesc(typeInfo.getName(), codeBase, typeInfo.getSuperClasses(), properties, supportsDynamicProperties, indexes, idPropertyName, typeInfo.getIdAutoGenerate(), defaultPropertyName, routingPropertyName, fifoGroupingName, fifoGroupingIndexes, typeInfo.isSystemClass(), fifoSupport, typeInfo.isReplicate(), supportsOptimisticLocking, defaultStorageType, EntryType.OBJECT_JAVA, type, ExternalEntry.class, SpaceDocument.class, null, DotNetStorageType.NULL, blobstoreEnabled, sequenceNumberPropertyName, queryExtensionsInfo);
        if (typeDesc.isExternalizable() && TypeDescFactory.shouldWarnExternalizable(typeInfo) && _deprecationLogger.isLoggable(Level.WARNING)) {
            _deprecationLogger.warning("Current class [" + type.getName() + "] implements " + Externalizable.class + ", usage of Externalizable in order to serialize it to a space is deprecated, Use SpaceExclude, StorageType and nested object serialization where relevant instead.If you use Externalizable for other purposes which are not serializing it into a space you can turn off this logger. The side effect of externalizable when it comes to serializing object to a space will be ignored in future version");
        }
        return typeDesc;
    }

    private static boolean shouldWarnExternalizable(SpaceTypeInfo typeInfo) {
        return !typeInfo.getType().getName().equals("org.openspaces.jee.sessions.jetty.SessionData");
    }

    public ITypeDesc createEntryTypeDesc(Entry obj, String className, String codeBase, Class<?> realClass) {
        List<IField> fieldsList = ReflectionUtil.getCanonicalSortedFields(realClass);
        IField[] fields = fieldsList.toArray(new IField[fieldsList.size()]);
        int length = fields.length;
        PropertyInfo[] properties = new PropertyInfo[length];
        String[] fieldsNames = new String[length];
        String[] fieldsTypes = new String[length];
        SpaceIndexType[] fieldsIndexes = new SpaceIndexType[length];
        for (int i = 0; i < length; ++i) {
            fieldsNames[i] = fields[i].getName();
            fieldsTypes[i] = fields[i].getType().getName();
            properties[i] = new PropertyInfo(fields[i].getName(), fields[i].getType(), SpaceDocumentSupport.DEFAULT, StorageType.DEFAULT);
            properties[i].setDefaultStorageType(this._storageType);
        }
        String defaultPropertyName = this.getEntryIndices(realClass, fieldsNames, fieldsTypes, fieldsIndexes);
        HashMap<String, SpaceIndex> indexes = new HashMap<String, SpaceIndex>();
        for (int i = 0; i < length; ++i) {
            if (fieldsIndexes[i] == null || !fieldsIndexes[i].isIndexed()) continue;
            SpacePropertyIndex index = new SpacePropertyIndex(properties[i].getName(), fieldsIndexes[i], false, i);
            indexes.put(index.getName(), index);
        }
        ArrayList<String> superClassesList = new ArrayList<String>();
        for (Class<?> c = realClass; c != null; c = c.getSuperclass()) {
            superClassesList.add(c.getName());
        }
        String[] superClasses = superClassesList.toArray(new String[superClassesList.size()]);
        FifoSupport fifoMode = FifoSupport.OFF;
        if (MetaDataEntry.class.isAssignableFrom(realClass)) {
            boolean isFifo = obj != null && ((MetaDataEntry)obj).isFifo() || this.isFifoProxy() || this.isFifoProxyModifiers();
            FifoSupport fifoSupport = fifoMode = isFifo ? FifoSupport.OPERATION : FifoSupport.OFF;
        }
        if (this.isFifoProxy()) {
            fifoMode = FifoSupport.ALL;
        }
        boolean supportsDynamicProperties = false;
        boolean isSystemType = false;
        boolean replicable = IReplicatable.class.isAssignableFrom(realClass);
        String idPropertyName = null;
        boolean idAutoGenerate = false;
        String routingPropertyName = null;
        return new TypeDesc(className, codeBase, superClasses, properties, false, indexes, idPropertyName, false, defaultPropertyName, routingPropertyName, null, null, false, fifoMode, replicable, this.isVersionedProxy(), this._storageType, EntryType.OBJECT_JAVA, realClass, ExternalEntry.class, SpaceDocument.class, null, DotNetStorageType.NULL, true, null, null);
    }

    public ITypeDesc createExternalEntryTypeDesc(ExternalEntry externalEntry, String codeBase) {
        FifoSupport fifoMode;
        if (externalEntry.getClassName() == null) {
            throw new RuntimeException("ExternalEntry problem, Class Name is NULL.");
        }
        Object[] fieldsNames = externalEntry.getFieldsNames();
        Object[] fieldsTypes = externalEntry.getFieldsTypes();
        if (fieldsNames == null || fieldsTypes == null) {
            fieldsNames = fieldsNames == null ? new String[]{} : fieldsNames;
            Object[] objectArray = fieldsTypes = fieldsTypes == null ? new String[fieldsNames.length] : fieldsTypes;
            if (fieldsTypes.length > 0 && fieldsTypes[0] == null) {
                throw new RuntimeException("Internal exception: supplied type information is insufficient. Dump info:\n\t class-name: " + externalEntry.getClassName() + "\n\t field-names: " + Arrays.toString(fieldsNames) + "\n\t field-types: " + Arrays.toString(fieldsTypes) + "\n\t ref: GS-2273\n");
            }
        }
        if (fieldsNames.length != fieldsTypes.length) {
            throw new RuntimeException("ExternalEntry : " + externalEntry.getClassName() + " field types and field names size mismatch:\nfieldsTypes=" + Arrays.toString(fieldsTypes) + " fieldsNames=" + Arrays.toString(fieldsNames));
        }
        if (externalEntry.getFieldsTypes() == null) {
            throw new IllegalArgumentException("Insufficient field-type information in ExternalEntry for class: " + externalEntry.getClassName() + ";\nTo appropriately introduce the ExternalEntry, construct it with it's field-types or use the ExternalEntry.setFieldsTypes(String[]) method.");
        }
        SpaceIndexType[] indices = this.getExternalEntryIndices(externalEntry);
        String[] superClasses = externalEntry.getSuperClassesNames();
        if (superClasses == null || superClasses.length == 0) {
            superClasses = new String[]{externalEntry.getClassName(), Object.class.getName()};
        } else {
            int length = superClasses.length;
            boolean addClassName = false;
            boolean addObject = false;
            if (!superClasses[0].equals(externalEntry.getClassName())) {
                addClassName = true;
                ++length;
            }
            if (!superClasses[superClasses.length - 1].equals(Object.class.getName())) {
                addObject = true;
                ++length;
            }
            String[] temp = new String[length];
            if (addClassName) {
                temp[0] = externalEntry.getClassName();
            }
            System.arraycopy(superClasses, 0, temp, addClassName ? 1 : 0, superClasses.length);
            if (addObject) {
                temp[temp.length - 1] = Object.class.getName();
            }
        }
        PropertyInfo[] properties = new PropertyInfo[fieldsNames.length];
        HashMap<String, SpaceIndex> indexes = new HashMap<String, SpaceIndex>();
        for (int i = 0; i < properties.length; ++i) {
            properties[i] = new PropertyInfo((String)fieldsNames[i], (String)fieldsTypes[i], SpaceDocumentSupport.DEFAULT, StorageType.DEFAULT);
            properties[i].setDefaultStorageType(this._storageType);
            if (indices[i] == null || !indices[i].isIndexed()) continue;
            SpacePropertyIndex index = new SpacePropertyIndex((String)fieldsNames[i], indices[i], false, i);
            indexes.put(index.getName(), index);
        }
        FifoSupport fifoSupport = fifoMode = externalEntry.isFifo() ? FifoSupport.OPERATION : FifoSupport.OFF;
        if (this.isFifoProxy()) {
            fifoMode = FifoSupport.ALL;
        }
        boolean supportsDynamicProperties = false;
        boolean isSystemType = false;
        String idPropertyName = null;
        boolean idAutoGenerate = false;
        String defaultPropertyName = null;
        return new TypeDesc(externalEntry.getClassName(), codeBase, superClasses, properties, false, indexes, idPropertyName, false, defaultPropertyName, externalEntry.getRoutingFieldName(), null, null, false, fifoMode, externalEntry.isReplicatable(), true, this._storageType, EntryType.EXTERNAL_ENTRY, null, externalEntry.getClass(), SpaceDocument.class, null, DotNetStorageType.NULL, true, null, null);
    }

    public static ITypeDesc createPbsTypeDesc(EntryType entryType, String className, String codeBase, String[] superClassesNames, String[] fieldsNames, String[] fieldsTypes, SpaceIndexType[] fieldsIndexes, String idPropertyName, boolean idAutoGenerate, String routingPropertyName, FifoSupport fifoMode, boolean isReplicable, boolean supportsOptimisticLocking, boolean supportsDynamicProperties) {
        boolean blobstoreEnabled = true;
        PropertyInfo[] properties = new PropertyInfo[fieldsNames.length];
        HashMap<String, SpaceIndex> indexes = new HashMap<String, SpaceIndex>();
        for (int i = 0; i < properties.length; ++i) {
            properties[i] = new PropertyInfo(fieldsNames[i], fieldsTypes[i], SpaceDocumentSupport.DEFAULT, StorageType.OBJECT);
            if (fieldsIndexes[i] == SpaceIndexType.NONE) continue;
            boolean isUnique = fieldsNames[i].equals(idPropertyName) && !idAutoGenerate;
            SpacePropertyIndex index = new SpacePropertyIndex(fieldsNames[i], fieldsIndexes[i], isUnique, i);
            indexes.put(index.getName(), index);
        }
        String defaultPropertyName = null;
        boolean isSystemType = false;
        return new TypeDesc(className, codeBase, superClassesNames, properties, supportsDynamicProperties, indexes, idPropertyName, idAutoGenerate, defaultPropertyName, routingPropertyName, null, null, false, fifoMode, isReplicable, supportsOptimisticLocking, StorageType.OBJECT, entryType, null, ExternalEntry.class, SpaceDocument.class, null, DotNetStorageType.NULL, true, null, null);
    }

    public static ITypeDesc createPbsExplicitTypeDesc(EntryType entryType, String className, String[] superClassesNames, PropertyInfo[] properties, Map<String, SpaceIndex> indexes, String idPropertyName, boolean idAutoGenerate, String routingPropertyName, String fifoGroupingPropertyPath, Set<String> fifoGroupingIndexPaths, FifoSupport fifoMode, boolean isReplicable, boolean supportsOptimisticLocking, boolean supportsDynamicProperties, byte dynamicPropertiesStorageType, String documentWrapperType, boolean blobstoreEnabled) {
        String defaultPropertyName = null;
        boolean isSystemType = false;
        return new TypeDesc(className, null, superClassesNames, properties, supportsDynamicProperties, indexes, idPropertyName, idAutoGenerate, defaultPropertyName, routingPropertyName, fifoGroupingPropertyPath, fifoGroupingIndexPaths, false, fifoMode, isReplicable, supportsOptimisticLocking, StorageType.OBJECT, entryType, null, ExternalEntry.class, SpaceDocument.class, documentWrapperType, dynamicPropertiesStorageType, blobstoreEnabled, null, null);
    }

    private String getEntryIndices(Class<?> realClass, String[] fieldsNames, String[] fieldTypes, SpaceIndexType[] indexTypes) {
        String firstIndexName = null;
        try {
            Method method = realClass.getMethod("__getSpaceIndexedFields", new Class[0]);
            if (!Modifier.isStatic(method.getModifiers())) {
                throw new SpaceMetadataException("Entry Class: " + realClass.getName() + " contains a Non-Static, overloaded __getSpaceIndexedFields() method.\n Such method should be defined as static.");
            }
            String[] indicators = (String[])method.invoke(null, new Object[0]);
            if (indicators == null) {
                return null;
            }
            for (int i = 0; i < indicators.length; ++i) {
                String indexName = indicators[i];
                int pos = TypeDescFactory.getPosition(fieldsNames, indexName);
                if (pos != -1) {
                    indexTypes[pos] = SpaceIndexType.EQUAL;
                    if (firstIndexName != null) continue;
                    firstIndexName = indexName;
                    continue;
                }
                _logger.log(Level.SEVERE, "Field: " + indexName + " is not found or not usable in class: " + realClass.getName() + " although it is returned by __getSpaceIndexedFields()");
            }
        }
        catch (NoSuchMethodException method) {
        }
        catch (InvocationTargetException e) {
            throw new ConversionException(e);
        }
        catch (IllegalAccessException e) {
            throw new ConversionException(e);
        }
        return firstIndexName;
    }

    private SpaceIndexType[] getExternalEntryIndices(ExternalEntry entry) {
        String field;
        SpaceIndexType[] indexTypes = IndexTypeHelper.fromOld(entry.getIndexIndicators());
        if (indexTypes != null) {
            return indexTypes;
        }
        String[] fieldsNames = entry.getFieldsNames();
        indexTypes = new SpaceIndexType[fieldsNames.length];
        String string = field = entry.getRoutingFieldName() == null ? entry.getPrimaryKeyName() : entry.getRoutingFieldName();
        if (field != null) {
            for (int i = 0; i < fieldsNames.length; ++i) {
                if (!fieldsNames[i].equals(field)) continue;
                indexTypes[i] = SpaceIndexType.EQUAL;
                break;
            }
            return indexTypes;
        }
        return indexTypes;
    }

    private static <T> int getPosition(T[] array, T item) {
        for (int i = 0; i < array.length; ++i) {
            if (!array[i].equals(item)) continue;
            return i;
        }
        return -1;
    }

    private boolean isFifoProxy() {
        return this._spaceProxy != null ? this._spaceProxy.isFifo() : false;
    }

    private boolean isFifoProxyModifiers() {
        return this._spaceProxy != null ? ReadModifiers.isFifo(this._spaceProxy.getReadModifiers()) : false;
    }

    private boolean isVersionedProxy() {
        return this._spaceProxy != null ? this._spaceProxy.isOptimisticLockingEnabled() : false;
    }
}

