/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.client.spaceproxy.operations;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.client.spaceproxy.operations.AggregateEntriesSpaceOperationResult;
import com.gigaspaces.internal.client.spaceproxy.operations.SpaceOperationRequest;
import com.gigaspaces.internal.client.spaceproxy.operations.SpaceOperationResult;
import com.gigaspaces.internal.io.IOUtils;
import com.gigaspaces.internal.query.RawEntryConverter;
import com.gigaspaces.internal.remoting.RemoteOperationRequest;
import com.gigaspaces.internal.remoting.routing.partitioned.PartitionedClusterExecutionType;
import com.gigaspaces.internal.remoting.routing.partitioned.PartitionedClusterRemoteOperationRouter;
import com.gigaspaces.internal.transport.ITemplatePacket;
import com.gigaspaces.internal.version.PlatformLogicalVersion;
import com.gigaspaces.lrmi.LRMIInvocationContext;
import com.gigaspaces.query.aggregators.AggregationInternalUtils;
import com.gigaspaces.query.aggregators.AggregationResult;
import com.gigaspaces.query.aggregators.SpaceEntriesAggregator;
import com.j_spaces.core.IJSpace;
import com.j_spaces.core.exception.internal.InterruptedSpaceException;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import net.jini.core.transaction.Transaction;
import net.jini.core.transaction.TransactionException;

@InternalApi
public class AggregateEntriesSpaceOperationRequest
extends SpaceOperationRequest<AggregateEntriesSpaceOperationResult> {
    private static final long serialVersionUID = 1L;
    private ITemplatePacket queryPacket;
    private List<SpaceEntriesAggregator> aggregators;
    private Transaction txn;
    private int readModifiers;
    private transient Exception _exception;
    private static final short FLAG_TRANSACTION = 1;
    private static final short FLAG_MODIFIERS = 2;
    private static final int DEFAULT_MODIFIERS = 0;

    public AggregateEntriesSpaceOperationRequest() {
    }

    public AggregateEntriesSpaceOperationRequest(ITemplatePacket queryPacket, Transaction txn, int modifiers, List<SpaceEntriesAggregator> aggregators) {
        this.queryPacket = queryPacket;
        this.aggregators = aggregators;
        this.readModifiers = modifiers;
    }

    @Override
    public int getOperationCode() {
        return 20;
    }

    @Override
    public AggregateEntriesSpaceOperationResult createRemoteOperationResult() {
        return new AggregateEntriesSpaceOperationResult();
    }

    @Override
    public RemoteOperationRequest<AggregateEntriesSpaceOperationResult> createCopy(int targetPartitionId) {
        AggregateEntriesSpaceOperationRequest copy = (AggregateEntriesSpaceOperationRequest)super.createCopy(targetPartitionId);
        copy.queryPacket = this.queryPacket.clone();
        copy.aggregators = new ArrayList<SpaceEntriesAggregator>(this.aggregators.size());
        for (SpaceEntriesAggregator aggregator : this.aggregators) {
            copy.aggregators.add((SpaceEntriesAggregator)aggregator.clone());
        }
        return copy;
    }

    @Override
    public PartitionedClusterExecutionType getPartitionedClusterExecutionType() {
        if (this.queryPacket.getRoutingFieldValue() != null) {
            return PartitionedClusterExecutionType.SINGLE;
        }
        return PartitionedClusterExecutionType.BROADCAST_CONCURRENT;
    }

    @Override
    public Object getPartitionedClusterRoutingValue(PartitionedClusterRemoteOperationRouter router) {
        return this.queryPacket.getRoutingFieldValue();
    }

    @Override
    public boolean processPartitionResult(AggregateEntriesSpaceOperationResult remoteOperationResult, List<AggregateEntriesSpaceOperationResult> previousResults, int numOfPartitions) {
        if (remoteOperationResult.hasException()) {
            this._exception = remoteOperationResult.getExecutionException();
        } else {
            this.aggregate(remoteOperationResult);
        }
        return this._exception == null;
    }

    private void aggregate(AggregateEntriesSpaceOperationResult result) {
        Object[] newResults = result.getIntermediateResults();
        for (int i = 0; i < this.aggregators.size(); ++i) {
            Serializable partitionResult = (Serializable)newResults[i];
            if (partitionResult == null) continue;
            this.aggregators.get(i).aggregateIntermediateResult(partitionResult);
        }
    }

    public AggregationResult getFinalResult(IJSpace spaceProxy, ITemplatePacket queryPacket, boolean returnEntryPacket) throws TransactionException, InterruptedException, RemoteException {
        AggregateEntriesSpaceOperationResult remoteOperationResult = (AggregateEntriesSpaceOperationResult)this.getRemoteOperationResult();
        if (remoteOperationResult != null) {
            if (remoteOperationResult.hasException()) {
                this._exception = remoteOperationResult.getExecutionException();
            } else if (!remoteOperationResult.isEmbedded()) {
                this.aggregate(remoteOperationResult);
            }
        }
        if (this._exception != null) {
            this.processExecutionException(this._exception);
        }
        return AggregationInternalUtils.getFinalResult(this.aggregators, new RawEntryConverter(spaceProxy.getDirectProxy(), queryPacket, returnEntryPacket));
    }

    private void processExecutionException(Exception executionException) throws RemoteException, TransactionException, InterruptedException {
        if (executionException instanceof TransactionException) {
            throw (TransactionException)((Object)executionException);
        }
        if (executionException instanceof RemoteException) {
            throw (RemoteException)executionException;
        }
        if (executionException instanceof InterruptedSpaceException && executionException.getCause() instanceof InterruptedException) {
            throw (InterruptedException)executionException.getCause();
        }
        if (executionException instanceof InterruptedException) {
            throw (InterruptedException)executionException;
        }
        SpaceOperationResult.onUnexpectedException(executionException);
    }

    @Override
    public String getLRMIMethodTrackingId() {
        return "ScanEntries";
    }

    public ITemplatePacket getQueryPacket() {
        return this.queryPacket;
    }

    public void setQueryPacket(ITemplatePacket queryPacket) {
        this.queryPacket = queryPacket;
    }

    public List<SpaceEntriesAggregator> getAggregators() {
        return this.aggregators;
    }

    public int getReadModifiers() {
        return this.readModifiers;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        short flags = this.buildFlags();
        out.writeShort(flags);
        IOUtils.writeObject(out, this.queryPacket);
        PlatformLogicalVersion version = LRMIInvocationContext.getEndpointLogicalVersion();
        if (version.greaterOrEquals(PlatformLogicalVersion.v12_1_0)) {
            IOUtils.serializeSupportCodeChangeCollection(out, this.aggregators);
        } else {
            IOUtils.writeObject(out, this.aggregators);
        }
        if (flags != 0) {
            if (this.txn != null) {
                IOUtils.writeWithCachedStubs(out, this.txn);
            }
            if (this.readModifiers != 0) {
                out.writeInt(this.readModifiers);
            }
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        short flags = in.readShort();
        this.queryPacket = (ITemplatePacket)IOUtils.readObject(in);
        PlatformLogicalVersion version = LRMIInvocationContext.getEndpointLogicalVersion();
        if (version.greaterOrEquals(PlatformLogicalVersion.v12_1_0)) {
            this.aggregators = new ArrayList<SpaceEntriesAggregator>();
            IOUtils.deserializeSupportCodeChangeCollection(in, this.aggregators);
        } else {
            this.aggregators = (List)IOUtils.readObject(in);
        }
        if (flags != 0) {
            if ((flags & 1) != 0) {
                this.txn = (Transaction)IOUtils.readWithCachedStubs(in);
            }
            this.readModifiers = (flags & 2) != 0 ? in.readInt() : 0;
        } else {
            this.readModifiers = 0;
        }
    }

    private short buildFlags() {
        short flags = 0;
        if (this.txn != null) {
            flags = (short)(flags | 1);
        }
        if (this.readModifiers != 0) {
            flags = (short)(flags | 2);
        }
        return flags;
    }
}

