/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.client.spaceproxy.operations;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.client.ChangeException;
import com.gigaspaces.client.ChangeResult;
import com.gigaspaces.client.ChangedEntryDetails;
import com.gigaspaces.client.FailedChangedEntryDetails;
import com.gigaspaces.client.mutators.SpaceEntryMutator;
import com.gigaspaces.internal.client.ChangeDetailedResultImpl;
import com.gigaspaces.internal.client.ChangeEntryDetailsImpl;
import com.gigaspaces.internal.client.ChangeResultImpl;
import com.gigaspaces.internal.client.spaceproxy.operations.ChangeEntriesSpaceOperationResult;
import com.gigaspaces.internal.client.spaceproxy.operations.SpaceOperationRequest;
import com.gigaspaces.internal.io.IOUtils;
import com.gigaspaces.internal.query.QueryUtils;
import com.gigaspaces.internal.remoting.RemoteOperationRequest;
import com.gigaspaces.internal.remoting.routing.partitioned.PartitionedClusterExecutionType;
import com.gigaspaces.internal.remoting.routing.partitioned.PartitionedClusterRemoteOperationRouter;
import com.gigaspaces.internal.transport.ITemplatePacket;
import com.gigaspaces.internal.utils.Textualizer;
import com.gigaspaces.internal.version.PlatformLogicalVersion;
import com.gigaspaces.lrmi.LRMIInvocationContext;
import com.j_spaces.core.client.Modifiers;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jini.core.transaction.Transaction;
import net.jini.core.transaction.TransactionException;

@InternalApi
public class ChangeEntriesSpaceOperationRequest
extends SpaceOperationRequest<ChangeEntriesSpaceOperationResult> {
    private static final long serialVersionUID = 1L;
    private static final Logger _devLogger = Logger.getLogger("com.gigaspaces.dev");
    private ITemplatePacket _templatePacket;
    private Transaction _txn;
    private long _timeout;
    private long _lease;
    private int _modifiers;
    private Collection<SpaceEntryMutator> _mutators;
    private transient List<ChangeResult<?>> _updates;
    private transient List<Throwable> _exceptions;
    private transient List<ChangeException> _changeExceptions;
    private transient int _totalNumberOfMatchesEntries;
    private transient Object _query;
    private static final short FLAG_TRANSACTION = 1;
    private static final short FLAG_TIMEOUT = 2;
    private static final short FLAG_LEASE = 4;
    private static final short FLAG_MODIFIERS = 8;
    private static final int DEFAULT_MODIFIERS = 0;
    private static final long DEFAULT_TIMEOUT = 0L;
    private static final long DEFAULT_LEASE = 0L;

    public ChangeEntriesSpaceOperationRequest() {
    }

    public ChangeEntriesSpaceOperationRequest(ITemplatePacket templatePacket, Transaction txn, long timeout, long lease, int modifiers, Collection<SpaceEntryMutator> mutators, Object query) {
        this._templatePacket = templatePacket;
        this._txn = txn;
        this._timeout = timeout;
        this._lease = lease;
        this._modifiers = modifiers;
        this._mutators = mutators;
        this._query = query;
    }

    @Override
    public void toText(Textualizer textualizer) {
        super.toText(textualizer);
        textualizer.append("templatePacket", this._templatePacket);
        textualizer.append("txn", this._txn);
        textualizer.append("timeout", this._timeout);
        textualizer.append("lease", this._lease);
        textualizer.append("modifiers", this._modifiers);
        textualizer.append("mutators", this._mutators);
    }

    @Override
    public int getOperationCode() {
        return 17;
    }

    @Override
    public ChangeEntriesSpaceOperationResult createRemoteOperationResult() {
        return new ChangeEntriesSpaceOperationResult();
    }

    @Override
    public PartitionedClusterExecutionType getPartitionedClusterExecutionType() {
        if (this._templatePacket.getRoutingFieldValue() != null) {
            return PartitionedClusterExecutionType.SINGLE;
        }
        return PartitionedClusterExecutionType.BROADCAST_CONCURRENT;
    }

    @Override
    public boolean processPartitionResult(ChangeEntriesSpaceOperationResult remoteOperationResult, List<ChangeEntriesSpaceOperationResult> previousResults, int numOfPartitions) {
        this._totalNumberOfMatchesEntries += remoteOperationResult.getNumOfEntriesMatched();
        if (this.getRemoteOperationResult() == null) {
            this.setRemoteOperationResult(remoteOperationResult);
        }
        if (numOfPartitions > 1 || remoteOperationResult.getExecutionException() != null && !(remoteOperationResult.getExecutionException() instanceof ChangeException)) {
            if (remoteOperationResult.getExecutionException() != null) {
                Exception ex = remoteOperationResult.getExecutionException();
                if (ex instanceof ChangeException) {
                    if (this._changeExceptions == null) {
                        this._changeExceptions = new ArrayList<ChangeException>(numOfPartitions);
                    }
                    this._changeExceptions.add((ChangeException)ex);
                } else {
                    if (this._exceptions == null) {
                        this._exceptions = new ArrayList<Throwable>(numOfPartitions);
                    }
                    this._exceptions.add(ex);
                }
            }
            if (remoteOperationResult.getChangeResult() != null) {
                if (this._updates == null) {
                    this._updates = new ArrayList(numOfPartitions);
                }
                this._updates.add(remoteOperationResult.getChangeResult());
            }
        }
        return numOfPartitions > 1;
    }

    @Override
    public Object getPartitionedClusterRoutingValue(PartitionedClusterRemoteOperationRouter router) {
        return this._templatePacket.getRoutingFieldValue();
    }

    public ITemplatePacket getTemplatePacket() {
        return this._templatePacket;
    }

    public int getModifiers() {
        return this._modifiers;
    }

    public long getTimeout() {
        return this._timeout;
    }

    public long getLease() {
        return this._lease;
    }

    @Override
    public Transaction getTransaction() {
        return this._txn;
    }

    @Override
    public boolean isBlockingOperation() {
        return this._timeout != 0L;
    }

    public Collection<SpaceEntryMutator> getMutators() {
        return this._mutators;
    }

    @Override
    public boolean processUnknownTypeException(List<Integer> positions) {
        if (this._templatePacket.isSerializeTypeDesc()) {
            return false;
        }
        this._templatePacket.setSerializeTypeDesc(true);
        return true;
    }

    @Override
    public String getLRMIMethodTrackingId() {
        return "change";
    }

    /*
     * WARNING - void declaration
     */
    public ChangeResult<?> getFinalResult() throws RemoteException, TransactionException, InterruptedException {
        void var5_15;
        boolean isDetailedResult = Modifiers.contains(this._modifiers, 0x2000000);
        if (this._updates == null && this._changeExceptions == null && this._exceptions == null) {
            ChangeEntriesSpaceOperationResult result = (ChangeEntriesSpaceOperationResult)this.getRemoteOperationResult();
            this._totalNumberOfMatchesEntries = result.getNumOfEntriesMatched();
            if (this._totalNumberOfMatchesEntries > 0 && _devLogger.isLoggable(Level.FINEST)) {
                _devLogger.finest(this._totalNumberOfMatchesEntries + " entries were scanned in the space in order to return the result for the change operation of query " + QueryUtils.getQueryDescription(this._query));
            }
            try {
                result.processExecutionException();
            }
            catch (ChangeException e) {
                if (isDetailedResult) {
                    this.setMutators(e.getSuccesfullChanges());
                }
                throw e;
            }
            ChangeResult<?> changeResult = result.getChangeResult();
            if (isDetailedResult) {
                this.setMutators(changeResult.getResults());
            }
            return changeResult;
        }
        if (this._totalNumberOfMatchesEntries > 0 && _devLogger.isLoggable(Level.FINEST)) {
            _devLogger.finest(this._totalNumberOfMatchesEntries + " entries were scanned in the space in order to return the result for the change operation of query " + QueryUtils.getQueryDescription(this._query));
        }
        LinkedList allChangedEntries = null;
        int numChanged = 0;
        if (this._updates != null) {
            for (ChangeResult<?> changeResult : this._updates) {
                if (isDetailedResult && changeResult.getNumberOfChangedEntries() > 0) {
                    if (allChangedEntries == null) {
                        allChangedEntries = new LinkedList();
                    }
                    Collection<ChangedEntryDetails<?>> results = changeResult.getResults();
                    this.setMutators(results);
                    allChangedEntries.addAll(results);
                }
                numChanged += changeResult.getNumberOfChangedEntries();
            }
        }
        if (this._exceptions == null && this._changeExceptions == null) {
            return isDetailedResult ? new ChangeDetailedResultImpl(allChangedEntries == null ? Collections.EMPTY_LIST : allChangedEntries) : new ChangeResultImpl(numChanged);
        }
        ArrayList<FailedChangedEntryDetails> rejectedEntries = null;
        if (this._changeExceptions != null) {
            for (ChangeException ce : this._changeExceptions) {
                if (ce.getErrors() != null && ce.getErrors().size() > 0) {
                    if (this._exceptions == null) {
                        this._exceptions = new ArrayList<Throwable>();
                    }
                    this._exceptions.addAll(ce.getErrors());
                }
                if (ce.getFailedChanges() != null && ce.getFailedChanges().size() > 0) {
                    if (rejectedEntries == null) {
                        rejectedEntries = new ArrayList<FailedChangedEntryDetails>();
                    }
                    rejectedEntries.addAll(ce.getFailedChanges());
                }
                if (ce.getNumSuccesfullChanges() <= 0) continue;
                if (isDetailedResult) {
                    if (allChangedEntries == null) {
                        allChangedEntries = new LinkedList();
                    }
                    this.setMutators(ce.getSuccesfullChanges());
                    allChangedEntries.addAll(ce.getSuccesfullChanges());
                }
                numChanged += ce.getNumSuccesfullChanges();
            }
        }
        Object var5_11 = null;
        if (rejectedEntries != null && !rejectedEntries.isEmpty()) {
            String string = "Failed to change some entries in space";
        } else {
            String string = "error in change operation";
            if (this._exceptions != null && !this._exceptions.isEmpty() && this._exceptions.get(0).getCause() != null) {
                String string2 = string + (this._exceptions.get(0).getCause().getMessage() != null ? this._exceptions.get(0).getCause().getMessage() : this._exceptions.get(0).getCause());
            }
        }
        ChangeException cex = null;
        cex = isDetailedResult ? new ChangeException((String)var5_15, allChangedEntries != null ? allChangedEntries : Collections.EMPTY_LIST, rejectedEntries != null ? rejectedEntries : Collections.EMPTY_LIST, this._exceptions != null ? this._exceptions : Collections.EMPTY_LIST) : new ChangeException((String)var5_15, numChanged, (Collection<FailedChangedEntryDetails>)(rejectedEntries != null ? rejectedEntries : Collections.EMPTY_LIST), this._exceptions != null ? this._exceptions : Collections.EMPTY_LIST);
        throw cex;
    }

    protected void setMutators(Iterable<ChangedEntryDetails<?>> entriesDetails) {
        for (ChangedEntryDetails<?> entryDetails : entriesDetails) {
            if (!(entryDetails instanceof ChangeEntryDetailsImpl)) continue;
            ((ChangeEntryDetailsImpl)entryDetails).setMutators(this._mutators);
        }
    }

    @Override
    public RemoteOperationRequest<ChangeEntriesSpaceOperationResult> createCopy(int targetPartitionId) {
        ChangeEntriesSpaceOperationRequest copy = (ChangeEntriesSpaceOperationRequest)super.createCopy(targetPartitionId);
        copy._templatePacket = this._templatePacket.clone();
        return copy;
    }

    @Override
    public Object getAsyncFinalResult() throws Exception {
        return this.getFinalResult();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        short flags = this.buildFlags();
        out.writeShort(flags);
        IOUtils.writeObject(out, this._templatePacket);
        PlatformLogicalVersion version = LRMIInvocationContext.getEndpointLogicalVersion();
        if (version.greaterOrEquals(PlatformLogicalVersion.v12_1_0)) {
            IOUtils.serializeSupportCodeChangeCollection(out, this._mutators);
        } else {
            IOUtils.writeObject(out, this._mutators);
        }
        if (flags != 0) {
            if (this._txn != null) {
                IOUtils.writeWithCachedStubs(out, this._txn);
            }
            if (this._timeout != 0L) {
                out.writeLong(this._timeout);
            }
            if (this._lease != 0L) {
                out.writeLong(this._lease);
            }
            if (this._modifiers != 0) {
                out.writeInt(this._modifiers);
            }
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        short flags = in.readShort();
        this._templatePacket = (ITemplatePacket)IOUtils.readObject(in);
        PlatformLogicalVersion version = LRMIInvocationContext.getEndpointLogicalVersion();
        if (version.greaterOrEquals(PlatformLogicalVersion.v12_1_0)) {
            this._mutators = new LinkedList<SpaceEntryMutator>();
            IOUtils.deserializeSupportCodeChangeCollection(in, this._mutators);
        } else {
            this._mutators = (Collection)IOUtils.readObject(in);
        }
        if (flags != 0) {
            if ((flags & 1) != 0) {
                this._txn = (Transaction)IOUtils.readWithCachedStubs(in);
            }
            this._timeout = (flags & 2) != 0 ? in.readLong() : 0L;
            this._lease = (flags & 4) != 0 ? in.readLong() : 0L;
            this._modifiers = (flags & 8) != 0 ? in.readInt() : 0;
        } else {
            this._timeout = 0L;
            this._lease = 0L;
            this._modifiers = 0;
        }
    }

    private short buildFlags() {
        short flags = 0;
        if (this._txn != null) {
            flags = (short)(flags | 1);
        }
        if (this._timeout != 0L) {
            flags = (short)(flags | 2);
        }
        if (this._lease != 0L) {
            flags = (short)(flags | 4);
        }
        if (this._modifiers != 0) {
            flags = (short)(flags | 8);
        }
        return flags;
    }
}

