/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.client.spaceproxy.operations;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.client.ChangeResult;
import com.gigaspaces.internal.client.spaceproxy.operations.SpaceOperationResult;
import com.gigaspaces.internal.io.IOUtils;
import com.gigaspaces.internal.utils.Textualizer;
import com.gigaspaces.internal.version.PlatformLogicalVersion;
import com.gigaspaces.lrmi.LRMIInvocationContext;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.rmi.RemoteException;
import net.jini.core.transaction.TransactionException;

@InternalApi
public class ChangeEntriesSpaceOperationResult
extends SpaceOperationResult {
    private static final long serialVersionUID = 1L;
    private ChangeResult<?> _changeResult;
    private int _numOfEntriesMatched;
    private static final short FLAG_NUM_OF_ENTRIES_MATCHED = 1;

    public void processExecutionException() throws TransactionException, RemoteException, InterruptedException {
        Exception executionException = this.getExecutionException();
        if (executionException == null) {
            return;
        }
        if (executionException instanceof TransactionException) {
            throw (TransactionException)((Object)executionException);
        }
        if (executionException instanceof RemoteException) {
            throw (RemoteException)executionException;
        }
        if (executionException instanceof InterruptedException) {
            throw (InterruptedException)executionException;
        }
        ChangeEntriesSpaceOperationResult.onUnexpectedException(executionException);
    }

    public void setChangeResult(ChangeResult<?> changeResult) {
        this._changeResult = changeResult;
    }

    public ChangeResult<?> getChangeResult() {
        return this._changeResult;
    }

    public void setNumOfEntriesMatched(int numOfEntriesMatched) {
        this._numOfEntriesMatched = numOfEntriesMatched;
    }

    public int getNumOfEntriesMatched() {
        return this._numOfEntriesMatched;
    }

    @Override
    public void toText(Textualizer textualizer) {
        super.toText(textualizer);
        textualizer.append("updateResult", this._changeResult);
    }

    @Override
    public String toString() {
        return Textualizer.toString(this);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        IOUtils.writeObject(out, this._changeResult);
        if (LRMIInvocationContext.getEndpointLogicalVersion().greaterOrEquals(PlatformLogicalVersion.v10_0_0)) {
            short flags = this.buildFlags();
            out.writeShort(flags);
            if (flags != 0 && this._numOfEntriesMatched > 0) {
                out.writeInt(this._numOfEntriesMatched);
            }
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        short flags;
        super.readExternal(in);
        this._changeResult = (ChangeResult)IOUtils.readObject(in);
        if (LRMIInvocationContext.getEndpointLogicalVersion().greaterOrEquals(PlatformLogicalVersion.v10_0_0) && (flags = in.readShort()) != 0 && (flags & 1) != 0) {
            this._numOfEntriesMatched = in.readInt();
        }
    }

    private short buildFlags() {
        short flags = 0;
        if (this._numOfEntriesMatched > 0) {
            flags = (short)(flags | 1);
        }
        return flags;
    }
}

