/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.client.spaceproxy.operations;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.client.spaceproxy.operations.CommitPreparedTransactionSpaceOperationResult;
import com.gigaspaces.internal.client.spaceproxy.operations.SpaceOperationRequest;
import com.gigaspaces.internal.io.IOUtils;
import com.gigaspaces.internal.remoting.routing.partitioned.PartitionedClusterExecutionType;
import com.gigaspaces.internal.remoting.routing.partitioned.PartitionedClusterRemoteOperationRouter;
import com.gigaspaces.internal.utils.Textualizer;
import com.j_spaces.core.OperationID;
import com.j_spaces.core.client.IProxySecurityManager;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import net.jini.core.transaction.server.TransactionManager;

@InternalApi
public class CommitPreparedTransactionSpaceOperationRequest
extends SpaceOperationRequest<CommitPreparedTransactionSpaceOperationResult> {
    private static final long serialVersionUID = 1L;
    private TransactionManager _mgr;
    private long _id;
    private Object _xid;
    private int _numParticipants;
    private OperationID _operationID;
    private transient int _partitionId;
    private static final short FLAG_XID = 1;

    public CommitPreparedTransactionSpaceOperationRequest() {
    }

    public CommitPreparedTransactionSpaceOperationRequest(TransactionManager mgr, long id, int partitionId, int numParticipants, OperationID operationID) {
        this._mgr = mgr;
        this._id = id;
        this._numParticipants = numParticipants;
        this._partitionId = partitionId;
        this._operationID = operationID;
    }

    public CommitPreparedTransactionSpaceOperationRequest(TransactionManager mgr, Object xid, int partitionId, int numParticipants, OperationID operationID) {
        if (xid == null) {
            throw new IllegalArgumentException("xid parameter cannot be null");
        }
        this._mgr = mgr;
        this._xid = xid;
        this._operationID = operationID;
        this._numParticipants = numParticipants;
        this._partitionId = partitionId;
    }

    @Override
    public CommitPreparedTransactionSpaceOperationResult createRemoteOperationResult() {
        return new CommitPreparedTransactionSpaceOperationResult();
    }

    @Override
    public PartitionedClusterExecutionType getPartitionedClusterExecutionType() {
        return PartitionedClusterExecutionType.SINGLE;
    }

    @Override
    public Object getPartitionedClusterRoutingValue(PartitionedClusterRemoteOperationRouter router) {
        return this._partitionId;
    }

    @Override
    public int getOperationCode() {
        return 2;
    }

    public TransactionManager getMgr() {
        return this._mgr;
    }

    public Object getXid() {
        return this._xid;
    }

    public long getId() {
        return this._id;
    }

    public int getNumParticipants() {
        return this._numParticipants;
    }

    public OperationID getOperationID() {
        return this._operationID;
    }

    @Override
    public String getLRMIMethodTrackingId() {
        return "commit";
    }

    @Override
    public void toText(Textualizer textualizer) {
        super.toText(textualizer);
        if (this._xid != null) {
            textualizer.append("xid", this._xid);
        } else {
            textualizer.append("id", this._id);
        }
        textualizer.append("operationID", this._operationID);
        textualizer.append("numParticipants", this._numParticipants);
        textualizer.append("partitionId", this._partitionId);
        textualizer.append("manager", this._mgr);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        short flags = this.buildFlags();
        out.writeShort(flags);
        IOUtils.writeObject(out, this._mgr);
        out.writeInt(this._numParticipants);
        IOUtils.writeObject(out, this._operationID);
        if (this._xid != null) {
            IOUtils.writeObject(out, this._xid);
        } else {
            out.writeLong(this._id);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        short flags = in.readShort();
        this._mgr = (TransactionManager)IOUtils.readObject(in);
        this._numParticipants = in.readInt();
        this._operationID = (OperationID)IOUtils.readObject(in);
        if ((flags & 1) != 0) {
            this._xid = IOUtils.readObject(in);
        } else {
            this._id = in.readLong();
        }
    }

    private short buildFlags() {
        short flags = 0;
        if (this._xid != null) {
            flags = (short)(flags | 1);
        }
        return flags;
    }

    @Override
    public boolean supportsSecurity() {
        return IProxySecurityManager.SUPPORT_TRANSACTION_AUTHENTICATION;
    }
}

