/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.client.spaceproxy.operations;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.client.spaceproxy.operations.CountClearEntriesSpaceOperationResult;
import com.gigaspaces.internal.client.spaceproxy.operations.SpaceOperationRequest;
import com.gigaspaces.internal.client.spaceproxy.operations.SpaceOperationResult;
import com.gigaspaces.internal.io.IOUtils;
import com.gigaspaces.internal.query.explainplan.ExplainPlanImpl;
import com.gigaspaces.internal.remoting.RemoteOperationRequest;
import com.gigaspaces.internal.remoting.routing.partitioned.PartitionedClusterExecutionType;
import com.gigaspaces.internal.remoting.routing.partitioned.PartitionedClusterRemoteOperationRouter;
import com.gigaspaces.internal.transport.ITemplatePacket;
import com.gigaspaces.internal.utils.Textualizer;
import com.gigaspaces.query.explainplan.ExplainPlan;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.rmi.RemoteException;
import java.util.List;
import net.jini.core.entry.UnusableEntryException;
import net.jini.core.transaction.Transaction;
import net.jini.core.transaction.TransactionException;

@InternalApi
public class CountClearEntriesSpaceOperationRequest
extends SpaceOperationRequest<CountClearEntriesSpaceOperationResult> {
    private static final long serialVersionUID = 1L;
    private ITemplatePacket _templatePacket;
    private Transaction _txn;
    private boolean _isClear;
    private int _modifiers;
    private transient CountClearEntriesSpaceOperationResult _finalResult;
    private transient ExplainPlanImpl explainPlan;
    private static final short FLAG_TRANSACTION = 1;
    private static final short FLAG_MODIFIERS = 2;
    private static final short FLAG_IS_CLEAR = 4;
    private static final int DEFAULT_MODIFIERS = 0;

    public CountClearEntriesSpaceOperationRequest() {
    }

    public CountClearEntriesSpaceOperationRequest(ITemplatePacket templatePacket, Transaction txn, boolean isClear, int modifiers) {
        this._templatePacket = templatePacket;
        this._txn = txn;
        this._isClear = isClear;
        this._modifiers = modifiers;
        this.explainPlan = ExplainPlanImpl.fromQueryPacket(templatePacket);
    }

    @Override
    public void toText(Textualizer textualizer) {
        super.toText(textualizer);
        textualizer.append("isClear", this._isClear);
        textualizer.append("template", this._templatePacket);
        textualizer.append("txn", this._txn);
        textualizer.append("modifiers", this._modifiers);
        textualizer.append("typeName", this._templatePacket.getTypeName());
    }

    @Override
    public int getOperationCode() {
        return 15;
    }

    @Override
    public CountClearEntriesSpaceOperationResult createRemoteOperationResult() {
        return new CountClearEntriesSpaceOperationResult();
    }

    @Override
    public PartitionedClusterExecutionType getPartitionedClusterExecutionType() {
        if (this._templatePacket.getRoutingFieldValue() != null) {
            return PartitionedClusterExecutionType.SINGLE;
        }
        return PartitionedClusterExecutionType.BROADCAST_CONCURRENT;
    }

    @Override
    public Object getPartitionedClusterRoutingValue(PartitionedClusterRemoteOperationRouter router) {
        return this._templatePacket.getRoutingFieldValue();
    }

    public ITemplatePacket getTemplatePacket() {
        return this._templatePacket;
    }

    public int getModifiers() {
        return this._modifiers;
    }

    @Override
    public Transaction getTransaction() {
        return this._txn;
    }

    @Override
    public boolean isBlockingOperation() {
        return false;
    }

    public boolean isClear() {
        return this._isClear;
    }

    @Override
    public String getLRMIMethodTrackingId() {
        return this.isClear() ? "clear" : "count";
    }

    @Override
    public boolean processUnknownTypeException(List<Integer> positions) {
        if (this._templatePacket.isSerializeTypeDesc()) {
            return false;
        }
        this._templatePacket.setSerializeTypeDesc(true);
        return true;
    }

    @Override
    public boolean processPartitionResult(CountClearEntriesSpaceOperationResult remoteOperationResult, List<CountClearEntriesSpaceOperationResult> previousResults, int numOfPartitions) {
        if (remoteOperationResult.getExecutionException() != null) {
            this._finalResult = remoteOperationResult;
            return this._isClear;
        }
        this.processExplainPlan(remoteOperationResult);
        if (this._finalResult == null) {
            this._finalResult = remoteOperationResult;
        } else {
            this._finalResult.add(remoteOperationResult.getCount());
        }
        return true;
    }

    public int getFinalResult() throws RemoteException, TransactionException, UnusableEntryException {
        CountClearEntriesSpaceOperationResult result = this._finalResult == null ? (CountClearEntriesSpaceOperationResult)this.getRemoteOperationResult() : this._finalResult;
        result.processExecutionException();
        return result.getCount();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        short flags = this.buildFlags();
        out.writeShort(flags);
        IOUtils.writeObject(out, this._templatePacket);
        if (flags != 0) {
            if (this._txn != null) {
                IOUtils.writeWithCachedStubs(out, this._txn);
            }
            if (this._modifiers != 0) {
                out.writeInt(this._modifiers);
            }
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        short flags = in.readShort();
        this._templatePacket = (ITemplatePacket)IOUtils.readObject(in);
        if (flags != 0) {
            if ((flags & 1) != 0) {
                this._txn = (Transaction)IOUtils.readWithCachedStubs(in);
            }
            this._modifiers = (flags & 2) != 0 ? in.readInt() : 0;
            this._isClear = (flags & 4) != 0;
        } else {
            this._modifiers = 0;
        }
    }

    @Override
    public RemoteOperationRequest<CountClearEntriesSpaceOperationResult> createCopy(int targetPartitionId) {
        CountClearEntriesSpaceOperationRequest copy = (CountClearEntriesSpaceOperationRequest)super.createCopy(targetPartitionId);
        copy._templatePacket = this._templatePacket.clone();
        return copy;
    }

    private short buildFlags() {
        short flags = 0;
        if (this._txn != null) {
            flags = (short)(flags | 1);
        }
        if (this._modifiers != 0) {
            flags = (short)(flags | 2);
        }
        if (this._isClear) {
            flags = (short)(flags | 4);
        }
        return flags;
    }

    @Override
    public boolean hasLockedResources() {
        return this._isClear && ((CountClearEntriesSpaceOperationResult)this.getRemoteOperationResult()).getCount() > 0;
    }

    @Override
    public void afterOperationExecution(int partitionId) {
        this.processExplainPlan((SpaceOperationResult)this.getRemoteOperationResult());
    }

    private void processExplainPlan(SpaceOperationResult result) {
        if (result != null && result.getExplainPlan() != null) {
            this.explainPlan.aggregate(result.getExplainPlan());
        }
    }

    public ExplainPlan getExplainPlan() {
        return this.explainPlan;
    }
}

