/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.client.spaceproxy.operations;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.async.AsyncResult;
import com.gigaspaces.async.AsyncResultFilter;
import com.gigaspaces.async.AsyncResultFilterEvent;
import com.gigaspaces.async.AsyncResultsReducer;
import com.gigaspaces.async.internal.DefaultAsyncResult;
import com.gigaspaces.executor.SpaceTask;
import com.gigaspaces.executor.SpaceTaskWrapper;
import com.gigaspaces.internal.client.spaceproxy.operations.ExecuteTaskSpaceOperationResult;
import com.gigaspaces.internal.client.spaceproxy.operations.SpaceOperationRequest;
import com.gigaspaces.internal.io.IOUtils;
import com.gigaspaces.internal.remoting.routing.partitioned.PartitionedClusterExecutionType;
import com.gigaspaces.internal.remoting.routing.partitioned.PartitionedClusterRemoteOperationRouter;
import com.gigaspaces.internal.utils.Textualizer;
import com.gigaspaces.internal.version.PlatformLogicalVersion;
import com.gigaspaces.lrmi.LRMIInvocationContext;
import com.gigaspaces.utils.CodeChangeUtilities;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import net.jini.core.transaction.Transaction;
import net.jini.core.transaction.server.ServerTransaction;
import org.jini.rio.boot.SupportCodeChangeAnnotationContainer;

@InternalApi
public class ExecuteTaskSpaceOperationRequest
extends SpaceOperationRequest<ExecuteTaskSpaceOperationResult> {
    private static final long serialVersionUID = 1L;
    private static final AsyncResult<Object>[] EMPTY_RESULTS = new AsyncResult[0];
    private SpaceTask<?> _task;
    private Transaction _txn;
    private transient Object _routingValue;
    private transient AsyncResultsReducer<Object, Object> _reducer;
    private transient AsyncResultFilter<Object> _filter;
    private transient List<AsyncResult<Object>> _prevResults;
    private Transaction _originalTranscation;

    public ExecuteTaskSpaceOperationRequest() {
    }

    public ExecuteTaskSpaceOperationRequest(SpaceTask<?> task, Transaction txn, Object routingValue) {
        this._task = task;
        this._txn = txn;
        this._originalTranscation = txn;
        this._routingValue = routingValue;
        this._reducer = task instanceof AsyncResultsReducer ? (AsyncResultsReducer)((Object)task) : null;
        this._filter = task instanceof AsyncResultFilter ? (AsyncResultFilter)((Object)task) : null;
    }

    @Override
    public void toText(Textualizer textualizer) {
        super.toText(textualizer);
        textualizer.append("task", this._task);
    }

    public SpaceTask<?> getTask() {
        return this._task;
    }

    @Override
    public Transaction getTransaction() {
        return this._txn;
    }

    @Override
    public int getOperationCode() {
        return 0;
    }

    @Override
    public ExecuteTaskSpaceOperationResult createRemoteOperationResult() {
        return new ExecuteTaskSpaceOperationResult();
    }

    @Override
    public boolean isDedicatedPoolRequired() {
        return true;
    }

    @Override
    public PartitionedClusterExecutionType getPartitionedClusterExecutionType() {
        if (this._routingValue == null && this._reducer == null) {
            throw new UnsupportedOperationException("Executing a non-distributed task without a routing value is not supported. Task class: " + this._task.getClass().getName());
        }
        return this._routingValue == null ? PartitionedClusterExecutionType.BROADCAST_CONCURRENT : PartitionedClusterExecutionType.SINGLE;
    }

    @Override
    public Object getPartitionedClusterRoutingValue(PartitionedClusterRemoteOperationRouter router) {
        return this._routingValue;
    }

    @Override
    public boolean processPartitionResult(ExecuteTaskSpaceOperationResult remoteOperationResult, List<ExecuteTaskSpaceOperationResult> previousResults, int numOfPartitions) {
        DefaultAsyncResult<Object> currResult = new DefaultAsyncResult<Object>(remoteOperationResult.getResult(), remoteOperationResult.getExecutionException());
        if (this._filter != null) {
            return this.filterResult(currResult, numOfPartitions);
        }
        this._prevResults = ExecuteTaskSpaceOperationRequest.append(this._prevResults, currResult);
        return true;
    }

    @Override
    public Object getAsyncFinalResult() throws Exception {
        ExecuteTaskSpaceOperationResult remoteResult = (ExecuteTaskSpaceOperationResult)this.getRemoteOperationResult();
        if (remoteResult != null) {
            if (this._reducer == null) {
                if (remoteResult.getExecutionException() != null) {
                    throw remoteResult.getExecutionException();
                }
                return remoteResult.getResult();
            }
            this._prevResults = ExecuteTaskSpaceOperationRequest.append(this._prevResults, new DefaultAsyncResult<Object>(remoteResult.getResult(), remoteResult.getExecutionException()));
        }
        return this._reducer.reduce(this._prevResults);
    }

    @Override
    public boolean beforeOperationExecution(boolean isEmbedded) {
        if (!super.beforeOperationExecution(isEmbedded)) {
            return false;
        }
        if (isEmbedded) {
            return true;
        }
        if (this._txn != null) {
            ServerTransaction transaction = (ServerTransaction)this._txn;
            try {
                if (transaction.isEmbeddedMgrProxySideInstance() && transaction.needParticipantsJoin()) {
                    this._txn = transaction.createCopy();
                    ((ServerTransaction)this._txn).setEmbeddedMgrProxySideInstance(false);
                }
            }
            catch (RemoteException e) {
                this.setRemoteOperationExecutionError(new IllegalStateException("Caught remote exception on embedded transaction manager", e));
                return false;
            }
        }
        return true;
    }

    @Override
    public void afterOperationExecution(int partitionId) {
        super.afterOperationExecution(partitionId);
        this._txn = this._originalTranscation;
    }

    private boolean filterResult(AsyncResult<Object> currResult, int maxResults) {
        if (this._prevResults == null) {
            this._prevResults = new ArrayList<AsyncResult<Object>>();
        }
        AsyncResult<Object>[] prevResults = this._prevResults.isEmpty() ? EMPTY_RESULTS : this._prevResults.toArray(new AsyncResult[this._prevResults.size()]);
        AsyncResultFilterEvent<Object> event = new AsyncResultFilterEvent<Object>(currResult, prevResults, maxResults);
        AsyncResultFilter.Decision filterResult = this._filter.onResult(event);
        switch (filterResult) {
            case CONTINUE: {
                this._prevResults = ExecuteTaskSpaceOperationRequest.append(this._prevResults, currResult);
                return true;
            }
            case SKIP: {
                return true;
            }
            case BREAK: {
                this._prevResults = ExecuteTaskSpaceOperationRequest.append(this._prevResults, currResult);
                return false;
            }
            case SKIP_AND_BREAK: {
                return false;
            }
        }
        return false;
    }

    private static List<AsyncResult<Object>> append(List<AsyncResult<Object>> prevResults, AsyncResult<Object> result) {
        if (prevResults == null) {
            prevResults = new ArrayList<AsyncResult<Object>>();
        }
        prevResults.add(result);
        return prevResults;
    }

    @Override
    public String getLRMIMethodTrackingId() {
        return "executeTask";
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        PlatformLogicalVersion version = LRMIInvocationContext.getEndpointLogicalVersion();
        if (version.greaterOrEquals(PlatformLogicalVersion.v12_1_0)) {
            SupportCodeChangeAnnotationContainer supportCodeChangeAnnotationContainer = null;
            supportCodeChangeAnnotationContainer = this._task instanceof SpaceTaskWrapper ? ((SpaceTaskWrapper)((Object)this._task)).getSupportCodeChangeAnnotationContainer() : CodeChangeUtilities.createContainerFromSupportCodeAnnotationIfNeeded(this._task);
            out.writeObject(supportCodeChangeAnnotationContainer);
        }
        out.writeObject(this._task);
        IOUtils.writeWithCachedStubs(out, this._txn);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        PlatformLogicalVersion version = LRMIInvocationContext.getEndpointLogicalVersion();
        SupportCodeChangeAnnotationContainer supportCodeChangeAnnotationContainer = null;
        boolean useIOUtilsReadExternal = true;
        if (version.greaterOrEquals(PlatformLogicalVersion.v12_1_0)) {
            supportCodeChangeAnnotationContainer = (SupportCodeChangeAnnotationContainer)in.readObject();
            useIOUtilsReadExternal = false;
        }
        this._task = (SpaceTask)IOUtils.readObject(in, supportCodeChangeAnnotationContainer, useIOUtilsReadExternal);
        this._txn = (Transaction)IOUtils.readWithCachedStubs(in);
    }
}

