/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.client.spaceproxy.operations;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.client.ReadTakeByIdsException;
import com.gigaspaces.internal.client.spaceproxy.operations.ReadTakeEntriesByIdsSpaceOperationResult;
import com.gigaspaces.internal.client.spaceproxy.operations.SpaceScatterGatherOperationRequest;
import com.gigaspaces.internal.io.IOUtils;
import com.gigaspaces.internal.remoting.routing.partitioned.PartitionedClusterExecutionType;
import com.gigaspaces.internal.remoting.routing.partitioned.PartitionedClusterRemoteOperationRouter;
import com.gigaspaces.internal.remoting.routing.partitioned.ScatterGatherOperationFutureListener;
import com.gigaspaces.internal.remoting.routing.partitioned.ScatterGatherPartitionInfo;
import com.gigaspaces.internal.remoting.routing.partitioned.ScatterGatherRemoteOperationRequest;
import com.gigaspaces.internal.transport.IEntryPacket;
import com.gigaspaces.internal.utils.Textualizer;
import com.j_spaces.core.AbstractIdsQueryPacket;
import com.j_spaces.core.IdsMultiRoutingQueryPacket;
import com.j_spaces.core.IdsQueryPacket;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.rmi.RemoteException;
import java.util.List;
import net.jini.core.entry.UnusableEntryException;
import net.jini.core.transaction.Transaction;
import net.jini.core.transaction.TransactionException;

@InternalApi
public class ReadTakeEntriesByIdsSpaceOperationRequest
extends SpaceScatterGatherOperationRequest<ReadTakeEntriesByIdsSpaceOperationResult> {
    private static final long serialVersionUID = 1L;
    private static final int DEFAULT_MODIFIERS = 0;
    private static final short FLAG_TRANSACTION = 1;
    private static final short FLAG_MODIFIERS = 2;
    private static final short FLAG_TAKE = 4;
    private AbstractIdsQueryPacket _template;
    private boolean _take;
    private int _modifiers;
    private Transaction _transaction;
    private transient IEntryPacket[] _results;
    private transient Throwable[] _exceptions;

    public ReadTakeEntriesByIdsSpaceOperationRequest() {
    }

    public ReadTakeEntriesByIdsSpaceOperationRequest(AbstractIdsQueryPacket queryPacket, boolean isTake, int modifiers, Transaction transaction) {
        this._template = queryPacket;
        this._take = isTake;
        this._modifiers = modifiers;
        this._transaction = transaction;
    }

    @Override
    public boolean processPartitionResult(ScatterGatherRemoteOperationRequest<ReadTakeEntriesByIdsSpaceOperationResult> partitionRequest, List<ScatterGatherRemoteOperationRequest<ReadTakeEntriesByIdsSpaceOperationResult>> previousRequests) {
        if (this._results == null) {
            this._results = new IEntryPacket[this._template.getIds().length];
        }
        ReadTakeEntriesByIdsSpaceOperationResult result = (ReadTakeEntriesByIdsSpaceOperationResult)partitionRequest.getRemoteOperationResult();
        ScatterGatherPartitionInfo partitionInfo = partitionRequest.getPartitionInfo();
        if (result.hasException()) {
            this.processScatterResultException(result, partitionInfo);
        } else {
            IEntryPacket[] entries = result.getEntryPackets();
            for (int i = 0; i < partitionInfo.size(); ++i) {
                this._results[partitionInfo.getQuick((int)i)] = entries[i];
            }
        }
        return true;
    }

    private void processScatterResultException(ReadTakeEntriesByIdsSpaceOperationResult result, ScatterGatherPartitionInfo partitionInfo) {
        if (this._exceptions == null) {
            this._exceptions = new Throwable[this._template.getIds().length];
        }
        if (result.getExecutionException() instanceof ReadTakeByIdsException) {
            ReadTakeByIdsException exception = (ReadTakeByIdsException)result.getExecutionException();
            for (int i = 0; i < partitionInfo.size(); ++i) {
                int index = partitionInfo.getQuick(i);
                if (this._results[index] != null) continue;
                if (exception.getResults()[i].isError()) {
                    this._exceptions[index] = exception.getResults()[i].getError();
                    continue;
                }
                this._results[index] = (IEntryPacket)exception.getResults()[i].getObject();
            }
        } else {
            for (int i = 0; i < partitionInfo.size(); ++i) {
                this._exceptions[partitionInfo.getQuick((int)i)] = result.getExecutionException();
            }
        }
    }

    @Override
    public void loadPartitionData(ScatterGatherRemoteOperationRequest<ReadTakeEntriesByIdsSpaceOperationResult> mainRequest) {
        ReadTakeEntriesByIdsSpaceOperationRequest request = (ReadTakeEntriesByIdsSpaceOperationRequest)mainRequest;
        IdsMultiRoutingQueryPacket mainTemplate = (IdsMultiRoutingQueryPacket)request.getTemplate();
        Object[] ids = new Object[this._partitionInfo.size()];
        Object[] routings = new Object[this._partitionInfo.size()];
        for (int i = 0; i < this._partitionInfo.size(); ++i) {
            ids[i] = mainTemplate.getIds()[this._partitionInfo.getQuick(i)];
            routings[i] = mainTemplate.getRoutings()[this._partitionInfo.getQuick(i)];
        }
        this._template = new IdsMultiRoutingQueryPacket(ids, routings, 0, mainTemplate.getTypeDescriptor(), mainTemplate.getQueryResultType(), mainTemplate.getProjectionTemplate());
    }

    @Override
    public int getOperationCode() {
        return 13;
    }

    @Override
    public ReadTakeEntriesByIdsSpaceOperationResult createRemoteOperationResult() {
        return new ReadTakeEntriesByIdsSpaceOperationResult();
    }

    @Override
    public PartitionedClusterExecutionType getPartitionedClusterExecutionType() {
        if (this._template instanceof IdsQueryPacket) {
            IdsQueryPacket queryPacket = (IdsQueryPacket)this._template;
            return queryPacket.getRoutingFieldValue() != null ? PartitionedClusterExecutionType.SINGLE : PartitionedClusterExecutionType.BROADCAST_CONCURRENT;
        }
        return PartitionedClusterExecutionType.SCATTER_CONCURRENT;
    }

    @Override
    public Object getPartitionedClusterRoutingValue(PartitionedClusterRemoteOperationRouter router) {
        return this._template.getRouting(0);
    }

    public ReadTakeEntriesByIdsSpaceOperationResult getFinalResult() throws RemoteException, TransactionException, UnusableEntryException {
        ReadTakeEntriesByIdsSpaceOperationResult result;
        if (this._results != null) {
            result = new ReadTakeEntriesByIdsSpaceOperationResult();
            if (this._exceptions == null) {
                result.setEntryPackets(this._results);
            } else {
                for (int i = 0; i < this._results.length; ++i) {
                    if (this._results[i] == null) continue;
                    this._exceptions[i] = null;
                }
                result.setExecutionException(ReadTakeByIdsException.newException(this._template.getIds(), this._results, this._exceptions, this._take));
            }
        } else {
            result = (ReadTakeEntriesByIdsSpaceOperationResult)this.getRemoteOperationResult();
            if (result.hasException() && !(result.getExecutionException() instanceof ReadTakeByIdsException)) {
                result.setExecutionException(ReadTakeByIdsException.newException(this._template.getIds(), result.getExecutionException(), this._take));
            }
        }
        result.processExecutionException();
        return result;
    }

    @Override
    public void scatterIndexesToPartitions(ScatterGatherOperationFutureListener<ReadTakeEntriesByIdsSpaceOperationResult> scatterGatherCoordinator) {
        IdsMultiRoutingQueryPacket multiRoutingTemplate = (IdsMultiRoutingQueryPacket)this._template;
        scatterGatherCoordinator.mapValuesByHashCode(multiRoutingTemplate.getRoutings(), this);
    }

    @Override
    public boolean processPartitionResult(ReadTakeEntriesByIdsSpaceOperationResult remoteOperationResult, List<ReadTakeEntriesByIdsSpaceOperationResult> previousResults, int numOfPartitions) {
        if (this._results == null) {
            this._results = new IEntryPacket[this._template.getIds().length];
        }
        if (remoteOperationResult.hasException()) {
            this.processBroadcastResultException(remoteOperationResult);
        } else {
            IEntryPacket[] entries = remoteOperationResult.getEntryPackets();
            for (int i = 0; i < entries.length; ++i) {
                if (entries[i] == null) continue;
                this._results[i] = entries[i];
            }
        }
        return true;
    }

    private void processBroadcastResultException(ReadTakeEntriesByIdsSpaceOperationResult remoteOperationResult) {
        boolean internalServerError = remoteOperationResult.getExecutionException() instanceof ReadTakeByIdsException;
        if (this._exceptions == null) {
            this._exceptions = new Throwable[this._template.getIds().length];
            if (!internalServerError) {
                for (int i = 0; i < this._exceptions.length; ++i) {
                    this._exceptions[i] = remoteOperationResult.getExecutionException();
                }
            }
        }
        if (internalServerError) {
            ReadTakeByIdsException exception = (ReadTakeByIdsException)remoteOperationResult.getExecutionException();
            for (int i = 0; i < exception.getResults().length; ++i) {
                if (this._results[i] != null) continue;
                if (exception.getResults()[i].isError()) {
                    this._exceptions[i] = exception.getResults()[i].getError();
                    continue;
                }
                this._results[i] = (IEntryPacket)exception.getResults()[i].getObject();
            }
        }
    }

    @Override
    public String getLRMIMethodTrackingId() {
        return this.isTake() ? "takeByIds" : "readByIds";
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        short flags = this.buildFlags();
        out.writeShort(flags);
        out.writeObject(this._template);
        if ((flags & 1) != 0) {
            IOUtils.writeWithCachedStubs(out, this._transaction);
        }
        if ((flags & 2) != 0) {
            out.writeInt(this._modifiers);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        short flags = in.readShort();
        this._template = (AbstractIdsQueryPacket)in.readObject();
        if ((flags & 1) != 0) {
            this._transaction = (Transaction)IOUtils.readWithCachedStubs(in);
        }
        this._modifiers = (flags & 2) != 0 ? in.readInt() : 0;
        this._take = (flags & 4) != 0;
    }

    @Override
    public boolean processUnknownTypeException(List<Integer> positions) {
        if (this._template.isSerializeTypeDesc()) {
            return false;
        }
        this._template.setSerializeTypeDesc(true);
        return true;
    }

    @Override
    public SpaceScatterGatherOperationRequest<ReadTakeEntriesByIdsSpaceOperationResult> createCopy(int targetPartitionId) {
        ReadTakeEntriesByIdsSpaceOperationRequest copy = (ReadTakeEntriesByIdsSpaceOperationRequest)super.createCopy(targetPartitionId);
        if (this._template instanceof IdsQueryPacket) {
            copy._template = (AbstractIdsQueryPacket)this._template.clone();
        }
        return copy;
    }

    private short buildFlags() {
        short flags = 0;
        if (this._transaction != null) {
            flags = (short)(flags | 1);
        }
        if (this._modifiers != 0) {
            flags = (short)(flags | 2);
        }
        if (this._take) {
            flags = (short)(flags | 4);
        }
        return flags;
    }

    @Override
    public Transaction getTransaction() {
        return this._transaction;
    }

    public boolean isTake() {
        return this._take;
    }

    public int getModifiers() {
        return this._modifiers;
    }

    public AbstractIdsQueryPacket getTemplate() {
        return this._template;
    }

    @Override
    public boolean hasLockedResources() {
        IEntryPacket[] entries = ((ReadTakeEntriesByIdsSpaceOperationResult)this.getRemoteOperationResult()).getEntryPackets();
        if (entries != null && entries.length > 0) {
            for (IEntryPacket entry : entries) {
                if (entry == null) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void toText(Textualizer textualizer) {
        super.toText(textualizer);
        textualizer.append("isTake", this._take);
        textualizer.append("template", this._template);
        textualizer.append("txn", this._transaction);
        textualizer.append("modifiers", this._modifiers);
    }
}

