/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.client.spaceproxy.operations;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.client.ReadMultipleException;
import com.gigaspaces.client.TakeMultipleException;
import com.gigaspaces.internal.client.spaceproxy.operations.ReadTakeEntriesSpaceOperationResult;
import com.gigaspaces.internal.client.spaceproxy.operations.ReplicationLevel;
import com.gigaspaces.internal.client.spaceproxy.operations.SpaceOperationRequest;
import com.gigaspaces.internal.client.spaceproxy.operations.SpaceOperationResult;
import com.gigaspaces.internal.exceptions.BatchQueryException;
import com.gigaspaces.internal.io.IOUtils;
import com.gigaspaces.internal.query.QueryUtils;
import com.gigaspaces.internal.query.explainplan.ExplainPlanImpl;
import com.gigaspaces.internal.remoting.RemoteOperationRequest;
import com.gigaspaces.internal.remoting.routing.partitioned.PartitionedClusterExecutionType;
import com.gigaspaces.internal.remoting.routing.partitioned.PartitionedClusterRemoteOperationRouter;
import com.gigaspaces.internal.transport.IEntryPacket;
import com.gigaspaces.internal.transport.ITemplatePacket;
import com.gigaspaces.internal.utils.Textualizer;
import com.j_spaces.core.client.ReadModifiers;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jini.core.entry.UnusableEntryException;
import net.jini.core.transaction.Transaction;
import net.jini.core.transaction.TransactionException;

@InternalApi
public class ReadTakeEntriesSpaceOperationRequest
extends SpaceOperationRequest<ReadTakeEntriesSpaceOperationResult> {
    private static final long serialVersionUID = 1L;
    private static final Logger _devLogger = Logger.getLogger("com.gigaspaces.dev");
    private ITemplatePacket _templatePacket;
    private Transaction _txn;
    private boolean _isTake;
    private int _modifiers;
    private int _maxResults;
    private int _minResultsToWaitFor;
    private boolean _ifExist;
    private long _timeout;
    private transient int _resultEntriesCount = 0;
    private transient int _finalResultMaxEntries;
    private transient List<IEntryPacket[]> _entries;
    private transient List<Throwable> _exceptions;
    private transient int _totalNumberOfMatchesEntries;
    private transient Object _query;
    private transient Map<IEntryPacket[], Integer> replicationLevels;
    private transient List<ReplicationLevel> levels = null;
    private transient ExplainPlanImpl explainPlan;
    private static final short FLAG_TRANSACTION = 1;
    private static final short FLAG_MAX_ENTRIES = 2;
    private static final short FLAG_MODIFIERS = 4;
    private static final short FLAG_IS_TAKE = 8;
    private static final short FLAG_TIMEOUT = 16;
    private static final short FLAG_MIN_ENTRIES = 32;
    private static final short FLAG_IS_IFEXIST = 64;
    private static final int DEFAULT_MODIFIERS = 0;
    private static final int DEFAULT_MAX_ENTRIES = Integer.MAX_VALUE;

    public ReadTakeEntriesSpaceOperationRequest() {
    }

    public ReadTakeEntriesSpaceOperationRequest(ITemplatePacket templatePacket, Transaction transaction, boolean isTake, int modifiers, int maxResults, int minResultsToWaitFor, long timeout, boolean ifExist, Object query) {
        this._templatePacket = templatePacket;
        this._txn = transaction;
        this._isTake = isTake;
        this._modifiers = modifiers;
        this._maxResults = maxResults;
        this._minResultsToWaitFor = minResultsToWaitFor;
        this._timeout = timeout;
        this._ifExist = ifExist;
        this._finalResultMaxEntries = maxResults;
        this._query = query;
        this.explainPlan = ExplainPlanImpl.fromQueryPacket(query);
    }

    @Override
    public void toText(Textualizer textualizer) {
        super.toText(textualizer);
        textualizer.append("isTake", this._isTake);
        textualizer.append("template", this._templatePacket);
        textualizer.append("txn", this._txn);
        textualizer.append("maxResults", this._maxResults);
        textualizer.append("modifiers", this._modifiers);
        textualizer.append("timeout", this._timeout);
        textualizer.append("minResultsToWaitFor", this._minResultsToWaitFor);
        textualizer.append("ifExist", this._ifExist);
    }

    @Override
    public int getOperationCode() {
        return 12;
    }

    @Override
    public ReadTakeEntriesSpaceOperationResult createRemoteOperationResult() {
        return new ReadTakeEntriesSpaceOperationResult();
    }

    @Override
    public PartitionedClusterExecutionType getPartitionedClusterExecutionType() {
        if (this._templatePacket.getRoutingFieldValue() != null) {
            return PartitionedClusterExecutionType.SINGLE;
        }
        if (this._timeout != 0L) {
            throw new IllegalArgumentException("Broadcast is not supported for Read/Take multiple Operations with timeout greater than 0. (Type='" + this._templatePacket.getTypeName() + "' ,routing property='" + this._templatePacket.getTypeDescriptor().getRoutingPropertyName() + "')");
        }
        if (this._maxResults != Integer.MAX_VALUE && (this._isTake || this._txn != null)) {
            return PartitionedClusterExecutionType.BROADCAST_SEQUENTIAL;
        }
        return PartitionedClusterExecutionType.BROADCAST_CONCURRENT;
    }

    @Override
    public boolean processPartitionResult(ReadTakeEntriesSpaceOperationResult remoteOperationResult, List<ReadTakeEntriesSpaceOperationResult> previousResults, int numberOfPartitions) {
        this._totalNumberOfMatchesEntries += remoteOperationResult.getNumOfEntriesMatched();
        if (remoteOperationResult.hasException()) {
            if (this._exceptions == null) {
                this._exceptions = new LinkedList<Throwable>();
            }
            this._exceptions.add(remoteOperationResult.getExecutionException());
        } else {
            if (remoteOperationResult.getEntryPackets() != null) {
                if (this._entries == null) {
                    this._entries = new LinkedList<IEntryPacket[]>();
                    this.replicationLevels = new HashMap<IEntryPacket[], Integer>();
                }
                this._entries.add(remoteOperationResult.getEntryPackets());
                this.replicationLevels.put(remoteOperationResult.getEntryPackets(), remoteOperationResult.getSyncReplicationLevel());
                this._resultEntriesCount += remoteOperationResult.getEntryPackets().length;
                if (previousResults.size() + 1 == numberOfPartitions) {
                    this.levels = new ArrayList<ReplicationLevel>(this._entries.size());
                    int index = 0;
                    for (IEntryPacket[] entry : this._entries) {
                        this.levels.add(new ReplicationLevel(index, entry.length, this.replicationLevels.get(entry)));
                        index += entry.length;
                    }
                    this.replicationLevels.clear();
                }
            }
            if (this._maxResults != Integer.MAX_VALUE) {
                this._maxResults -= remoteOperationResult.getEntryPackets().length;
                this._minResultsToWaitFor = Math.min(this._minResultsToWaitFor, this._maxResults);
            }
            this.processExplainPlan(remoteOperationResult);
        }
        return this._maxResults > 0;
    }

    public IEntryPacket[] getFinalResult() throws RemoteException, TransactionException, UnusableEntryException {
        ReadTakeEntriesSpaceOperationResult result;
        if (this._entries == null && this._exceptions == null) {
            result = (ReadTakeEntriesSpaceOperationResult)this.getRemoteOperationResult();
            this._totalNumberOfMatchesEntries = ((ReadTakeEntriesSpaceOperationResult)this.getRemoteOperationResult()).getNumOfEntriesMatched();
        } else {
            int resultsCount = Math.min(this._resultEntriesCount, this._finalResultMaxEntries);
            IEntryPacket[] entries = new IEntryPacket[resultsCount];
            if (this._entries != null) {
                int index = 0;
                for (IEntryPacket[] entry : this._entries) {
                    index = this.accumulateResult(entry, entries, index);
                }
            }
            result = new ReadTakeEntriesSpaceOperationResult(entries);
            if (this._exceptions != null && entries.length < this._finalResultMaxEntries && ReadModifiers.isThrowPartialFailure(this._modifiers)) {
                result.setExecutionException(this.createPartialExecutionException(entries));
            }
        }
        result.processExecutionException();
        if (this._totalNumberOfMatchesEntries > 0 && _devLogger.isLoggable(Level.FINEST)) {
            _devLogger.finest(this._totalNumberOfMatchesEntries + " entries were scanned in the space in order to return the result for the " + (this._isTake ? "take" : "read") + " multiple operation of query " + QueryUtils.getQueryDescription(this._query));
        }
        IEntryPacket[] entryPackets = result.getEntryPackets();
        return entryPackets;
    }

    private BatchQueryException createPartialExecutionException(IEntryPacket[] entries) {
        return this._isTake ? new TakeMultipleException(entries, this._exceptions) : new ReadMultipleException(entries, this._exceptions);
    }

    private int accumulateResult(IEntryPacket[] entryPackets, IEntryPacket[] entries, int index) {
        for (int i = 0; i < entryPackets.length && index < entries.length; ++i) {
            entries[index++] = entryPackets[i];
        }
        return index;
    }

    @Override
    public Object getPartitionedClusterRoutingValue(PartitionedClusterRemoteOperationRouter router) {
        return this._templatePacket.getRoutingFieldValue();
    }

    @Override
    public boolean processUnknownTypeException(List<Integer> positions) {
        if (this._templatePacket.isSerializeTypeDesc()) {
            return false;
        }
        this._templatePacket.setSerializeTypeDesc(true);
        return true;
    }

    @Override
    public Transaction getTransaction() {
        return this._txn;
    }

    public ITemplatePacket getTemplatePacket() {
        return this._templatePacket;
    }

    public boolean isTake() {
        return this._isTake;
    }

    public int getMaxResults() {
        return this._maxResults;
    }

    public int getModifiers() {
        return this._modifiers;
    }

    public int getMinResultsToWaitFor() {
        return this._minResultsToWaitFor;
    }

    public long getTimeOut() {
        return this._timeout;
    }

    public boolean isIfExist() {
        return this._ifExist;
    }

    @Override
    public String getLRMIMethodTrackingId() {
        return this.isTake() ? "takeMultiple" : "readMultiple";
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        short flags = this.buildFlags();
        out.writeShort(flags);
        IOUtils.writeObject(out, this._templatePacket);
        if (flags != 0) {
            if (this._txn != null) {
                IOUtils.writeWithCachedStubs(out, this._txn);
            }
            if (this._maxResults != Integer.MAX_VALUE) {
                out.writeInt(this._maxResults);
            }
            if (this._modifiers != 0) {
                out.writeInt(this._modifiers);
            }
            if (this._timeout != 0L) {
                out.writeLong(this._timeout);
            }
            if (this._maxResults != this._minResultsToWaitFor) {
                out.writeInt(this._minResultsToWaitFor);
            }
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        short flags = in.readShort();
        this._templatePacket = (ITemplatePacket)IOUtils.readObject(in);
        if (flags != 0) {
            if ((flags & 1) != 0) {
                this._txn = (Transaction)IOUtils.readWithCachedStubs(in);
            }
            this._maxResults = (flags & 2) != 0 ? in.readInt() : Integer.MAX_VALUE;
            this._modifiers = (flags & 4) != 0 ? in.readInt() : 0;
            this._isTake = (flags & 8) != 0;
            this._timeout = (flags & 0x10) != 0 ? in.readLong() : 0L;
            this._minResultsToWaitFor = (flags & 0x20) != 0 ? in.readInt() : this._maxResults;
            this._ifExist = (flags & 0x40) != 0;
        } else {
            this._modifiers = 0;
            this._minResultsToWaitFor = this._maxResults = Integer.MAX_VALUE;
        }
    }

    @Override
    public RemoteOperationRequest<ReadTakeEntriesSpaceOperationResult> createCopy(int targetPartitionId) {
        ReadTakeEntriesSpaceOperationRequest copy = (ReadTakeEntriesSpaceOperationRequest)super.createCopy(targetPartitionId);
        copy._templatePacket = this._templatePacket.clone();
        return copy;
    }

    private short buildFlags() {
        short flags = 0;
        if (this._txn != null) {
            flags = (short)(flags | 1);
        }
        if (this._maxResults != Integer.MAX_VALUE) {
            flags = (short)(flags | 2);
        }
        if (this._modifiers != 0) {
            flags = (short)(flags | 4);
        }
        if (this._isTake) {
            flags = (short)(flags | 8);
        }
        if (this._timeout != 0L) {
            flags = (short)(flags | 0x10);
        }
        if (this._minResultsToWaitFor != this._maxResults) {
            flags = (short)(flags | 0x20);
        }
        if (this._ifExist) {
            flags = (short)(flags | 0x40);
        }
        return flags;
    }

    @Override
    public boolean hasLockedResources() {
        return ((ReadTakeEntriesSpaceOperationResult)this.getRemoteOperationResult()).getEntryPackets() != null && ((ReadTakeEntriesSpaceOperationResult)this.getRemoteOperationResult()).getEntryPackets().length > 0;
    }

    @Override
    public boolean requiresPartitionedPreciseDistribution() {
        return this._isTake;
    }

    @Override
    public int getPreciseDistributionGroupingCode() {
        if (this._isTake) {
            return 1;
        }
        throw new UnsupportedOperationException();
    }

    public List<ReplicationLevel> getLevels() {
        return this.levels;
    }

    @Override
    public void afterOperationExecution(int partitionId) {
        this.processExplainPlan((SpaceOperationResult)this.getRemoteOperationResult());
    }

    private void processExplainPlan(SpaceOperationResult result) {
        if (result != null && result.getExplainPlan() != null) {
            this.explainPlan.aggregate(result.getExplainPlan());
        }
    }
}

