/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.client.spaceproxy.operations;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.client.spaceproxy.operations.SpaceOperationResult;
import com.gigaspaces.internal.transport.IEntryPacket;
import com.gigaspaces.internal.utils.Textualizer;
import com.gigaspaces.internal.version.PlatformLogicalVersion;
import com.gigaspaces.lrmi.LRMIInvocationContext;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.rmi.RemoteException;
import net.jini.core.entry.UnusableEntryException;
import net.jini.core.transaction.TransactionException;

@InternalApi
public class ReadTakeEntriesSpaceOperationResult
extends SpaceOperationResult {
    private static final long serialVersionUID = 1L;
    private IEntryPacket[] _entryPackets;
    private int _numOfEntriesMatched;
    private int syncReplicationLevel;
    private static final short FLAG_ENTRY_PACKETS = 1;
    private static final short FLAG_NUM_OF_ENTRIES_MATCHED = 2;
    private static final short FLAG_SYNC_REPLICATION_LEVEL = 4;

    public ReadTakeEntriesSpaceOperationResult() {
    }

    public ReadTakeEntriesSpaceOperationResult(IEntryPacket[] entries) {
        this._entryPackets = entries;
    }

    public ReadTakeEntriesSpaceOperationResult(IEntryPacket[] entries, Exception ex) {
        this._entryPackets = entries;
        super.setExecutionException(ex);
    }

    @Override
    public void toText(Textualizer textualizer) {
        super.toText(textualizer);
        textualizer.append("entryPackets", this._entryPackets);
    }

    public void processExecutionException() throws TransactionException, RemoteException, UnusableEntryException {
        Exception executionException = this.getExecutionException();
        if (executionException == null) {
            return;
        }
        if (executionException instanceof TransactionException) {
            throw (TransactionException)((Object)executionException);
        }
        if (executionException instanceof RemoteException) {
            throw (RemoteException)executionException;
        }
        if (executionException instanceof UnusableEntryException) {
            throw (UnusableEntryException)((Object)executionException);
        }
        ReadTakeEntriesSpaceOperationResult.onUnexpectedException(executionException);
    }

    public int getSyncReplicationLevel() {
        return this.syncReplicationLevel;
    }

    public void setSyncReplicationLevel(int syncReplicationLevel) {
        this.syncReplicationLevel = syncReplicationLevel;
    }

    public IEntryPacket[] getEntryPackets() {
        return this._entryPackets;
    }

    public void setEntryPackets(IEntryPacket[] entryPackets) {
        this._entryPackets = entryPackets;
    }

    public void setNumOfEntriesMatched(int numOfEntriesMatched) {
        this._numOfEntriesMatched = numOfEntriesMatched;
    }

    public int getNumOfEntriesMatched() {
        return this._numOfEntriesMatched;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        if (LRMIInvocationContext.getEndpointLogicalVersion().greaterOrEquals(PlatformLogicalVersion.v10_0_0)) {
            this.writeExternalV10(out);
        } else {
            out.writeObject(this._entryPackets);
        }
    }

    private void writeExternalV10(ObjectOutput out) throws IOException {
        short flags = this.buildFlags();
        out.writeShort(flags);
        if (flags != 0) {
            if (this._entryPackets != null) {
                out.writeObject(this._entryPackets);
            }
            if (this._numOfEntriesMatched > 0) {
                out.writeInt(this._numOfEntriesMatched);
            }
            if (0 < this.syncReplicationLevel) {
                out.writeInt(this.syncReplicationLevel);
            }
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        if (LRMIInvocationContext.getEndpointLogicalVersion().greaterOrEquals(PlatformLogicalVersion.v10_0_0)) {
            this.readExternalV10(in);
        } else {
            this._entryPackets = (IEntryPacket[])in.readObject();
        }
    }

    private void readExternalV10(ObjectInput in) throws IOException, ClassNotFoundException {
        short flags = in.readShort();
        if (flags != 0) {
            if ((flags & 1) != 0) {
                this._entryPackets = (IEntryPacket[])in.readObject();
            }
            if ((flags & 2) != 0) {
                this._numOfEntriesMatched = in.readInt();
            }
            this.syncReplicationLevel = (flags & 4) != 0 ? in.readInt() : 0;
        }
    }

    private short buildFlags() {
        short flags = 0;
        if (this._entryPackets != null) {
            flags = (short)(flags | 1);
        }
        if (this._numOfEntriesMatched > 0) {
            flags = (short)(flags | 2);
        }
        if (0 < this.syncReplicationLevel) {
            flags = (short)(flags | 4);
        }
        return flags;
    }
}

