/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.client.spaceproxy.operations;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.cluster.loadbalance.PartitionResultsMetadata;
import com.gigaspaces.internal.client.ReadTakeEntriesUidsResult;
import com.gigaspaces.internal.client.spaceproxy.operations.ReadTakeEntriesUidsSpaceOperationResult;
import com.gigaspaces.internal.client.spaceproxy.operations.SpaceOperationRequest;
import com.gigaspaces.internal.io.IOUtils;
import com.gigaspaces.internal.query.IPartitionResultMetadata;
import com.gigaspaces.internal.query.PartitionResultMetadata;
import com.gigaspaces.internal.remoting.RemoteOperationRequest;
import com.gigaspaces.internal.remoting.routing.partitioned.PartitionedClusterExecutionType;
import com.gigaspaces.internal.remoting.routing.partitioned.PartitionedClusterRemoteOperationRouter;
import com.gigaspaces.internal.transport.ITemplatePacket;
import com.gigaspaces.internal.utils.Textualizer;
import com.j_spaces.core.client.Modifiers;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.rmi.RemoteException;
import java.util.LinkedList;
import java.util.List;
import net.jini.core.entry.UnusableEntryException;
import net.jini.core.transaction.Transaction;
import net.jini.core.transaction.TransactionException;

@InternalApi
public class ReadTakeEntriesUidsSpaceOperationRequest
extends SpaceOperationRequest<ReadTakeEntriesUidsSpaceOperationResult> {
    private static final long serialVersionUID = 1L;
    private static final short FLAG_TRANSACTION = 1;
    private static final short FLAG_ENTRIES_LIMIT = 2;
    private static final short FLAG_MODIFIERS = 4;
    private static final int DEFAULT_ENTRIES_LIMIT = Integer.MAX_VALUE;
    private static final int DEFAULT_MODIFIERS = 0;
    private ITemplatePacket _template;
    private Transaction _txn;
    private int _maxResults;
    private int _modifiers;
    private transient List<String[]> _results;
    private transient List<IPartitionResultMetadata> _metadata;
    private transient Exception _exception;
    private transient int _resultsCount;

    public ReadTakeEntriesUidsSpaceOperationRequest() {
    }

    public ReadTakeEntriesUidsSpaceOperationRequest(ITemplatePacket template, Transaction transaction, int entriesLimit, int modifiers) {
        this._template = template;
        this._txn = transaction;
        this._maxResults = entriesLimit;
        this._modifiers = modifiers;
        this.setFifoIfNeeded();
        if (entriesLimit != Integer.MAX_VALUE) {
            throw new IllegalArgumentException("entriesLimit other than Integer.MAX_VALUE is not supported");
        }
    }

    private void setFifoIfNeeded() {
        if (this._template.getTypeDescriptor() != null && this._template.getTypeDescriptor().isFifoDefault()) {
            this._modifiers = Modifiers.add(this._modifiers, 2048);
        }
    }

    @Override
    public int getOperationCode() {
        return 14;
    }

    @Override
    public ReadTakeEntriesUidsSpaceOperationResult createRemoteOperationResult() {
        return new ReadTakeEntriesUidsSpaceOperationResult();
    }

    @Override
    public PartitionedClusterExecutionType getPartitionedClusterExecutionType() {
        return this._template.getRoutingFieldValue() != null ? PartitionedClusterExecutionType.SINGLE : PartitionedClusterExecutionType.BROADCAST_CONCURRENT;
    }

    @Override
    public Object getPartitionedClusterRoutingValue(PartitionedClusterRemoteOperationRouter router) {
        return this._template.getRoutingFieldValue();
    }

    @Override
    public void toText(Textualizer textualizer) {
        super.toText(textualizer);
        textualizer.append("template", this._template);
        textualizer.append("txn", this._txn);
        textualizer.append("maxResults", this._maxResults);
        textualizer.append("modifiers", this._modifiers);
    }

    @Override
    public String getLRMIMethodTrackingId() {
        return "readMultipleUids";
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        short flags = this.buildFlags();
        out.writeShort(flags);
        IOUtils.writeObject(out, this._template);
        if ((flags & 1) != 0) {
            IOUtils.writeWithCachedStubs(out, this._txn);
        }
        if ((flags & 4) != 0) {
            out.writeInt(this._modifiers);
        }
        if ((flags & 2) != 0) {
            out.writeInt(this._maxResults);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        short flags = in.readShort();
        this._template = (ITemplatePacket)IOUtils.readObject(in);
        if ((flags & 1) != 0) {
            this._txn = (Transaction)IOUtils.readWithCachedStubs(in);
        }
        this._modifiers = (flags & 4) != 0 ? in.readInt() : 0;
        this._maxResults = (flags & 2) != 0 ? in.readInt() : Integer.MAX_VALUE;
    }

    private short buildFlags() {
        short flags = 0;
        if (this._txn != null) {
            flags = (short)(flags | 1);
        }
        if (this._maxResults != Integer.MAX_VALUE) {
            flags = (short)(flags | 2);
        }
        if (this._modifiers != 0) {
            flags = (short)(flags | 4);
        }
        return flags;
    }

    public ITemplatePacket getTemplate() {
        return this._template;
    }

    public void setTemplate(ITemplatePacket template) {
        this._template = template;
    }

    @Override
    public Transaction getTransaction() {
        return this._txn;
    }

    public int getEntriesLimit() {
        return this._maxResults;
    }

    public int getModifiers() {
        return this._modifiers;
    }

    @Override
    public boolean processUnknownTypeException(List<Integer> positions) {
        if (this._template.isSerializeTypeDesc()) {
            return false;
        }
        this._template.setSerializeTypeDesc(true);
        return true;
    }

    @Override
    public boolean processPartitionResult(ReadTakeEntriesUidsSpaceOperationResult remoteOperationResult, List<ReadTakeEntriesUidsSpaceOperationResult> previousResults, int numOfPartitions) {
        if (remoteOperationResult.hasException()) {
            this._exception = remoteOperationResult.getExecutionException();
            return false;
        }
        if (this._results == null) {
            this._results = new LinkedList<String[]>();
            this._metadata = new LinkedList<IPartitionResultMetadata>();
        }
        this._results.add(remoteOperationResult.getUids());
        this._metadata.add(new PartitionResultMetadata(remoteOperationResult.getPartitionId(), remoteOperationResult.getUids().length));
        this._resultsCount += remoteOperationResult.getUids().length;
        return true;
    }

    @Override
    public boolean hasLockedResources() {
        return ((ReadTakeEntriesUidsSpaceOperationResult)this.getRemoteOperationResult()).getUids() != null && ((ReadTakeEntriesUidsSpaceOperationResult)this.getRemoteOperationResult()).getUids().length > 0;
    }

    @Override
    public void afterOperationExecution(int partitionId) {
        if (this.getRemoteOperationResult() != null) {
            ((ReadTakeEntriesUidsSpaceOperationResult)this.getRemoteOperationResult()).setPartitionId(partitionId != -1 ? Integer.valueOf(partitionId) : null);
        }
    }

    @Override
    public RemoteOperationRequest<ReadTakeEntriesUidsSpaceOperationResult> createCopy(int targetPartitionId) {
        ReadTakeEntriesUidsSpaceOperationRequest copy = (ReadTakeEntriesUidsSpaceOperationRequest)super.createCopy(targetPartitionId);
        copy._template = this._template.clone();
        return copy;
    }

    public ReadTakeEntriesUidsResult getFinalResult() throws RemoteException, TransactionException, UnusableEntryException {
        if (this._exception != null) {
            this.setRemoteOperationExecutionError(this._exception);
        } else if (this._results != null) {
            String[] finalResultUids = new String[this._resultsCount];
            int index = 0;
            for (String[] uids : this._results) {
                for (int i = 0; i < uids.length; ++i) {
                    finalResultUids[index++] = uids[i];
                }
            }
            return new ReadTakeEntriesUidsResult(finalResultUids, this._metadata);
        }
        ReadTakeEntriesUidsSpaceOperationResult result = (ReadTakeEntriesUidsSpaceOperationResult)this.getRemoteOperationResult();
        result.processExecutionException();
        return new ReadTakeEntriesUidsResult(result.getUids(), new PartitionResultsMetadata(result.getPartitionId(), result.getUids().length));
    }
}

