/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.client.spaceproxy.operations;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.client.spaceproxy.metadata.ISpaceProxyTypeManager;
import com.gigaspaces.internal.client.spaceproxy.operations.ReadTakeEntrySpaceOperationResult;
import com.gigaspaces.internal.client.spaceproxy.operations.SpaceOperationRequest;
import com.gigaspaces.internal.client.spaceproxy.operations.SpaceOperationResult;
import com.gigaspaces.internal.io.IOUtils;
import com.gigaspaces.internal.query.QueryUtils;
import com.gigaspaces.internal.query.explainplan.ExplainPlanImpl;
import com.gigaspaces.internal.remoting.RemoteOperationRequest;
import com.gigaspaces.internal.remoting.routing.partitioned.PartitionedClusterExecutionType;
import com.gigaspaces.internal.remoting.routing.partitioned.PartitionedClusterRemoteOperationRouter;
import com.gigaspaces.internal.transport.IEntryPacket;
import com.gigaspaces.internal.transport.ITemplatePacket;
import com.gigaspaces.internal.utils.Textualizer;
import com.gigaspaces.query.explainplan.ExplainPlan;
import com.j_spaces.core.exception.internal.InterruptedSpaceException;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.rmi.RemoteException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jini.core.entry.UnusableEntryException;
import net.jini.core.transaction.Transaction;
import net.jini.core.transaction.TransactionException;

@InternalApi
public class ReadTakeEntrySpaceOperationRequest
extends SpaceOperationRequest<ReadTakeEntrySpaceOperationResult> {
    private static final long serialVersionUID = 1L;
    private static final Logger _devLogger = Logger.getLogger("com.gigaspaces.dev");
    private ITemplatePacket _templatePacket;
    private Transaction _txn;
    private boolean _isTake;
    private boolean _ifExists;
    private long _timeout;
    private int _modifiers;
    private boolean _returnOnlyUid;
    private transient Exception _executionException;
    private transient IEntryPacket _resultEntry;
    private transient ISpaceProxyTypeManager _typeManager;
    private transient boolean _returnPacket;
    private transient int _totalNumberOfMatchesEntries;
    private transient Object _query;
    private transient ExplainPlanImpl explainPlan;
    private static final short FLAG_TRANSACTION = 1;
    private static final short FLAG_TIMEOUT = 2;
    private static final short FLAG_MODIFIERS = 4;
    private static final short FLAG_IS_TAKE = 8;
    private static final short FLAG_IF_EXISTS = 16;
    private static final short FLAG_RETURN_ONLY_UID = 32;
    private static final int DEFAULT_MODIFIERS = 0;
    private static final long DEFAULT_TIMEOUT = 0L;

    public ReadTakeEntrySpaceOperationRequest() {
    }

    public ReadTakeEntrySpaceOperationRequest(ITemplatePacket templatePacket, Transaction txn, boolean isTake, boolean ifExists, long timeout, int modifiers, boolean returnOnlyUid, Object query) {
        if (timeout < 0L) {
            throw new IllegalArgumentException("Timeout should be greater or equals 0");
        }
        this._templatePacket = templatePacket;
        this._txn = txn;
        this._isTake = isTake;
        this._ifExists = ifExists;
        this._timeout = timeout;
        this._modifiers = modifiers;
        this._returnOnlyUid = returnOnlyUid;
        this._query = query;
        this.explainPlan = ExplainPlanImpl.fromQueryPacket(query);
    }

    public ReadTakeEntrySpaceOperationRequest(ITemplatePacket templatePacket, Transaction txn, boolean isTake, boolean ifExists, long timeout, int modifiers, boolean returnOnlyUid, ISpaceProxyTypeManager typeManager, boolean returnPacket, Object query) {
        this(templatePacket, txn, isTake, ifExists, timeout, modifiers, returnOnlyUid, query);
        this._typeManager = typeManager;
        this._returnPacket = returnPacket;
    }

    @Override
    public void toText(Textualizer textualizer) {
        super.toText(textualizer);
        textualizer.append("isTake", this._isTake);
        textualizer.append("txn", this._txn);
        textualizer.append("modifiers", this._modifiers);
        textualizer.append("timeout", this._timeout);
        textualizer.append("ifExists", this._ifExists);
        textualizer.append("returnOnlyUid", this._returnOnlyUid);
        textualizer.append("template", this._templatePacket);
    }

    @Override
    public int getOperationCode() {
        return 11;
    }

    @Override
    public ReadTakeEntrySpaceOperationResult createRemoteOperationResult() {
        return new ReadTakeEntrySpaceOperationResult();
    }

    @Override
    public PartitionedClusterExecutionType getPartitionedClusterExecutionType() {
        if (this._templatePacket.getRoutingFieldValue() != null) {
            return PartitionedClusterExecutionType.SINGLE;
        }
        if (this._timeout != 0L) {
            throw new IllegalArgumentException("Broadcast is not supported for Read/Take Operations with timeout greater than 0. (Type='" + this._templatePacket.getTypeName() + "' ,routing property='" + this._templatePacket.getTypeDescriptor().getRoutingPropertyName() + "')");
        }
        if (this._isTake || this._txn != null) {
            return PartitionedClusterExecutionType.BROADCAST_SEQUENTIAL;
        }
        return PartitionedClusterExecutionType.BROADCAST_CONCURRENT;
    }

    @Override
    public Object getPartitionedClusterRoutingValue(PartitionedClusterRemoteOperationRouter router) {
        return this._templatePacket.getRoutingFieldValue();
    }

    public ITemplatePacket getTemplatePacket() {
        return this._templatePacket;
    }

    public int getModifiers() {
        return this._modifiers;
    }

    public long getTimeout() {
        return this._timeout;
    }

    @Override
    public Transaction getTransaction() {
        return this._txn;
    }

    @Override
    public boolean isBlockingOperation() {
        return this._timeout != 0L;
    }

    public boolean isTake() {
        return this._isTake;
    }

    public boolean isIfExists() {
        return this._ifExists;
    }

    public boolean isReturnOnlyUid() {
        return this._returnOnlyUid;
    }

    @Override
    public boolean processUnknownTypeException(List<Integer> positions) {
        if (this._templatePacket.isSerializeTypeDesc()) {
            return false;
        }
        this._templatePacket.setSerializeTypeDesc(true);
        return true;
    }

    @Override
    public boolean processPartitionResult(ReadTakeEntrySpaceOperationResult partitionResult, List<ReadTakeEntrySpaceOperationResult> previousResults, int numOfPartitions) {
        this._totalNumberOfMatchesEntries += partitionResult.getNumOfEntriesMatched();
        if (partitionResult.getExecutionException() != null) {
            this._executionException = partitionResult.getExecutionException();
            return false;
        }
        if (this._resultEntry == null) {
            this._resultEntry = partitionResult.getEntryPacket();
        }
        this.processExplainPlan(partitionResult);
        return this._resultEntry == null;
    }

    public IEntryPacket getFinalResult() throws RemoteException, TransactionException, InterruptedException, UnusableEntryException {
        if (this.getRemoteOperationResult() != null) {
            this._executionException = ((ReadTakeEntrySpaceOperationResult)this.getRemoteOperationResult()).getExecutionException();
            this._resultEntry = ((ReadTakeEntrySpaceOperationResult)this.getRemoteOperationResult()).getEntryPacket();
            this._totalNumberOfMatchesEntries = ((ReadTakeEntrySpaceOperationResult)this.getRemoteOperationResult()).getNumOfEntriesMatched();
        }
        if (this._executionException != null) {
            this.processExecutionException(this._executionException);
        }
        if (this._totalNumberOfMatchesEntries > 0 && _devLogger.isLoggable(Level.FINEST)) {
            _devLogger.finest(this._totalNumberOfMatchesEntries + " entries were scanned in the space in order to return the result for the " + (this._isTake ? "take" : "read") + " operation of query " + QueryUtils.getQueryDescription(this._query));
        }
        return this._resultEntry;
    }

    private void processExecutionException(Exception executionException) throws TransactionException, RemoteException, InterruptedException, UnusableEntryException {
        if (executionException instanceof TransactionException) {
            throw (TransactionException)((Object)executionException);
        }
        if (executionException instanceof RemoteException) {
            throw (RemoteException)executionException;
        }
        if (executionException instanceof InterruptedSpaceException && executionException.getCause() instanceof InterruptedException) {
            throw (InterruptedException)executionException.getCause();
        }
        if (executionException instanceof InterruptedException) {
            throw (InterruptedException)executionException;
        }
        if (executionException instanceof UnusableEntryException) {
            throw (UnusableEntryException)((Object)executionException);
        }
        SpaceOperationResult.onUnexpectedException(executionException);
    }

    @Override
    public Object getAsyncFinalResult() throws Exception {
        IEntryPacket resultPacket = this.getFinalResult();
        return this._typeManager.convertQueryResult(resultPacket, this._templatePacket, this._returnPacket);
    }

    @Override
    public String getLRMIMethodTrackingId() {
        return this.isTake() ? "take" : "read";
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        short flags = this.buildFlags();
        out.writeShort(flags);
        IOUtils.writeObject(out, this._templatePacket);
        if (flags != 0) {
            if (this._txn != null) {
                IOUtils.writeWithCachedStubs(out, this._txn);
            }
            if (this._timeout != 0L) {
                out.writeLong(this._timeout);
            }
            if (this._modifiers != 0) {
                out.writeInt(this._modifiers);
            }
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        short flags = in.readShort();
        this._templatePacket = (ITemplatePacket)IOUtils.readObject(in);
        if (flags != 0) {
            if ((flags & 1) != 0) {
                this._txn = (Transaction)IOUtils.readWithCachedStubs(in);
            }
            this._timeout = (flags & 2) != 0 ? in.readLong() : 0L;
            this._modifiers = (flags & 4) != 0 ? in.readInt() : 0;
            this._isTake = (flags & 8) != 0;
            this._ifExists = (flags & 0x10) != 0;
            this._returnOnlyUid = (flags & 0x20) != 0;
        } else {
            this._timeout = 0L;
            this._modifiers = 0;
        }
    }

    @Override
    public RemoteOperationRequest<ReadTakeEntrySpaceOperationResult> createCopy(int targetPartitionId) {
        ReadTakeEntrySpaceOperationRequest copy = (ReadTakeEntrySpaceOperationRequest)super.createCopy(targetPartitionId);
        copy._templatePacket = this._templatePacket.clone();
        return copy;
    }

    private short buildFlags() {
        short flags = 0;
        if (this._txn != null) {
            flags = (short)(flags | 1);
        }
        if (this._timeout != 0L) {
            flags = (short)(flags | 2);
        }
        if (this._modifiers != 0) {
            flags = (short)(flags | 4);
        }
        if (this._isTake) {
            flags = (short)(flags | 8);
        }
        if (this._ifExists) {
            flags = (short)(flags | 0x10);
        }
        if (this._returnOnlyUid) {
            flags = (short)(flags | 0x20);
        }
        return flags;
    }

    @Override
    public boolean hasLockedResources() {
        return ((ReadTakeEntrySpaceOperationResult)this.getRemoteOperationResult()).getEntryPacket() != null;
    }

    @Override
    public boolean requiresPartitionedPreciseDistribution() {
        return this._isTake;
    }

    @Override
    public int getPreciseDistributionGroupingCode() {
        if (this._isTake) {
            return 1;
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public void afterOperationExecution(int partitionId) {
        this.processExplainPlan((SpaceOperationResult)this.getRemoteOperationResult());
    }

    private void processExplainPlan(SpaceOperationResult result) {
        if (result != null && result.getExplainPlan() != null) {
            this.explainPlan.aggregate(result.getExplainPlan());
        }
    }

    public ExplainPlan getExplainPlan() {
        return this.explainPlan;
    }
}

