/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.client.spaceproxy.operations;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.client.spaceproxy.operations.SpaceOperationResult;
import com.gigaspaces.internal.io.IOUtils;
import com.gigaspaces.internal.transport.IEntryPacket;
import com.gigaspaces.internal.utils.Textualizer;
import com.j_spaces.core.AnswerPacket;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

@InternalApi
public class ReadTakeEntrySpaceOperationResult
extends SpaceOperationResult {
    private static final long serialVersionUID = 1L;
    private IEntryPacket _entryPacket;
    private int _numOfEntriesMatched;
    private int syncReplicationLevel;
    private static final short FLAG_ENTRY_PACKET = 1;
    private static final short FLAG_NUM_OF_ENTRIES_MATCHED = 2;
    private static final short FLAG_SYNC_REPLICATION_LEVEL = 4;

    public ReadTakeEntrySpaceOperationResult() {
    }

    public ReadTakeEntrySpaceOperationResult(AnswerPacket answerPacket, Exception ex) {
        this._entryPacket = answerPacket != null ? answerPacket.m_EntryPacket : null;
        this.setExecutionException(ex);
    }

    @Override
    public void toText(Textualizer textualizer) {
        super.toText(textualizer);
        textualizer.append("entryPacket", this._entryPacket);
    }

    public int getSyncReplicationLevel() {
        return this.syncReplicationLevel;
    }

    public void setSyncReplicationLevel(int syncReplicationLevel) {
        this.syncReplicationLevel = syncReplicationLevel;
    }

    public IEntryPacket getEntryPacket() {
        return this._entryPacket;
    }

    public void setEntryPacket(IEntryPacket entry) {
        this._entryPacket = entry;
    }

    public void setNumOfEntriesMatched(int numOfEntriesMatched) {
        this._numOfEntriesMatched = numOfEntriesMatched;
    }

    public int getNumOfEntriesMatched() {
        return this._numOfEntriesMatched;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        short flags = this.buildFlags();
        out.writeShort(flags);
        if (flags != 0) {
            if (this._entryPacket != null) {
                IOUtils.writeObject(out, this._entryPacket);
            }
            if (this._numOfEntriesMatched > 0) {
                out.writeInt(this._numOfEntriesMatched);
            }
            if (0 < this.syncReplicationLevel) {
                out.writeInt(this.syncReplicationLevel);
            }
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        short flags = in.readShort();
        if (flags != 0) {
            if ((flags & 1) != 0) {
                this._entryPacket = (IEntryPacket)IOUtils.readObject(in);
            }
            if ((flags & 2) != 0) {
                this._numOfEntriesMatched = in.readInt();
            }
            this.syncReplicationLevel = (flags & 4) != 0 ? in.readInt() : 0;
        }
    }

    private short buildFlags() {
        short flags = 0;
        if (this._entryPacket != null) {
            flags = (short)(flags | 1);
        }
        if (this._numOfEntriesMatched > 0) {
            flags = (short)(flags | 2);
        }
        if (0 < this.syncReplicationLevel) {
            flags = (short)(flags | 4);
        }
        return flags;
    }
}

