/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.client.spaceproxy.operations;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.events.NotifyInfo;
import com.gigaspaces.internal.client.spaceproxy.operations.RegisterEntriesListenerSpaceOperationResult;
import com.gigaspaces.internal.client.spaceproxy.operations.SpaceOperationRequest;
import com.gigaspaces.internal.io.IOUtils;
import com.gigaspaces.internal.remoting.RemoteOperationRequest;
import com.gigaspaces.internal.remoting.routing.partitioned.PartitionedClusterExecutionType;
import com.gigaspaces.internal.remoting.routing.partitioned.PartitionedClusterRemoteOperationRouter;
import com.gigaspaces.internal.transport.ITemplatePacket;
import com.gigaspaces.internal.utils.Textualizer;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.List;

@InternalApi
public class RegisterEntriesListenerSpaceOperationRequest
extends SpaceOperationRequest<RegisterEntriesListenerSpaceOperationResult> {
    private static final long serialVersionUID = 1L;
    private ITemplatePacket _templatePacket;
    private NotifyInfo _notifyInfo;
    private long _lease;
    private transient RegisterEntriesListenerSpaceOperationResult _finalResult;
    private static final short FLAG_LEASE = 1;
    private static final long DEFAULT_LEASE = Long.MAX_VALUE;

    public RegisterEntriesListenerSpaceOperationRequest() {
    }

    public RegisterEntriesListenerSpaceOperationRequest(ITemplatePacket templatePacket, NotifyInfo notifyInfo, long lease) {
        this._templatePacket = templatePacket;
        this._notifyInfo = notifyInfo;
        this._lease = lease;
    }

    @Override
    public RegisterEntriesListenerSpaceOperationResult createRemoteOperationResult() {
        return new RegisterEntriesListenerSpaceOperationResult();
    }

    @Override
    public PartitionedClusterExecutionType getPartitionedClusterExecutionType() {
        if (this._templatePacket.getRoutingFieldValue() != null) {
            return PartitionedClusterExecutionType.SINGLE;
        }
        this._notifyInfo.setBroadcast(true);
        return PartitionedClusterExecutionType.BROADCAST_CONCURRENT;
    }

    @Override
    public Object getPartitionedClusterRoutingValue(PartitionedClusterRemoteOperationRouter router) {
        return this._templatePacket.getRoutingFieldValue();
    }

    @Override
    public int getOperationCode() {
        return 16;
    }

    public ITemplatePacket getTemplatePacket() {
        return this._templatePacket;
    }

    public NotifyInfo getNotifyInfo() {
        return this._notifyInfo;
    }

    public long getLease() {
        return this._lease;
    }

    @Override
    public boolean processUnknownTypeException(List<Integer> positions) {
        if (this._templatePacket.isSerializeTypeDesc()) {
            return false;
        }
        this._templatePacket.setSerializeTypeDesc(true);
        return true;
    }

    @Override
    public boolean processPartitionResult(RegisterEntriesListenerSpaceOperationResult remoteOperationResult, List<RegisterEntriesListenerSpaceOperationResult> previousResults, int numOfPartitions) {
        if (this._finalResult == null || this._finalResult.getEventRegistration() == null) {
            this._finalResult = remoteOperationResult;
        }
        if (remoteOperationResult.getEventRegistration() != null) {
            this._finalResult.getEventRegistration().addSequenceNumber(remoteOperationResult.getEventRegistration());
        }
        return true;
    }

    public RegisterEntriesListenerSpaceOperationResult getFinalResult() {
        return this._finalResult == null ? (RegisterEntriesListenerSpaceOperationResult)this.getRemoteOperationResult() : this._finalResult;
    }

    @Override
    public void toText(Textualizer textualizer) {
        super.toText(textualizer);
        textualizer.append("template", this._templatePacket);
        textualizer.append("lease", this._lease);
        textualizer.append("notifyInfo", this._notifyInfo);
    }

    @Override
    public String getLRMIMethodTrackingId() {
        return "addEntriesListener";
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        short flags = this.buildFlags();
        out.writeShort(flags);
        IOUtils.writeObject(out, this._templatePacket);
        IOUtils.writeObject(out, this._notifyInfo);
        if (flags != 0 && this._lease != Long.MAX_VALUE) {
            out.writeLong(this._lease);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        short flags = in.readShort();
        this._templatePacket = (ITemplatePacket)IOUtils.readObject(in);
        this._notifyInfo = (NotifyInfo)IOUtils.readObject(in);
        if (flags != 0) {
            if ((flags & 1) != 0) {
                this._lease = in.readLong();
            }
        } else {
            this._lease = Long.MAX_VALUE;
        }
    }

    @Override
    public RemoteOperationRequest<RegisterEntriesListenerSpaceOperationResult> createCopy(int targetPartitionId) {
        RegisterEntriesListenerSpaceOperationRequest copy = (RegisterEntriesListenerSpaceOperationRequest)super.createCopy(targetPartitionId);
        copy._templatePacket = this._templatePacket.clone();
        return copy;
    }

    private short buildFlags() {
        short flags = 0;
        if (this._lease != Long.MAX_VALUE) {
            flags = (short)(flags | 1);
        }
        return flags;
    }
}

