/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.client.spaceproxy.operations;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.client.spaceproxy.operations.RegisterLocalViewSpaceOperationResult;
import com.gigaspaces.internal.client.spaceproxy.operations.SpaceScatterGatherOperationRequest;
import com.gigaspaces.internal.cluster.node.impl.router.RouterStubHolder;
import com.gigaspaces.internal.exceptions.PartitionedExecutionExceptionsCollection;
import com.gigaspaces.internal.io.IOUtils;
import com.gigaspaces.internal.remoting.routing.partitioned.PartitionedClusterExecutionType;
import com.gigaspaces.internal.remoting.routing.partitioned.PartitionedClusterRemoteOperationRouter;
import com.gigaspaces.internal.remoting.routing.partitioned.ScatterGatherOperationFutureListener;
import com.gigaspaces.internal.remoting.routing.partitioned.ScatterGatherRemoteOperationRequest;
import com.gigaspaces.internal.transport.ITemplatePacket;
import com.gigaspaces.management.space.SpaceQueryDetails;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collection;
import java.util.List;

@InternalApi
public class RegisterLocalViewSpaceOperationRequest
extends SpaceScatterGatherOperationRequest<RegisterLocalViewSpaceOperationResult> {
    private static final long serialVersionUID = 1L;
    private transient List<ITemplatePacket>[] _allQueryPackets;
    private transient List<SpaceQueryDetails>[] _allQueryDescriptions;
    private List<ITemplatePacket> _queryPackets;
    private List<SpaceQueryDetails> _queryDescriptions;
    private RouterStubHolder _viewStub;
    private int _batchSize;
    private long _batchTimeout;
    private transient PartitionedExecutionExceptionsCollection _errors;

    public RegisterLocalViewSpaceOperationRequest() {
    }

    public RegisterLocalViewSpaceOperationRequest(List<ITemplatePacket>[] allQueryPackets, List<SpaceQueryDetails>[] allQueryDescriptions, RouterStubHolder viewStub, int batchSize, long batchTimeout) {
        this._allQueryPackets = allQueryPackets;
        this._allQueryDescriptions = allQueryDescriptions;
        if (allQueryPackets.length == 1) {
            this._queryPackets = allQueryPackets[0];
            this._queryDescriptions = allQueryDescriptions[0];
        }
        this._viewStub = viewStub;
        this._batchSize = batchSize;
        this._batchTimeout = batchTimeout;
    }

    @Override
    public int getOperationCode() {
        return 18;
    }

    @Override
    public RegisterLocalViewSpaceOperationResult createRemoteOperationResult() {
        return new RegisterLocalViewSpaceOperationResult();
    }

    @Override
    public PartitionedClusterExecutionType getPartitionedClusterExecutionType() {
        return PartitionedClusterExecutionType.SCATTER_CONCURRENT;
    }

    @Override
    public Object getPartitionedClusterRoutingValue(PartitionedClusterRemoteOperationRouter router) {
        throw new IllegalStateException();
    }

    @Override
    public String getLRMIMethodTrackingId() {
        return "registerLocalView";
    }

    public Collection<ITemplatePacket> getQueryPackets() {
        return this._queryPackets;
    }

    public Collection<SpaceQueryDetails> getQueryDescriptions() {
        return this._queryDescriptions;
    }

    public RouterStubHolder getViewStub() {
        return this._viewStub;
    }

    public int getBatchSize() {
        return this._batchSize;
    }

    public long getBatchTimeout() {
        return this._batchTimeout;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        IOUtils.writeObject(out, this._queryPackets);
        IOUtils.writeObject(out, this._queryDescriptions);
        IOUtils.writeObject(out, this._viewStub);
        out.writeInt(this._batchSize);
        out.writeLong(this._batchTimeout);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this._queryPackets = (List)IOUtils.readObject(in);
        this._queryDescriptions = (List)IOUtils.readObject(in);
        this._viewStub = (RouterStubHolder)IOUtils.readObject(in);
        this._batchSize = in.readInt();
        this._batchTimeout = in.readLong();
    }

    @Override
    public void scatterIndexesToPartitions(ScatterGatherOperationFutureListener<RegisterLocalViewSpaceOperationResult> scatterGatherCoordinator) {
        for (int partitionId = 0; partitionId < this._allQueryPackets.length; ++partitionId) {
            if (this._allQueryPackets[partitionId].isEmpty()) continue;
            scatterGatherCoordinator.addPartition(partitionId, this);
        }
    }

    @Override
    public void loadPartitionData(ScatterGatherRemoteOperationRequest<RegisterLocalViewSpaceOperationResult> mainRequest) {
        int partitionId = this.getPartitionInfo().getPartitionId();
        this._queryPackets = ((RegisterLocalViewSpaceOperationRequest)mainRequest)._allQueryPackets[partitionId];
        this._queryDescriptions = ((RegisterLocalViewSpaceOperationRequest)mainRequest)._allQueryDescriptions[partitionId];
    }

    @Override
    public boolean processPartitionResult(ScatterGatherRemoteOperationRequest<RegisterLocalViewSpaceOperationResult> partitionRequest, List<ScatterGatherRemoteOperationRequest<RegisterLocalViewSpaceOperationResult>> previousRequests) {
        Exception partitionException = ((RegisterLocalViewSpaceOperationResult)partitionRequest.getRemoteOperationResult()).getExecutionException();
        if (partitionException != null) {
            if (this._errors == null) {
                this._errors = new PartitionedExecutionExceptionsCollection();
            }
            this._errors.add(partitionRequest.getPartitionInfo().getPartitionId(), partitionException);
        }
        return true;
    }

    public PartitionedExecutionExceptionsCollection getErrors() {
        if (this.getRemoteOperationResult() != null) {
            Exception executionException = ((RegisterLocalViewSpaceOperationResult)this.getRemoteOperationResult()).getExecutionException();
            if (executionException == null) {
                return null;
            }
            this._errors = new PartitionedExecutionExceptionsCollection();
            this._errors.add(0, executionException);
        }
        return this._errors;
    }
}

