/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.client.spaceproxy.operations;

import com.gigaspaces.internal.client.spaceproxy.operations.SpaceOperationResult;
import com.gigaspaces.internal.io.IOUtils;
import com.gigaspaces.internal.remoting.RemoteOperationRequest;
import com.gigaspaces.internal.utils.Textualizable;
import com.gigaspaces.internal.utils.Textualizer;
import com.j_spaces.core.SpaceContext;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.List;
import net.jini.core.transaction.Transaction;

public abstract class SpaceOperationRequest<TResult extends SpaceOperationResult>
implements RemoteOperationRequest<TResult>,
Cloneable,
Externalizable,
Textualizable {
    private static final long serialVersionUID = 1L;
    private SpaceContext _spaceContext;
    private transient TResult _remoteOperationResult;
    private static final short FLAG_SPACE_CONTEXT = 1;

    public String toString() {
        return Textualizer.toString(this);
    }

    @Override
    public void toText(Textualizer textualizer) {
    }

    @Override
    public TResult getRemoteOperationResult() {
        return this._remoteOperationResult;
    }

    @Override
    public void setRemoteOperationResult(TResult remoteOperationResult) {
        this._remoteOperationResult = remoteOperationResult;
    }

    @Override
    public void setRemoteOperationExecutionError(Exception error) {
        this._remoteOperationResult = (SpaceOperationResult)this.createRemoteOperationResult();
        ((SpaceOperationResult)this._remoteOperationResult).setExecutionException(error);
    }

    @Override
    public boolean processPartitionResult(TResult remoteOperationResult, List<TResult> previousResults, int numOfPartitions) {
        throw new UnsupportedOperationException("This method must be overridden if execution type is broadcast");
    }

    @Override
    public Object getAsyncFinalResult() throws Exception {
        return this.getRemoteOperationResult();
    }

    public Transaction getTransaction() {
        return null;
    }

    @Override
    public boolean isBlockingOperation() {
        return false;
    }

    @Override
    public boolean isDedicatedPoolRequired() {
        return false;
    }

    @Override
    public boolean processUnknownTypeException(List<Integer> positions) {
        return false;
    }

    public void setSpaceContext(SpaceContext spaceContext) {
        this._spaceContext = spaceContext;
    }

    public SpaceContext getSpaceContext() {
        return this._spaceContext;
    }

    @Override
    public RemoteOperationRequest<TResult> createCopy(int targetPartitionId) {
        return (RemoteOperationRequest)this.clone();
    }

    protected Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Failed to clone a cloneable object", e);
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        short flags = this.buildFlags();
        out.writeShort(flags);
        if (flags != 0 && this._spaceContext != null) {
            IOUtils.writeObject(out, this._spaceContext);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        short flags = in.readShort();
        if (flags != 0 && (flags & 1) != 0) {
            this._spaceContext = (SpaceContext)IOUtils.readObject(in);
        }
    }

    private short buildFlags() {
        short flags = 0;
        if (this._spaceContext != null) {
            flags = (short)(flags | 1);
        }
        return flags;
    }

    public boolean beforeOperationExecution(boolean isEmbedded) {
        return true;
    }

    public void afterOperationExecution(int partitionId) {
    }

    public boolean hasLockedResources() {
        return true;
    }

    @Override
    public boolean requiresPartitionedPreciseDistribution() {
        return false;
    }

    @Override
    public int getPreciseDistributionGroupingCode() {
        throw new UnsupportedOperationException();
    }

    public boolean supportsSecurity() {
        return true;
    }
}

