/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.client.spaceproxy.operations;

import com.gigaspaces.internal.client.spaceproxy.operations.SpaceOperationRequest;
import com.gigaspaces.internal.client.spaceproxy.operations.SpaceOperationResult;
import com.gigaspaces.internal.remoting.routing.partitioned.OperationResult;
import com.gigaspaces.internal.remoting.routing.partitioned.ScatterGatherPartitionInfo;
import com.gigaspaces.internal.remoting.routing.partitioned.ScatterGatherRemoteOperationRequest;

public abstract class SpaceScatterGatherOperationRequest<TResult extends SpaceOperationResult>
extends SpaceOperationRequest<TResult>
implements ScatterGatherRemoteOperationRequest<TResult> {
    private static final long serialVersionUID = 1L;
    protected ScatterGatherPartitionInfo _partitionInfo;

    @Override
    public SpaceScatterGatherOperationRequest<TResult> createCopy(int targetPartitionId) {
        SpaceScatterGatherOperationRequest copy = (SpaceScatterGatherOperationRequest)super.createCopy(targetPartitionId);
        copy._partitionInfo = new ScatterGatherPartitionInfo(targetPartitionId);
        return copy;
    }

    @Override
    public ScatterGatherPartitionInfo getPartitionInfo() {
        return this._partitionInfo;
    }

    protected int[] scatter(int[] data) {
        if (data == null) {
            return null;
        }
        int[] partitionData = new int[this._partitionInfo.size()];
        for (int i = 0; i < partitionData.length; ++i) {
            partitionData[i] = data[this._partitionInfo.getQuick(i)];
        }
        return partitionData;
    }

    protected long[] scatter(long[] data) {
        if (data == null) {
            return null;
        }
        long[] partitionData = new long[this._partitionInfo.size()];
        for (int i = 0; i < partitionData.length; ++i) {
            partitionData[i] = data[this._partitionInfo.getQuick(i)];
        }
        return partitionData;
    }

    protected <T> T[] scatter(T[] data, T[] partitionData) {
        if (data == null) {
            return null;
        }
        for (int i = 0; i < partitionData.length; ++i) {
            partitionData[i] = data[this._partitionInfo.getQuick(i)];
        }
        return partitionData;
    }

    public void gather(int[] data, int[] partitionData) {
        for (int i = 0; i < partitionData.length; ++i) {
            data[this._partitionInfo.getQuick((int)i)] = partitionData[i];
        }
    }

    public <T> void gather(T[] data, T[] partitionData) {
        for (int i = 0; i < partitionData.length; ++i) {
            data[this._partitionInfo.getQuick((int)i)] = partitionData[i];
        }
    }

    public void gather(OperationResult<Integer>[] data, int[] partitionData) {
        for (int i = 0; i < partitionData.length; ++i) {
            data[this._partitionInfo.getQuick((int)i)] = new OperationResult<Integer>(partitionData[i], null);
        }
    }

    public <T> void gather(OperationResult<T>[] data, Exception error) {
        for (int i = 0; i < this._partitionInfo.size(); ++i) {
            data[this._partitionInfo.getQuick((int)i)] = new OperationResult<Object>(null, error);
        }
    }

    public <T> void gather(T[] data, T partitionData) {
        for (int i = 0; i < this._partitionInfo.size(); ++i) {
            data[this._partitionInfo.getQuick((int)i)] = partitionData;
        }
    }
}

