/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.client.spaceproxy.operations;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.client.spaceproxy.operations.SpaceScatterGatherOperationRequest;
import com.gigaspaces.internal.client.spaceproxy.operations.UnregisterLocalViewSpaceOperationResult;
import com.gigaspaces.internal.exceptions.PartitionedExecutionExceptionsCollection;
import com.gigaspaces.internal.io.IOUtils;
import com.gigaspaces.internal.remoting.routing.partitioned.PartitionedClusterExecutionType;
import com.gigaspaces.internal.remoting.routing.partitioned.PartitionedClusterRemoteOperationRouter;
import com.gigaspaces.internal.remoting.routing.partitioned.ScatterGatherOperationFutureListener;
import com.gigaspaces.internal.remoting.routing.partitioned.ScatterGatherRemoteOperationRequest;
import com.gigaspaces.internal.transport.ITemplatePacket;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.List;

@InternalApi
public class UnregisterLocalViewSpaceOperationRequest
extends SpaceScatterGatherOperationRequest<UnregisterLocalViewSpaceOperationResult> {
    private static final long serialVersionUID = 1L;
    private String _viewStubHolderName;
    private transient List<ITemplatePacket>[] _allTemplates;
    private transient PartitionedExecutionExceptionsCollection _errors;

    public UnregisterLocalViewSpaceOperationRequest() {
    }

    public UnregisterLocalViewSpaceOperationRequest(String viewStubHolderName, List<ITemplatePacket>[] allTemplates) {
        this._viewStubHolderName = viewStubHolderName;
        this._allTemplates = allTemplates;
    }

    @Override
    public int getOperationCode() {
        return 19;
    }

    @Override
    public UnregisterLocalViewSpaceOperationResult createRemoteOperationResult() {
        return new UnregisterLocalViewSpaceOperationResult();
    }

    @Override
    public PartitionedClusterExecutionType getPartitionedClusterExecutionType() {
        return PartitionedClusterExecutionType.SCATTER_CONCURRENT;
    }

    @Override
    public Object getPartitionedClusterRoutingValue(PartitionedClusterRemoteOperationRouter router) {
        throw new IllegalStateException();
    }

    @Override
    public String getLRMIMethodTrackingId() {
        return "unregisterLocalView";
    }

    public String getViewStubHolderName() {
        return this._viewStubHolderName;
    }

    public PartitionedExecutionExceptionsCollection getErrors() {
        if (this.getRemoteOperationResult() != null) {
            Exception executionException = ((UnregisterLocalViewSpaceOperationResult)this.getRemoteOperationResult()).getExecutionException();
            if (executionException == null) {
                return null;
            }
            this._errors = new PartitionedExecutionExceptionsCollection();
            this._errors.add(0, executionException);
        }
        return this._errors;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        IOUtils.writeString(out, this._viewStubHolderName);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this._viewStubHolderName = IOUtils.readString(in);
    }

    @Override
    public void scatterIndexesToPartitions(ScatterGatherOperationFutureListener<UnregisterLocalViewSpaceOperationResult> scatterGatherCoordinator) {
        for (int partitionId = 0; partitionId < this._allTemplates.length; ++partitionId) {
            if (this._allTemplates[partitionId].isEmpty()) continue;
            scatterGatherCoordinator.addPartition(partitionId, this);
        }
    }

    @Override
    public void loadPartitionData(ScatterGatherRemoteOperationRequest<UnregisterLocalViewSpaceOperationResult> mainRequest) {
    }

    @Override
    public boolean processPartitionResult(ScatterGatherRemoteOperationRequest<UnregisterLocalViewSpaceOperationResult> partitionRequest, List<ScatterGatherRemoteOperationRequest<UnregisterLocalViewSpaceOperationResult>> previousRequests) {
        Exception partitionException = ((UnregisterLocalViewSpaceOperationResult)partitionRequest.getRemoteOperationResult()).getExecutionException();
        if (partitionException != null) {
            if (this._errors == null) {
                this._errors = new PartitionedExecutionExceptionsCollection();
            }
            this._errors.add(partitionRequest.getPartitionInfo().getPartitionId(), partitionException);
        }
        return true;
    }
}

