/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.client.spaceproxy.operations;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.client.spaceproxy.operations.SpaceOperationRequest;
import com.gigaspaces.internal.client.spaceproxy.operations.UpdateLeaseSpaceOperationResult;
import com.gigaspaces.internal.io.IOUtils;
import com.gigaspaces.internal.remoting.routing.partitioned.PartitionedClusterExecutionType;
import com.gigaspaces.internal.remoting.routing.partitioned.PartitionedClusterRemoteOperationRouter;
import com.gigaspaces.internal.utils.Textualizer;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.List;

@InternalApi
public class UpdateLeaseSpaceOperationRequest
extends SpaceOperationRequest<UpdateLeaseSpaceOperationResult> {
    private static final long serialVersionUID = 1L;
    private String _uid;
    private String _typeName;
    private int _leaseObjectType;
    private long _duration;
    private transient Object _routingValue;
    private transient UpdateLeaseSpaceOperationResult _finalResult;
    private static final short FLAG_UID = 1;
    private static final short FLAG_TYPE_NAME = 2;
    private static final short FLAG_LEASE_OBJECT_TYPE = 4;
    private static final short FLAG_DURATION = 8;
    private static final int DEFAULT_LEASE_OBJECT_TYPE = 1;
    private static final long DEFAULT_DURATION = -1L;

    public UpdateLeaseSpaceOperationRequest() {
    }

    public UpdateLeaseSpaceOperationRequest(String uid, String typeName, int leaseObjectType, long duration, Object routingValue) {
        this._uid = uid;
        this._typeName = typeName;
        this._leaseObjectType = leaseObjectType;
        this._duration = duration;
        this._routingValue = routingValue;
    }

    @Override
    public int getOperationCode() {
        return 4;
    }

    @Override
    public UpdateLeaseSpaceOperationResult createRemoteOperationResult() {
        return new UpdateLeaseSpaceOperationResult();
    }

    @Override
    public PartitionedClusterExecutionType getPartitionedClusterExecutionType() {
        if (this._routingValue != null) {
            return PartitionedClusterExecutionType.SINGLE;
        }
        return PartitionedClusterExecutionType.BROADCAST_CONCURRENT;
    }

    @Override
    public boolean processPartitionResult(UpdateLeaseSpaceOperationResult remoteOperationResult, List<UpdateLeaseSpaceOperationResult> previousResults, int numOfPartitions) {
        if (remoteOperationResult.getExecutionException() != null) {
            this._finalResult = remoteOperationResult;
            return false;
        }
        if (this._finalResult == null) {
            this._finalResult = new UpdateLeaseSpaceOperationResult();
        }
        return true;
    }

    public UpdateLeaseSpaceOperationResult getFinalResult() {
        return this._finalResult == null ? (UpdateLeaseSpaceOperationResult)this.getRemoteOperationResult() : this._finalResult;
    }

    @Override
    public Object getPartitionedClusterRoutingValue(PartitionedClusterRemoteOperationRouter router) {
        return this._routingValue;
    }

    public String getUid() {
        return this._uid;
    }

    public String getTypeName() {
        return this._typeName;
    }

    public int getLeaseObjectType() {
        return this._leaseObjectType;
    }

    public long getDuration() {
        return this._duration;
    }

    public boolean isCancel() {
        return this._duration == -1L;
    }

    @Override
    public void toText(Textualizer textualizer) {
        super.toText(textualizer);
        textualizer.append("uid", this._uid);
        textualizer.append("typeName", this._typeName);
        textualizer.append("leaseObjectType", this._leaseObjectType);
        textualizer.append("duration", this._duration);
    }

    @Override
    public String getLRMIMethodTrackingId() {
        return this.isCancel() ? "cancelLease" : "renewLease";
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        short flags = this.buildFlags();
        out.writeShort(flags);
        if (flags != 0) {
            if (this._uid != null) {
                IOUtils.writeString(out, this._uid);
            }
            if (this._typeName != null) {
                IOUtils.writeString(out, this._typeName);
            }
            if (this._leaseObjectType != 1) {
                out.writeInt(this._leaseObjectType);
            }
            if (this._duration != -1L) {
                out.writeLong(this._duration);
            }
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        short flags = in.readShort();
        if (flags != 0) {
            if ((flags & 1) != 0) {
                this._uid = IOUtils.readString(in);
            }
            if ((flags & 2) != 0) {
                this._typeName = IOUtils.readString(in);
            }
            this._leaseObjectType = (flags & 4) != 0 ? in.readInt() : 1;
            this._duration = (flags & 8) != 0 ? in.readLong() : -1L;
        } else {
            this._leaseObjectType = 1;
            this._duration = -1L;
        }
    }

    private short buildFlags() {
        short flags = 0;
        if (this._uid != null) {
            flags = (short)(flags | 1);
        }
        if (this._typeName != null) {
            flags = (short)(flags | 2);
        }
        if (this._leaseObjectType != 1) {
            flags = (short)(flags | 4);
        }
        if (this._duration != -1L) {
            flags = (short)(flags | 8);
        }
        return flags;
    }
}

