/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.client.spaceproxy.operations;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.client.spaceproxy.operations.SpaceScatterGatherOperationRequest;
import com.gigaspaces.internal.client.spaceproxy.operations.UpdateLeasesSpaceOperationResult;
import com.gigaspaces.internal.io.IOUtils;
import com.gigaspaces.internal.lease.LeaseUpdateDetails;
import com.gigaspaces.internal.remoting.routing.partitioned.PartitionedClusterExecutionType;
import com.gigaspaces.internal.remoting.routing.partitioned.PartitionedClusterRemoteOperationRouter;
import com.gigaspaces.internal.remoting.routing.partitioned.ScatterGatherOperationFutureListener;
import com.gigaspaces.internal.remoting.routing.partitioned.ScatterGatherRemoteOperationRequest;
import com.gigaspaces.internal.utils.Textualizer;
import com.gigaspaces.internal.version.PlatformLogicalVersion;
import com.gigaspaces.lrmi.LRMIInvocationContext;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.List;

@InternalApi
public class UpdateLeasesSpaceOperationRequest
extends SpaceScatterGatherOperationRequest<UpdateLeasesSpaceOperationResult> {
    private static final long serialVersionUID = 1L;
    private LeaseUpdateDetails[] _leases;
    private boolean _isRenew;
    private transient Exception[] _errors;

    public UpdateLeasesSpaceOperationRequest() {
    }

    public UpdateLeasesSpaceOperationRequest(LeaseUpdateDetails[] leases, boolean isRenew) {
        this._leases = leases;
        this._isRenew = isRenew;
    }

    public int getSize() {
        return this._leases.length;
    }

    public String getUid(int index) {
        return this._leases[index].getUid();
    }

    public String getTypeName(int index) {
        return this._leases[index].getTypeName();
    }

    public int getLeaseObjectType(int index) {
        return this._leases[index].getLeaseObjectType();
    }

    public long getDurations(int index) {
        return this._leases[index].getRenewDuration();
    }

    public Exception[] getFinalResult() {
        if (this.getRemoteOperationResult() != null) {
            UpdateLeasesSpaceOperationResult result = (UpdateLeasesSpaceOperationResult)this.getRemoteOperationResult();
            if (result.getErrors() != null) {
                return result.getErrors();
            }
            if (result.getExecutionException() != null) {
                this._errors = new Exception[this._leases.length];
                for (int i = 0; i < this._errors.length; ++i) {
                    this._errors[i] = result.getExecutionException();
                }
            }
        }
        return this._errors;
    }

    @Override
    public Object getAsyncFinalResult() throws Exception {
        return this.getFinalResult();
    }

    @Override
    public int getOperationCode() {
        return 5;
    }

    @Override
    public UpdateLeasesSpaceOperationResult createRemoteOperationResult() {
        return new UpdateLeasesSpaceOperationResult();
    }

    @Override
    public PartitionedClusterExecutionType getPartitionedClusterExecutionType() {
        return PartitionedClusterExecutionType.SCATTER_CONCURRENT;
    }

    @Override
    public Object getPartitionedClusterRoutingValue(PartitionedClusterRemoteOperationRouter router) {
        throw new IllegalStateException();
    }

    @Override
    public void scatterIndexesToPartitions(ScatterGatherOperationFutureListener<UpdateLeasesSpaceOperationResult> scatterGatherCoordinator) {
        for (int i = 0; i < this._leases.length; ++i) {
            int partitionId = scatterGatherCoordinator.getPartitionIdByHashcode(this._leases[i].getRoutingValue());
            scatterGatherCoordinator.mapIndexToPartition(i, partitionId, this);
        }
    }

    @Override
    public void loadPartitionData(ScatterGatherRemoteOperationRequest<UpdateLeasesSpaceOperationResult> mainRequest) {
        UpdateLeasesSpaceOperationRequest main = (UpdateLeasesSpaceOperationRequest)mainRequest;
        this._leases = this.scatter(main._leases, new LeaseUpdateDetails[this._partitionInfo.size()]);
    }

    @Override
    public boolean processPartitionResult(ScatterGatherRemoteOperationRequest<UpdateLeasesSpaceOperationResult> partitionRequest, List<ScatterGatherRemoteOperationRequest<UpdateLeasesSpaceOperationResult>> previousRequests) {
        UpdateLeasesSpaceOperationResult partitionResult = (UpdateLeasesSpaceOperationResult)partitionRequest.getRemoteOperationResult();
        if (partitionResult.getExecutionException() != null) {
            if (this._errors == null) {
                this._errors = new Exception[this._leases.length];
            }
            ((UpdateLeasesSpaceOperationRequest)partitionRequest).gather(this._errors, partitionResult.getExecutionException());
        } else if (partitionResult.getErrors() != null) {
            if (this._errors == null) {
                this._errors = new Exception[this._leases.length];
            }
            ((UpdateLeasesSpaceOperationRequest)partitionRequest).gather((T[])this._errors, partitionResult.getErrors());
        }
        return true;
    }

    @Override
    public void toText(Textualizer textualizer) {
        super.toText(textualizer);
        textualizer.append("leases", this._leases);
    }

    @Override
    public String getLRMIMethodTrackingId() {
        return "updateLeases";
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        PlatformLogicalVersion version = LRMIInvocationContext.getEndpointLogicalVersion();
        if (version.greaterOrEquals(PlatformLogicalVersion.v9_7_0)) {
            this.writeExternalV9_7_0(out);
        } else {
            this.writeExternalOld(out);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        PlatformLogicalVersion version = LRMIInvocationContext.getEndpointLogicalVersion();
        if (version.greaterOrEquals(PlatformLogicalVersion.v9_7_0)) {
            this.readExternalV9_7_0(in);
        } else {
            this.readExternalOld(in);
        }
    }

    private void writeExternalV9_7_0(ObjectOutput out) throws IOException {
        out.writeBoolean(this._isRenew);
        out.writeInt(this._leases.length);
        for (int i = 0; i < this._leases.length; ++i) {
            IOUtils.writeString(out, this._leases[i].getUid());
            IOUtils.writeString(out, this._leases[i].getTypeName());
            out.writeInt(this._leases[i].getLeaseObjectType());
            if (!this._isRenew) continue;
            out.writeLong(this._leases[i].getRenewDuration());
        }
    }

    private void readExternalV9_7_0(ObjectInput in) throws IOException, ClassNotFoundException {
        this._isRenew = in.readBoolean();
        this._leases = new LeaseUpdateDetails[in.readInt()];
        for (int i = 0; i < this._leases.length; ++i) {
            this._leases[i] = new LeaseUpdateDetails();
            this._leases[i].setUid(IOUtils.readString(in));
            this._leases[i].setTypeName(IOUtils.readString(in));
            this._leases[i].setLeaseObjectType(in.readInt());
            this._leases[i].setRenewDuration(this._isRenew ? in.readLong() : -1L);
        }
    }

    private void writeExternalOld(ObjectOutput out) throws IOException {
        int i;
        int length = this._leases.length;
        out.writeInt(length);
        for (i = 0; i < length; ++i) {
            IOUtils.writeString(out, this._leases[i].getUid());
        }
        out.writeInt(length);
        for (i = 0; i < length; ++i) {
            IOUtils.writeString(out, this._leases[i].getTypeName());
        }
        out.writeInt(length);
        for (i = 0; i < length; ++i) {
            out.writeInt(this._leases[i].getLeaseObjectType());
        }
        if (this._isRenew) {
            out.writeInt(length);
            for (i = 0; i < length; ++i) {
                out.writeLong(this._leases[i].getRenewDuration());
            }
        } else {
            out.writeInt(-1);
        }
    }

    private void readExternalOld(ObjectInput in) throws IOException, ClassNotFoundException {
        int i;
        int length = in.readInt();
        this._leases = new LeaseUpdateDetails[length];
        for (i = 0; i < length; ++i) {
            this._leases[i] = new LeaseUpdateDetails();
            this._leases[i].setUid(IOUtils.readString(in));
        }
        length = in.readInt();
        for (i = 0; i < length; ++i) {
            this._leases[i].setTypeName(IOUtils.readString(in));
        }
        length = in.readInt();
        for (i = 0; i < length; ++i) {
            this._leases[i].setLeaseObjectType(in.readInt());
        }
        boolean bl = this._isRenew = in.readInt() >= 0;
        if (this._isRenew) {
            for (i = 0; i < length; ++i) {
                this._leases[i].setRenewDuration(in.readLong());
            }
        }
    }
}

