/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.client.spaceproxy.operations;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.client.WriteMultipleException;
import com.gigaspaces.cluster.replication.WriteConsistencyLevelCompromisedException;
import com.gigaspaces.internal.client.spaceproxy.metadata.ISpaceProxyTypeManager;
import com.gigaspaces.internal.client.spaceproxy.metadata.SpaceProxyTypeManager;
import com.gigaspaces.internal.client.spaceproxy.operations.SpaceScatterGatherOperationRequest;
import com.gigaspaces.internal.client.spaceproxy.operations.WriteEntriesSpaceOperationResult;
import com.gigaspaces.internal.exceptions.WriteResultImpl;
import com.gigaspaces.internal.io.IOUtils;
import com.gigaspaces.internal.remoting.routing.partitioned.PartitionedClusterExecutionType;
import com.gigaspaces.internal.remoting.routing.partitioned.PartitionedClusterRemoteOperationRouter;
import com.gigaspaces.internal.remoting.routing.partitioned.ScatterGatherOperationFutureListener;
import com.gigaspaces.internal.remoting.routing.partitioned.ScatterGatherPartitionInfo;
import com.gigaspaces.internal.remoting.routing.partitioned.ScatterGatherRemoteOperationRequest;
import com.gigaspaces.internal.server.space.operations.WriteEntriesResult;
import com.gigaspaces.internal.server.space.operations.WriteEntryResult;
import com.gigaspaces.internal.transport.IEntryPacket;
import com.gigaspaces.internal.utils.Textualizer;
import com.j_spaces.core.LeaseContext;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.List;
import net.jini.core.transaction.Transaction;

@InternalApi
public class WriteEntriesSpaceOperationRequest
extends SpaceScatterGatherOperationRequest<WriteEntriesSpaceOperationResult> {
    private static final long serialVersionUID = 1L;
    private IEntryPacket[] _entriesPackets;
    private Transaction _txn;
    private long _lease;
    private long[] _leases;
    private int _modifiers;
    private long _timeout;
    private transient ISpaceProxyTypeManager _typeManager;
    private transient Object[] _entries;
    private transient LeaseContext<?>[] _resultLeases;
    private transient WriteMultipleException.IWriteResult[] _partialFailureResults;
    private static final short FLAG_TRANSACTION = 1;
    private static final short FLAG_LEASE = 2;
    private static final short FLAG_LEASES = 4;
    private static final short FLAG_MODIFIERS = 8;
    private static final short FLAG_TIMEOUT = 16;
    private static final long DEFAULT_LEASE = Long.MAX_VALUE;
    private static final int DEFAULT_MODIFIERS = 4096;
    private static long DEFAULT_TIMEOUT = 0L;

    public WriteEntriesSpaceOperationRequest() {
    }

    public WriteEntriesSpaceOperationRequest(ISpaceProxyTypeManager typeManager, Object[] entries, IEntryPacket[] entriesPackets, Transaction txn, long lease, long[] leases, long timeout, int modifiers) {
        this._typeManager = typeManager;
        this._entries = entries;
        this._entriesPackets = entriesPackets;
        this._txn = txn;
        this._lease = lease;
        this._leases = leases;
        this._modifiers = modifiers;
        this._timeout = timeout;
    }

    @Override
    public void toText(Textualizer textualizer) {
        super.toText(textualizer);
        if (this._entriesPackets.length < 10) {
            textualizer.append("entriesPackets", this._entriesPackets);
        } else {
            IEntryPacket[] dest = new IEntryPacket[10];
            System.arraycopy(this._entriesPackets, 0, dest, 0, dest.length);
            textualizer.append("entriesPackets", dest);
            textualizer.appendString("... truncated [length=" + this._entriesPackets.length + "]");
        }
        textualizer.append("txn", this._txn);
        textualizer.append("lease", this._lease);
        textualizer.append("leases", this._leases);
        textualizer.append("modifiers", this._modifiers);
        textualizer.append("timeout", this._timeout);
    }

    @Override
    public int getOperationCode() {
        return 10;
    }

    @Override
    public WriteEntriesSpaceOperationResult createRemoteOperationResult() {
        return new WriteEntriesSpaceOperationResult();
    }

    @Override
    public PartitionedClusterExecutionType getPartitionedClusterExecutionType() {
        return PartitionedClusterExecutionType.SCATTER_CONCURRENT;
    }

    @Override
    public Object getPartitionedClusterRoutingValue(PartitionedClusterRemoteOperationRouter router) {
        throw new IllegalStateException();
    }

    @Override
    public void scatterIndexesToPartitions(ScatterGatherOperationFutureListener<WriteEntriesSpaceOperationResult> listener) {
        for (int i = 0; i < this._entriesPackets.length; ++i) {
            int partitionId;
            Object routingValue = this._entriesPackets[i].getRoutingFieldValue();
            if (routingValue != null) {
                partitionId = listener.getPartitionIdByHashcode(routingValue);
            } else if (this._entriesPackets[i].getTypeDescriptor().isAutoGenerateRouting()) {
                partitionId = listener.getNextDistributionPartitionId();
            } else {
                throw new IllegalArgumentException("Routing value of entry #" + i + " is null");
            }
            listener.mapIndexToPartition(i, partitionId, this);
        }
    }

    @Override
    public void loadPartitionData(ScatterGatherRemoteOperationRequest<WriteEntriesSpaceOperationResult> mainRequest) {
        WriteEntriesSpaceOperationRequest main = (WriteEntriesSpaceOperationRequest)mainRequest;
        this._entriesPackets = this.scatter(main._entriesPackets, new IEntryPacket[this._partitionInfo.size()]);
        this._leases = this.scatter(main._leases);
    }

    @Override
    public boolean processPartitionResult(ScatterGatherRemoteOperationRequest<WriteEntriesSpaceOperationResult> partitionRequest, List<ScatterGatherRemoteOperationRequest<WriteEntriesSpaceOperationResult>> previousRequests) {
        if ((((WriteEntriesSpaceOperationResult)partitionRequest.getRemoteOperationResult()).getExecutionException() != null || ((WriteEntriesSpaceOperationResult)partitionRequest.getRemoteOperationResult()).getResult().getErrors() != null) && this._partialFailureResults == null) {
            this._partialFailureResults = new WriteMultipleException.IWriteResult[this._entriesPackets.length];
            if (this._resultLeases != null) {
                for (ScatterGatherRemoteOperationRequest<WriteEntriesSpaceOperationResult> prevRequest : previousRequests) {
                    this.processPartitionResult(prevRequest);
                }
            }
        }
        this.processPartitionResult(partitionRequest);
        return true;
    }

    private void processPartitionResult(ScatterGatherRemoteOperationRequest<WriteEntriesSpaceOperationResult> partitionRequest) {
        ScatterGatherPartitionInfo partitionInfo = partitionRequest.getPartitionInfo();
        Exception partitionException = ((WriteEntriesSpaceOperationResult)partitionRequest.getRemoteOperationResult()).getExecutionException();
        boolean consistencyCompromised = this.isSyncReplicationConsistencyCompromised(partitionRequest);
        if (consistencyCompromised && this._partialFailureResults == null) {
            this._partialFailureResults = new WriteMultipleException.IWriteResult[this._entriesPackets.length];
        }
        if (partitionException != null) {
            int size = partitionInfo != null ? partitionInfo.size() : this._entriesPackets.length;
            for (int i = 0; i < size; ++i) {
                int masterPosition = partitionInfo != null ? partitionInfo.getQuick(i) : i;
                this._partialFailureResults[masterPosition] = WriteResultImpl.createErrorResult(partitionException);
            }
        } else if (this._partialFailureResults != null) {
            WriteEntriesResult partitionResult = ((WriteEntriesSpaceOperationResult)partitionRequest.getRemoteOperationResult()).getResult();
            for (int i = 0; i < partitionResult.getResults().length; ++i) {
                int masterPosition;
                int n = masterPosition = partitionInfo != null ? partitionInfo.getQuick(i) : i;
                if (partitionResult.isError(i)) {
                    this._partialFailureResults[masterPosition] = WriteResultImpl.createErrorResult(partitionResult.getErrors()[i]);
                    continue;
                }
                try {
                    LeaseContext<?> lease = this.createLease(partitionResult.getResults()[i], masterPosition);
                    this._partialFailureResults[masterPosition] = WriteResultImpl.createLeaseResult(lease);
                    continue;
                }
                catch (WriteConsistencyLevelCompromisedException e) {
                    this._partialFailureResults[masterPosition] = WriteResultImpl.createErrorResult(e);
                }
            }
        } else {
            if (this._resultLeases == null) {
                this._resultLeases = new LeaseContext[this._entriesPackets.length];
            }
            WriteEntriesResult partitionResult = ((WriteEntriesSpaceOperationResult)partitionRequest.getRemoteOperationResult()).getResult();
            for (int i = 0; i < partitionResult.getResults().length; ++i) {
                int masterPosition = partitionInfo != null ? partitionInfo.getQuick(i) : i;
                this._resultLeases[masterPosition] = this.createLease(partitionResult.getResults()[i], masterPosition);
            }
        }
    }

    private boolean isSyncReplicationConsistencyCompromised(ScatterGatherRemoteOperationRequest<WriteEntriesSpaceOperationResult> partitionRequest) {
        WriteEntriesResult partitionResult = ((WriteEntriesSpaceOperationResult)partitionRequest.getRemoteOperationResult()).getResult();
        if (partitionResult == null || partitionResult.getResults() == null) {
            return false;
        }
        for (int i = 0; i < partitionResult.getResults().length; ++i) {
            if (partitionResult.isError(i) || !this.syncReplicationConsistencyCompromised(partitionResult.getResults()[i])) continue;
            return true;
        }
        return false;
    }

    private boolean syncReplicationConsistencyCompromised(WriteEntryResult writeEntryResult) {
        return writeEntryResult.getSyncReplicationLevel() + 1 < SpaceProxyTypeManager.requiredConsistencyLevel();
    }

    private LeaseContext<?> createLease(WriteEntryResult writeResult, int masterPosition) {
        return this._typeManager.processWriteResult(writeResult, this._entries[masterPosition], this._entriesPackets[masterPosition]);
    }

    public LeaseContext<?>[] getFinalResult() {
        if (this.getRemoteOperationResult() != null) {
            this.processPartitionResult(this, (List<ScatterGatherRemoteOperationRequest<WriteEntriesSpaceOperationResult>>)null);
        }
        if (this._partialFailureResults != null) {
            throw new WriteMultipleException(this._partialFailureResults);
        }
        return this._resultLeases;
    }

    public IEntryPacket[] getEntriesPackets() {
        return this._entriesPackets;
    }

    @Override
    public Transaction getTransaction() {
        return this._txn;
    }

    public long getLease() {
        return this._lease;
    }

    public long[] getLeases() {
        return this._leases;
    }

    public int getModifiers() {
        return this._modifiers;
    }

    public long getTimeOut() {
        return this._timeout;
    }

    @Override
    public boolean processUnknownTypeException(List<Integer> positions) {
        if (positions == null) {
            return false;
        }
        boolean retry = false;
        for (Integer position : positions) {
            if (this._entriesPackets[position].isSerializeTypeDesc()) continue;
            this._entriesPackets[position].setSerializeTypeDesc(true);
            retry = true;
        }
        return retry;
    }

    @Override
    public String getLRMIMethodTrackingId() {
        return "writeMultiple";
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        short flags = this.buildFlags();
        out.writeShort(flags);
        IOUtils.writeObjectArray(out, this._entriesPackets);
        if (flags != 0) {
            if (this._txn != null) {
                IOUtils.writeWithCachedStubs(out, this._txn);
            }
            if (this._lease != Long.MAX_VALUE) {
                out.writeLong(this._lease);
            }
            if (this._leases != null) {
                IOUtils.writeLongArray(out, this._leases);
            }
            if (this._modifiers != 4096) {
                out.writeInt(this._modifiers);
            }
            if (this._timeout != DEFAULT_TIMEOUT) {
                out.writeLong(this._timeout);
            }
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        short flags = in.readShort();
        this._entriesPackets = IOUtils.readEntryPacketArray(in);
        if (flags != 0) {
            if ((flags & 1) != 0) {
                this._txn = (Transaction)IOUtils.readWithCachedStubs(in);
            }
            long l = this._lease = (flags & 2) != 0 ? in.readLong() : Long.MAX_VALUE;
            if ((flags & 4) != 0) {
                this._leases = IOUtils.readLongArray(in);
            }
            this._modifiers = (flags & 8) != 0 ? in.readInt() : 4096;
            this._timeout = (flags & 0x10) != 0 ? in.readLong() : DEFAULT_TIMEOUT;
        } else {
            this._lease = Long.MAX_VALUE;
            this._modifiers = 4096;
            this._timeout = DEFAULT_TIMEOUT;
        }
    }

    private short buildFlags() {
        short flags = 0;
        if (this._txn != null) {
            flags = (short)(flags | 1);
        }
        if (this._lease != Long.MAX_VALUE) {
            flags = (short)(flags | 2);
        }
        if (this._leases != null) {
            flags = (short)(flags | 4);
        }
        if (this._modifiers != 4096) {
            flags = (short)(flags | 8);
        }
        if (this._timeout != DEFAULT_TIMEOUT) {
            flags = (short)(flags | 0x10);
        }
        return flags;
    }

    @Override
    public boolean requiresPartitionedPreciseDistribution() {
        return true;
    }

    @Override
    public int getPreciseDistributionGroupingCode() {
        return 0;
    }
}

