/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.client.spaceproxy.operations;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.client.spaceproxy.operations.SpaceOperationRequest;
import com.gigaspaces.internal.client.spaceproxy.operations.WriteEntrySpaceOperationResult;
import com.gigaspaces.internal.io.IOUtils;
import com.gigaspaces.internal.remoting.routing.partitioned.PartitionedClusterExecutionType;
import com.gigaspaces.internal.remoting.routing.partitioned.PartitionedClusterRemoteOperationRouter;
import com.gigaspaces.internal.transport.IEntryPacket;
import com.gigaspaces.internal.utils.Textualizer;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.List;
import net.jini.core.transaction.Transaction;

@InternalApi
public class WriteEntrySpaceOperationRequest
extends SpaceOperationRequest<WriteEntrySpaceOperationResult> {
    private static final long serialVersionUID = 1L;
    private IEntryPacket _entryPacket;
    private Transaction _txn;
    private long _lease;
    private long _timeout;
    private int _modifiers;
    private boolean _isUpdate;
    private static final short FLAG_TRANSACTION = 1;
    private static final short FLAG_LEASE = 2;
    private static final short FLAG_TIMEOUT = 4;
    private static final short FLAG_MODIFIERS = 8;
    private static final short FLAG_UPDATE = 16;
    private static final long DEFAULT_LEASE = Long.MAX_VALUE;
    private static final int DEFAULT_MODIFIERS = 4096;
    private static final long DEFAULT_TIMEOUT = 0L;

    public WriteEntrySpaceOperationRequest() {
    }

    public WriteEntrySpaceOperationRequest(IEntryPacket entryPacket, Transaction txn, long lease, long timeout, int modifiers, boolean isUpdate) {
        this._entryPacket = entryPacket;
        this._txn = txn;
        this._lease = lease;
        this._timeout = timeout;
        this._modifiers = modifiers;
        this._isUpdate = isUpdate;
    }

    @Override
    public void toText(Textualizer textualizer) {
        super.toText(textualizer);
        textualizer.append("entryPacket", this._entryPacket);
        textualizer.append("txn", this._txn);
        textualizer.append("lease", this._lease);
        textualizer.append("timeout", this._timeout);
        textualizer.append("modifiers", this._modifiers);
        textualizer.append("isUpdate", this._isUpdate);
    }

    @Override
    public WriteEntrySpaceOperationResult createRemoteOperationResult() {
        return new WriteEntrySpaceOperationResult();
    }

    @Override
    public PartitionedClusterExecutionType getPartitionedClusterExecutionType() {
        return PartitionedClusterExecutionType.SINGLE;
    }

    @Override
    public Object getPartitionedClusterRoutingValue(PartitionedClusterRemoteOperationRouter router) {
        Object routingValue = this._entryPacket.getRoutingFieldValue();
        if (routingValue != null) {
            return routingValue;
        }
        if (this._entryPacket.getTypeDescriptor().isAutoGenerateRouting()) {
            return router.getNextPreciseDistributionPartitionId(this.getPreciseDistributionGroupingCode());
        }
        return null;
    }

    @Override
    public int getOperationCode() {
        return 9;
    }

    public IEntryPacket getEntryPacket() {
        return this._entryPacket;
    }

    public long getLease() {
        return this._lease;
    }

    public int getModifiers() {
        return this._modifiers;
    }

    public boolean isUpdate() {
        return this._isUpdate;
    }

    public long getTimeout() {
        return this._timeout;
    }

    @Override
    public Transaction getTransaction() {
        return this._txn;
    }

    @Override
    public boolean isBlockingOperation() {
        return this._timeout != 0L;
    }

    @Override
    public boolean processUnknownTypeException(List<Integer> positions) {
        if (this._entryPacket.isSerializeTypeDesc()) {
            return false;
        }
        this._entryPacket.setSerializeTypeDesc(true);
        return true;
    }

    @Override
    public String getLRMIMethodTrackingId() {
        return "write";
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        short flags = this.buildFlags();
        out.writeShort(flags);
        IOUtils.writeObject(out, this._entryPacket);
        if (flags != 0) {
            if (this._txn != null) {
                IOUtils.writeWithCachedStubs(out, this._txn);
            }
            if (this._lease != Long.MAX_VALUE) {
                out.writeLong(this._lease);
            }
            if (this._timeout != 0L) {
                out.writeLong(this._timeout);
            }
            if (this._modifiers != 4096) {
                out.writeInt(this._modifiers);
            }
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        short flags = in.readShort();
        this._entryPacket = (IEntryPacket)IOUtils.readObject(in);
        if (flags != 0) {
            if ((flags & 1) != 0) {
                this._txn = (Transaction)IOUtils.readWithCachedStubs(in);
            }
            this._lease = (flags & 2) != 0 ? in.readLong() : Long.MAX_VALUE;
            this._timeout = (flags & 4) != 0 ? in.readLong() : 0L;
            this._modifiers = (flags & 8) != 0 ? in.readInt() : 4096;
            this._isUpdate = (flags & 0x10) != 0;
        } else {
            this._lease = Long.MAX_VALUE;
            this._timeout = 0L;
            this._modifiers = 4096;
        }
    }

    private short buildFlags() {
        short flags = 0;
        if (this._txn != null) {
            flags = (short)(flags | 1);
        }
        if (this._lease != Long.MAX_VALUE) {
            flags = (short)(flags | 2);
        }
        if (this._timeout != 0L) {
            flags = (short)(flags | 4);
        }
        if (this._modifiers != 4096) {
            flags = (short)(flags | 8);
        }
        if (this._isUpdate) {
            flags = (short)(flags | 0x10);
        }
        return flags;
    }

    @Override
    public boolean requiresPartitionedPreciseDistribution() {
        return true;
    }

    @Override
    public int getPreciseDistributionGroupingCode() {
        return 0;
    }
}

