/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.client.spaceproxy.operations;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.client.spaceproxy.operations.SpaceOperationResult;
import com.gigaspaces.internal.io.IOUtils;
import com.gigaspaces.internal.server.space.operations.WriteEntryResult;
import com.gigaspaces.internal.utils.Textualizer;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.rmi.RemoteException;
import net.jini.core.entry.UnusableEntryException;
import net.jini.core.transaction.TransactionException;

@InternalApi
public class WriteEntrySpaceOperationResult
extends SpaceOperationResult {
    private static final long serialVersionUID = 1L;
    private WriteEntryResult _result;

    public WriteEntrySpaceOperationResult() {
    }

    public WriteEntrySpaceOperationResult(WriteEntryResult writeResult, Exception ex) {
        this.setExecutionException(ex);
        this.setResult(writeResult);
    }

    public WriteEntryResult getResult() {
        return this._result;
    }

    public void setResult(WriteEntryResult result) {
        this._result = result;
    }

    public void processExecutionException() throws TransactionException, RemoteException, InterruptedException {
        Exception executionException = this.getExecutionException();
        if (executionException == null) {
            return;
        }
        if (executionException instanceof TransactionException) {
            throw (TransactionException)((Object)executionException);
        }
        if (executionException instanceof RemoteException) {
            throw (RemoteException)executionException;
        }
        if (executionException instanceof InterruptedException) {
            throw (InterruptedException)executionException;
        }
        if (executionException instanceof UnusableEntryException) {
            throw new RemoteException("Failed during update operation ", executionException);
        }
        WriteEntrySpaceOperationResult.onUnexpectedException(executionException);
    }

    @Override
    public void toText(Textualizer textualizer) {
        super.toText(textualizer);
        textualizer.append("result", this._result);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        IOUtils.writeObject(out, this._result);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this._result = (WriteEntryResult)IOUtils.readObject(in);
    }
}

