/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.client.spaceproxy.router;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.client.spaceproxy.SpaceProxyImpl;
import com.gigaspaces.internal.client.spaceproxy.operations.SpaceOperationRequest;
import com.gigaspaces.internal.client.spaceproxy.router.SpaceProxyRemoteOperationRouter;
import com.gigaspaces.internal.remoting.RemoteOperationRequest;
import com.gigaspaces.internal.remoting.routing.clustered.ClusterRemoteOperationRouter;
import com.gigaspaces.internal.remoting.routing.clustered.PostponedAsyncOperationsQueue;
import com.gigaspaces.internal.remoting.routing.clustered.RemoteOperationsExecutorProxy;
import com.gigaspaces.internal.remoting.routing.clustered.RemoteOperationsExecutorsCluster;
import com.gigaspaces.internal.server.space.IRemoteSpace;
import java.rmi.RemoteException;

@InternalApi
public class SpaceClusterRemoteOperationRouter
extends ClusterRemoteOperationRouter
implements SpaceProxyRemoteOperationRouter {
    private final SpaceProxyImpl _spaceProxy;
    private final int _failOverPartitionId;

    public SpaceClusterRemoteOperationRouter(RemoteOperationsExecutorsCluster cluster, PostponedAsyncOperationsQueue postponedAsyncOperationsQueue, SpaceProxyImpl spaceProxy) {
        super(cluster, postponedAsyncOperationsQueue);
        this._spaceProxy = spaceProxy;
        this._failOverPartitionId = cluster.getPartitionId();
    }

    @Override
    protected boolean beforeOperationExecution(RemoteOperationRequest<?> request, RemoteOperationsExecutorProxy proxy) throws RemoteException {
        if (!super.beforeOperationExecution(request, proxy)) {
            return false;
        }
        return this._spaceProxy.beforeExecute((SpaceOperationRequest)request, (IRemoteSpace)proxy.getExecutor(), this._failOverPartitionId, this._cluster.getName(), false);
    }

    @Override
    protected void afterOperationExecution(RemoteOperationRequest<?> request, RemoteOperationsExecutorProxy proxy, ClusterRemoteOperationRouter.ExecutionStatus status) {
        SpaceProxyImpl.afterExecute((SpaceOperationRequest)request, (IRemoteSpace)proxy.getExecutor(), this._cluster.getPartitionId(), status != ClusterRemoteOperationRouter.ExecutionStatus.COMPLETED);
        super.afterOperationExecution(request, proxy, status);
    }

    @Override
    public String getActiveMemberName(int partitionId) {
        RemoteOperationsExecutorProxy activeMember = this.getAnyActiveMember();
        return activeMember != null ? activeMember.getName() : null;
    }
}

