/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.client.spaceproxy.router;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.client.spaceproxy.SpaceProxyImpl;
import com.gigaspaces.internal.client.spaceproxy.operations.SpaceOperationRequest;
import com.gigaspaces.internal.client.spaceproxy.router.SpaceProxyRemoteOperationRouter;
import com.gigaspaces.internal.quiesce.QuiesceTokenProvider;
import com.gigaspaces.internal.remoting.RemoteOperationRequest;
import com.gigaspaces.internal.remoting.routing.clustered.RemoteOperationsExecutorProxy;
import com.gigaspaces.internal.remoting.routing.embedded.EmbeddedRemoteOperationRouter;
import com.gigaspaces.internal.server.space.IRemoteSpace;
import com.gigaspaces.lrmi.LRMIRuntime;
import java.rmi.RemoteException;

@InternalApi
public class SpaceEmbeddedRemoteOperationRouter
extends EmbeddedRemoteOperationRouter
implements SpaceProxyRemoteOperationRouter {
    private final SpaceProxyImpl _spaceProxy;

    public SpaceEmbeddedRemoteOperationRouter(SpaceProxyImpl spaceProxy, int partitionId, QuiesceTokenProvider quiesceTokenProvider) {
        super(new RemoteOperationsExecutorProxy(spaceProxy.getRemoteMemberName(), spaceProxy.getRemoteJSpace(), quiesceTokenProvider), partitionId, spaceProxy.getName(), LRMIRuntime.getRuntime().getThreadPool());
        this._spaceProxy = spaceProxy;
    }

    @Override
    protected boolean beforeOperationExecution(RemoteOperationRequest<?> request) {
        if (!super.beforeOperationExecution(request)) {
            return false;
        }
        try {
            return this._spaceProxy.beforeExecute((SpaceOperationRequest)request, (IRemoteSpace)this._executor, this.getPartitionId(), this.getName(), true);
        }
        catch (RemoteException e) {
            request.setRemoteOperationExecutionError(e);
            return false;
        }
    }

    @Override
    protected void afterOperationExecution(RemoteOperationRequest<?> request) {
        SpaceProxyImpl.afterExecute((SpaceOperationRequest)request, (IRemoteSpace)this._executor, this.getPartitionId(), false);
        super.afterOperationExecution(request);
    }

    @Override
    public String getActiveMemberName(int partitionId) {
        return this._spaceProxy.getRemoteMemberName();
    }
}

