/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.client.spaceproxy.router;

import com.gigaspaces.admin.quiesce.QuiesceToken;
import com.gigaspaces.api.InternalApi;
import com.gigaspaces.async.AsyncFutureListener;
import com.gigaspaces.internal.client.spaceproxy.SpaceProxyImpl;
import com.gigaspaces.internal.client.spaceproxy.operations.SpaceOperationResult;
import com.gigaspaces.internal.client.spaceproxy.router.SpaceClusterRemoteOperationRouter;
import com.gigaspaces.internal.client.spaceproxy.router.SpaceEmbeddedRemoteOperationRouter;
import com.gigaspaces.internal.client.spaceproxy.router.SpacePartitionedClusterRemoteOperationRouter;
import com.gigaspaces.internal.client.spaceproxy.router.SpaceProxyRemoteOperationRouter;
import com.gigaspaces.internal.client.spaceproxy.router.SpaceRemoteOperationsExecutorsClusterConfig;
import com.gigaspaces.internal.cluster.SpaceClusterInfo;
import com.gigaspaces.internal.cluster.SpaceProxyLoadBalancerType;
import com.gigaspaces.internal.lookup.SpaceUrlUtils;
import com.gigaspaces.internal.quiesce.QuiesceTokenProviderImpl;
import com.gigaspaces.internal.remoting.RemoteOperationFutureListener;
import com.gigaspaces.internal.remoting.RemoteOperationRequest;
import com.gigaspaces.internal.remoting.routing.clustered.PostponedAsyncOperationsQueue;
import com.gigaspaces.internal.remoting.routing.clustered.RemoteOperationsExecutorProxy;
import com.gigaspaces.internal.remoting.routing.clustered.RemoteOperationsExecutorsCluster;
import com.gigaspaces.internal.remoting.routing.clustered.RemoteOperationsExecutorsClusterConfig;
import com.gigaspaces.internal.remoting.routing.clustered.RemoteSpaceProxyLocator;
import com.gigaspaces.internal.remoting.routing.partitioned.PartitionedClusterUtils;
import com.gigaspaces.internal.server.space.IRemoteSpace;
import com.gigaspaces.internal.utils.CollectionUtils;
import com.gigaspaces.internal.utils.concurrent.IAsyncHandlerProvider;
import com.gigaspaces.internal.utils.concurrent.ScheduledThreadPoolAsyncHandlerProvider;
import com.j_spaces.core.SpaceContext;
import com.j_spaces.core.client.SpaceURL;
import com.j_spaces.core.client.SpaceURLParser;
import com.j_spaces.core.exception.internal.ProxyInternalSpaceException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

@InternalApi
public class SpaceProxyRouter {
    private final Logger _logger;
    private final SpaceClusterInfo _clusterInfo;
    private SpaceContext _defaultSpaceContext;
    private final SpaceRemoteOperationsExecutorsClusterConfig _config;
    private final SpaceProxyRemoteOperationRouter _router;
    private final PostponedAsyncOperationsQueue _postponedAsyncOperationsQueue;
    private final IAsyncHandlerProvider _asyncHandlerProvider;
    private final RemoteSpaceProxyLocator _proxyLocator;
    private final boolean isGateway;
    private final boolean isSecured;
    private final QuiesceTokenProviderImpl quiesceTokenProvider;

    public SpaceProxyRouter(SpaceProxyImpl spaceProxy) {
        this._logger = Logger.getLogger("com.gigaspaces.spaceproxy.router." + spaceProxy.getName());
        this._clusterInfo = spaceProxy.getSpaceClusterInfo();
        this.isGateway = spaceProxy.isGatewayProxy();
        this.isSecured = spaceProxy.isSecured();
        this.quiesceTokenProvider = new QuiesceTokenProviderImpl();
        this.updateDefaultSpaceContext(null);
        Properties properties = this.loadConfig(spaceProxy.getProxySettings().getCustomProperties(), this._clusterInfo);
        this._config = new SpaceRemoteOperationsExecutorsClusterConfig(properties);
        if (this._clusterInfo.isPartitioned() && this._config.getLoadBalancerType() == SpaceProxyLoadBalancerType.ROUND_ROBIN) {
            throw new IllegalStateException("Cannot use round robin load balancing with a partitioned space.");
        }
        if (this._logger.isLoggable(Level.CONFIG)) {
            this._logger.log(Level.CONFIG, "Initializing space proxy router - [Active server lookup timeout=" + this._config.getActiveServerLookupTimeout() + ", Active server lookup sampling interval=" + this._config.getActiveServerLookupSamplingInterval() + ", Thread pool size=" + this._config.getThreadPoolSize() + "]");
        }
        this._proxyLocator = this.createProxyLocator(spaceProxy);
        this._asyncHandlerProvider = new ScheduledThreadPoolAsyncHandlerProvider(spaceProxy.getName() + "-router-threadpool", this._config.getThreadPoolSize());
        if (!(!spaceProxy.isEmbedded() || this._clusterInfo.isPartitioned() && spaceProxy.isClustered())) {
            int partitionId = PartitionedClusterUtils.extractPartitionIdFromSpaceName(spaceProxy.getRemoteMemberName());
            this._postponedAsyncOperationsQueue = null;
            this._router = new SpaceEmbeddedRemoteOperationRouter(spaceProxy, partitionId, this.quiesceTokenProvider);
        } else {
            this._postponedAsyncOperationsQueue = new PostponedAsyncOperationsQueue(spaceProxy.getName());
            this._router = spaceProxy.isClustered() ? (this._clusterInfo.isPartitioned() ? this.createPartitionedRouter(spaceProxy, this._clusterInfo, this._config) : this.createClusteredRouter(spaceProxy, this._clusterInfo.getMembersNames(), this._config)) : this.createClusteredRouter(spaceProxy, CollectionUtils.toList(spaceProxy.getRemoteMemberName()), this._config);
        }
        this.warnIfOldConfigIsUsed(properties);
    }

    public IAsyncHandlerProvider getAsyncHandlerProvider() {
        return this._asyncHandlerProvider;
    }

    private void warnIfOldConfigIsUsed(Properties properties) {
        if (this._logger.isLoggable(Level.WARNING)) {
            this.testDeprecatedProperty(properties, "space-config.proxy-settings.connection-monitor");
            this.testDeprecatedProperty(properties, "space-config.proxy-settings.connection-retries");
            this.testDeprecatedProperty(properties, "space-config.proxy-settings.lookup-frequency");
            this.testDeprecatedProperty(properties, "space-config.proxy-settings.ping-frequency");
            this.testDeprecatedProperty(properties, "space-config.retries");
        }
    }

    private void testDeprecatedProperty(Properties properties, String propertyName) {
        if (properties.containsKey(propertyName)) {
            this._logger.warning("Property is ignored when using the new space proxy router: " + propertyName);
        }
    }

    private SpaceProxyRemoteOperationRouter createClusteredRouter(SpaceProxyImpl spaceProxy, List<String> membersNames, RemoteOperationsExecutorsClusterConfig config) {
        RemoteOperationsExecutorProxy defaultProxy = new RemoteOperationsExecutorProxy(spaceProxy.getRemoteMemberName(), spaceProxy.getRemoteJSpace(), this.quiesceTokenProvider);
        RemoteOperationsExecutorsCluster cluster = new RemoteOperationsExecutorsCluster(spaceProxy.getName(), this._clusterInfo, -1, membersNames, config, this._asyncHandlerProvider, this._proxyLocator, defaultProxy);
        return new SpaceClusterRemoteOperationRouter(cluster, this._postponedAsyncOperationsQueue, spaceProxy);
    }

    private SpaceProxyRemoteOperationRouter createPartitionedRouter(SpaceProxyImpl spaceProxy, SpaceClusterInfo clusterInfo, RemoteOperationsExecutorsClusterConfig config) {
        SpaceProxyRemoteOperationRouter[] partitions = new SpaceProxyRemoteOperationRouter[clusterInfo.getNumberOfPartitions()];
        String embeddedMemberName = spaceProxy.isEmbedded() ? spaceProxy.getRemoteMemberName() : null;
        for (int i = 0; i < partitions.length; ++i) {
            List<String> members = clusterInfo.getPartitionMembersNames(i);
            if (this.isEmbeddedPartition(members, embeddedMemberName)) {
                partitions[i] = new SpaceEmbeddedRemoteOperationRouter(spaceProxy, i, this.quiesceTokenProvider);
                continue;
            }
            RemoteOperationsExecutorsCluster cluster = new RemoteOperationsExecutorsCluster(spaceProxy.getName(), clusterInfo, i, members, config, this._asyncHandlerProvider, this._proxyLocator, null);
            partitions[i] = new SpaceClusterRemoteOperationRouter(cluster, this._postponedAsyncOperationsQueue, spaceProxy);
        }
        RemoteOperationsExecutorsCluster partitionedCluster = new RemoteOperationsExecutorsCluster(spaceProxy.getName(), clusterInfo, -1, clusterInfo.getMembersNames(), config, this._asyncHandlerProvider, this._proxyLocator, null);
        return new SpacePartitionedClusterRemoteOperationRouter(spaceProxy.getName(), partitions, clusterInfo.isBroadcastDisabled(), partitionedCluster);
    }

    private Properties loadConfig(Properties properties, SpaceClusterInfo clusterInfo) {
        if (!properties.containsKey("space-config.proxy.router.load-balancer-type") && clusterInfo != null && clusterInfo.getLoadBalancerType() != null && clusterInfo.getLoadBalancerType() != SpaceProxyLoadBalancerType.STICKY) {
            properties.setProperty("space-config.proxy.router.load-balancer-type", clusterInfo.getLoadBalancerType().toString());
            if (this._logger.isLoggable(Level.WARNING)) {
                this._logger.log(Level.WARNING, "Setting load balance type via cluster policy is deprecated, use space property 'space-config.proxy.router.load-balancer-type' instead.");
            }
        }
        return properties;
    }

    private RemoteSpaceProxyLocator createProxyLocator(SpaceProxyImpl spaceProxy) {
        SpaceURL spaceUrl = spaceProxy.getFinderURL();
        if (spaceUrl == null) {
            spaceUrl = spaceProxy.getURL();
        }
        if (spaceUrl.isJiniProtocol()) {
            spaceUrl = spaceUrl.clone();
            spaceUrl.remove("useLocalCache");
        } else {
            String url = SpaceUrlUtils.buildJiniUrl(spaceUrl.getContainerName(), spaceUrl.getSpaceName(), spaceUrl.getProperty("groups"), null);
            try {
                spaceUrl = SpaceURLParser.parseURL(url);
            }
            catch (MalformedURLException e) {
                throw new ProxyInternalSpaceException(e);
            }
        }
        return new RemoteSpaceProxyLocator(spaceProxy.getName(), spaceUrl, this.quiesceTokenProvider);
    }

    private boolean isEmbeddedPartition(List<String> members, String embeddedMemberName) {
        if (embeddedMemberName == null) {
            return false;
        }
        for (String member : members) {
            if (!member.equals(embeddedMemberName)) continue;
            return true;
        }
        return false;
    }

    public void close() {
        if (this._postponedAsyncOperationsQueue != null) {
            this._postponedAsyncOperationsQueue.close();
        }
        if (this._asyncHandlerProvider != null) {
            this._asyncHandlerProvider.close();
        }
        this._router.close();
    }

    public <T extends SpaceOperationResult> void execute(RemoteOperationRequest<T> request) throws InterruptedException {
        this._router.execute(request);
    }

    public <T extends SpaceOperationResult> RemoteOperationFutureListener<T> executeAsync(RemoteOperationRequest<T> request, AsyncFutureListener<Object> listener) {
        RemoteOperationFutureListener<T> futureListener = this._router.createFutureListener(request, listener);
        this._router.executeAsync(request, futureListener);
        return futureListener;
    }

    public void executeOneway(RemoteOperationRequest<?> request) throws InterruptedException {
        this._router.executeOneway(request);
    }

    public RemoteOperationsExecutorsClusterConfig getConfig() {
        return this._config;
    }

    public IRemoteSpace getAnyAvailableSpace() {
        RemoteOperationsExecutorProxy member = this._router.getAnyAvailableMember();
        return member != null ? (IRemoteSpace)member.getExecutor() : null;
    }

    public IRemoteSpace getAnyActiveSpace() {
        RemoteOperationsExecutorProxy member = this._router.getAnyActiveMember();
        return member != null ? (IRemoteSpace)member.getExecutor() : null;
    }

    private List<RemoteOperationsExecutorProxy> getAllAvailableMembers() {
        ArrayList<RemoteOperationsExecutorProxy> result = new ArrayList<RemoteOperationsExecutorProxy>();
        this._router.getAllAvailableMembers(result);
        return result;
    }

    public List<IRemoteSpace> getAllAvailableSpaces() {
        List<RemoteOperationsExecutorProxy> availableMembers = this.getAllAvailableMembers();
        ArrayList<IRemoteSpace> result = new ArrayList<IRemoteSpace>();
        for (RemoteOperationsExecutorProxy member : availableMembers) {
            result.add((IRemoteSpace)member.getExecutor());
        }
        return result;
    }

    public SpaceURL getMemberUrl(String memberName) {
        return memberName == null ? null : this._proxyLocator.getMemberUrl(memberName);
    }

    public SpaceURL getPrimaryMemberUrl(int partitionId) {
        return this.getMemberUrl(this._router.getActiveMemberName(partitionId));
    }

    public RemoteSpaceProxyLocator getProxyLocator() {
        return this._proxyLocator;
    }

    public SpaceContext getDefaultSpaceContext() {
        return this._defaultSpaceContext;
    }

    public void setQuiesceToken(QuiesceToken token) {
        this.updateDefaultSpaceContext(token);
    }

    private void updateDefaultSpaceContext(QuiesceToken token) {
        SpaceContext spaceContext = this._defaultSpaceContext = this.isSecured || this.isGateway || token != null ? new SpaceContext(this.isGateway) : null;
        if (token != null) {
            this._defaultSpaceContext.setQuiesceToken(token);
        }
        this.quiesceTokenProvider.setToken(token);
    }
}

