/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.client.spaceproxy.router;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.cluster.SpaceProxyLoadBalancerType;
import com.gigaspaces.internal.remoting.routing.clustered.RemoteOperationsExecutorsClusterConfig;
import com.gigaspaces.internal.utils.PropertiesUtils;
import java.util.Properties;

@InternalApi
public class SpaceRemoteOperationsExecutorsClusterConfig
implements RemoteOperationsExecutorsClusterConfig {
    private final long _activeServerLookupTimeout;
    private final long _activeServerLookupSamplingInterval;
    private final int _threadPoolSize;
    private SpaceProxyLoadBalancerType _loadBalancerType;
    private final int _numOfOperationsTypes;

    public SpaceRemoteOperationsExecutorsClusterConfig() {
        this(null);
    }

    public SpaceRemoteOperationsExecutorsClusterConfig(Properties properties) {
        this._activeServerLookupTimeout = PropertiesUtils.getLong(properties, "space-config.proxy.router.active-server-lookup-timeout", 20000L);
        this._activeServerLookupSamplingInterval = PropertiesUtils.getLong(properties, "space-config.proxy.router.active-server-lookup-sampling-interval", 100L);
        this._threadPoolSize = PropertiesUtils.getInteger(properties, "space-config.proxy.router.threadpool-size", Runtime.getRuntime().availableProcessors() * 2);
        this._numOfOperationsTypes = 23;
        this._loadBalancerType = PropertiesUtils.getEnum(properties, "space-config.proxy.router.load-balancer-type", SpaceProxyLoadBalancerType.class, SpaceProxyLoadBalancerType.STICKY);
    }

    @Override
    public long getActiveServerLookupTimeout() {
        return this._activeServerLookupTimeout;
    }

    @Override
    public long getActiveServerLookupSamplingInterval() {
        return this._activeServerLookupSamplingInterval;
    }

    @Override
    public int getThreadPoolSize() {
        return this._threadPoolSize;
    }

    @Override
    public SpaceProxyLoadBalancerType getLoadBalancerType() {
        return this._loadBalancerType;
    }

    @Override
    public int getNumOfOperationsTypes() {
        return this._numOfOperationsTypes;
    }
}

