/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.client.spaceproxy.transaction;

import com.gigaspaces.api.InternalApi;
import com.j_spaces.core.client.ActionListener;
import com.j_spaces.core.client.XAResourceImpl;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jini.core.transaction.Transaction;

@InternalApi
public class SpaceProxyTransactionManager {
    private boolean _supportsContextTransaction;
    private final ThreadLocal<CurrentXtnProxyHolder> _contextTransactions = new ThreadLocal();
    private transient ActionListener _actionListener;
    private static final Logger _logger = Logger.getLogger("com.gigaspaces.core.xa");

    public void setActionListener(ActionListener actionListener) {
        this._actionListener = actionListener;
    }

    public Transaction.Created getContextTransaction() {
        CurrentXtnProxyHolder ph = this._contextTransactions.get();
        return ph != null ? ph.getXtn() : null;
    }

    public Transaction.Created replaceContextTransaction(Transaction.Created txn) {
        return this.replaceContextTransaction(txn, null, false);
    }

    public Transaction.Created replaceContextTransaction(Transaction.Created txn, ActionListener currentActionListener, boolean delegatedXa) {
        if (_logger.isLoggable(Level.FINE)) {
            if (txn == null) {
                _logger.log(Level.FINE, "GS:replaceContextTransaction called with txn NULL  thread=" + Thread.currentThread().getId() + " proxy=" + this);
            } else {
                XAResourceImpl xares = null;
                if (currentActionListener != null) {
                    xares = (XAResourceImpl)currentActionListener;
                }
                if (xares != null) {
                    _logger.log(Level.FINE, "GS:replaceContextTransaction called with txn  thread=" + Thread.currentThread().getId() + " rmid=" + xares.getRmid() + " proxy=" + this);
                } else {
                    _logger.log(Level.FINE, "GS:replaceContextTransaction called with txn  thread=" + Thread.currentThread().getId() + " rmid= = NULL proxy=" + this);
                }
            }
        }
        Transaction.Created oldTxn = this.getContextTransaction();
        if (txn != null) {
            this._supportsContextTransaction = true;
            this._contextTransactions.set(new CurrentXtnProxyHolder(txn, currentActionListener, delegatedXa));
        } else {
            this._contextTransactions.remove();
        }
        return oldTxn;
    }

    public Transaction beforeSpaceAction(Transaction transaction) {
        boolean ignore;
        Transaction res_transaction = transaction;
        boolean consideredActionListener = false;
        ActionListener currentActionListener = null;
        CurrentXtnProxyHolder ph = this._supportsContextTransaction ? this._contextTransactions.get() : null;
        boolean bl = ignore = res_transaction == null && ph != null && ph.isdelegatedXa();
        if (!ignore && (res_transaction == null || ph != null && ph.getCurrentActionListener() != null && ph.getXtn().transaction.equals(transaction)) && ph != null) {
            consideredActionListener = true;
            res_transaction = ph.getXtn().transaction;
            currentActionListener = ph.getCurrentActionListener();
            if (currentActionListener == null) {
                currentActionListener = this._actionListener;
            }
            if (currentActionListener != null) {
                currentActionListener.action(res_transaction);
            }
        }
        if (!ignore && this._actionListener != null && !consideredActionListener) {
            this._actionListener.action(transaction);
        }
        return res_transaction;
    }

    private static class CurrentXtnProxyHolder {
        private final Transaction.Created _currentXtn;
        private final ActionListener _currentActionListener;
        private final boolean _delegatedXa;

        CurrentXtnProxyHolder(Transaction.Created currentXtn, ActionListener currentActionListener, boolean delegatedXa) {
            this._currentXtn = currentXtn;
            this._currentActionListener = currentActionListener;
            this._delegatedXa = delegatedXa;
        }

        Transaction.Created getXtn() {
            return this._currentXtn;
        }

        ActionListener getCurrentActionListener() {
            return this._currentActionListener;
        }

        boolean isdelegatedXa() {
            return this._delegatedXa;
        }
    }
}

