/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.client.utils;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.io.CompressedMarshObjectConvertor;
import com.gigaspaces.internal.io.ContextClassResolverCompressedMarshObjectConvertor;
import com.gigaspaces.internal.io.ContextClassResolverMarshObjectConvertor;
import com.gigaspaces.internal.io.MarshObject;
import com.gigaspaces.internal.io.MarshObjectConvertor;
import com.gigaspaces.internal.io.MarshObjectConvertorResource;
import com.gigaspaces.internal.utils.pool.IMemoryAwareResourceFactory;
import com.gigaspaces.internal.utils.pool.MemoryBoundedResourcePool;
import com.gigaspaces.metadata.StorageType;
import java.io.IOException;

@InternalApi
public class SerializationUtil {
    private static final SerializationAdapter _binaryAdapter = new PooledMarshalledObjectSerializationAdapter<MarshObjectConvertor>(ContextClassResolverMarshObjectConvertor.getFactory());
    private static final SerializationAdapter _compressedAdapter = new PooledMarshalledObjectSerializationAdapter<CompressedMarshObjectConvertor>(ContextClassResolverCompressedMarshObjectConvertor.getFactory());

    public static Object serializeFieldValue(Object value, StorageType storageType) throws IOException {
        if (value == null) {
            return value;
        }
        SerializationAdapter adapter = SerializationUtil.getSerializationAdapter(storageType);
        return adapter == null ? value : adapter.beforeSerialize(value);
    }

    public static Object deSerializeFieldValue(Object value, StorageType storageType) throws ClassNotFoundException, IOException {
        if (value == null) {
            return value;
        }
        SerializationAdapter adapter = SerializationUtil.getSerializationAdapter(storageType);
        return adapter == null ? value : adapter.afterDeserialize(value);
    }

    private static SerializationAdapter getSerializationAdapter(StorageType storageType) {
        switch (storageType) {
            case OBJECT: {
                return null;
            }
            case BINARY: {
                return _binaryAdapter;
            }
            case COMPRESSED: {
                return _compressedAdapter;
            }
        }
        throw new IllegalArgumentException("Invalid storage Type : " + (Object)((Object)storageType));
    }

    public static class PooledMarshalledObjectSerializationAdapter<T extends MarshObjectConvertorResource>
    implements SerializationAdapter {
        private final MemoryBoundedResourcePool<T> _convertorPool;

        public PooledMarshalledObjectSerializationAdapter(IMemoryAwareResourceFactory<T> factory) {
            int maxResources = Integer.getInteger("com.gs.client.storage-type-serialization.cache.max-pool-resource-count", 100);
            int poolMemoryBounds = Integer.getInteger("com.gs.client.storage-type-serialization.cache.max-pool-memory-size", 0x10000000);
            this._convertorPool = new MemoryBoundedResourcePool<T>(factory, 0, maxResources, poolMemoryBounds);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object beforeSerialize(Object value) throws IOException {
            MarshObjectConvertorResource convertor = (MarshObjectConvertorResource)this._convertorPool.getResource();
            try {
                MarshObject marshObject = convertor.getMarshObject(value);
                return marshObject;
            }
            finally {
                this._convertorPool.freeResource(convertor);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object afterDeserialize(Object value) throws IOException, ClassNotFoundException {
            MarshObjectConvertorResource convertor = (MarshObjectConvertorResource)this._convertorPool.getResource();
            try {
                Object object = convertor.getObject((MarshObject)value);
                return object;
            }
            finally {
                this._convertorPool.freeResource(convertor);
            }
        }
    }

    public static interface SerializationAdapter {
        public Object beforeSerialize(Object var1) throws IOException;

        public Object afterDeserialize(Object var1) throws IOException, ClassNotFoundException;
    }
}

