/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.cluster;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.cluster.replication.MirrorServiceConfig;
import com.gigaspaces.internal.cluster.SpaceClusterPartitionInfo;
import com.gigaspaces.internal.cluster.SpaceProxyLoadBalancerType;
import com.gigaspaces.internal.extension.CustomSerializer;
import com.gigaspaces.internal.extension.XapExtensions;
import com.gigaspaces.internal.io.IOUtils;
import com.gigaspaces.internal.utils.StringUtils;
import com.gigaspaces.internal.version.PlatformLogicalVersion;
import com.gigaspaces.lrmi.LRMIInvocationContext;
import com.gigaspaces.server.SpaceCustomComponent;
import com.j_spaces.core.JSpaceAttributes;
import com.j_spaces.core.cluster.ClusterPolicy;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

@InternalApi
public class SpaceClusterInfo
implements Externalizable {
    private static final long serialVersionUID = 1L;
    private static final Set<String> supportedSchemas = SpaceClusterInfo.initSupportedSchemas();
    private boolean clustered;
    private String clusterName;
    private String clusterSchema;
    private boolean replicated;
    private boolean primaryElectionAvailable;
    private boolean activeActive;
    private List<String> membersNames;
    private boolean broadcastDisabled;
    private int numOfPartitions;
    private int numOfBackups;
    private transient SpaceClusterPartitionInfo[] partitions;
    private SpaceProxyLoadBalancerType loadBalancerType;
    private final Map<String, SpaceCustomComponent> customComponents = new HashMap<String, SpaceCustomComponent>();
    private boolean syncReplication;
    private MirrorServiceConfig mirrorServiceConfig;
    private boolean hasReplicationTargets;
    private static final short FLAG_CLUSTERED = 1;
    private static final short FLAG_REPLICATED = 2;
    private static final short FLAG_PRIMARY_ELECTION = 4;
    private static final short FLAG_ACTIVE_ACTIVE = 8;
    private static final short FLAG_BROADCAST_DISABLED = 16;
    private static final short FLAG_SYNC_REPLICATION = 32;
    private static final short FLAG_MIRROR_CONFIG = 64;
    private static final short FLAG_HAS_REPLICATION_TARGETS = 128;
    private static final short FLAG_PARTITIONED = 256;
    private static final short FLAG_HAS_BACKUPS = 512;
    private static final short FLAG_HAS_CUSTOM_COMPONENTS = 1024;
    private static final short FLAG_LOAD_BALANCER_TYPE = 2048;

    private static Set<String> initSupportedSchemas() {
        HashSet<String> result = new HashSet<String>();
        result.add("sync_replicated");
        result.add("async_replicated");
        result.add("primary_backup");
        result.add("partitioned");
        result.add("partitioned-sync2backup");
        return result;
    }

    public SpaceClusterInfo() {
    }

    public SpaceClusterInfo(JSpaceAttributes spaceAttributes, String defaultMemberName) {
        Map<String, SpaceCustomComponent> customComponents;
        ClusterPolicy clusterPolicy = spaceAttributes != null ? spaceAttributes.getClusterPolicy() : null;
        this.clustered = clusterPolicy != null;
        this.clusterName = clusterPolicy != null ? clusterPolicy.m_ClusterName : null;
        String string = this.clusterSchema = clusterPolicy != null ? clusterPolicy.m_ClusterSchemaName : null;
        if (this.clusterSchema != null && !supportedSchemas.contains(this.clusterSchema)) {
            throw new IllegalArgumentException("Unsupported cluster schema - " + this.clusterSchema);
        }
        this.replicated = clusterPolicy != null && clusterPolicy.isReplicated();
        this.primaryElectionAvailable = clusterPolicy != null && clusterPolicy.isPrimaryElectionAvailable();
        this.activeActive = clusterPolicy != null && clusterPolicy.isActiveActive();
        this.syncReplication = clusterPolicy != null && clusterPolicy.getReplicationPolicy() != null && clusterPolicy.getReplicationPolicy().m_IsSyncReplicationEnabled;
        this.mirrorServiceConfig = this.replicated ? clusterPolicy.getReplicationPolicy().getMirrorServiceConfig() : null;
        this.hasReplicationTargets = clusterPolicy != null && clusterPolicy.getReplicationPolicy() != null && clusterPolicy.getReplicationPolicy().getReplicationTargetsCount() > 0;
        Map<String, SpaceCustomComponent> map = customComponents = spaceAttributes != null ? spaceAttributes.getCustomComponents() : null;
        if (customComponents != null) {
            for (SpaceCustomComponent component : customComponents.values()) {
                if (!(component instanceof Serializable)) continue;
                this.customComponents.put(component.getSpaceComponentKey(), component);
            }
        }
        this.membersNames = clusterPolicy != null ? Collections.unmodifiableList(clusterPolicy.m_AllClusterMemberList) : Collections.singletonList(defaultMemberName);
        this.broadcastDisabled = clusterPolicy != null && clusterPolicy.m_LoadBalancingPolicy != null && clusterPolicy.m_LoadBalancingPolicy.m_DefaultPolicy.getBroadcastCondition().isBroadcastNever();
        String routingPolicy = SpaceClusterInfo.getLoadBalancingPolicy(clusterPolicy);
        this.numOfPartitions = SpaceClusterInfo.getNumOfPartitions(clusterPolicy, routingPolicy);
        this.numOfBackups = SpaceClusterInfo.getNumberOfBackups(clusterPolicy, this.numOfPartitions);
        this.loadBalancerType = StringUtils.hasLength(routingPolicy) && routingPolicy.equals("round-robin") ? SpaceProxyLoadBalancerType.ROUND_ROBIN : SpaceProxyLoadBalancerType.STICKY;
        this.initialize();
    }

    private void initialize() {
        this.partitions = SpaceClusterInfo.generatePartitionsInfo(this.clusterName, this.numOfPartitions, this.numOfBackups);
    }

    public boolean isClustered() {
        return this.clustered;
    }

    public List<String> getMembersNames() {
        return this.membersNames;
    }

    public boolean isBroadcastDisabled() {
        return this.broadcastDisabled;
    }

    public boolean isPartitioned() {
        return this.numOfPartitions != 0;
    }

    public int getNumberOfPartitions() {
        return this.numOfPartitions;
    }

    public int getNumberOfBackups() {
        return this.numOfBackups;
    }

    public SpaceProxyLoadBalancerType getLoadBalancerType() {
        return this.loadBalancerType;
    }

    public List<String> getPartitionMembersNames(int partitionId) {
        return this.partitions[partitionId].members;
    }

    public int getPartitionOfMember(String memberName) {
        for (int i = 0; i < this.numOfPartitions; ++i) {
            if (!this.partitions[i].members.contains(memberName)) continue;
            return i;
        }
        return -1;
    }

    public boolean isReplicated() {
        return this.replicated;
    }

    public boolean isActiveActive() {
        return this.activeActive;
    }

    public <T> T getCustomComponent(String key) {
        return (T)this.customComponents.get(key);
    }

    public Map<String, SpaceCustomComponent> getCustomComponents() {
        return this.customComponents;
    }

    public void setCustomComponent(SpaceCustomComponent component) {
        this.customComponents.put(component.getSpaceComponentKey(), component);
    }

    public boolean isSyncReplicationEnabled() {
        return this.syncReplication;
    }

    public boolean isMirrorServiceEnabled() {
        return this.mirrorServiceConfig != null;
    }

    public MirrorServiceConfig getMirrorServiceConfig() {
        return this.mirrorServiceConfig;
    }

    public boolean hasReplicationTargets() {
        return this.hasReplicationTargets;
    }

    public boolean isPrimaryElectionAvailable() {
        return this.primaryElectionAvailable;
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public String getClusterSchema() {
        return this.clusterSchema;
    }

    private static String getLoadBalancingPolicy(ClusterPolicy clusterPolicy) {
        if (clusterPolicy == null || clusterPolicy.m_LoadBalancingPolicy == null) {
            return null;
        }
        return clusterPolicy.m_LoadBalancingPolicy.m_DefaultPolicy.m_PolicyType;
    }

    private static int getNumOfPartitions(ClusterPolicy clusterPolicy, String routingPolicy) {
        HashMap<String, List<String>> backups;
        boolean isPartitioned;
        boolean bl = isPartitioned = StringUtils.hasLength(routingPolicy) && routingPolicy.equals("hash-based");
        if (!isPartitioned) {
            return 0;
        }
        HashMap<String, List<String>> hashMap = backups = clusterPolicy.m_FailOverPolicy == null ? null : clusterPolicy.m_FailOverPolicy.m_DefaultFOPolicy.m_BackupMemberNames;
        if (backups != null) {
            return backups.size();
        }
        return clusterPolicy.m_LoadBalancingPolicy.loadBalanceGroupMembersNames.size();
    }

    private static SpaceClusterPartitionInfo[] generatePartitionsInfo(String spaceName, int numOfPartitions, int numOfBackups) {
        SpaceClusterPartitionInfo[] partitions = new SpaceClusterPartitionInfo[numOfPartitions];
        for (int partitionId = 1; partitionId <= numOfPartitions; ++partitionId) {
            ArrayList<String> members = new ArrayList<String>();
            for (int backupId = 0; backupId <= numOfBackups; ++backupId) {
                members.add(SpaceClusterInfo.toMemberName(spaceName, partitionId, backupId));
            }
            partitions[partitionId - 1] = new SpaceClusterPartitionInfo(members);
        }
        return partitions;
    }

    private static int getNumberOfBackups(ClusterPolicy clusterPolicy, int numOfPartitions) {
        if (clusterPolicy == null || clusterPolicy.m_FailOverPolicy == null || clusterPolicy.m_FailOverPolicy.m_DefaultFOPolicy == null || clusterPolicy.m_FailOverPolicy.m_DefaultFOPolicy.m_BackupOnly == null) {
            return 0;
        }
        int numOfBackups = clusterPolicy.m_FailOverPolicy.m_DefaultFOPolicy.m_BackupOnly.size();
        return numOfPartitions == 0 ? numOfBackups : numOfBackups / numOfPartitions;
    }

    private static String toMemberName(String spaceName, int partitionId, int backupId) {
        String member = backupId == 0 ? String.valueOf(partitionId) : partitionId + "_" + backupId;
        return spaceName + "_container" + member + ":" + spaceName;
    }

    public String toString() {
        if (!this.clustered) {
            return "SpaceClusterInfo [clustered=false]";
        }
        return "SpaceClusterInfo [clusterName=" + this.clusterName + ", clusterSchema=" + this.clusterSchema + ", numOfPartitions=" + this.numOfPartitions + ", numOfBackups=" + this.numOfBackups + "]";
    }

    private int buildFlags() {
        int flags = 0;
        if (this.clustered) {
            flags |= 1;
        }
        if (this.replicated) {
            flags |= 2;
        }
        if (this.primaryElectionAvailable) {
            flags |= 4;
        }
        if (this.activeActive) {
            flags |= 8;
        }
        if (this.broadcastDisabled) {
            flags |= 0x10;
        }
        if (this.syncReplication) {
            flags |= 0x20;
        }
        if (this.mirrorServiceConfig != null) {
            flags |= 0x40;
        }
        if (this.hasReplicationTargets) {
            flags |= 0x80;
        }
        if (this.numOfPartitions != 0) {
            flags |= 0x100;
        }
        if (this.numOfBackups != 0) {
            flags |= 0x200;
        }
        if (!this.customComponents.isEmpty()) {
            flags |= 0x400;
        }
        if (this.loadBalancerType != SpaceProxyLoadBalancerType.STICKY) {
            flags |= 0x800;
        }
        return flags;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        PlatformLogicalVersion version = LRMIInvocationContext.getEndpointLogicalVersion();
        out.writeInt(this.buildFlags());
        IOUtils.writeString(out, this.clusterName);
        IOUtils.writeString(out, this.clusterSchema);
        IOUtils.writeListString(out, this.membersNames);
        if (this.numOfPartitions != 0) {
            out.writeInt(this.numOfPartitions);
        }
        if (this.numOfBackups != 0) {
            out.writeInt(this.numOfBackups);
        }
        if (this.mirrorServiceConfig != null) {
            this.mirrorServiceConfig.writeExternal(out);
        }
        if (!this.customComponents.isEmpty()) {
            CustomSerializer<SpaceClusterInfo> customSerializer = XapExtensions.getInstance().getCustomSerializer(SpaceClusterInfo.class, version);
            if (customSerializer != null) {
                customSerializer.writeExternal(this, out, version);
            } else {
                IOUtils.writeObject(out, this.customComponents);
            }
        }
        if (this.loadBalancerType != SpaceProxyLoadBalancerType.STICKY) {
            out.writeByte(this.loadBalancerType.getCode());
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        PlatformLogicalVersion version = LRMIInvocationContext.getEndpointLogicalVersion();
        int flags = in.readInt();
        this.clusterName = IOUtils.readString(in);
        this.clusterSchema = IOUtils.readString(in);
        this.membersNames = IOUtils.readListString(in);
        this.numOfPartitions = (flags & 0x100) != 0 ? in.readInt() : 0;
        int n = this.numOfBackups = (flags & 0x200) != 0 ? in.readInt() : 0;
        if ((flags & 0x40) != 0) {
            this.mirrorServiceConfig = new MirrorServiceConfig();
            this.mirrorServiceConfig.readExternal(in);
        }
        if ((flags & 0x400) != 0) {
            CustomSerializer<SpaceClusterInfo> customSerializer = XapExtensions.getInstance().getCustomSerializer(SpaceClusterInfo.class, version);
            if (customSerializer != null) {
                customSerializer.readExternal(this, in, version);
            } else {
                Map componentMap = (Map)IOUtils.readObject(in);
                this.customComponents.putAll(componentMap);
            }
        }
        this.loadBalancerType = (flags & 0x800) != 0 ? SpaceProxyLoadBalancerType.fromCode(in.readByte()) : SpaceProxyLoadBalancerType.STICKY;
        this.clustered = (flags & 1) != 0;
        this.replicated = (flags & 2) != 0;
        this.primaryElectionAvailable = (flags & 4) != 0;
        this.activeActive = (flags & 8) != 0;
        this.broadcastDisabled = (flags & 0x10) != 0;
        this.syncReplication = (flags & 0x20) != 0;
        this.hasReplicationTargets = (flags & 0x80) != 0;
        this.initialize();
    }
}

