/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.cluster.node.impl;

import com.gigaspaces.internal.cluster.node.IReplicationInBatchContext;
import com.gigaspaces.internal.cluster.node.impl.ReplicationInContext;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Logger;

public abstract class AbstractReplicationInBatchContext
extends ReplicationInContext
implements IReplicationInBatchContext {
    private final LinkedList<Object> _batchContext = new LinkedList();
    private final int _entireBatchSize;
    private long _lastUnprocessedKeyInBatch;
    private long _currentKey;
    private Object _tagObject;
    private int _snapshotBatchContextSize;
    private long _snapshotLastUnprocessedKeyInBatch;

    public AbstractReplicationInBatchContext(Logger contextLogger, int entireBatchSize, String sourceLookupName, String groupName, boolean supportDistTransactionConsolidation) {
        super(sourceLookupName, groupName, contextLogger, false, supportDistTransactionConsolidation);
        this._entireBatchSize = entireBatchSize;
    }

    @Override
    public void pendingConsumed() {
        if (this._batchContext.isEmpty()) {
            throw new IllegalStateException("No pending operation to consume");
        }
        this._batchContext.clear();
        this.afterBatchConsumed(this._lastUnprocessedKeyInBatch);
    }

    @Override
    public <T> void addPendingContext(T operationContext) {
        this._batchContext.add(operationContext);
        this._lastUnprocessedKeyInBatch = this._currentKey;
    }

    @Override
    public <T> List<T> getPendingContext() {
        return this._batchContext;
    }

    public void setCurrentKey(long currentKey) {
        this._currentKey = currentKey;
    }

    @Override
    public void currentConsumed() {
        this._lastUnprocessedKeyInBatch = this._currentKey;
        this.afterBatchConsumed(this._lastUnprocessedKeyInBatch);
    }

    protected abstract void afterBatchConsumed(long var1);

    @Override
    public <T> void setTagObject(T tagObject) {
        this._tagObject = tagObject;
    }

    @Override
    public <T> T getTagObject() {
        return (T)this._tagObject;
    }

    @Override
    public int getEntireBatchSize() {
        return this._entireBatchSize;
    }

    public long getCurrentKey() {
        return this._currentKey;
    }

    public void snapshot() {
        this._snapshotBatchContextSize = this._batchContext.size();
        this._snapshotLastUnprocessedKeyInBatch = this._lastUnprocessedKeyInBatch;
    }

    public void rollback() {
        int index = 0;
        Iterator iterator = this._batchContext.iterator();
        while (iterator.hasNext()) {
            iterator.next();
            if (index++ < this._snapshotBatchContextSize) continue;
            iterator.remove();
        }
        this._lastUnprocessedKeyInBatch = this._snapshotLastUnprocessedKeyInBatch;
    }

    @Override
    public boolean isBatchContext() {
        return true;
    }
}

