/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.cluster.node.impl;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.utils.StringUtils;
import com.gigaspaces.time.SystemTime;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedList;
import java.util.ListIterator;

@InternalApi
public class EventsTracer<T> {
    private static final SimpleDateFormat SIMPLE_DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss,SSS");
    private final Event<T>[] _events;
    private final int _length;
    private int _lastEventIndex = -1;

    public EventsTracer(int length) {
        this._length = length;
        this._events = new Event[length];
    }

    public synchronized void logEvent(T event) {
        this._lastEventIndex = (this._lastEventIndex + 1) % this._length;
        this._events[this._lastEventIndex] = new Event<T>(event, SystemTime.timeMillis());
    }

    public synchronized Event<T> getLastEvent() {
        if (this._lastEventIndex == -1) {
            return null;
        }
        return this._events[this._lastEventIndex];
    }

    public synchronized Iterable<Event<T>> getAccesendingEvents() {
        LinkedList<Event<T>> descendingEventsList = this.createDescendingEventsList();
        LinkedList<Event<T>> result = new LinkedList<Event<T>>();
        ListIterator<Event<T>> listIterator = descendingEventsList.listIterator(descendingEventsList.size());
        while (listIterator.hasPrevious()) {
            result.add(listIterator.previous());
        }
        return result;
    }

    public synchronized Iterable<Event<T>> getDescendingEvents() {
        return this.createDescendingEventsList();
    }

    public String outputDescendingEvents() {
        StringBuilder sb = new StringBuilder();
        sb.append("------------------");
        sb.append(StringUtils.NEW_LINE);
        Iterable<Event<T>> descendingEvents = this.getDescendingEvents();
        for (Event<T> event : descendingEvents) {
            sb.append(event);
            sb.append(StringUtils.NEW_LINE);
            sb.append("------------------");
            sb.append(StringUtils.NEW_LINE);
        }
        return sb.toString();
    }

    private LinkedList<Event<T>> createDescendingEventsList() {
        int positionWithoutOffset;
        int index;
        Event<T> event;
        LinkedList<Event<T>> result = new LinkedList<Event<T>>();
        for (int i = 0; i < this._length && (event = this._events[index = (positionWithoutOffset = this._lastEventIndex - i) < 0 ? positionWithoutOffset + this._length : positionWithoutOffset]) != null; ++i) {
            result.add(event);
        }
        return result;
    }

    public static void main(String[] args) {
        EventsTracer<Integer> tracer = new EventsTracer<Integer>(3);
        System.out.println("\n" + tracer.getLastEvent());
        Iterable accesendingEvents = tracer.getAccesendingEvents();
        System.out.println("ascending 1");
        for (Event integer : accesendingEvents) {
            System.out.println(integer);
        }
        Iterable descendingEvents = tracer.getDescendingEvents();
        System.out.println("descendingEvents 1");
        for (Event integer : descendingEvents) {
            System.out.println(integer);
        }
        tracer.logEvent(1);
        System.out.println("\n" + tracer.getLastEvent());
        accesendingEvents = tracer.getAccesendingEvents();
        System.out.println("ascending 2");
        for (Event integer : accesendingEvents) {
            System.out.println(integer);
        }
        descendingEvents = tracer.getDescendingEvents();
        System.out.println("descendingEvents 2");
        for (Event integer : descendingEvents) {
            System.out.println(integer);
        }
        tracer.logEvent(2);
        System.out.println("\n" + tracer.getLastEvent());
        accesendingEvents = tracer.getAccesendingEvents();
        System.out.println("ascending 3");
        for (Event integer : accesendingEvents) {
            System.out.println(integer);
        }
        descendingEvents = tracer.getDescendingEvents();
        System.out.println("descendingEvents 3");
        for (Event integer : descendingEvents) {
            System.out.println(integer);
        }
        tracer.logEvent(3);
        System.out.println("\n" + tracer.getLastEvent());
        accesendingEvents = tracer.getAccesendingEvents();
        System.out.println("ascending 3");
        for (Event integer : accesendingEvents) {
            System.out.println(integer);
        }
        descendingEvents = tracer.getDescendingEvents();
        System.out.println("descendingEvents 3");
        for (Event integer : descendingEvents) {
            System.out.println(integer);
        }
        tracer.logEvent(4);
        System.out.println("\n" + tracer.getLastEvent());
        accesendingEvents = tracer.getAccesendingEvents();
        System.out.println("ascending 3");
        for (Event integer : accesendingEvents) {
            System.out.println(integer);
        }
        descendingEvents = tracer.getDescendingEvents();
        System.out.println("descendingEvents 3");
        for (Event integer : descendingEvents) {
            System.out.println(integer);
        }
    }

    public static class Event<T> {
        private final T _event;
        private final long _timeStamp;

        public Event(T event, long timeStamp) {
            this._event = event;
            this._timeStamp = timeStamp;
        }

        public T getEvent() {
            return this._event;
        }

        public long getTimeStamp() {
            return this._timeStamp;
        }

        public String toString() {
            return SIMPLE_DATE_FORMAT.format(new Date(this._timeStamp)) + ":" + StringUtils.NEW_LINE + this._event;
        }
    }
}

