/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.cluster.node.impl;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.cluster.node.replica.ISpaceCopyResult;
import com.gigaspaces.internal.cluster.node.replica.ISpaceSynchronizeReplicaState;
import com.gigaspaces.internal.cluster.node.replica.ISpaceSynchronizeResult;
import com.gigaspaces.internal.cluster.node.replica.SpaceReplicaStage;
import com.j_spaces.core.SpaceCopyStatus;
import com.j_spaces.core.SpaceCopyStatusImpl;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

@InternalApi
public class FailedSyncSpaceReplicateState
implements ISpaceSynchronizeReplicaState,
ISpaceCopyResult,
ISpaceSynchronizeResult {
    private final Exception _failureReason;

    public static ISpaceSynchronizeReplicaState createFailedSyncState(Exception failureReason) {
        return new FailedSyncSpaceReplicateState(failureReason);
    }

    private FailedSyncSpaceReplicateState(Exception failureReason) {
        this._failureReason = failureReason;
    }

    @Override
    public boolean isDone() {
        return true;
    }

    @Override
    public SpaceReplicaStage getStage() {
        return SpaceReplicaStage.COPY;
    }

    @Override
    public ISpaceCopyResult waitForCopyResult() throws InterruptedException {
        return this;
    }

    @Override
    public ISpaceCopyResult waitForCopyResult(long time, TimeUnit unit) throws InterruptedException, TimeoutException {
        return this;
    }

    @Override
    public ISpaceSynchronizeResult getSynchronizeResult() {
        return this;
    }

    @Override
    public ISpaceSynchronizeResult waitForSynchronizeCompletion() throws InterruptedException {
        return this;
    }

    @Override
    public ISpaceSynchronizeResult waitForSynchronizeCompletion(long time, TimeUnit unit) throws InterruptedException, TimeoutException {
        return this;
    }

    @Override
    public Exception getFailureReason() {
        return this._failureReason;
    }

    @Override
    public boolean isFailed() {
        return true;
    }

    @Override
    public boolean isSuccessful() {
        return false;
    }

    @Override
    public ISpaceCopyResult getCopyResult() {
        return this;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public void abort(long timeout, TimeUnit units) {
    }

    @Override
    public SpaceCopyStatus toOldResult(short operationType, String targetMember) {
        SpaceCopyStatusImpl result = new SpaceCopyStatusImpl(operationType, targetMember);
        result.setCauseException(this.getFailureReason());
        return result;
    }

    @Override
    public String getStringDescription(String remoteSpaceMember, String remoteMemberUrl, String spaceName, boolean spaceSyncOperation, long duration) {
        String operationType = spaceSyncOperation ? "recover" : "copy data";
        return "Failed to " + operationType + " from space [" + remoteMemberUrl + "]";
    }
}

