/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.cluster.node.impl;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.cluster.node.IReplicationInContext;
import com.gigaspaces.internal.cluster.node.ReplicationBlobstoreBulkContext;
import com.gigaspaces.internal.cluster.node.ReplicationInContentContext;
import com.gigaspaces.internal.cluster.node.impl.backlog.sync.IMarker;
import com.gigaspaces.internal.cluster.node.impl.groups.reliableasync.IReplicationReliableAsyncMediator;
import com.gigaspaces.internal.cluster.node.impl.packets.IReplicationOrderedPacket;
import java.util.logging.Logger;

@InternalApi
public class ReplicationInContext
implements IReplicationInContext {
    private final String _sourceLookupName;
    private final Logger _contextLogger;
    private final String _groupName;
    private final ReplicationInContentContext _contentContext;
    private final IReplicationReliableAsyncMediator _reliableAsyncMediator;
    private final boolean _supportDistTransactionConsolidation;
    private IReplicationOrderedPacket _packet;
    private ReplicationBlobstoreBulkContext _replicationBlobstoreBulkContext;
    private long _lastProcessedKey;

    public ReplicationInContext(String sourceLookupName, String groupName, Logger specificLogger, boolean hasContentContext, boolean supportDistTransactionConsolidation) {
        this(sourceLookupName, groupName, specificLogger, hasContentContext, supportDistTransactionConsolidation, null);
    }

    public ReplicationInContext(String sourceLookupName, String groupName, Logger specificLogger, boolean hasContentContext, boolean supportDistTransactionConsolidation, IReplicationReliableAsyncMediator reliableAsyncMediator) {
        this._sourceLookupName = sourceLookupName;
        this._groupName = groupName;
        this._contextLogger = specificLogger;
        this._reliableAsyncMediator = reliableAsyncMediator;
        this._supportDistTransactionConsolidation = supportDistTransactionConsolidation;
        this._contentContext = hasContentContext ? new ReplicationInContentContext() : null;
    }

    @Override
    public String getSourceLookupName() {
        return this._sourceLookupName;
    }

    @Override
    public Logger getContextLogger() {
        return this._contextLogger;
    }

    @Override
    public String getGroupName() {
        return this._groupName;
    }

    @Override
    public ReplicationInContentContext getContentContext() {
        return this._contentContext;
    }

    @Override
    public boolean isBatchContext() {
        return false;
    }

    @Override
    public IMarker getContextMarker(String membersGroupName) {
        if (this._reliableAsyncMediator == null) {
            throw new UnsupportedOperationException();
        }
        if (this._packet == null) {
            throw new IllegalStateException("Cannot get a context marker when there is no context packet set");
        }
        return this._reliableAsyncMediator.getMarker(this._packet, membersGroupName);
    }

    public void setContextPacket(IReplicationOrderedPacket packet) {
        this._packet = packet;
    }

    @Override
    public boolean supportsDistributedTransactionConsolidation() {
        return this._supportDistTransactionConsolidation;
    }

    @Override
    public void setReplicationBlobstoreBulkContext(ReplicationBlobstoreBulkContext replicationBlobstoreBulkContext) {
        this._replicationBlobstoreBulkContext = replicationBlobstoreBulkContext;
    }

    @Override
    public ReplicationBlobstoreBulkContext getReplicationBlobstoreBulkContext() {
        return this._replicationBlobstoreBulkContext;
    }

    @Override
    public long getLastProcessedKey() {
        return this._lastProcessedKey;
    }

    public void setLastProcessedKey(long lastProcessedKey) {
        this._lastProcessedKey = lastProcessedKey;
    }
}

