/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.cluster.node.impl;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.cluster.node.impl.groups.sync.ISyncReplicationGroupOutContext;
import com.gigaspaces.internal.cluster.node.impl.packets.IReplicationOrderedPacket;
import com.gigaspaces.internal.extension.XapExtensions;
import com.gigaspaces.internal.utils.StringUtils;
import java.util.List;
import java.util.logging.Logger;

@InternalApi
public class ReplicationLogUtils {
    public static String toShortLookupName(String lookupName) {
        return XapExtensions.getInstance().getReplicationUtils().toShortLookupName(lookupName);
    }

    public static String packetsToLogString(List<IReplicationOrderedPacket> packets) {
        StringBuilder result = new StringBuilder();
        for (IReplicationOrderedPacket packet : packets) {
            result.append(packet);
            result.append(", ");
        }
        if (packets.isEmpty()) {
            result.append("NONE");
        } else {
            result.setLength(result.length() - 2);
        }
        return result.toString();
    }

    public static String packetsToLogString(ISyncReplicationGroupOutContext context) {
        if (context.isSinglePacket()) {
            return context.getSinglePacket().toString();
        }
        return ReplicationLogUtils.packetsToLogString(context.getOrderedPackets());
    }

    public static Logger createOutgoingChannelSpecificLogger(String myLookupName, String targetLookupName, String groupName) {
        return Logger.getLogger("com.gigaspaces.replication.channel.out." + ReplicationLogUtils.toShortLookupName(myLookupName) + "." + ReplicationLogUtils.toShortGroupName(groupName) + "." + ReplicationLogUtils.toShortLookupName(targetLookupName));
    }

    public static Logger createIncomingChannelSpecificLogger(String myLookupName, String targetLookupName, String groupName) {
        return Logger.getLogger("com.gigaspaces.replication.channel.in." + ReplicationLogUtils.toShortLookupName(myLookupName) + "." + ReplicationLogUtils.toShortGroupName(groupName) + "." + ReplicationLogUtils.toShortLookupName(targetLookupName));
    }

    public static Logger createChannelSpecificLogger(String myLookupName, String targetLookupName, String groupName) {
        return Logger.getLogger("com.gigaspaces.replication.channel." + ReplicationLogUtils.toShortLookupName(myLookupName) + "." + ReplicationLogUtils.toShortGroupName(groupName) + "." + ReplicationLogUtils.toShortLookupName(targetLookupName));
    }

    public static Logger createChannelSpecificVerboseLogger(String myLookupName, String targetLookupName, String groupName) {
        return Logger.getLogger("com.gigaspaces.replication.channel.verbose." + ReplicationLogUtils.toShortLookupName(myLookupName) + "." + ReplicationLogUtils.toShortGroupName(groupName) + "." + ReplicationLogUtils.toShortLookupName(targetLookupName));
    }

    public static String toShortGroupName(String groupName) {
        if (!StringUtils.hasText(groupName)) {
            return groupName;
        }
        if (!groupName.contains(":")) {
            return groupName;
        }
        return groupName.substring(groupName.lastIndexOf(":") + 1);
    }
}

