/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.cluster.node.impl;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.cluster.replication.IRedoLogStatistics;
import com.gigaspaces.cluster.replication.IncomingReplicationOutOfSyncException;
import com.gigaspaces.cluster.replication.RedoLogStatistics;
import com.gigaspaces.internal.cluster.node.IReplicationNode;
import com.gigaspaces.internal.cluster.node.IReplicationNodeAdmin;
import com.gigaspaces.internal.cluster.node.IReplicationNodeStateListener;
import com.gigaspaces.internal.cluster.node.IReplicationOutContext;
import com.gigaspaces.internal.cluster.node.handlers.IReplicationInBatchConsumptionHandler;
import com.gigaspaces.internal.cluster.node.handlers.IReplicationInDataTypeCreatedHandler;
import com.gigaspaces.internal.cluster.node.handlers.IReplicationInDataTypeIndexAddedHandler;
import com.gigaspaces.internal.cluster.node.handlers.IReplicationInEntryHandler;
import com.gigaspaces.internal.cluster.node.handlers.IReplicationInEntryLeaseCancelledHandler;
import com.gigaspaces.internal.cluster.node.handlers.IReplicationInEntryLeaseExpiredHandler;
import com.gigaspaces.internal.cluster.node.handlers.IReplicationInEntryLeaseExtendedHandler;
import com.gigaspaces.internal.cluster.node.handlers.IReplicationInEvictEntryHandler;
import com.gigaspaces.internal.cluster.node.handlers.IReplicationInNotificationSentHandler;
import com.gigaspaces.internal.cluster.node.handlers.IReplicationInNotifyTemplateCreatedHandler;
import com.gigaspaces.internal.cluster.node.handlers.IReplicationInNotifyTemplateLeaseExpiredHandler;
import com.gigaspaces.internal.cluster.node.handlers.IReplicationInNotifyTemplateLeaseExtendedHandler;
import com.gigaspaces.internal.cluster.node.handlers.IReplicationInNotifyTemplateRemovedHandler;
import com.gigaspaces.internal.cluster.node.handlers.IReplicationInTransactionHandler;
import com.gigaspaces.internal.cluster.node.impl.FailedSyncSpaceReplicateState;
import com.gigaspaces.internal.cluster.node.impl.GroupMapping;
import com.gigaspaces.internal.cluster.node.impl.IIncomingReplicationFacade;
import com.gigaspaces.internal.cluster.node.impl.IReplicationNodeBuilder;
import com.gigaspaces.internal.cluster.node.impl.IReplicationNodePluginFacade;
import com.gigaspaces.internal.cluster.node.impl.NotificationSentSyncOperation;
import com.gigaspaces.internal.cluster.node.impl.ReplicationMultipleOperationType;
import com.gigaspaces.internal.cluster.node.impl.ReplicationNodeAdmin;
import com.gigaspaces.internal.cluster.node.impl.ReplicationNodeInFacade;
import com.gigaspaces.internal.cluster.node.impl.ReplicationOutContext;
import com.gigaspaces.internal.cluster.node.impl.ReplicationSingleOperationType;
import com.gigaspaces.internal.cluster.node.impl.backlog.IBacklogMemberState;
import com.gigaspaces.internal.cluster.node.impl.backlog.IReplicationGroupBacklog;
import com.gigaspaces.internal.cluster.node.impl.backlog.OperationWeightInfo;
import com.gigaspaces.internal.cluster.node.impl.config.ReplicationNodeConfig;
import com.gigaspaces.internal.cluster.node.impl.config.ReplicationNodeMode;
import com.gigaspaces.internal.cluster.node.impl.directPersistency.DirectPersistencyBackupSyncIteratorHandler;
import com.gigaspaces.internal.cluster.node.impl.directPersistency.IDirectPersistencySyncHandler;
import com.gigaspaces.internal.cluster.node.impl.filters.IReplicationInFilter;
import com.gigaspaces.internal.cluster.node.impl.filters.IReplicationOutFilter;
import com.gigaspaces.internal.cluster.node.impl.groups.BrokenReplicationTopologyException;
import com.gigaspaces.internal.cluster.node.impl.groups.IReplicationDynamicTargetGroupBuilder;
import com.gigaspaces.internal.cluster.node.impl.groups.IReplicationGroupOutContext;
import com.gigaspaces.internal.cluster.node.impl.groups.IReplicationSourceGroup;
import com.gigaspaces.internal.cluster.node.impl.groups.IReplicationSourceGroupBuilder;
import com.gigaspaces.internal.cluster.node.impl.groups.IReplicationSourceGroupStateListener;
import com.gigaspaces.internal.cluster.node.impl.groups.IReplicationStaticTargetGroupBuilder;
import com.gigaspaces.internal.cluster.node.impl.groups.IReplicationTargetGroup;
import com.gigaspaces.internal.cluster.node.impl.groups.IReplicationTargetGroupStateListener;
import com.gigaspaces.internal.cluster.node.impl.groups.ISpaceItemGroupsExtractor;
import com.gigaspaces.internal.cluster.node.impl.groups.NoSuchReplicationGroupExistException;
import com.gigaspaces.internal.cluster.node.impl.groups.ReplicationNodeGroupsHolder;
import com.gigaspaces.internal.cluster.node.impl.packets.ReplicaRequestPacket;
import com.gigaspaces.internal.cluster.node.impl.processlog.DefaultProcessLogExceptionHandlerBuilder;
import com.gigaspaces.internal.cluster.node.impl.processlog.IReplicationProcessLogExceptionHandlerBuilder;
import com.gigaspaces.internal.cluster.node.impl.replica.CurrentStageInfo;
import com.gigaspaces.internal.cluster.node.impl.replica.ISpaceReplicaData;
import com.gigaspaces.internal.cluster.node.impl.replica.ISpaceReplicaDataConsumer;
import com.gigaspaces.internal.cluster.node.impl.replica.ReplicationNodeReplicaHandler;
import com.gigaspaces.internal.cluster.node.impl.replica.SpaceCopyIntermediateResult;
import com.gigaspaces.internal.cluster.node.impl.replica.SpaceCopyReplicaRequestContext;
import com.gigaspaces.internal.cluster.node.impl.replica.SpaceCopyReplicaRunnable;
import com.gigaspaces.internal.cluster.node.impl.replica.SpaceReplicaState;
import com.gigaspaces.internal.cluster.node.impl.replica.SpaceSynchronizeReplicaRequestContext;
import com.gigaspaces.internal.cluster.node.impl.router.AbstractReplicationPacket;
import com.gigaspaces.internal.cluster.node.impl.router.ConnectionState;
import com.gigaspaces.internal.cluster.node.impl.router.IIncomingReplicationHandler;
import com.gigaspaces.internal.cluster.node.impl.router.IReplicationMonitoredConnection;
import com.gigaspaces.internal.cluster.node.impl.router.IReplicationRouter;
import com.gigaspaces.internal.cluster.node.impl.router.IReplicationRouterAdmin;
import com.gigaspaces.internal.cluster.node.impl.router.ReplicationEndpointDetails;
import com.gigaspaces.internal.cluster.node.impl.router.ReplicationRouterBuilder;
import com.gigaspaces.internal.cluster.node.impl.router.RouterStubHolder;
import com.gigaspaces.internal.cluster.node.replica.ISpaceCopyReplicaParameters;
import com.gigaspaces.internal.cluster.node.replica.ISpaceCopyReplicaRequestContext;
import com.gigaspaces.internal.cluster.node.replica.ISpaceCopyReplicaState;
import com.gigaspaces.internal.cluster.node.replica.ISpaceCopyResult;
import com.gigaspaces.internal.cluster.node.replica.ISpaceSynchronizeReplicaRequestContext;
import com.gigaspaces.internal.cluster.node.replica.ISpaceSynchronizeReplicaState;
import com.gigaspaces.internal.metadata.ITypeDesc;
import com.gigaspaces.internal.server.storage.IEntryHolder;
import com.gigaspaces.internal.server.storage.NotifyTemplateHolder;
import com.gigaspaces.internal.space.requests.AddTypeIndexesRequestInfo;
import com.gigaspaces.internal.utils.StringUtils;
import com.gigaspaces.internal.utils.concurrent.CyclicAtomicInteger;
import com.gigaspaces.internal.utils.concurrent.GSThreadFactory;
import com.gigaspaces.internal.utils.concurrent.IAsyncHandlerProvider;
import com.gigaspaces.internal.utils.threadlocal.PoolFactory;
import com.gigaspaces.internal.utils.threadlocal.ThreadLocalPool;
import com.gigaspaces.metrics.MetricRegistrator;
import com.gigaspaces.time.SystemTime;
import com.j_spaces.core.OperationID;
import com.j_spaces.core.cache.blobStore.BlobStoreReplicaConsumeHelper;
import com.j_spaces.core.cache.blobStore.BlobStoreReplicationBulkConsumeHelper;
import com.j_spaces.core.exception.ClosedResourceException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jini.core.event.EventRegistration;
import net.jini.core.transaction.server.ServerTransaction;

@InternalApi
public class ReplicationNode
implements IReplicationNode,
IIncomingReplicationHandler,
IIncomingReplicationFacade,
IReplicationTargetGroupStateListener,
IReplicationSourceGroupStateListener {
    private static final Logger _logger = Logger.getLogger("com.gigaspaces.replication.node");
    private static final Logger _loggerReplica = Logger.getLogger("com.gigaspaces.replication.replica");
    private final ReplicationNodeConfig _replicationNodeConfig;
    private final IReplicationNodeBuilder _nodeBuilder;
    private final IReplicationNodeAdmin _replicationNodeAdmin;
    private final Map<String, GroupMapping> _groupsMapping;
    private final IReplicationRouter _replicationRouter;
    private final ISpaceItemGroupsExtractor _spaceItemGroupsExtractor;
    private final IAsyncHandlerProvider _asyncHandlerProvider;
    private final ISpaceReplicaDataConsumer _replicaDataConsumer;
    private final IReplicationOutFilter _replicationOutFilter;
    private final IReplicationInFilter _replicationInFilter;
    private final ReplicationNodeReplicaHandler _replicaHandler;
    private final ReplicationNodeGroupsHolder _groupsHolder;
    private final ReplicationNodeInFacade _inFacade;
    private final IReplicationNodePluginFacade _pluginFacade;
    private final IReplicationProcessLogExceptionHandlerBuilder _exceptionHandlerBuilder;
    private final ScheduledExecutorService _statisticsMonitor;
    private final String _name;
    private final MetricRegistrator metricRegister;
    private final ThreadLocalPool<ReplicationOutContext> _contextPool = new ThreadLocalPool<ReplicationOutContext>(new PoolFactory<ReplicationOutContext>(){

        @Override
        public ReplicationOutContext create() {
            return new ReplicationOutContext();
        }
    });
    private volatile IReplicationNodeStateListener _stateListener;
    private volatile boolean _closed;
    private volatile ReplicationNodeMode _nodeMode;
    private BlobStoreReplicaConsumeHelper _blobStoreReplicaConsumeHelper;
    private volatile IDirectPersistencySyncHandler _directPesistencySyncHandler;
    private BlobStoreReplicationBulkConsumeHelper _blobStoreReplicationBulkConsumeHelper;

    public ReplicationNode(ReplicationNodeConfig replicationNodeConfig, IReplicationNodeBuilder nodeBuilder, String name, MetricRegistrator metricRegister) {
        this._replicationNodeConfig = replicationNodeConfig;
        this._nodeBuilder = nodeBuilder;
        this._name = name;
        this.metricRegister = metricRegister.extend("replication");
        if (_logger.isLoggable(Level.CONFIG)) {
            _logger.config(this.getLogPrefix() + "creating replication node with config:" + StringUtils.NEW_LINE + replicationNodeConfig + StringUtils.NEW_LINE + "builder:" + StringUtils.NEW_LINE + this._nodeBuilder);
        }
        this._replicationNodeAdmin = new ReplicationNodeAdmin(this);
        this._replicationRouter = this._nodeBuilder.createReplicationRouter(this);
        this._spaceItemGroupsExtractor = this._nodeBuilder.createSpaceItemGroupsExtractor();
        this._asyncHandlerProvider = this._nodeBuilder.getAsyncHandlerProvider();
        this._replicaDataConsumer = this._nodeBuilder.createReplicaDataConsumer();
        this._directPesistencySyncHandler = this._nodeBuilder.createDirectPersistencySyncHandler();
        this._replicationOutFilter = this._replicationNodeConfig.getReplicationOutFilter();
        this._replicationInFilter = this._replicationNodeConfig.getReplicationInFilter();
        this._groupsMapping = this._replicationNodeConfig.getSourceGroupsMapping();
        this._pluginFacade = this._replicationNodeConfig.getPluginFacade();
        this._replicaHandler = new ReplicationNodeReplicaHandler(this, this._nodeBuilder.createReplicaDataGenerator(), this._replicationNodeConfig.getSpaceCopyReplicaOutFilter());
        this._groupsHolder = new ReplicationNodeGroupsHolder();
        this._inFacade = new ReplicationNodeInFacade(this._groupsHolder);
        this._exceptionHandlerBuilder = new DefaultProcessLogExceptionHandlerBuilder();
        this._statisticsMonitor = new ScheduledThreadPoolExecutor(1, (ThreadFactory)new GSThreadFactory("StatisticsMonitor", true));
        this.createSourceGroups(ReplicationNodeMode.ALWAYS);
        this.createTargetGroups(ReplicationNodeMode.ALWAYS);
        this._statisticsMonitor.scheduleAtFixedRate(new StatisticsMonitor(), 3L, 3L, TimeUnit.SECONDS);
    }

    public String getName() {
        return this._name;
    }

    public Object getUniqueId() {
        return this._replicationRouter.getMyUniqueId();
    }

    @Override
    public IReplicationOutContext createContext() {
        return this._contextPool.get();
    }

    @Override
    public int execute(IReplicationOutContext context) {
        this.validateNotClose();
        ReplicationOutContext replicationContext = (ReplicationOutContext)context;
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.finest(this.getLogPrefix() + "executing replication context " + context);
        }
        if (replicationContext.isEmpty()) {
            return 0;
        }
        if (replicationContext.isSingleGroupParticipant()) {
            IReplicationGroupOutContext groupOutContext = replicationContext.getSingleGroupParticipantContext();
            if (context.isBlobstorePendingReplicationBulk() && groupOutContext == null) {
                return 0;
            }
            return this._groupsHolder.getSourceGroup(groupOutContext.getName()).execute(groupOutContext);
        }
        int res = 0;
        for (IReplicationGroupOutContext groupOutContext : replicationContext) {
            if (context.isBlobstorePendingReplicationBulk() && groupOutContext == null) continue;
            res += this._groupsHolder.getSourceGroup(groupOutContext.getName()).execute(groupOutContext);
        }
        return res;
    }

    public ReplicationRouterBuilder getReplicationRouterBuilder() {
        return this._nodeBuilder.getReplicationRouterBuilder();
    }

    public IReplicationRouter getReplicationRouter() {
        return this._replicationRouter;
    }

    @Override
    public IReplicationNodeAdmin getAdmin() {
        return this._replicationNodeAdmin;
    }

    @Override
    public void outCancelEntryLease(IReplicationOutContext context, IEntryHolder entryHolder) {
        ReplicationSingleOperationType operationType = ReplicationSingleOperationType.CANCEL_LEASE;
        this.routeBeforeReplicate(context, entryHolder, operationType);
    }

    @Override
    public void outEntryLeaseExpired(IReplicationOutContext context, IEntryHolder entryHolder) {
        ReplicationSingleOperationType operationType = ReplicationSingleOperationType.ENTRY_LEASE_EXPIRED;
        this.routeBeforeReplicate(context, entryHolder, operationType);
    }

    @Override
    public void outNotifyTemplateLeaseExpired(IReplicationOutContext context, NotifyTemplateHolder templateHolder) {
        ReplicationSingleOperationType operationType = ReplicationSingleOperationType.NOTIFY_TEMPLATE_LEASE_EXPIRED;
        this.routeBeforeReplicate(context, templateHolder, operationType);
    }

    @Override
    public void outEvictEntry(IReplicationOutContext context, IEntryHolder entryHolder) {
        ReplicationSingleOperationType operationType = ReplicationSingleOperationType.EVICT;
        this.routeBeforeReplicate(context, entryHolder, operationType);
    }

    @Override
    public void outExtendEntryLeasePeriod(IReplicationOutContext context, IEntryHolder entryHolder) {
        ReplicationSingleOperationType operationType = ReplicationSingleOperationType.EXTEND_ENTRY_LEASE;
        this.routeBeforeReplicate(context, entryHolder, operationType);
    }

    @Override
    public void outExtendNotifyTemplateLeasePeriod(IReplicationOutContext context, NotifyTemplateHolder entryHolder) {
        ReplicationSingleOperationType operationType = ReplicationSingleOperationType.EXTEND_NOTIFY_TEMPLATE_LEASE;
        this.routeBeforeReplicate(context, entryHolder, operationType);
    }

    @Override
    public void outInsertNotifyTemplate(IReplicationOutContext context, NotifyTemplateHolder templateHolder) {
        ReplicationSingleOperationType operationType = ReplicationSingleOperationType.INSERT_NOTIFY_TEMPLATE;
        this.routeBeforeReplicate(context, templateHolder, operationType);
    }

    @Override
    public void outNotificationSentAndExecute(OperationID operationId) {
        this.validateNotClose();
        NotificationSentSyncOperation operation = new NotificationSentSyncOperation(operationId);
        for (IReplicationSourceGroup sourceGroup : this._groupsHolder.getSourceGroups()) {
            sourceGroup.execute(operation);
        }
    }

    @Override
    public void outRemoveEntry(IReplicationOutContext context, IEntryHolder entryHolder) {
        ReplicationSingleOperationType operationType = ReplicationSingleOperationType.REMOVE_ENTRY;
        this.routeBeforeReplicate(context, entryHolder, operationType);
    }

    @Override
    public void outRemoveNotifyTemplate(IReplicationOutContext context, NotifyTemplateHolder templateHolder) {
        ReplicationSingleOperationType operationType = ReplicationSingleOperationType.REMOVE_NOTIFY_TEMPLATE;
        this.routeBeforeReplicate(context, templateHolder, operationType);
    }

    @Override
    public void outTransaction(IReplicationOutContext context, ServerTransaction transaction, ArrayList<IEntryHolder> lockedEntries) {
        ReplicationMultipleOperationType operationType = ReplicationMultipleOperationType.TRANSACTION_ONE_PHASE;
        this.routeBeforeTransactionExecute(context, transaction, lockedEntries, operationType);
    }

    @Override
    public void outTransactionCommit(IReplicationOutContext context, ServerTransaction transaction) {
        ReplicationMultipleOperationType operationType = ReplicationMultipleOperationType.TRANSACTION_TWO_PHASE_COMMIT;
        this.routeBeforeTransactionExecute(context, transaction, null, operationType);
    }

    @Override
    public void outTransactionAbort(IReplicationOutContext context, ServerTransaction transaction) {
        ReplicationMultipleOperationType operationType = ReplicationMultipleOperationType.TRANSACTION_TWO_PHASE_ABORT;
        this.routeBeforeTransactionExecute(context, transaction, null, operationType);
    }

    @Override
    public void outTransactionPrepare(IReplicationOutContext context, ServerTransaction transaction, ArrayList<IEntryHolder> lockedEntries) {
        ReplicationMultipleOperationType operationType = ReplicationMultipleOperationType.TRANSACTION_TWO_PHASE_PREPARE;
        this.routeBeforeTransactionExecute(context, transaction, lockedEntries, operationType);
    }

    private void routeBeforeTransactionExecute(IReplicationOutContext context, ServerTransaction transaction, ArrayList<IEntryHolder> lockedEntries, ReplicationMultipleOperationType operationType) {
        ReplicationOutContext replicationContext = (ReplicationOutContext)context;
        GroupMapping groupMapping = GroupMapping.getAllMapping();
        replicationContext.setGroupMapping(groupMapping);
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.finest(this.getLogPrefix() + "before replicate of operation " + (Object)((Object)operationType) + " and entries " + lockedEntries + " routed to " + groupMapping + " groups");
        }
        for (IReplicationSourceGroup sourceGroup : this._groupsHolder.getSourceGroups()) {
            sourceGroup.beforeTransactionExecute(replicationContext, transaction, lockedEntries, operationType);
        }
    }

    @Override
    public void outUpdateEntry(IReplicationOutContext context, IEntryHolder entryHolder) {
        ReplicationSingleOperationType operationType = ReplicationSingleOperationType.UPDATE;
        this.routeBeforeReplicate(context, entryHolder, operationType);
    }

    @Override
    public void outChangeEntry(IReplicationOutContext context, IEntryHolder entryHolder) {
        ReplicationSingleOperationType operationType = ReplicationSingleOperationType.CHANGE;
        this.routeBeforeReplicate(context, entryHolder, operationType);
    }

    @Override
    public void outWriteEntry(IReplicationOutContext context, IEntryHolder entryHolder) {
        ReplicationSingleOperationType operationType = ReplicationSingleOperationType.WRITE;
        this.routeBeforeReplicate(context, entryHolder, operationType);
    }

    @Override
    public void outDataTypeIntroduce(IReplicationOutContext context, ITypeDesc typeDescriptor) {
        ReplicationOutContext replicationContext = (ReplicationOutContext)context;
        replicationContext.setGroupMapping(GroupMapping.getAllMapping());
        for (IReplicationSourceGroup sourceGroup : this._groupsHolder.getSourceGroups()) {
            sourceGroup.beforeExecuteGeneric(replicationContext, typeDescriptor, ReplicationSingleOperationType.DATA_TYPE_INTRODUCE);
        }
    }

    @Override
    public void outDataTypeAddIndex(IReplicationOutContext context, AddTypeIndexesRequestInfo addIndexesRequest) {
        ReplicationOutContext replicationContext = (ReplicationOutContext)context;
        replicationContext.setGroupMapping(GroupMapping.getAllMapping());
        for (IReplicationSourceGroup sourceGroup : this._groupsHolder.getSourceGroups()) {
            sourceGroup.beforeExecuteGeneric(replicationContext, addIndexesRequest, ReplicationSingleOperationType.DATA_TYPE_ADD_INDEX);
        }
    }

    @Override
    public void setInEvictEntryHandler(IReplicationInEvictEntryHandler handler) {
        this._inFacade.setInEvictEntryHandler(handler);
    }

    @Override
    public void setInNotificationSentHandler(IReplicationInNotificationSentHandler handler) {
        this._inFacade.setInNotificationSentHandler(handler);
    }

    @Override
    public void setInTransactionHandler(IReplicationInTransactionHandler handler) {
        this._inFacade.setInTransactionHandler(handler);
    }

    @Override
    public void setInEntryHandler(IReplicationInEntryHandler handler) {
        this._inFacade.setInEntryHandler(handler);
    }

    @Override
    public void setInEntryLeaseCancelledHandler(IReplicationInEntryLeaseCancelledHandler handler) {
        this._inFacade.setInEntryLeaseCancelledHandler(handler);
    }

    @Override
    public void setInEntryLeaseExtendedHandler(IReplicationInEntryLeaseExtendedHandler handler) {
        this._inFacade.setInEntryLeaseExtendedHandler(handler);
    }

    @Override
    public void setInEntryLeaseExpiredHandler(IReplicationInEntryLeaseExpiredHandler handler) {
        this._inFacade.setInEntryLeaseExpiredHandler(handler);
    }

    @Override
    public void setInNotifyTemplateCreatedHandler(IReplicationInNotifyTemplateCreatedHandler handler) {
        this._inFacade.setInNotifyTemplateCreatedHandler(handler);
    }

    @Override
    public void setInNotifyTemplateRemovedHandler(IReplicationInNotifyTemplateRemovedHandler handler) {
        this._inFacade.setInNotifyTemplateRemovedHandler(handler);
    }

    @Override
    public void setInNotifyTemplateLeaseExtendedHandler(IReplicationInNotifyTemplateLeaseExtendedHandler handler) {
        this._inFacade.setInNotifyTemplateLeaseExtendedHandler(handler);
    }

    @Override
    public void setInNotifyTemplateLeaseExpiredHandler(IReplicationInNotifyTemplateLeaseExpiredHandler handler) {
        this._inFacade.setInNotifyTemplateLeaseExpiredHandler(handler);
    }

    @Override
    public void setInDataTypeCreatedHandler(IReplicationInDataTypeCreatedHandler handler) {
        this._inFacade.setInDataTypeCreatedHandler(handler);
    }

    @Override
    public void setInDataTypeIndexAddedHandler(IReplicationInDataTypeIndexAddedHandler handler) {
        this._inFacade.setInDataTypeIndexAddedHandler(handler);
    }

    @Override
    public void setInBatchConsumptionHandler(IReplicationInBatchConsumptionHandler handler) {
        this._inFacade.setInBatchConsumptionHandler(handler);
    }

    @Override
    public ISpaceSynchronizeReplicaState spaceSynchronizeReplicaRequest(ISpaceSynchronizeReplicaRequestContext context) {
        SpaceSynchronizeReplicaRequestContext replicaContext = (SpaceSynchronizeReplicaRequestContext)context;
        this._replicaHandler.initFifoBatchesHandler();
        if (_loggerReplica.isLoggable(Level.FINE)) {
            _loggerReplica.fine(this.getLogPrefix() + "starting space synchronization replica process using Url " + replicaContext.getOriginUrl());
        }
        return this.doSpaceReplica(replicaContext.getOriginUrl(), replicaContext.getConcurrentConsumers(), replicaContext.getFetchBatchSize(), replicaContext.getSynchronizeGroupName(), replicaContext.getParameters(), replicaContext.getProgressTimeout());
    }

    @Override
    public ISpaceCopyReplicaState spaceCopyReplicaRequest(ISpaceCopyReplicaRequestContext context) {
        SpaceCopyReplicaRequestContext replicaContext = (SpaceCopyReplicaRequestContext)context;
        if (_loggerReplica.isLoggable(Level.FINE)) {
            _loggerReplica.fine(this.getLogPrefix() + "starting space copy replica process using Url " + replicaContext.getOriginUrl());
        }
        return this.doSpaceReplica(replicaContext.getOriginUrl(), replicaContext.getConcurrentConsumers(), replicaContext.getFetchBatchSize(), null, replicaContext.getParameters(), replicaContext.getProgressTimeout());
    }

    @Override
    public void rollbackCopyReplica(ISpaceCopyResult replicaResult) {
        if (replicaResult == null || !(replicaResult instanceof SpaceCopyIntermediateResult)) {
            return;
        }
        SpaceCopyIntermediateResult copyResult = (SpaceCopyIntermediateResult)replicaResult;
        if (copyResult.getNotifyRegistrations() != null) {
            for (EventRegistration eventReg : copyResult.getNotifyRegistrations()) {
                try {
                    eventReg.getLease().cancel();
                }
                catch (Exception exception) {}
            }
        }
    }

    @Override
    public void close() {
        if (this._closed) {
            return;
        }
        if (_logger.isLoggable(Level.FINER)) {
            _logger.finer(this.getLogPrefix() + " closing replication node");
        }
        this._replicaHandler.close();
        this._statisticsMonitor.shutdownNow();
        this._groupsHolder.close();
        this._replicationRouter.close();
        if (this._asyncHandlerProvider != null) {
            this._asyncHandlerProvider.close();
        }
        this._closed = true;
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine(this.getLogPrefix() + " replication node closed");
        }
    }

    @Override
    public void setBlobStoreReplicationBulkConsumeHelper(BlobStoreReplicationBulkConsumeHelper blobStoreReplicationBulkConsumeHelper) {
        this._blobStoreReplicationBulkConsumeHelper = blobStoreReplicationBulkConsumeHelper;
    }

    @Override
    public BlobStoreReplicationBulkConsumeHelper getBlobStoreReplicationBulkConsumeHelper() {
        return this._blobStoreReplicationBulkConsumeHelper;
    }

    private ISpaceSynchronizeReplicaState doSpaceReplica(Object originUrl, int concurrentConsumers, int fetchBatchSize, String syncGroupName, ISpaceCopyReplicaParameters parameters, long progressTimeout) {
        IReplicationMonitoredConnection originConnection = this._replicationRouter.getUrlConnection(originUrl);
        if (originConnection.getState() == ConnectionState.DISCONNECTED) {
            Exception reason = originConnection.getLastDisconnectionReason();
            originConnection.close();
            return FailedSyncSpaceReplicateState.createFailedSyncState(reason);
        }
        ReplicaRequestPacket requestPacket = new ReplicaRequestPacket(syncGroupName, parameters);
        Object replicaRemoteContext = null;
        try {
            replicaRemoteContext = originConnection.dispatch(requestPacket);
        }
        catch (Exception e) {
            originConnection.close();
            return FailedSyncSpaceReplicateState.createFailedSyncState(e);
        }
        boolean isSynchronize = syncGroupName != null;
        IReplicationTargetGroup targetGroup = null;
        if (isSynchronize) {
            targetGroup = this.getReplicationTargetGroup(syncGroupName);
        }
        SpaceReplicaState result = new SpaceReplicaState(originConnection, isSynchronize, progressTimeout, targetGroup);
        CyclicAtomicInteger orderProvider = new CyclicAtomicInteger(concurrentConsumers - 1);
        for (int i = 0; i < concurrentConsumers; ++i) {
            SpaceCopyReplicaRunnable consumer = new SpaceCopyReplicaRunnable(this, originConnection, this._replicaDataConsumer, this._replicationNodeConfig.getSpaceCopyReplicaInFilter(), replicaRemoteContext, fetchBatchSize, result, orderProvider);
            result.addReplicateConsumer(consumer);
            this._asyncHandlerProvider.start(consumer, 1L, "CopyReplicaConsumer-" + i + "-" + this.getName() + "." + originConnection.getFinalEndpointLookupName(), false);
        }
        return result;
    }

    @Override
    public <T> T onReplication(AbstractReplicationPacket<T> packet) throws RemoteException {
        try {
            this.validateNotClose();
            return packet.accept(this);
        }
        catch (ClosedResourceException e) {
            throw new RemoteException(e.getMessage(), e);
        }
    }

    private void routeBeforeReplicate(IReplicationOutContext context, IEntryHolder entryHolder, ReplicationSingleOperationType operationType) {
        ReplicationOutContext replicationContext = (ReplicationOutContext)context;
        String routing = this._spaceItemGroupsExtractor.extractGroupMapping(entryHolder);
        GroupMapping mapping = this._groupsMapping.get(routing);
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.finest(this.getLogPrefix() + "before replicate of operation " + (Object)((Object)operationType) + " and entry " + entryHolder + " routed to " + mapping + " groups");
        }
        replicationContext.setGroupMapping(mapping);
        if (mapping.hasSpecificGroups()) {
            String[] routedGroups;
            for (String routedGroup : routedGroups = mapping.getSpecificGroups()) {
                this._groupsHolder.getSourceGroup(routedGroup).beforeExecute(replicationContext, entryHolder, operationType);
            }
        } else {
            for (IReplicationSourceGroup sourceGroup : this._groupsHolder.getSourceGroups()) {
                sourceGroup.beforeExecute(replicationContext, entryHolder, operationType);
            }
        }
    }

    void createSourceGroups(ReplicationNodeMode nodeMode) {
        for (IReplicationSourceGroupBuilder builder : this._replicationNodeConfig.getSourceGroupBuilders(nodeMode)) {
            IReplicationSourceGroup group = builder.createGroup(this._replicationRouter, this._replicationOutFilter, this);
            if (_logger.isLoggable(Level.FINER)) {
                _logger.finer(this.getLogPrefix() + "created source group " + group.getGroupName());
            }
            this._groupsHolder.addSourceGroup(group, nodeMode);
        }
        this.registerMetrics(nodeMode);
    }

    private void registerMetrics(ReplicationNodeMode nodeMode) {
        this.metricRegister.clear();
        if (ReplicationNodeMode.PASSIVE != nodeMode) {
            boolean first = true;
            for (IReplicationSourceGroup replicationSourceGroup : this._groupsHolder.getSourceGroups()) {
                if (first) {
                    replicationSourceGroup.getGroupBacklog().registerWith(this.metricRegister.extend("redo-log"));
                    first = false;
                }
                replicationSourceGroup.registerWith(this.metricRegister);
            }
        }
    }

    void createTargetGroups(ReplicationNodeMode nodeMode) {
        for (IReplicationStaticTargetGroupBuilder builder : this._replicationNodeConfig.getTargetGroupBuilders(nodeMode)) {
            IReplicationTargetGroup group = builder.createStaticGroup(this._replicationRouter, this._inFacade, this._exceptionHandlerBuilder, this._replicationInFilter, this);
            if (_logger.isLoggable(Level.FINER)) {
                _logger.finer(this.getLogPrefix() + "created target group " + group.getGroupName());
            }
            this._groupsHolder.addTargetGroup(group, nodeMode);
        }
    }

    void closeSourceGroups(ReplicationNodeMode nodeMode) {
        this._groupsHolder.closeSourceGroups(nodeMode);
    }

    void closeTargetGroups(ReplicationNodeMode nodeMode) {
        this._groupsHolder.closeTargetGroups(nodeMode);
    }

    ReplicationNodeMode getNodeMode() {
        return this._nodeMode;
    }

    void setNodeMode(ReplicationNodeMode newMode) {
        this._nodeMode = newMode;
        IReplicationNodeStateListener stateListener = this._stateListener;
        if (stateListener != null) {
            stateListener.onReplicationNodeModeChange(newMode);
        }
    }

    @Override
    public IReplicationTargetGroup getReplicationTargetGroup(String groupName) throws NoSuchReplicationGroupExistException {
        try {
            return this._groupsHolder.getTargetGroup(groupName);
        }
        catch (NoSuchReplicationGroupExistException e) {
            IReplicationTargetGroup finalGroup;
            IReplicationDynamicTargetGroupBuilder matchingGroupBuilder = this._replicationNodeConfig.getMatchingTargetGroupBuilder(groupName, this.getNodeMode());
            if (matchingGroupBuilder == null) {
                throw e;
            }
            IReplicationTargetGroup dynamicGroup = matchingGroupBuilder.createDynamicGroup(groupName, this._replicationRouter, this._inFacade, this._exceptionHandlerBuilder, this._replicationInFilter, this._stateListener);
            if (dynamicGroup == (finalGroup = this._groupsHolder.addIfAbsentTargetGroup(dynamicGroup, this.getNodeMode()))) {
                if (_logger.isLoggable(Level.FINER)) {
                    _logger.finer(this.getLogPrefix() + "created dynamic target group " + dynamicGroup.getGroupName());
                }
                switch (this.getNodeMode()) {
                    case ACTIVE: {
                        dynamicGroup.setActive();
                        break;
                    }
                    case PASSIVE: {
                        dynamicGroup.setPassive();
                    }
                }
            }
            return finalGroup;
        }
    }

    @Override
    public IReplicationSourceGroup getReplicationSourceGroup(String groupName) throws NoSuchReplicationGroupExistException {
        return this._groupsHolder.getSourceGroup(groupName);
    }

    public IReplicationGroupBacklog getGroupBacklogByRequestContext(Object requestContext) {
        return this._replicaHandler.getGroupBacklogByRequestContext(requestContext);
    }

    @Override
    public RouterStubHolder getRemoteRouterStub(String routerLookupName) {
        return this.getRouterAdmin().getRemoteRouterStub(routerLookupName);
    }

    @Override
    public ReplicationEndpointDetails getEndpointDetails() {
        return this.getRouterAdmin().getMyEndpointDetails();
    }

    @Override
    public <T> T accept(AbstractReplicationPacket<T> packet) {
        if (this._pluginFacade != null) {
            return this._pluginFacade.accept(packet);
        }
        throw new UnsupportedOperationException("No plugin present");
    }

    IReplicationSourceGroup[] getReplicationSourceGroups() {
        return this._groupsHolder.getSourceGroups();
    }

    IReplicationTargetGroup[] getReplicationTargetGroups() {
        return this._groupsHolder.getTargetGroups();
    }

    @Override
    public Object newReplicaRequest(String requesterLookupName, ReplicaRequestPacket replicaRequestPacket) {
        return this._replicaHandler.newReplicaRequest(requesterLookupName, replicaRequestPacket);
    }

    @Override
    public Collection<ISpaceReplicaData> getNextReplicaBatch(Object context, int fetchBatchSize) {
        return this._replicaHandler.getNextReplicaBatch(context, fetchBatchSize);
    }

    public void clearStaleReplicas(long expirationTime) {
        this._replicaHandler.clearStaleReplicas(expirationTime);
    }

    @Override
    public CurrentStageInfo nextReplicaStage(Object replicaRemoteContext) {
        return this._replicaHandler.nextReplicaState(replicaRemoteContext);
    }

    public String getLogPrefix() {
        return "Replication [" + this.getName() + "]: ";
    }

    public String toString() {
        return this.getLogPrefix();
    }

    public IRedoLogStatistics getBackLogStatistics() {
        int n = 0;
        IReplicationSourceGroup[] iReplicationSourceGroupArray = this.getReplicationSourceGroups();
        int n2 = iReplicationSourceGroupArray.length;
        if (n < n2) {
            IReplicationSourceGroup group = iReplicationSourceGroupArray[n];
            IReplicationGroupBacklog groupBacklog = group.getGroupBacklog();
            return groupBacklog.getStatistics();
        }
        return RedoLogStatistics.EMPTY_STATISTICS;
    }

    public void monitorState(OperationWeightInfo info) {
        for (IReplicationSourceGroup sourceGroup : this._groupsHolder.getSourceGroups()) {
            sourceGroup.getGroupBacklog().monitor(info);
            sourceGroup.monitorConsistencyLevel();
        }
    }

    public void setNodeStateListener(IReplicationNodeStateListener listener) {
        this._stateListener = listener;
    }

    @Override
    public boolean onTargetChannelOutOfSync(String groupName, String channelSourceLookupName, IncomingReplicationOutOfSyncException outOfSyncReason) {
        IReplicationNodeStateListener stateListener = this._stateListener;
        if (stateListener != null) {
            return stateListener.onTargetChannelOutOfSync(groupName, channelSourceLookupName, outOfSyncReason);
        }
        return false;
    }

    @Override
    public void onTargetChannelBacklogDropped(String groupName, String channelSourceLooString, IBacklogMemberState memberState) {
        IReplicationNodeStateListener stateListener = this._stateListener;
        if (stateListener != null) {
            stateListener.onTargetChannelBacklogDropped(groupName, channelSourceLooString, memberState);
        }
    }

    @Override
    public void onTargetChannelCreationValidation(String groupName, String sourceMemberName, Object sourceUniqueId) {
        IReplicationNodeStateListener stateListener = this._stateListener;
        if (stateListener != null) {
            stateListener.onTargetChannelCreationValidation(groupName, sourceMemberName, sourceUniqueId);
        }
    }

    @Override
    public void onTargetChannelSourceDisconnected(String groupName, String sourceMemberName, Object sourceUniqueId) {
        IReplicationNodeStateListener stateListener = this._stateListener;
        if (stateListener != null) {
            stateListener.onTargetChannelSourceDisconnected(groupName, sourceMemberName, sourceUniqueId);
        }
    }

    @Override
    public void onTargetChannelConnected(String groupName, String sourceMemberName, Object sourceUniqueId) {
        IReplicationNodeStateListener stateListener = this._stateListener;
        if (stateListener != null) {
            stateListener.onTargetChannelConnected(groupName, sourceMemberName, sourceUniqueId);
        }
    }

    @Override
    public void onSourceBrokenReplicationTopology(String groupName, String channelMemberName, BrokenReplicationTopologyException error) {
        IReplicationNodeStateListener stateListener = this._stateListener;
        if (stateListener != null) {
            stateListener.onSourceBrokenReplicationTopology(groupName, channelMemberName, error);
        }
    }

    @Override
    public void onSourceChannelActivated(String groupName, String memberName) {
        IReplicationNodeStateListener stateListener = this._stateListener;
        if (stateListener != null) {
            stateListener.onSourceChannelActivated(groupName, memberName);
        }
    }

    public void onNewReplicaRequest(String groupName, String channelName, boolean isSynchronizeRequest) {
        IReplicationNodeStateListener stateListener = this._stateListener;
        if (stateListener != null) {
            stateListener.onNewReplicaRequest(groupName, channelName, isSynchronizeRequest);
        }
    }

    public boolean flushPendingReplication(long timeout, TimeUnit units) {
        if (_logger.isLoggable(Level.FINER)) {
            _logger.fine(this.getLogPrefix() + "initiating flush of pending replication");
        }
        long remainingTime = units.toMillis(timeout);
        for (IReplicationSourceGroup sourceGroup : this._groupsHolder.getSourceGroups()) {
            long iterationStartTime = SystemTime.timeMillis();
            boolean flushPendingReplication = sourceGroup.flushPendingReplication(remainingTime, TimeUnit.MILLISECONDS);
            if (!flushPendingReplication) {
                return false;
            }
            if ((remainingTime -= SystemTime.timeMillis() - iterationStartTime) > 0L) continue;
            return false;
        }
        if (_logger.isLoggable(Level.INFO)) {
            _logger.info(this.getLogPrefix() + "completed replication.");
        }
        return true;
    }

    public String dumpState() {
        return "---- Replication Groups ----" + StringUtils.NEW_LINE + this._groupsHolder.dumpState() + StringUtils.NEW_LINE + "---- Replication Router ----" + StringUtils.NEW_LINE + this._replicationRouter.dumpState() + StringUtils.NEW_LINE + "---- Replica Handler ----" + StringUtils.NEW_LINE + this._replicaHandler.dumpState();
    }

    private void validateNotClose() {
        if (this._closed) {
            throw new ClosedResourceException("Replication module is closed");
        }
    }

    public IReplicationRouterAdmin getRouterAdmin() {
        return this._replicationRouter.getAdmin();
    }

    @Override
    public void setBlobStoreReplicaConsumeHelper(BlobStoreReplicaConsumeHelper blobStoreReplicaConsumeHelper) {
        this._blobStoreReplicaConsumeHelper = blobStoreReplicaConsumeHelper;
    }

    @Override
    public BlobStoreReplicaConsumeHelper getBlobStoreReplicaConsumeHelper() {
        return this._blobStoreReplicaConsumeHelper;
    }

    @Override
    public IDirectPersistencySyncHandler getDirectPesistencySyncHandler() {
        return this._directPesistencySyncHandler;
    }

    @Override
    public DirectPersistencyBackupSyncIteratorHandler getDirectPersistencyBackupSyncIteratorHandler() {
        return this._replicaHandler.getDirectPersistencyBackupSyncIteratorHandler();
    }

    @Override
    public void setDirectPersistencyBackupSyncIteratorHandler(DirectPersistencyBackupSyncIteratorHandler directPersistencyBackupSyncIteratorHandler) {
        this._replicaHandler.setDirectPersistencyBackupSyncIteratorHandler(directPersistencyBackupSyncIteratorHandler);
    }

    public MetricRegistrator getMetricRegister() {
        return this.metricRegister;
    }

    public ReplicationNodeReplicaHandler getReplicaHandler() {
        return this._replicaHandler;
    }

    public class StatisticsMonitor
    implements Runnable {
        @Override
        public void run() {
            for (IReplicationSourceGroup sourceGroup : ReplicationNode.this.getReplicationSourceGroups()) {
                sourceGroup.sampleStatistics();
            }
        }
    }
}

