/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.cluster.node.impl;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.cluster.replication.ConsistencyLevelViolationException;
import com.gigaspaces.cluster.replication.IRedoLogStatistics;
import com.gigaspaces.cluster.replication.RedoLogCapacityExceededException;
import com.gigaspaces.internal.cluster.node.IReplicationNodeAdmin;
import com.gigaspaces.internal.cluster.node.IReplicationNodeStateListener;
import com.gigaspaces.internal.cluster.node.impl.ReplicationNode;
import com.gigaspaces.internal.cluster.node.impl.backlog.OperationWeightInfo;
import com.gigaspaces.internal.cluster.node.impl.config.DynamicSourceGroupConfigHolder;
import com.gigaspaces.internal.cluster.node.impl.config.ReplicationNodeMode;
import com.gigaspaces.internal.cluster.node.impl.groups.IReplicationSourceChannelStatistics;
import com.gigaspaces.internal.cluster.node.impl.groups.IReplicationSourceGroup;
import com.gigaspaces.internal.cluster.node.impl.groups.IReplicationSourceGroupStatistics;
import com.gigaspaces.internal.cluster.node.impl.groups.IReplicationTargetGroup;
import com.gigaspaces.internal.cluster.node.impl.router.ConnectionState;
import com.gigaspaces.internal.cluster.node.impl.router.IReplicationRouterAdmin;
import com.gigaspaces.internal.utils.StringUtils;
import com.j_spaces.core.filters.ReplicationStatistics;
import com.j_spaces.kernel.JSpaceUtilities;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

@InternalApi
public class ReplicationNodeAdmin
implements IReplicationNodeAdmin {
    private static final Logger _logger = Logger.getLogger("com.gigaspaces.replication.node");
    private final ReplicationNode _replicationNode;

    public ReplicationNodeAdmin(ReplicationNode replicationNode) {
        this._replicationNode = replicationNode;
    }

    @Override
    public boolean flushPendingReplication(long timeout, TimeUnit units) {
        return this._replicationNode.flushPendingReplication(timeout, units);
    }

    @Override
    public ReplicationStatistics getStatistics() {
        IRedoLogStatistics backLogStatistics = this._replicationNode.getBackLogStatistics();
        LinkedList<ReplicationStatistics.OutgoingChannel> outChannelsStat = new LinkedList<ReplicationStatistics.OutgoingChannel>();
        for (IReplicationSourceGroup sourceGroup : this._replicationNode.getReplicationSourceGroups()) {
            IReplicationSourceGroupStatistics groupStat = sourceGroup.getStatistics();
            for (IReplicationSourceChannelStatistics channelStat : groupStat.getChannelStatistics()) {
                String name = channelStat.getName();
                ReplicationStatistics.ReplicationMode replicationMode = channelStat.getChannelType();
                ReplicationStatistics.ChannelState state = channelStat.getConnectionState() == ConnectionState.DISCONNECTED ? ReplicationStatistics.ChannelState.DISCONNECTED : (channelStat.isActive() ? ReplicationStatistics.ChannelState.ACTIVE : ReplicationStatistics.ChannelState.CONNECTED);
                long lastConfirmedKeyFromTarget = channelStat.getLastConfirmedKey();
                Throwable inconsistencyReason = channelStat.getInconsistencyReason();
                ReplicationStatistics.OutgoingChannel outChannelStat = new ReplicationStatistics.OutgoingChannel(name, replicationMode, state, backLogStatistics.getLastKeyInRedoLog(), lastConfirmedKeyFromTarget, channelStat.getPacketsTP(), channelStat.getTotalNumberOfReplicatedPackets(), inconsistencyReason != null ? JSpaceUtilities.getStackTrace(inconsistencyReason) : null, channelStat.getGeneratedTraffic(), channelStat.getReceivedTraffic(), channelStat.getGeneratedTrafficTP(), channelStat.getReceivedTrafficTP(), channelStat.getGeneratedTrafficPerPacket(), channelStat.getBacklogRetainedSize(), channelStat.getOperatingType(), channelStat.getTargetDetails(), channelStat.getDelegatorDetails());
                outChannelsStat.add(outChannelStat);
            }
        }
        ReplicationStatistics.OutgoingReplication outStat = new ReplicationStatistics.OutgoingReplication(backLogStatistics, outChannelsStat);
        ReplicationStatistics replicationStatistics = new ReplicationStatistics(outStat);
        return replicationStatistics;
    }

    @Override
    public Object[] getStatus() {
        LinkedList<String> allChannelsNames = new LinkedList<String>();
        LinkedList<Integer> allChannelsStatus = new LinkedList<Integer>();
        for (IReplicationSourceGroup sourceGroup : this._replicationNode.getReplicationSourceGroups()) {
            Map<String, Boolean> channelsStatus = sourceGroup.getChannelsStatus();
            for (Map.Entry<String, Boolean> entry : channelsStatus.entrySet()) {
                allChannelsNames.add(entry.getKey());
                boolean value = entry.getValue();
                int status = value ? 0 : 1;
                allChannelsStatus.add(status);
            }
        }
        int[] allChannelsStatusPrimitive = new int[allChannelsStatus.size()];
        for (int i = 0; i < allChannelsStatus.size(); ++i) {
            allChannelsStatusPrimitive[i] = (Integer)allChannelsStatus.get(i);
        }
        return new Object[]{allChannelsNames.toArray(new String[allChannelsNames.size()]), allChannelsStatusPrimitive};
    }

    @Override
    public void monitorState(OperationWeightInfo info) throws RedoLogCapacityExceededException, ConsistencyLevelViolationException {
        this._replicationNode.monitorState(info);
    }

    private String nodeModeDisplayString() {
        return this._replicationNode.getNodeMode() == null ? "NONE" : this._replicationNode.getNodeMode().toString();
    }

    @Override
    public synchronized void setActive() {
        if (this._replicationNode.getNodeMode() == ReplicationNodeMode.ACTIVE) {
            return;
        }
        if (_logger.isLoggable(Level.FINER)) {
            _logger.finer("Replication node [" + this._replicationNode.getName() + "] moving from " + this.nodeModeDisplayString() + " mode to " + (Object)((Object)ReplicationNodeMode.ACTIVE) + " mode");
        }
        this._replicationNode.createSourceGroups(ReplicationNodeMode.ACTIVE);
        this._replicationNode.createTargetGroups(ReplicationNodeMode.ACTIVE);
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("Replication node [" + this._replicationNode.getName() + "] moved from " + this.nodeModeDisplayString() + " mode to " + (Object)((Object)ReplicationNodeMode.ACTIVE) + " mode");
        }
        for (IReplicationSourceGroup sourceGroup : this._replicationNode.getReplicationSourceGroups()) {
            sourceGroup.setActive(this._replicationNode.getMetricRegister());
        }
        for (IReplicationTargetGroup targetGroup : this._replicationNode.getReplicationTargetGroups()) {
            targetGroup.setActive();
        }
        if (this._replicationNode.getNodeMode() == ReplicationNodeMode.PASSIVE) {
            this._replicationNode.closeSourceGroups(ReplicationNodeMode.PASSIVE);
            this._replicationNode.closeTargetGroups(ReplicationNodeMode.PASSIVE);
        }
        this._replicationNode.setNodeMode(ReplicationNodeMode.ACTIVE);
    }

    @Override
    public synchronized void setPassive(boolean closeProxy) {
        if (this._replicationNode.getNodeMode() == ReplicationNodeMode.PASSIVE) {
            return;
        }
        if (_logger.isLoggable(Level.FINER)) {
            _logger.finer("Replication node [" + this._replicationNode.getName() + "] moving from " + this.nodeModeDisplayString() + " mode to " + (Object)((Object)ReplicationNodeMode.PASSIVE) + " mode");
        }
        this._replicationNode.createSourceGroups(ReplicationNodeMode.PASSIVE);
        this._replicationNode.createTargetGroups(ReplicationNodeMode.PASSIVE);
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("Replication node [" + this._replicationNode.getName() + "] moved from " + this.nodeModeDisplayString() + " mode to " + (Object)((Object)ReplicationNodeMode.PASSIVE) + " mode");
        }
        for (IReplicationSourceGroup sourceGroup : this._replicationNode.getReplicationSourceGroups()) {
            sourceGroup.setPassive(closeProxy);
        }
        for (IReplicationTargetGroup targetGroup : this._replicationNode.getReplicationTargetGroups()) {
            targetGroup.setPassive();
        }
        if (this._replicationNode.getNodeMode() == ReplicationNodeMode.ACTIVE) {
            this._replicationNode.closeSourceGroups(ReplicationNodeMode.ACTIVE);
            this._replicationNode.closeTargetGroups(ReplicationNodeMode.ACTIVE);
        }
        this._replicationNode.setNodeMode(ReplicationNodeMode.PASSIVE);
    }

    @Override
    public void setNodeStateListener(IReplicationNodeStateListener listener) {
        this._replicationNode.setNodeStateListener(listener);
    }

    @Override
    public String dumpState() {
        return "ReplicationNode [" + this._replicationNode.getName() + ", " + this._replicationNode.getUniqueId() + "] mode: " + this.nodeModeDisplayString() + StringUtils.NEW_LINE + this._replicationNode.dumpState();
    }

    @Override
    public void clearStaleReplicas(long expirationTime) {
        this._replicationNode.clearStaleReplicas(expirationTime);
    }

    @Override
    public IReplicationRouterAdmin getRouterAdmin() {
        return this._replicationNode.getRouterAdmin();
    }

    @Override
    public DynamicSourceGroupConfigHolder getSourceGroupConfigHolder(String groupName) {
        IReplicationSourceGroup replicationSourceGroup = this._replicationNode.getReplicationSourceGroup(groupName);
        return replicationSourceGroup.getConfigHolder();
    }
}

