/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.cluster.node.impl;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.client.mutators.SpaceEntryMutator;
import com.gigaspaces.internal.cluster.node.IReplicationOutContext;
import com.gigaspaces.internal.cluster.node.impl.GroupMapping;
import com.gigaspaces.internal.cluster.node.impl.backlog.sync.IMarker;
import com.gigaspaces.internal.cluster.node.impl.directPersistency.IDirectPersistencyOpInfo;
import com.gigaspaces.internal.cluster.node.impl.directPersistency.IDirectPersistencySyncHandler;
import com.gigaspaces.internal.cluster.node.impl.groups.IReplicationGroupOutContext;
import com.gigaspaces.internal.server.storage.IEntryData;
import com.gigaspaces.internal.utils.threadlocal.AbstractResource;
import com.j_spaces.core.OperationID;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

@InternalApi
public class ReplicationOutContext
extends AbstractResource
implements IReplicationOutContext,
Iterable<IReplicationGroupOutContext> {
    private Map<String, IReplicationGroupOutContext> _groupsContext;
    private GroupMapping _mapping = GroupMapping.getAllMapping();
    private IReplicationGroupOutContext _singleGroupContext;
    private OperationID _operationID;
    private boolean[] _partialUpdatedValuesIndicators;
    public boolean[] _shouldReplicate;
    public Map<String, Object> _partialUpdatesAndInPlaceUpdatesInfo;
    public OperationID[] _operationIDs;
    private boolean _fromGateway;
    private Set<String> _overrideVersionUids;
    private IEntryData _previousUpdatedEntryData;
    private String _askedMarkerMembersGroupName;
    private IMarker _askedMarker;
    private Collection<SpaceEntryMutator> _spaceEntryMutators;
    private int _completed;
    private IDirectPersistencyOpInfo _directPesistencyPendingEntry;
    private IDirectPersistencySyncHandler _directPersistencyHandler;
    private int _blobstoreReplicationBulkId;
    private boolean _blobstorePendingReplicationBulk;

    public IReplicationGroupOutContext getGroupContext(String groupName) {
        if (this.isSingleGroupParticipant()) {
            if (this._singleGroupContext == null || groupName.equals(this._singleGroupContext.getName())) {
                return this._singleGroupContext;
            }
            return null;
        }
        return this._groupsContext.get(groupName);
    }

    @Override
    protected void clean() {
        this._singleGroupContext = null;
        this._groupsContext = null;
        this._operationID = null;
        this._partialUpdatedValuesIndicators = null;
        this._shouldReplicate = null;
        this._partialUpdatesAndInPlaceUpdatesInfo = null;
        this._operationIDs = null;
        this._fromGateway = false;
        this._overrideVersionUids = null;
        this._previousUpdatedEntryData = null;
        this._spaceEntryMutators = null;
        this._askedMarkerMembersGroupName = null;
        this._askedMarker = null;
        this._directPesistencyPendingEntry = null;
        this._directPersistencyHandler = null;
        this._blobstoreReplicationBulkId = 0;
        this._blobstorePendingReplicationBulk = false;
    }

    public void setGroupContext(IReplicationGroupOutContext groupContext) {
        groupContext.setEntireContext(this);
        if (this._singleGroupContext == null) {
            this._singleGroupContext = groupContext;
        } else {
            if (this._groupsContext == null) {
                this._groupsContext = new HashMap<String, IReplicationGroupOutContext>();
                this._groupsContext.put(this._singleGroupContext.getName(), this._singleGroupContext);
            }
            this._groupsContext.put(groupContext.getName(), groupContext);
        }
    }

    public boolean isSingleGroupParticipant() {
        return this._groupsContext == null;
    }

    public boolean isEmpty() {
        return this._singleGroupContext == null && this._directPersistencyHandler == null;
    }

    public IReplicationGroupOutContext getSingleGroupParticipantContext() {
        if (!this.isSingleGroupParticipant()) {
            throw new IllegalStateException("ReplicationOutContext has multiple participating groups");
        }
        return this._singleGroupContext;
    }

    @Override
    public Iterator<IReplicationGroupOutContext> iterator() {
        if (this.isSingleGroupParticipant()) {
            throw new IllegalStateException("ReplicationOutContext has a single participating groups");
        }
        return this._groupsContext.values().iterator();
    }

    public GroupMapping getGroupMapping() {
        return this._mapping;
    }

    public void setGroupMapping(GroupMapping mapping) {
        this._mapping = mapping;
    }

    public OperationID getOperationID() {
        return this._operationID;
    }

    public void setOperationID(OperationID operationID) {
        this._operationID = operationID;
    }

    public boolean[] getPartialUpdatedValuesIndicators() {
        return this._partialUpdatedValuesIndicators;
    }

    public void setPartialUpdatedValuesIndicators(boolean[] partialUpdatedValuesIndicators) {
        this._partialUpdatedValuesIndicators = partialUpdatedValuesIndicators;
    }

    public boolean[] getShouldReplicate() {
        return this._shouldReplicate;
    }

    public void setShouldReplicate(boolean[] shouldReplicate) {
        this._shouldReplicate = shouldReplicate;
    }

    public Map<String, Object> getPartialUpdatesAndInPlaceUpdatesInfo() {
        return this._partialUpdatesAndInPlaceUpdatesInfo;
    }

    public void setPartialUpdatesInfo(Map<String, Object> partialUpdatesAndInPlaceUpdatesInfo) {
        this._partialUpdatesAndInPlaceUpdatesInfo = partialUpdatesAndInPlaceUpdatesInfo;
    }

    public OperationID[] getOperationIDs() {
        return this._operationIDs;
    }

    public void setOperationIDs(OperationID[] operationIDs) {
        this._operationIDs = operationIDs;
    }

    public boolean isFromGateway() {
        return this._fromGateway;
    }

    public void setFromGateway(boolean fromGateway) {
        this._fromGateway = fromGateway;
    }

    @Override
    public int pendingSize() {
        if (this.isSingleGroupParticipant()) {
            if (this._singleGroupContext == null) {
                return 0;
            }
            return this._singleGroupContext.size();
        }
        int result = 0;
        for (IReplicationGroupOutContext groupContext : this._groupsContext.values()) {
            result += groupContext.size();
        }
        return result;
    }

    public void setOverrideVersionUids(Set<String> overrideVersionUids) {
        this._overrideVersionUids = overrideVersionUids;
    }

    public boolean isOverrideVersion(String uid) {
        if (this._overrideVersionUids == null) {
            return false;
        }
        return this._overrideVersionUids.contains(uid);
    }

    public void setPreviousUpdatedEntryData(IEntryData PreviousUpdatedEntryData) {
        this._previousUpdatedEntryData = PreviousUpdatedEntryData;
    }

    public IEntryData getPreviousUpdatedEntryData() {
        return this._previousUpdatedEntryData;
    }

    public void setSpaceEntryMutators(Collection<SpaceEntryMutator> spaceEntryMutators) {
        this._spaceEntryMutators = spaceEntryMutators;
    }

    public Collection<SpaceEntryMutator> getSpaceEntryMutators() {
        return this._spaceEntryMutators;
    }

    @Override
    public void askForMarker(String membersGroupName) {
        this._askedMarkerMembersGroupName = membersGroupName;
    }

    @Override
    public IMarker getRequestedMarker() {
        if (this._askedMarker == null) {
            throw new IllegalStateException("Cannot get requested marker without asking for one");
        }
        IMarker askedMarker = this._askedMarker;
        this._askedMarker = null;
        this._askedMarkerMembersGroupName = null;
        return askedMarker;
    }

    public String getAskedMarker() {
        return this._askedMarkerMembersGroupName;
    }

    public void setMarker(IMarker marker) {
        this._askedMarker = marker;
    }

    @Override
    public int setCompleted(int completed) {
        this._completed = completed;
        return this._completed;
    }

    @Override
    public int getCompleted() {
        return this._completed;
    }

    @Override
    public void setDirectPersistencyPendingEntry(IDirectPersistencyOpInfo directPesistencyEntry) {
        this._directPesistencyPendingEntry = directPesistencyEntry;
    }

    @Override
    public IDirectPersistencyOpInfo getDirectPersistencyPendingEntry() {
        return this._directPesistencyPendingEntry;
    }

    @Override
    public IDirectPersistencySyncHandler getDirectPesistencySyncHandler() {
        return this._directPersistencyHandler;
    }

    @Override
    public void setDirectPesistencySyncHandler(IDirectPersistencySyncHandler directPesistencySyncHandler) {
        this._directPersistencyHandler = directPesistencySyncHandler;
    }

    @Override
    public int getBlobstoreReplicationBulkId() {
        return this._blobstoreReplicationBulkId;
    }

    @Override
    public void setBlobstoreReplicationBulkId(int blobstoreBulkId) {
        this._blobstoreReplicationBulkId = blobstoreBulkId;
    }

    @Override
    public boolean isBlobstorePendingReplicationBulk() {
        return this._blobstorePendingReplicationBulk;
    }

    @Override
    public void blobstorePendingReplicationBulk() {
        this._blobstorePendingReplicationBulk = true;
    }

    public String toString() {
        if (this.isEmpty()) {
            return "[empty]";
        }
        if (this.isSingleGroupParticipant()) {
            return this._singleGroupContext.toString();
        }
        return this._groupsContext.toString();
    }
}

