/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.cluster.node.impl;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.time.SystemTime;
import java.util.concurrent.TimeUnit;

@InternalApi
public class StatisticsHolder<T> {
    private final int _samplesCount;
    private final long[] _timeStamps;
    private final T[] _samples;
    private int _startIndex;
    private final T _defaultValue;

    public StatisticsHolder(int samplesCount, T defaultValue) {
        this._samplesCount = samplesCount;
        this._defaultValue = defaultValue;
        this._timeStamps = new long[this._samplesCount];
        this._samples = new Object[this._samplesCount];
    }

    public synchronized void addSample(long timeStamp, T sample) {
        this._timeStamps[this._startIndex] = timeStamp;
        this._samples[this._startIndex] = sample;
        this._startIndex = (this._startIndex + 1) % this._samplesCount;
    }

    public synchronized T getLastSample() {
        int lastSampleIndex = this._startIndex - 1;
        if (lastSampleIndex < 0) {
            lastSampleIndex = this._samplesCount - 1;
        }
        return this.sampleAt(lastSampleIndex);
    }

    public synchronized long getLastTimeStamp() {
        int lastSampleIndex = this._startIndex - 1;
        if (lastSampleIndex < 0) {
            lastSampleIndex = this._samplesCount - 1;
        }
        return this._timeStamps[lastSampleIndex];
    }

    public synchronized T getSampleBefore(long timeBefore, TimeUnit unit) {
        long currentTime = SystemTime.timeMillis();
        long requestedTime = currentTime - unit.toMillis(timeBefore);
        int requestedIndex = this._startIndex;
        for (int i = 0; i < this._samplesCount; ++i) {
            int index = this._startIndex - 1 - i;
            if (index < 0) {
                index += this._samplesCount;
            }
            if (this._timeStamps[index] > requestedTime) continue;
            requestedIndex = index;
            break;
        }
        return this.sampleAt(requestedIndex);
    }

    private T sampleAt(int requestedIndex) {
        T sample = this._samples[requestedIndex];
        if (sample == null) {
            return this._defaultValue;
        }
        return sample;
    }

    public static void main(String[] args) throws InterruptedException {
        StatisticsHolder<Integer> statisticsHolder = new StatisticsHolder<Integer>(2, 0);
        int lastSample = statisticsHolder.getLastSample();
        System.out.println("sample " + lastSample);
        long lastTimeStamp = statisticsHolder.getLastTimeStamp();
        System.out.println("timeStamp " + lastTimeStamp);
        lastSample = statisticsHolder.getSampleBefore(3L, TimeUnit.SECONDS);
        System.out.println("sample " + lastSample);
        statisticsHolder.addSample(SystemTime.timeMillis(), 5);
        lastSample = statisticsHolder.getLastSample();
        System.out.println("sample 1 " + lastSample);
        lastTimeStamp = statisticsHolder.getLastTimeStamp();
        System.out.println("timeStamp " + lastTimeStamp);
        lastSample = statisticsHolder.getSampleBefore(3L, TimeUnit.SECONDS);
        System.out.println("sample 2 " + lastSample);
        Thread.sleep(1000L);
        statisticsHolder.addSample(SystemTime.timeMillis(), 15);
        lastSample = statisticsHolder.getLastSample();
        System.out.println("sample 3 " + lastSample);
        lastTimeStamp = statisticsHolder.getLastTimeStamp();
        System.out.println("timeStamp " + lastTimeStamp);
        lastSample = statisticsHolder.getSampleBefore(3L, TimeUnit.SECONDS);
        System.out.println("sample 4 " + lastSample);
        Thread.sleep(2000L);
        lastSample = statisticsHolder.getSampleBefore(3L, TimeUnit.SECONDS);
        System.out.println("sample 5 " + lastSample);
        statisticsHolder.addSample(SystemTime.timeMillis(), 20);
        Thread.sleep(2000L);
        lastSample = statisticsHolder.getSampleBefore(3L, TimeUnit.SECONDS);
        System.out.println("sample 6 " + lastSample);
        Thread.sleep(2000L);
        lastSample = statisticsHolder.getSampleBefore(3L, TimeUnit.SECONDS);
        System.out.println("sample 7 " + lastSample);
        lastSample = statisticsHolder.getLastSample();
        System.out.println("sample 8 " + lastSample);
        lastTimeStamp = statisticsHolder.getLastTimeStamp();
        System.out.println("timeStamp " + lastTimeStamp);
    }
}

