/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.cluster.node.impl.backlog;

import com.gigaspaces.cluster.replication.IRedoLogStatistics;
import com.gigaspaces.cluster.replication.RedoLogCapacityExceededException;
import com.gigaspaces.cluster.replication.RedoLogStatistics;
import com.gigaspaces.cluster.replication.ReplicationTargetInfo;
import com.gigaspaces.internal.cluster.node.impl.DataTypeIntroducePacketData;
import com.gigaspaces.internal.cluster.node.impl.ReplicationLogUtils;
import com.gigaspaces.internal.cluster.node.impl.ReplicationOutContext;
import com.gigaspaces.internal.cluster.node.impl.backlog.BacklogConfig;
import com.gigaspaces.internal.cluster.node.impl.backlog.DefaultPacketFilteredHandler;
import com.gigaspaces.internal.cluster.node.impl.backlog.FixedBacklogWeightPolicy;
import com.gigaspaces.internal.cluster.node.impl.backlog.IIdleStateData;
import com.gigaspaces.internal.cluster.node.impl.backlog.IReplicationBacklogStateListener;
import com.gigaspaces.internal.cluster.node.impl.backlog.IReplicationGroupBacklog;
import com.gigaspaces.internal.cluster.node.impl.backlog.NoSuchReplicationMemberException;
import com.gigaspaces.internal.cluster.node.impl.backlog.OperationWeightInfo;
import com.gigaspaces.internal.cluster.node.impl.backlog.SingleFileBacklogGroupMarker;
import com.gigaspaces.internal.cluster.node.impl.backlog.SingleFileBacklogMarker;
import com.gigaspaces.internal.cluster.node.impl.backlog.SynchronizingData;
import com.gigaspaces.internal.cluster.node.impl.backlog.globalorder.AbstractSingleFileConfirmationHolder;
import com.gigaspaces.internal.cluster.node.impl.backlog.globalorder.IPacketFilteredHandler;
import com.gigaspaces.internal.cluster.node.impl.backlog.reliableasync.IReliableAsyncState;
import com.gigaspaces.internal.cluster.node.impl.backlog.reliableasync.IReliableAsyncTargetState;
import com.gigaspaces.internal.cluster.node.impl.backlog.reliableasync.MissingReliableAsyncTargetStateException;
import com.gigaspaces.internal.cluster.node.impl.backlog.sync.IMarker;
import com.gigaspaces.internal.cluster.node.impl.config.DynamicSourceGroupConfigHolder;
import com.gigaspaces.internal.cluster.node.impl.config.MemberAddedEvent;
import com.gigaspaces.internal.cluster.node.impl.config.SourceGroupConfig;
import com.gigaspaces.internal.cluster.node.impl.groups.IReplicationChannelDataFilter;
import com.gigaspaces.internal.cluster.node.impl.groups.IReplicationGroupHistory;
import com.gigaspaces.internal.cluster.node.impl.groups.ReplicationChannelDataFilterHelper;
import com.gigaspaces.internal.cluster.node.impl.groups.ReplicationChannelDataFilterResult;
import com.gigaspaces.internal.cluster.node.impl.groups.handshake.IHandshakeContext;
import com.gigaspaces.internal.cluster.node.impl.groups.handshake.IHandshakeIteration;
import com.gigaspaces.internal.cluster.node.impl.groups.reliableasync.ReliableAsyncSourceGroupConfig;
import com.gigaspaces.internal.cluster.node.impl.packets.IReplicationOrderedPacket;
import com.gigaspaces.internal.cluster.node.impl.packets.data.IReplicationPacketData;
import com.gigaspaces.internal.cluster.node.impl.packets.data.IReplicationPacketDataProducer;
import com.gigaspaces.internal.cluster.node.impl.packets.data.IReplicationPacketEntryData;
import com.gigaspaces.internal.cluster.node.impl.packets.data.ReplicationPacketEntryDataConversionException;
import com.gigaspaces.internal.collections.CollectionsFactory;
import com.gigaspaces.internal.collections.MapProcedure;
import com.gigaspaces.internal.server.space.redolog.FixedSizeSwapRedoLogFile;
import com.gigaspaces.internal.server.space.redolog.FixedSizeSwapRedoLogFileConfig;
import com.gigaspaces.internal.server.space.redolog.IRedoLogFile;
import com.gigaspaces.internal.server.space.redolog.MemoryRedoLogFile;
import com.gigaspaces.internal.server.space.redolog.RedoLogFileCompromisedException;
import com.gigaspaces.internal.server.space.redolog.storage.BufferedRedoLogFileStorageDecorator;
import com.gigaspaces.internal.server.space.redolog.storage.CacheLastRedoLogFileStorageDecorator;
import com.gigaspaces.internal.server.space.redolog.storage.bytebuffer.ByteBufferRedoLogFileConfig;
import com.gigaspaces.internal.server.space.redolog.storage.bytebuffer.ByteBufferRedoLogFileStorage;
import com.gigaspaces.internal.server.space.redolog.storage.bytebuffer.IPacketStreamSerializer;
import com.gigaspaces.internal.server.space.redolog.storage.bytebuffer.SwapPacketStreamSerializer;
import com.gigaspaces.internal.server.space.redolog.storage.bytebuffer.raf.RAFByteBufferStorageFactory;
import com.gigaspaces.internal.utils.StringUtils;
import com.gigaspaces.internal.utils.collections.CopyOnUpdateMap;
import com.gigaspaces.internal.utils.collections.CopyOnUpdateSet;
import com.gigaspaces.internal.utils.collections.ReadOnlyIterator;
import com.gigaspaces.internal.utils.collections.THashMapFactory;
import com.gigaspaces.internal.version.PlatformLogicalVersion;
import com.gigaspaces.metrics.Gauge;
import com.gigaspaces.metrics.MetricRegistrator;
import com.j_spaces.core.cluster.RedoLogCompaction;
import com.j_spaces.core.cluster.SwapBacklogConfig;
import com.j_spaces.core.cluster.startup.CompactionResult;
import com.j_spaces.core.exception.internal.ReplicationInternalSpaceException;
import com.j_spaces.kernel.JSpaceUtilities;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class AbstractSingleFileGroupBacklog<T extends IReplicationOrderedPacket, CType extends AbstractSingleFileConfirmationHolder>
implements IReplicationGroupBacklog,
DynamicSourceGroupConfigHolder.IDynamicSourceGroupStateListener {
    protected static final Logger _loggerReplica = Logger.getLogger("com.gigaspaces.replication.replica");
    protected final Logger _logger;
    private static final long WEIGHT_WARNING_THRESHOLD = 50L;
    private final DynamicSourceGroupConfigHolder _groupConfigHolder;
    private final String _groupName;
    private final IReplicationPacketDataProducer<?> _dataProducer;
    private final String _name;
    private final IRedoLogFile<T> _backlogFile;
    private boolean _isLimited;
    private boolean _allBlockingMembers;
    private long _minDeletionLimitation;
    private long _minBlockLimitation;
    private boolean _hasBlockOnLimitMember;
    private String _mirrorMemberName;
    private final CopyOnUpdateMap<String, SynchronizingData> _activeSynchronizingTarget;
    private final CopyOnUpdateSet<String> _backlogCapacityAllowedBreachingTargets;
    private final CopyOnUpdateMap<String, CType> _confirmationMap;
    protected final Set<String> _outOfSyncDueToDeletionTargets;
    private boolean _backlogDroppedEntirely;
    private volatile IReplicationGroupHistory _groupHistory;
    private IReplicationBacklogStateListener _stateListener;
    protected final IPacketFilteredHandler _defaultFilteredHandler = new DefaultPacketFilteredHandler();
    protected final ReadWriteLock _rwLock = new ReentrantReadWriteLock();
    private long _nextKey = 0L;
    private final ICaluclateMinUnconfirmedKey _getMinUnconfirmedKeyProcedure;
    private boolean _closed;
    private RedoLogCompaction _redoLogCompaction;

    public AbstractSingleFileGroupBacklog(DynamicSourceGroupConfigHolder groupConfigHolder, String name, IReplicationPacketDataProducer<?> dataProducer) {
        this._groupConfigHolder = groupConfigHolder;
        SourceGroupConfig groupConfig = groupConfigHolder.getConfig();
        this._groupName = groupConfig.getName();
        this._dataProducer = dataProducer;
        this._name = name;
        this._logger = Logger.getLogger("com.gigaspaces.replication.backlog." + ReplicationLogUtils.toShortGroupName(this._groupName));
        this._outOfSyncDueToDeletionTargets = new HashSet<String>();
        this._backlogCapacityAllowedBreachingTargets = new CopyOnUpdateSet();
        this._activeSynchronizingTarget = new CopyOnUpdateMap();
        this._backlogFile = this.createBacklog(groupConfig);
        this.updateBacklogLimitations(groupConfig);
        this._confirmationMap = new CopyOnUpdateMap(new THashMapFactory());
        this._confirmationMap.putAll(this.createConfirmationMap(groupConfig));
        this._mirrorMemberName = groupConfig.getBacklogConfig().getMirrorMemberName();
        this._redoLogCompaction = groupConfig.getBacklogConfig().getRedoLogCompaction();
        this._getMinUnconfirmedKeyProcedure = this.isRedoLogCompactionEnabled() ? new CompactionEnabledCaluclateMinUnconfirmedKeyProcedure() : new CaluclateMinUnconfirmedKeyProcedure();
    }

    protected void updateBacklogLimitations(SourceGroupConfig groupConfig) {
        this._isLimited = this.isLimitedBacklog(groupConfig);
        this._allBlockingMembers = this.isAllLimitationsBlocking(groupConfig);
        this._minDeletionLimitation = this.calcMinDeletionLimitation(groupConfig);
        this._hasBlockOnLimitMember = this.hasBlockOnLimitMember(groupConfig);
        this._minBlockLimitation = this.calcMinBlockLimitation(groupConfig);
    }

    protected abstract Map<String, CType> createConfirmationMap(SourceGroupConfig var1);

    protected boolean hasExistingMember() {
        return this._groupConfigHolder.getConfig().getMembersLookupNames().length > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void memberAdded(MemberAddedEvent memberAddedParam, SourceGroupConfig newConfig) {
        this._rwLock.writeLock().lock();
        try {
            CType newConfirmationHolder = this.createNewConfirmationHolder();
            AbstractSingleFileConfirmationHolder previous = (AbstractSingleFileConfirmationHolder)this._confirmationMap.putIfAbsent(memberAddedParam.getMemberName(), newConfirmationHolder);
            if (previous != null) {
                throw new IllegalStateException("Cannot add an already existing member [" + memberAddedParam.getMemberName() + "]");
            }
            if (this._logger.isLoggable(Level.FINER)) {
                this._logger.finer(this.getLogPrefix() + "adding new member [" + memberAddedParam.getMemberName() + "] to backlog, using backlog configuration [" + memberAddedParam.getBacklogMemberLimitation().toString() + "], setting its confirmation state to [" + newConfirmationHolder + "]");
            }
            this.updateBacklogLimitations(newConfig);
        }
        finally {
            this._rwLock.writeLock().unlock();
        }
    }

    @Override
    public void makeMemberConfirmedOnAll(String memberName) {
        this._rwLock.writeLock().lock();
        try {
            CType newConfirmationHolder = this.createNewConfirmationHolder();
            this._confirmationMap.put(memberName, newConfirmationHolder);
            if (this._logger.isLoggable(Level.FINER)) {
                this._logger.finer(this.getLogPrefix() + "making member [" + memberName + "] confirmed on all current packets [" + newConfirmationHolder + "]");
            }
        }
        finally {
            this._rwLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void memberRemoved(String memberName, SourceGroupConfig newConfig) {
        this._rwLock.writeLock().lock();
        try {
            AbstractSingleFileConfirmationHolder member = (AbstractSingleFileConfirmationHolder)this._confirmationMap.remove(memberName);
            this._outOfSyncDueToDeletionTargets.remove(memberName);
            this._backlogCapacityAllowedBreachingTargets.remove(memberName);
            if (member == null) {
                if (this._logger.isLoggable(Level.WARNING)) {
                    this._logger.warning(this.getLogPrefix() + "attempting to remove a non existing member [" + memberName + "]");
                }
                return;
            }
            this.updateBacklogLimitations(newConfig);
            this.clearConfirmedPackets();
        }
        finally {
            this._rwLock.writeLock().unlock();
        }
    }

    protected CType getConfirmationHolderUnsafe(String memberName) {
        AbstractSingleFileConfirmationHolder confirmation = (AbstractSingleFileConfirmationHolder)this._confirmationMap.get(memberName);
        if (confirmation == null) {
            return this.createNewConfirmationHolder();
        }
        return (CType)confirmation;
    }

    protected void validateReliableAsyncUpdateTargetsMatch(IReliableAsyncState reliableAsyncState, String sourceMemberName) throws NoSuchReplicationMemberException, MissingReliableAsyncTargetStateException {
        IReliableAsyncTargetState[] asyncTargetsState = reliableAsyncState.getReliableAsyncTargetsState();
        Set<String> members = this.getMembersToValidateAgainst();
        members.remove(sourceMemberName);
        for (IReliableAsyncTargetState asyncTargetState : asyncTargetsState) {
            if (members.remove(asyncTargetState.getTargetMemberName())) continue;
            throw new NoSuchReplicationMemberException(asyncTargetState.getTargetMemberName());
        }
        if (!members.isEmpty()) {
            String missingMember = members.iterator().next();
            throw new MissingReliableAsyncTargetStateException(missingMember);
        }
    }

    protected Set<String> getMembersToValidateAgainst() {
        ReliableAsyncSourceGroupConfig config = (ReliableAsyncSourceGroupConfig)this._groupConfigHolder.getConfig();
        return new HashSet<String>(Arrays.asList(config.getMembersLookupNames()));
    }

    protected Collection<CType> getAllConfirmationHoldersUnsafe() {
        return this._confirmationMap.values();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Set<Map.Entry<String, CType>> getAllConfirmations(String ... filterMembers) {
        this._rwLock.readLock().lock();
        try {
            HashSet<String> filteredSet = new HashSet<String>(Arrays.asList(filterMembers));
            Set<Map.Entry<String, CType>> entrySet = this._confirmationMap.entrySet();
            HashSet<Map.Entry<String, CType>> result = new HashSet<Map.Entry<String, CType>>();
            for (Map.Entry<String, CType> entry : entrySet) {
                if (filteredSet.contains(entry.getKey())) continue;
                result.add(entry);
            }
            HashSet<Map.Entry<String, CType>> hashSet = result;
            return hashSet;
        }
        finally {
            this._rwLock.readLock().unlock();
        }
    }

    protected Set<Map.Entry<String, CType>> getAllConfirmations() {
        this._rwLock.readLock().lock();
        try {
            Set<Map.Entry<String, CType>> set = this._confirmationMap.entrySet();
            return set;
        }
        finally {
            this._rwLock.readLock().unlock();
        }
    }

    protected abstract CType createNewConfirmationHolder();

    private long calcMinBlockLimitation(SourceGroupConfig groupConfig) {
        long result = Long.MAX_VALUE;
        BacklogConfig backlogConfig = groupConfig.getBacklogConfig();
        for (String memberLookupName : groupConfig.getMembersLookupNames()) {
            if (backlogConfig.isLimited(memberLookupName) && backlogConfig.getLimitReachedPolicy(memberLookupName) == BacklogConfig.LimitReachedPolicy.BLOCK_NEW) {
                result = Math.min(result, backlogConfig.getLimit(memberLookupName));
            }
            if (!backlogConfig.isLimitedDuringSynchronization(memberLookupName)) continue;
            result = Math.min(result, backlogConfig.getLimitDuringSynchronization(memberLookupName));
        }
        if (result == Long.MAX_VALUE) {
            return -1L;
        }
        return result;
    }

    private boolean hasBlockOnLimitMember(SourceGroupConfig groupConfig) {
        for (String memberLookupName : groupConfig.getMembersLookupNames()) {
            if (groupConfig.getBacklogConfig().getLimitReachedPolicy(memberLookupName) != BacklogConfig.LimitReachedPolicy.BLOCK_NEW) continue;
            return true;
        }
        return false;
    }

    private long calcMinDeletionLimitation(SourceGroupConfig groupConfig) {
        long result = Long.MAX_VALUE;
        BacklogConfig backlogConfig = groupConfig.getBacklogConfig();
        for (String memberLookupName : groupConfig.getMembersLookupNames()) {
            if (!backlogConfig.isLimited(memberLookupName) || backlogConfig.getLimitReachedPolicy(memberLookupName) == BacklogConfig.LimitReachedPolicy.BLOCK_NEW) continue;
            result = Math.min(result, backlogConfig.getLimit(memberLookupName));
        }
        if (result == Long.MAX_VALUE) {
            return -1L;
        }
        return result;
    }

    private boolean isAllLimitationsBlocking(SourceGroupConfig groupConfig) {
        BacklogConfig backlogConfig = groupConfig.getBacklogConfig();
        for (String memberLookupName : groupConfig.getMembersLookupNames()) {
            if (backlogConfig.getLimitReachedPolicy(memberLookupName) == BacklogConfig.LimitReachedPolicy.BLOCK_NEW) continue;
            return false;
        }
        return true;
    }

    private boolean isLimitedBacklog(SourceGroupConfig groupConfig) {
        for (String memberLookupName : groupConfig.getMembersLookupNames()) {
            if (!groupConfig.getBacklogConfig().isLimited(memberLookupName)) continue;
            return true;
        }
        return false;
    }

    private IRedoLogFile<T> createBacklog(SourceGroupConfig groupConfig) {
        if (groupConfig.getBacklogConfig().isLimitedMemoryCapacity()) {
            return this.createSwapBacklog(groupConfig);
        }
        return new MemoryRedoLogFile(this._name, this);
    }

    private IRedoLogFile<T> createSwapBacklog(SourceGroupConfig groupConfig) {
        BacklogConfig backlogConfig = groupConfig.getBacklogConfig();
        SwapBacklogConfig swapBacklogConfig = backlogConfig.getSwapBacklogConfig();
        RAFByteBufferStorageFactory byteBufferStorageProvider = new RAFByteBufferStorageFactory("redolog_" + this._name.replace(":", "_"));
        ByteBufferRedoLogFileConfig storageConfig = new ByteBufferRedoLogFileConfig();
        storageConfig.setMaxSizePerSegment(swapBacklogConfig.getSegmentSize());
        storageConfig.setMaxScanLength(swapBacklogConfig.getMaxScanLength());
        storageConfig.setMaxOpenStorageCursors(swapBacklogConfig.getMaxOpenCursors());
        storageConfig.setWriterMaxBufferSize(swapBacklogConfig.getWriterBufferSize());
        storageConfig.setPacketStreamSerializer(new IPacketStreamSerializer<T>(){
            final SwapPacketStreamSerializer<T> serializer = new SwapPacketStreamSerializer();

            @Override
            public void writePacketToStream(ObjectOutput output, T packet) throws IOException {
                this.serializer.writePacketToStream(output, packet);
            }

            @Override
            public T readPacketFromStream(ObjectInput input) throws IOException, ClassNotFoundException {
                IReplicationOrderedPacket packet = (IReplicationOrderedPacket)this.serializer.readPacketFromStream(input);
                IReplicationPacketDataProducer dataProducer = AbstractSingleFileGroupBacklog.this._dataProducer;
                dataProducer.completePacketDataContent(packet.getData());
                return packet;
            }
        });
        ByteBufferRedoLogFileStorage externalRedoLogFileStorage = new ByteBufferRedoLogFileStorage(byteBufferStorageProvider, storageConfig, backlogConfig.getBackLogWeightPolicy());
        BufferedRedoLogFileStorageDecorator bufferedRedoLogFileStorage = new BufferedRedoLogFileStorageDecorator(swapBacklogConfig.getFlushBufferPacketsCount(), externalRedoLogFileStorage);
        int memoryRedoLogFileSize = backlogConfig.getLimitedMemoryCapacity() / 2;
        int cachedDecoratorSize = backlogConfig.getLimitedMemoryCapacity() - memoryRedoLogFileSize;
        CacheLastRedoLogFileStorageDecorator cacheLastRedoLogFileStorage = new CacheLastRedoLogFileStorageDecorator(cachedDecoratorSize, bufferedRedoLogFileStorage, this);
        FixedSizeSwapRedoLogFileConfig config = new FixedSizeSwapRedoLogFileConfig(memoryRedoLogFileSize, Math.min(swapBacklogConfig.getFetchBufferPacketsCount(), memoryRedoLogFileSize), backlogConfig.getLimitedMemoryCapacity(), cacheLastRedoLogFileStorage);
        FixedSizeSwapRedoLogFile swappedRedoLogFile = new FixedSizeSwapRedoLogFile(config, this._name, this);
        return swappedRedoLogFile;
    }

    protected long getFirstKeyInBacklogInternal() {
        if (this.getBacklogFile().isEmpty()) {
            return 0L;
        }
        return this.getBacklogFile().getOldest().getKey();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void monitor(OperationWeightInfo info) throws RedoLogCapacityExceededException {
        if (!this._isLimited || this._backlogCapacityAllowedBreachingTargets.isEmpty() && !this._hasBlockOnLimitMember) {
            return;
        }
        SourceGroupConfig config = this._groupConfigHolder.getConfig();
        BacklogConfig backlogConfig = config.getBacklogConfig();
        int operationWeight = backlogConfig.getBackLogWeightPolicy().predictWeightBeforeOperation(info);
        if ((long)operationWeight > this._minBlockLimitation && (this.getWeight() == 0L || this.dataTypeIntroduceOnly())) {
            this._logger.log(Level.WARNING, this.getLogPrefix() + "Allowing to do an operation which is larger than the backlog's capacity.\nbacklog capacity = " + this._minBlockLimitation + ". operation weight = " + operationWeight);
            return;
        }
        if (this._minBlockLimitation > this.getBacklogFile().getWeight() + (long)operationWeight) {
            return;
        }
        this._rwLock.readLock().lock();
        try {
            for (String memberLookupName : config.getMembersLookupNames()) {
                long memberLimit;
                boolean memberHasBlockingLimitation;
                boolean memberUnderBlockingSyncLimit = backlogConfig.isLimitedDuringSynchronization(memberLookupName) && this.isUnderSynchronizationLimitation(memberLookupName) && backlogConfig.getLimitDuringSynchronizationReachedPolicy(memberLookupName) == BacklogConfig.LimitReachedPolicy.BLOCK_NEW;
                boolean bl = memberHasBlockingLimitation = backlogConfig.isLimited(memberLookupName) && backlogConfig.getLimitReachedPolicy(memberLookupName) == BacklogConfig.LimitReachedPolicy.BLOCK_NEW;
                if (!memberUnderBlockingSyncLimit && !memberHasBlockingLimitation) continue;
                long targetWeightUnsafe = this.getWeightUnsafe(memberLookupName);
                long retainedWeightForMember = targetWeightUnsafe + (long)operationWeight;
                long l = memberLimit = memberUnderBlockingSyncLimit ? backlogConfig.getLimitDuringSynchronization(memberLookupName) : backlogConfig.getLimit(memberLookupName);
                if (retainedWeightForMember <= memberLimit) continue;
                throw new RedoLogCapacityExceededException("This operation cannot be performed because it needs to be replicated and the current replication backlog capacity reached [" + memberLookupName + " retained size before inserting packet: " + targetWeightUnsafe + ", packet weight: " + operationWeight + ",but member is limited to " + memberLimit + "], backlog is kept for replication group " + this.getGroupName() + " from space " + this.getName() + " to space " + memberLookupName + ". Retry the operation once the backlog size is reduced", this.getGroupName(), this.getName());
            }
        }
        finally {
            this._rwLock.readLock().unlock();
        }
    }

    private boolean dataTypeIntroduceOnly() {
        return this.getWeight() == 1L && ((IReplicationOrderedPacket)this._backlogFile.readOnlyIterator(0L).next()).getData() instanceof DataTypeIntroducePacketData;
    }

    protected boolean isBacklogDroppedEntirely() {
        return this._backlogDroppedEntirely;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void ensureLimit(IReplicationPacketData<?> data) {
        if (!this._isLimited || this._allBlockingMembers) {
            return;
        }
        int weight = data.getWeight();
        if (this.getWeightUnsafe() + (long)weight <= this._minDeletionLimitation) {
            return;
        }
        long firstKeyInBacklog = this.getFirstKeyInBacklogInternal();
        long maxAllowedDeleteUpTo = this.getInitialMaxAllowedDeleteUpTo();
        if (maxAllowedDeleteUpTo <= firstKeyInBacklog) {
            return;
        }
        SourceGroupConfig config = this._groupConfigHolder.getConfig();
        BacklogConfig backlogConfig = config.getBacklogConfig();
        ArrayList<String> problematicMembers = null;
        String maximalCapacityMemberName = null;
        long capacityForMaxMember = 0L;
        for (String memberLookupName : config.getMembersLookupNames()) {
            long currentAllowedLimit;
            boolean isMemberLimited;
            long lastConfirmedKeyForMember = this.getLastConfirmedKeyUnsafe(memberLookupName);
            boolean isMemberUnderSynchronizationLimitations = this.isUnderSynchronizationLimitation(memberLookupName);
            BacklogConfig.LimitReachedPolicy limitReachedPolicy = isMemberUnderSynchronizationLimitations ? backlogConfig.getLimitDuringSynchronizationReachedPolicy(memberLookupName) : backlogConfig.getLimitReachedPolicy(memberLookupName);
            boolean bl = isMemberLimited = isMemberUnderSynchronizationLimitations ? backlogConfig.isLimitedDuringSynchronization(memberLookupName) : backlogConfig.isLimited(memberLookupName);
            if (!isMemberLimited || limitReachedPolicy == BacklogConfig.LimitReachedPolicy.BLOCK_NEW) {
                maxAllowedDeleteUpTo = Math.min(maxAllowedDeleteUpTo, lastConfirmedKeyForMember + 1L);
                continue;
            }
            long oldestKeptPacketInLog = Math.max(firstKeyInBacklog, lastConfirmedKeyForMember + 1L);
            long newWeightForMember = this.getWeightUnsafe(memberLookupName) + (long)weight;
            long l = currentAllowedLimit = isMemberUnderSynchronizationLimitations ? backlogConfig.getLimitDuringSynchronization(memberLookupName) : backlogConfig.getLimit(memberLookupName);
            if (newWeightForMember <= currentAllowedLimit) {
                maxAllowedDeleteUpTo = Math.min(maxAllowedDeleteUpTo, oldestKeptPacketInLog);
                continue;
            }
            if (problematicMembers == null) {
                problematicMembers = new ArrayList<String>(3);
            }
            if (limitReachedPolicy == BacklogConfig.LimitReachedPolicy.DROP_UNTIL_RESYNC || limitReachedPolicy == BacklogConfig.LimitReachedPolicy.DROP_MEMBER) {
                problematicMembers.add(memberLookupName);
                continue;
            }
            if (maximalCapacityMemberName != null && currentAllowedLimit <= capacityForMaxMember) continue;
            maximalCapacityMemberName = memberLookupName;
            capacityForMaxMember = currentAllowedLimit;
        }
        if (maximalCapacityMemberName != null) {
            problematicMembers.add(maximalCapacityMemberName);
        }
        if (problematicMembers == null) {
            return;
        }
        boolean initiallyEmpty = this.getBacklogFile().isEmpty();
        long firstKeyDropped = -1L;
        long lastKeyDropped = -1L;
        for (String member : problematicMembers) {
            BacklogConfig.LimitReachedPolicy limitReachedPolicy;
            boolean isMemberUnderSynchronizationLimitations = this.isUnderSynchronizationLimitation(member);
            long currentAllowedLimit = isMemberUnderSynchronizationLimitations ? backlogConfig.getLimitDuringSynchronization(member) : backlogConfig.getLimit(member);
            BacklogConfig.LimitReachedPolicy limitReachedPolicy2 = limitReachedPolicy = isMemberUnderSynchronizationLimitations ? backlogConfig.getLimitDuringSynchronizationReachedPolicy(member) : backlogConfig.getLimitReachedPolicy(member);
            if (currentAllowedLimit < (long)weight) {
                this._logger.log(Level.WARNING, this.getLogPrefix() + "inserting to the backlog an operation which is larger than the backlog's capacity.\ntarget name = " + member + ", target defined capacity = " + currentAllowedLimit + ", operation type = , operation weight = " + weight);
                if (initiallyEmpty) continue;
            }
            long lastConfirmedKeyForMember = this.getLastConfirmedKeyUnsafe(member);
            boolean dropBacklogPolicy = limitReachedPolicy == BacklogConfig.LimitReachedPolicy.DROP_UNTIL_RESYNC || limitReachedPolicy == BacklogConfig.LimitReachedPolicy.DROP_MEMBER;
            try {
                while (!this.getBacklogFile().isEmpty() && (currentAllowedLimit < this.getWeightUnsafe(member) + (long)weight || dropBacklogPolicy) && maxAllowedDeleteUpTo > this.getFirstKeyInBacklogInternal()) {
                    if (firstKeyDropped == -1L) {
                        firstKeyDropped = this.getFirstKeyInBacklogInternal();
                    }
                    lastKeyDropped = this.getFirstKeyInBacklogInternal();
                    this.deleteBatchFromBacklog(1L);
                }
            }
            finally {
                if (dropBacklogPolicy) {
                    if (initiallyEmpty) continue;
                    this.makeMemberOutOfSyncDueToDeletion(member, config, limitReachedPolicy);
                }
                if (firstKeyDropped != -1L && lastKeyDropped > lastConfirmedKeyForMember) {
                    this._logger.log(Level.WARNING, this.getLogPrefix() + "backlog capacity reached, packets from key " + firstKeyDropped + " to key " + lastKeyDropped + " was deleted.");
                }
                if (this.getWeightUnsafe(member) + (long)weight - currentAllowedLimit <= 50L) continue;
                this._logger.log(Level.WARNING, this.getLogPrefix() + "current backlog weight is more than the target limit, weight exceeds by more than the threshold.\ntarget name = " + member + ", target defined capacity = " + currentAllowedLimit + ", operation weight = " + weight + " threshold = " + 50L);
            }
        }
    }

    protected abstract void deleteBatchFromBacklog(long var1);

    protected long getInitialMaxAllowedDeleteUpTo() {
        return Long.MAX_VALUE;
    }

    protected abstract long getLastConfirmedKeyUnsafe(String var1);

    private boolean isUnderSynchronizationLimitation(String memberLookupName) {
        return this._backlogCapacityAllowedBreachingTargets.contains(memberLookupName);
    }

    private void makeMemberOutOfSyncDueToDeletion(String memberLookupName, SourceGroupConfig<?> groupConfig, BacklogConfig.LimitReachedPolicy limitReachedPolicy) {
        String[] membersLookupNames;
        if (this._outOfSyncDueToDeletionTargets.contains(memberLookupName)) {
            return;
        }
        String backlogDroppedMsg = "backlog for target " + memberLookupName + " is dropped due to backlog capacity reached [" + groupConfig.getBacklogConfig().getLimit(memberLookupName) + "]" + (limitReachedPolicy == BacklogConfig.LimitReachedPolicy.DROP_UNTIL_RESYNC ? ", target will have to perform full recovery upon reconnection" : ".");
        this.logEventInHistory(memberLookupName, backlogDroppedMsg);
        if (this._logger.isLoggable(Level.WARNING)) {
            this._logger.warning(this.getLogPrefix() + backlogDroppedMsg);
        }
        this._outOfSyncDueToDeletionTargets.add(memberLookupName);
        boolean backlogDroppedEntirely = true;
        for (String member : membersLookupNames = groupConfig.getMembersLookupNames()) {
            if (this._outOfSyncDueToDeletionTargets.contains(member)) continue;
            backlogDroppedEntirely = false;
            break;
        }
        this._backlogDroppedEntirely = backlogDroppedEntirely;
        if (this._backlogDroppedEntirely && this._logger.isLoggable(Level.INFO)) {
            this._logger.info(this.getLogPrefix() + "backlog is dropped for all targets, no packets will held in the backlog until some of the targets will recover");
        }
    }

    private void logEventInHistory(String memberLookupName, String event) {
        if (this._groupHistory == null) {
            return;
        }
        this._groupHistory.logEvent(memberLookupName, event);
    }

    protected SynchronizingData isSynchronizing(String memberName) {
        SynchronizingData synchronizingData = this._activeSynchronizingTarget.get(memberName);
        return synchronizingData;
    }

    protected SynchronizingData checkSynchronizingDone(SynchronizingData synchronizingData, long currentKey, String memberName) {
        if (synchronizingData == null) {
            return null;
        }
        if (synchronizingData.isDone(currentKey)) {
            this.removeSynchronizingState(currentKey, memberName);
            return null;
        }
        return synchronizingData;
    }

    protected void removeSynchronizingState(long currentKey, String memberName) {
        if (_loggerReplica.isLoggable(Level.FINER)) {
            _loggerReplica.finer(this.getLogPrefix() + "interleaving synchronization data filtering done with member [" + memberName + "], reached key " + currentKey);
        }
        this._activeSynchronizingTarget.remove(memberName);
    }

    @Override
    public void beginSynchronizing(String memberName) {
        this.beginSynchronizing(memberName, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void beginSynchronizing(String memberName, boolean isDirectPersistencySync) {
        this._rwLock.writeLock().lock();
        try {
            boolean removed;
            BacklogConfig backlogConfig = this._groupConfigHolder.getConfig().getBacklogConfig();
            long limitDuringSynchronization = backlogConfig.getLimitDuringSynchronization(memberName);
            boolean isLimitedDuringSync = backlogConfig.isLimitedDuringSynchronization(memberName);
            String beginSyncMsg = "begin synchronization with member [" + memberName + "], current key " + this.getLastInsertedKeyToBacklogUnsafe() + ", temporarily increasing its backlog size limitation to " + (isLimitedDuringSync ? Long.valueOf(limitDuringSynchronization) : "UNLIMITED");
            if (_loggerReplica.isLoggable(Level.FINER)) {
                _loggerReplica.finer(this.getLogPrefix() + beginSyncMsg);
            }
            if (removed = this._outOfSyncDueToDeletionTargets.remove(memberName)) {
                String backlogRestoredMsg = "backlog is being kept for member [" + memberName + "], removing backlog dropped state";
                beginSyncMsg = beginSyncMsg + ". " + backlogRestoredMsg;
                this._backlogDroppedEntirely = false;
                if (this._logger.isLoggable(Level.FINER)) {
                    this._logger.finer(this.getLogPrefix() + backlogRestoredMsg);
                }
            }
            this.logEventInHistory(memberName, beginSyncMsg);
            if (!isDirectPersistencySync) {
                this.onBeginSynchronization(memberName);
            }
            this.clearConfirmedPackets();
            this._activeSynchronizingTarget.put(memberName, new SynchronizingData(this._logger, isDirectPersistencySync));
            this._backlogCapacityAllowedBreachingTargets.add(memberName);
        }
        finally {
            this._rwLock.writeLock().unlock();
        }
    }

    protected abstract void onBeginSynchronization(String var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean synchronizationDataGenerated(String memberName, String uid) {
        this._rwLock.writeLock().lock();
        try {
            SynchronizingData syncData = this._activeSynchronizingTarget.get(memberName);
            boolean bl = syncData.updateUidKey(uid, this.getLastInsertedKeyToBacklogUnsafe());
            return bl;
        }
        finally {
            this._rwLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void synchronizationCopyStageDone(String memberName) {
        this._rwLock.writeLock().lock();
        try {
            SynchronizingData syncData = this._activeSynchronizingTarget.get(memberName);
            long lastSynchronizingKey = this.getLastInsertedKeyToBacklogUnsafe();
            if (_loggerReplica.isLoggable(Level.FINER)) {
                _loggerReplica.finer("Marking last synchronization key of member [" + memberName + "], current key [" + lastSynchronizingKey + "]");
            }
            syncData.setKeyWhenCopyStageCompleted(lastSynchronizingKey);
        }
        finally {
            this._rwLock.writeLock().unlock();
        }
    }

    @Override
    public void synchronizationDone(String memberName) {
        this._rwLock.writeLock().lock();
        try {
            this.restoreRegularBacklogLimitation(memberName, false);
        }
        finally {
            this._rwLock.writeLock().unlock();
        }
    }

    @Override
    public void stopSynchronization(String memberName) {
        this._rwLock.writeLock().lock();
        try {
            this.restoreRegularBacklogLimitation(memberName, true);
        }
        finally {
            this._rwLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<IReplicationOrderedPacket> getPackets(String memberName, int maxSize, IReplicationChannelDataFilter filter, PlatformLogicalVersion targetMemberVersion, Logger logger) {
        this._rwLock.readLock().lock();
        try {
            List<IReplicationOrderedPacket> list = this.getPacketsUnsafe(memberName, maxSize, Long.MAX_VALUE, filter, this.getFilteredHandler(), targetMemberVersion, logger);
            return list;
        }
        finally {
            this._rwLock.readLock().unlock();
        }
    }

    public List<IReplicationOrderedPacket> getPacketsUnsafe(String memberName, int maxWeight, long upToKey, IReplicationChannelDataFilter dataFilter, IPacketFilteredHandler filteredHandler, PlatformLogicalVersion targetMemberVersion, Logger logger) {
        long startIndex;
        boolean backlogOverflown;
        LinkedList<IReplicationOrderedPacket> result = new LinkedList<IReplicationOrderedPacket>();
        if (this._outOfSyncDueToDeletionTargets.contains(memberName)) {
            return result;
        }
        long memberLastConfirmedKey = this.getFirstRequiredKeyUnsafe(memberName);
        long firstKeyInBacklog = this.getFirstKeyInBacklogInternal();
        boolean bl = backlogOverflown = firstKeyInBacklog > memberLastConfirmedKey + 1L;
        if (backlogOverflown) {
            result.add((IReplicationOrderedPacket)this.createBacklogOverflowPacket(memberLastConfirmedKey, firstKeyInBacklog, memberName));
        }
        SynchronizingData synchronizingData = this.isSynchronizing(memberName);
        long l = startIndex = backlogOverflown ? 0L : memberLastConfirmedKey + 1L - firstKeyInBacklog;
        if (startIndex >= this.calculateSizeUnsafe()) {
            if (result.isEmpty() && synchronizingData != null) {
                this.removeSynchronizingState(memberLastConfirmedKey + 1L, memberName);
            }
            return result;
        }
        ReadOnlyIterator<T> iterator = this.getBacklogFile().readOnlyIterator(startIndex);
        IReplicationOrderedPacket previousDiscardedPacket = null;
        int weightSum = 0;
        try {
            while (iterator.hasNext() && weightSum < maxWeight) {
                IReplicationOrderedPacket packet = (IReplicationOrderedPacket)iterator.next();
                if (packet.getKey() > upToKey) {
                    break;
                }
                if (packet.getWeight() > maxWeight && weightSum == 0) {
                    if (this._logger.isLoggable(Level.WARNING)) {
                        this._logger.log(Level.WARNING, this.getLogPrefix() + "replicating a packet which is bigger than the batch size, [packet key=" + packet.getKey() + ", packet weight=" + packet.getWeight() + ", backlog batch size = " + maxWeight + "]\n" + this.getStatistics() + "]");
                    }
                } else if (weightSum + packet.getWeight() > maxWeight) {
                    break;
                }
                weightSum += packet.getWeight();
                if (dataFilter != null) {
                    if (previousDiscardedPacket == (packet = ReplicationChannelDataFilterHelper.filterPacket(dataFilter, targetMemberVersion, packet, this.getDataProducer(), this, previousDiscardedPacket, logger, memberName))) continue;
                    if (packet.isDiscardedPacket() && (previousDiscardedPacket == null || previousDiscardedPacket != packet)) {
                        result.add(packet);
                        previousDiscardedPacket = packet;
                        continue;
                    }
                }
                previousDiscardedPacket = null;
                if ((synchronizingData = this.checkSynchronizingDone(synchronizingData, packet.getKey(), memberName)) != null) {
                    packet = this.filterPacketForSynchronizing(synchronizingData, packet, filteredHandler, this.getDataProducer(), logger, memberName, targetMemberVersion);
                }
                result.add(packet);
            }
        }
        catch (RuntimeException e) {
            if (this._logger.isLoggable(Level.SEVERE)) {
                this._logger.log(Level.SEVERE, this.getLogPrefix() + "exception while iterating over the backlog file (getPacketsUnsafe), [startIndex=" + startIndex + " iteration=" + weightSum + " " + this.getStatistics() + "]", e);
            }
            this.validateIntegrity();
            throw e;
        }
        finally {
            iterator.close();
        }
        if (backlogOverflown && this._logger.isLoggable(Level.FINE)) {
            this._logger.fine(this.getLogPrefix() + "Backlog overflow. First key [" + firstKeyInBacklog + "], first required key [" + memberLastConfirmedKey + "].");
        }
        return result;
    }

    protected long getFirstRequiredKeyUnsafe(String memberName) {
        return this.getLastConfirmedKeyUnsafe(memberName);
    }

    protected abstract T createBacklogOverflowPacket(long var1, long var3, String var5);

    protected IPacketFilteredHandler getFilteredHandler() {
        return this._defaultFilteredHandler;
    }

    protected T filterPacketForSynchronizing(SynchronizingData synchronizingData, T packet, IPacketFilteredHandler filteredHandler, IReplicationPacketDataProducer dataProducer, Logger logger, String memberName, PlatformLogicalVersion targetMemberVersion) {
        IReplicationPacketData<?> data = packet.getData();
        T originalPacket = packet;
        if (data.requiresRecoveryFiltering()) {
            ReplicationChannelDataFilterResult filterResult = synchronizingData.filterData(data.getRecoveryFilteringId(), packet.getKey(), data.getMultipleOperationType());
            switch (filterResult.getFilterOperation()) {
                case PASS: {
                    break;
                }
                case FILTER_DATA: 
                case FILTER_PACKET: {
                    if (logger != null && logger.isLoggable(Level.FINEST)) {
                        logger.finest(this.getLogPrefix() + "filtered obsolete replication data [" + data + "] associated to key [" + packet.getKey() + "] due to synchronization process");
                    }
                    boolean forceDiscard = filterResult.getFilterOperation() == IReplicationChannelDataFilter.FilterOperation.FILTER_PACKET;
                    packet = this.replaceWithDiscarded((IReplicationOrderedPacket)packet, forceDiscard);
                    return (T)filteredHandler.packetFiltered((IReplicationOrderedPacket)originalPacket, (IReplicationOrderedPacket)packet, this, memberName);
                }
                case CONVERT: {
                    try {
                        if (logger != null && logger.isLoggable(Level.FINEST)) {
                            logger.finest(this.getLogPrefix() + "converting replication data [" + data + "] to [" + (Object)((Object)filterResult.getConvertToOperation()) + "] associated to key [" + packet.getKey() + "] due to synchronization process");
                        }
                        IReplicationPacketData<?> convertedData = dataProducer.convertData(data, filterResult.getConvertToOperation(), targetMemberVersion);
                        packet = packet.cloneWithNewData(convertedData);
                        break;
                    }
                    catch (ReplicationPacketEntryDataConversionException e) {
                        throw new ReplicationInternalSpaceException(e.getMessage(), e);
                    }
                }
            }
        }
        boolean shouldFilter = false;
        for (IReplicationPacketEntryData entryData : data) {
            if (!entryData.requiresRecoveryDuplicationProtection() || !synchronizingData.filterEntryData(entryData.getUid(), packet.getKey(), entryData.filterIfNotPresentInReplicaState())) continue;
            shouldFilter = true;
            break;
        }
        if (shouldFilter) {
            packet = packet.clone();
            data = packet.getData();
            Iterator iterator = data.iterator();
            while (iterator.hasNext()) {
                IReplicationPacketEntryData entryData;
                entryData = (IReplicationPacketEntryData)iterator.next();
                if (!entryData.requiresRecoveryDuplicationProtection() || !synchronizingData.filterEntryData(entryData.getUid(), packet.getKey(), entryData.filterIfNotPresentInReplicaState())) continue;
                if (logger != null && logger.isLoggable(Level.FINEST)) {
                    logger.finest(this.getLogPrefix() + "filtered obsolete replication data [" + entryData + "] associated to key [" + packet.getKey() + "] due to previous synchronization process");
                }
                iterator.remove();
            }
            if (packet.getData().isEmpty()) {
                packet = this.replaceWithDiscarded((IReplicationOrderedPacket)packet, false);
            }
        }
        if (originalPacket != packet) {
            return (T)filteredHandler.packetFiltered((IReplicationOrderedPacket)originalPacket, (IReplicationOrderedPacket)packet, this, memberName);
        }
        return (T)packet;
    }

    @Override
    public void clearReplicated() {
        this._rwLock.writeLock().lock();
        try {
            this.clearConfirmedPackets();
        }
        finally {
            this._rwLock.writeLock().unlock();
        }
    }

    protected void clearConfirmedPackets() {
        long deletionBatchSize;
        long firstKeyInBacklog = this.getFirstKeyInBacklogInternal();
        if (firstKeyInBacklog == 0L && this.getBacklogFile().isEmpty()) {
            return;
        }
        long minUnconfirmedKey = this.getMinimumUnconfirmedKeyUnsafe();
        if (minUnconfirmedKey != -1L && (deletionBatchSize = minUnconfirmedKey - firstKeyInBacklog) > 0L) {
            this.getBacklogFile().deleteOldestPackets(deletionBatchSize);
            IReplicationBacklogStateListener stateListener = this._stateListener;
            if (stateListener != null) {
                stateListener.onPacketsClearedAfterConfirmation(deletionBatchSize);
            }
        }
        this.performCompactionUnsafe();
    }

    @Override
    public void performCompaction() {
        if (!this.isRedoLogCompactionEnabled()) {
            return;
        }
        this._rwLock.writeLock().lock();
        this._getMinUnconfirmedKeyProcedure.reset();
        CollectionsFactory.getInstance().forEachEntry(this._confirmationMap.getUnsafeMapReference(), this._getMinUnconfirmedKeyProcedure);
        this.performCompactionUnsafe();
        this._rwLock.writeLock().unlock();
    }

    private boolean isRedoLogCompactionEnabled() {
        return this._mirrorMemberName != null && this._redoLogCompaction.equals((Object)RedoLogCompaction.MIRROR);
    }

    public void performCompactionUnsafe() {
        CompactionResult compactionResult;
        long lastConfirmedNonMirrorKey;
        long minUnconfirmedMirrorKey;
        if (this.isRedoLogCompactionEnabled() && (minUnconfirmedMirrorKey = this._getMinUnconfirmedKeyProcedure.getMinUnconfirmedMirrorKey()) < (lastConfirmedNonMirrorKey = this._getMinUnconfirmedKeyProcedure.getMinUnconfirmedNonMirrorKey() - 1L) && !(compactionResult = this._backlogFile.performCompaction(minUnconfirmedMirrorKey, lastConfirmedNonMirrorKey)).isEmpty()) {
            this.updateMirrorWeightAfterCompaction(compactionResult);
        }
    }

    public void updateMirrorWeightAfterCompaction(CompactionResult compactionResult) {
        AbstractSingleFileConfirmationHolder confirmation = (AbstractSingleFileConfirmationHolder)this._confirmationMap.get(this._mirrorMemberName);
        confirmation.setWeight(confirmation.getWeight() - compactionResult.getDiscardedCount() - (long)compactionResult.getDeletedFromTxn());
        this.increaseMirrorDiscardedCount(compactionResult.getDiscardedCount());
    }

    public void decreaseMirrorDiscardedCount(long count) {
        AbstractSingleFileConfirmationHolder confirmation = (AbstractSingleFileConfirmationHolder)this._confirmationMap.get(this._mirrorMemberName);
        confirmation.setDiscardedPacketsCount(confirmation.getDiscardedPacketsCount() - count);
    }

    public void increaseMirrorDiscardedCount(long count) {
        AbstractSingleFileConfirmationHolder confirmation = (AbstractSingleFileConfirmationHolder)this._confirmationMap.get(this._mirrorMemberName);
        confirmation.setDiscardedPacketsCount(confirmation.getDiscardedPacketsCount() + count);
    }

    public boolean hasMirror() {
        return this._mirrorMemberName != null;
    }

    protected long getMinimumUnconfirmedKeyUnsafe() {
        this._getMinUnconfirmedKeyProcedure.reset();
        CollectionsFactory.getInstance().forEachEntry(this._confirmationMap.getUnsafeMapReference(), this._getMinUnconfirmedKeyProcedure);
        return this._getMinUnconfirmedKeyProcedure.getCalculatedMinimumUnconfirmedKey();
    }

    protected abstract long getMemberUnconfirmedKey(CType var1);

    private void restoreRegularBacklogLimitation(String memberName, boolean stopped) {
        boolean removed = this._backlogCapacityAllowedBreachingTargets.remove(memberName);
        if (removed) {
            String syncDoneMsg = "synchronization of member [" + memberName + "] is " + (stopped ? "stopped" : "done") + ", backlog size is [" + this.calculateSizeUnsafe(memberName) + "] restoring backlog limitation to normal";
            this.logEventInHistory(memberName, syncDoneMsg);
            if (_loggerReplica.isLoggable(Level.FINER)) {
                _loggerReplica.finer(this.getLogPrefix() + syncDoneMsg);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long size(String memberName) {
        this._rwLock.readLock().lock();
        try {
            long l = this.calculateSizeUnsafe(memberName);
            return l;
        }
        finally {
            this._rwLock.readLock().unlock();
        }
    }

    @Override
    public long size() {
        this._rwLock.readLock().lock();
        try {
            long l = this.calculateSizeUnsafe();
            return l;
        }
        finally {
            this._rwLock.readLock().unlock();
        }
    }

    private long calculateSizeUnsafe() {
        return this.getBacklogFile().size();
    }

    private long calculateSizeUnsafe(String memberName) {
        if (this._outOfSyncDueToDeletionTargets.contains(memberName)) {
            return 0L;
        }
        long lastConfirmedLong = this.getLastConfirmedKeyUnsafe(memberName);
        return Math.min(this.calculateSizeUnsafe(), this.getLastInsertedKeyToBacklogUnsafe() - lastConfirmedLong);
    }

    @Override
    public IMarker getCurrentMarker(String memberName) {
        this._rwLock.readLock().lock();
        try {
            SingleFileBacklogMarker singleFileBacklogMarker = new SingleFileBacklogMarker(this, memberName, Math.max(0L, this.getLastInsertedKeyToBacklogUnsafe()));
            return singleFileBacklogMarker;
        }
        finally {
            this._rwLock.readLock().unlock();
        }
    }

    @Override
    public IMarker getMarker(IReplicationOrderedPacket packet, String membersGroupName) {
        long markedKey = packet.getEndKey() + 1L;
        return this.createMarker(membersGroupName, markedKey);
    }

    private IMarker createMarker(String membersGroupName, long markedKey) {
        String[] memberNames = this.getMembersOfGroup(membersGroupName);
        if (memberNames.length == 1) {
            return new SingleFileBacklogMarker(this, memberNames[0], markedKey);
        }
        return new SingleFileBacklogGroupMarker(this, memberNames, markedKey);
    }

    private IMarker getNextPacketMarker(String membersGroupName) {
        long markedKey = Math.max(1L, this.getNextKeyUnsafe());
        return this.createMarker(membersGroupName, markedKey);
    }

    private String[] getMembersOfGroup(String groupingName) {
        Map<String, String[]> membersGrouping = ((SourceGroupConfig)this.getGroupConfigSnapshot()).getMembersGrouping();
        if (membersGrouping == null) {
            throw new IllegalStateException("Requesting replication marker for members grouping [" + groupingName + "] while there is no members grouping mapping");
        }
        String[] memberNames = membersGrouping.get(groupingName);
        if (memberNames == null) {
            throw new IllegalStateException("Requesting replication marker for members grouping [" + groupingName + "] while there is no members grouping mapping under that name");
        }
        return memberNames;
    }

    protected long getNextKeyUnsafe() {
        return this._nextKey;
    }

    protected long getLastInsertedKeyToBacklogUnsafe() {
        return this.getNextKeyUnsafe() - 1L;
    }

    protected long takeNextKeyUnsafe(ReplicationOutContext replicationOutContext) {
        long takenKey = this._nextKey++;
        return takenKey;
    }

    protected void setNextKeyUnsafe(long newNextKey) {
        this._nextKey = newNextKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IMarker getUnconfirmedMarker(String memberName) {
        this._rwLock.readLock().lock();
        try {
            long lastUnconfirmedKey = this.getLastConfirmedKeyUnsafe(memberName) + 1L;
            SingleFileBacklogMarker singleFileBacklogMarker = new SingleFileBacklogMarker(this, memberName, Math.max(0L, lastUnconfirmedKey + 1L));
            return singleFileBacklogMarker;
        }
        finally {
            this._rwLock.readLock().unlock();
        }
    }

    public boolean isMarkerReached(String memberName, long markedKey) {
        long lastConfirmedLong = this.getLastConfirmedKeyUnsafe(memberName);
        return lastConfirmedLong + 1L >= markedKey;
    }

    @Override
    public String toLogMessage(String memberName) {
        this._rwLock.readLock().lock();
        try {
            String string = "Backlog state { " + this.getStatistics() + "}. Last confirmed key for member " + memberName + " [" + this.getLastConfirmedKeyUnsafe(memberName) + "].";
            return string;
        }
        finally {
            this._rwLock.readLock().unlock();
        }
    }

    protected void validateIntegrity() {
        block4: {
            try {
                if (this._logger.isLoggable(Level.INFO)) {
                    this._logger.info("Performing redo log file integrity validation");
                }
                this.getBacklogFile().validateIntegrity();
                if (this._logger.isLoggable(Level.INFO)) {
                    this._logger.info("Redo log file integrity is intact");
                }
            }
            catch (RedoLogFileCompromisedException e) {
                if (!this._logger.isLoggable(Level.SEVERE)) break block4;
                this._logger.log(Level.SEVERE, "Redo log file integrity validation failed", e);
            }
        }
    }

    @Override
    public IHandshakeIteration getNextHandshakeIteration(String memberName, IHandshakeContext handshakeContext) {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IRedoLogStatistics getStatistics() {
        this._rwLock.readLock().lock();
        try {
            long firstKeyInBacklog = this.getBacklogFile().isEmpty() ? -1L : this.getFirstKeyInBacklogInternal();
            long lastKeyInBackLog = this.getLastInsertedKeyToBacklogUnsafe();
            RedoLogStatistics redoLogStatistics = new RedoLogStatistics(lastKeyInBackLog, firstKeyInBacklog, this.getWeightUnsafe(), this.getBacklogFile().getMemoryPacketsCount(), this.getBacklogFile().getExternalStoragePacketsCount(), this.getBacklogFile().getExternalStorageSpaceUsed(), this.generateInfotForMemberMap());
            return redoLogStatistics;
        }
        finally {
            this._rwLock.readLock().unlock();
        }
    }

    private Map<String, ReplicationTargetInfo> generateInfotForMemberMap() {
        HashMap<String, ReplicationTargetInfo> result = new HashMap<String, ReplicationTargetInfo>();
        for (Map.Entry<String, CType> entry : this._confirmationMap.entrySet()) {
            ReplicationTargetInfo targetInfo = new ReplicationTargetInfo(((AbstractSingleFileConfirmationHolder)entry.getValue()).getCalculatedWeight());
            result.put(entry.getKey(), targetInfo);
        }
        return result;
    }

    @Override
    public void registerWith(MetricRegistrator metricRegister) {
        metricRegister.register("first-key-in-backlog", new SynchronizedGauge(){

            @Override
            protected Long getValueImpl() {
                return AbstractSingleFileGroupBacklog.this.getBacklogFile().isEmpty() ? -1L : AbstractSingleFileGroupBacklog.this.getFirstKeyInBacklogInternal();
            }
        });
        metricRegister.register("last-key-in-backlog", new SynchronizedGauge(){

            @Override
            protected Long getValueImpl() {
                return AbstractSingleFileGroupBacklog.this.getLastInsertedKeyToBacklogUnsafe();
            }
        });
        metricRegister.register("size", new SynchronizedGauge(){

            @Override
            protected Long getValueImpl() {
                return AbstractSingleFileGroupBacklog.this.getWeightUnsafe();
            }
        });
        metricRegister.register("memory-packets", new SynchronizedGauge(){

            @Override
            protected Long getValueImpl() {
                return AbstractSingleFileGroupBacklog.this.getBacklogFile().getMemoryPacketsCount();
            }
        });
        metricRegister.register("external-storage-packets", new SynchronizedGauge(){

            @Override
            protected Long getValueImpl() {
                return AbstractSingleFileGroupBacklog.this.getBacklogFile().getExternalStoragePacketsCount();
            }
        });
        metricRegister.register("external-storage-bytes", new SynchronizedGauge(){

            @Override
            protected Long getValueImpl() {
                return AbstractSingleFileGroupBacklog.this.getBacklogFile().getExternalStorageSpaceUsed();
            }
        });
    }

    @Override
    public void close() {
        this._rwLock.writeLock().lock();
        try {
            if (this._closed) {
                return;
            }
            this._closed = true;
            this._backlogFile.close();
        }
        finally {
            this._rwLock.writeLock().unlock();
        }
    }

    public String getName() {
        return this._name;
    }

    public String getGroupName() {
        return this._groupName;
    }

    protected IRedoLogFile<T> getBacklogFile() {
        return this._backlogFile;
    }

    @Override
    public IReplicationPacketDataProducer getDataProducer() {
        return this._dataProducer;
    }

    @Override
    public synchronized void setGroupHistory(IReplicationGroupHistory groupHistory) {
        if (this._groupHistory != null) {
            throw new IllegalStateException("Cannot set group history twice, group history is already set [" + this._groupHistory + "]");
        }
        this._groupHistory = groupHistory;
    }

    @Override
    public synchronized void setStateListener(IReplicationBacklogStateListener stateListener) {
        if (this._stateListener != null) {
            throw new IllegalStateException("Cannot set state listener twice, state listener is already set [" + this._stateListener + "]");
        }
        this._stateListener = stateListener;
    }

    @Override
    public void setPendingError(String memberName, Throwable error, IIdleStateData idleStateData) {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setPendingError(String memberName, Throwable error, IReplicationOrderedPacket replicatedPacket) {
        this._rwLock.writeLock().lock();
        try {
            this.handlePendingErrorSinglePacket(memberName, replicatedPacket, error);
        }
        finally {
            this._rwLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setPendingError(String memberName, Throwable error, List<IReplicationOrderedPacket> replicatedPackets) {
        this._rwLock.writeLock().lock();
        try {
            IReplicationOrderedPacket lastPacket = replicatedPackets.get(replicatedPackets.size() - 1);
            this.handlePendingErrorBatchPackets(memberName, replicatedPackets, error, lastPacket.getKey());
        }
        finally {
            this._rwLock.writeLock().unlock();
        }
    }

    protected String getLogPrefix() {
        return "Replication [" + this._name + "] group [" + this._groupName + "]: ";
    }

    protected void logPendingErrorResolved(String memberName, Throwable error) {
        this.logEventInHistory(memberName, "Pending error [" + JSpaceUtilities.getRootCauseException(error) + "] is resolved");
    }

    protected void handlePendingErrorBatchPackets(String memberName, List<IReplicationOrderedPacket> packets, Throwable error, long potentialLastUnprocessedKey) {
        CType confirmationHolder = this.getConfirmationHolderUnsafe(memberName);
        if (((AbstractSingleFileConfirmationHolder)confirmationHolder).hasPendingError() && potentialLastUnprocessedKey <= ((AbstractSingleFileConfirmationHolder)confirmationHolder).getPendingErrorKey()) {
            return;
        }
        Logger channelLogger = ReplicationLogUtils.createChannelSpecificLogger(this._name, memberName, this._groupName);
        if (channelLogger.isLoggable(Level.SEVERE)) {
            channelLogger.log(Level.SEVERE, "Error while replicating packets [" + this.toString(packets) + "]", error);
        }
        this.logEventInHistory(memberName, "Replication error encountered [" + JSpaceUtilities.getStackTrace(JSpaceUtilities.getRootCauseException(error)) + "] while replicating [" + packets + "]" + StringUtils.NEW_LINE + "Backlog position of error [" + potentialLastUnprocessedKey + "]");
        if (!((AbstractSingleFileConfirmationHolder)confirmationHolder).setPendingError(potentialLastUnprocessedKey, error)) {
            this.logPendingErrorResolved(memberName, error);
        }
    }

    protected String toString(List<IReplicationOrderedPacket> packets) {
        if (packets.size() < 5) {
            return String.valueOf(packets);
        }
        StringBuilder sb = new StringBuilder();
        sb.append("[size:").append(packets.size()).append(", ");
        this.addPacket(sb, packets.get(0));
        sb.append(", ");
        this.addPacket(sb, packets.get(1));
        sb.append(" ... ");
        this.addPacket(sb, packets.get(packets.size() - 2));
        sb.append(", ");
        this.addPacket(sb, packets.get(packets.size() - 1));
        sb.append("]");
        return sb.toString();
    }

    private void addPacket(StringBuilder sb, IReplicationOrderedPacket iReplicationOrderedPacket) {
        sb.append(String.valueOf(iReplicationOrderedPacket));
    }

    protected void handlePendingErrorSinglePacket(String memberName, IReplicationOrderedPacket packet, Throwable error) {
        CType confirmationHolder = this.getConfirmationHolderUnsafe(memberName);
        if (((AbstractSingleFileConfirmationHolder)confirmationHolder).hasPendingError() && packet.getKey() <= ((AbstractSingleFileConfirmationHolder)confirmationHolder).getPendingErrorKey()) {
            return;
        }
        this.logEventInHistory(memberName, "Replication error encountered [" + JSpaceUtilities.getStackTrace(JSpaceUtilities.getRootCauseException(error)) + "] while replicating [" + packet + "]" + StringUtils.NEW_LINE + "Backlog position of error [" + packet.getKey() + "]");
        if (!((AbstractSingleFileConfirmationHolder)confirmationHolder).setPendingError(packet.getKey(), error)) {
            this.logPendingErrorResolved(memberName, error);
        }
    }

    protected void cleanPendingErrorStateIfNeeded(String memberName, long packetKeykey, AbstractSingleFileConfirmationHolder confirmationHolder) {
        if (confirmationHolder.hasPendingError() && packetKeykey >= confirmationHolder.getPendingErrorKey()) {
            Throwable pendingError = confirmationHolder.getPendingError();
            this.logPendingErrorResolved(memberName, pendingError);
            confirmationHolder.clearPendingError();
            Logger channelLogger = ReplicationLogUtils.createChannelSpecificLogger(this._name, memberName, this._groupName);
            if (channelLogger.isLoggable(Level.INFO)) {
                channelLogger.info("Pending error [" + JSpaceUtilities.getRootCauseException(pendingError) + "] is resolved");
            }
        }
    }

    protected void setPacketWeight(IReplicationPacketData<?> data) {
        data.setWeight(((SourceGroupConfig)this.getGroupConfigSnapshot()).getBacklogConfig().getBackLogWeightPolicy().calculateWeight(data));
    }

    protected boolean shouldInsertPacket(IReplicationPacketData<?> data) {
        if (this.isBacklogDroppedEntirely()) {
            if (this._logger.isLoggable(Level.FINEST)) {
                this._logger.finest(this.getLogPrefix() + "backlog is dropped, skipping insertion of data");
            }
            return false;
        }
        this.ensureLimit(data);
        if (this.isBacklogDroppedEntirely()) {
            if (this._logger.isLoggable(Level.FINEST)) {
                this._logger.finest(this.getLogPrefix() + "backlog is dropped, skipping insertion of data");
            }
            return false;
        }
        return true;
    }

    protected <T extends SourceGroupConfig> T getGroupConfigSnapshot() {
        return (T)this._groupConfigHolder.getConfig();
    }

    protected void appendConfirmationStateString(StringBuilder dump) {
        for (Map.Entry<String, CType> memberConfirmation : this._confirmationMap.entrySet()) {
            dump.append(StringUtils.NEW_LINE);
            dump.append("Member [");
            dump.append(memberConfirmation.getKey());
            dump.append("] Confirmation state [");
            dump.append(memberConfirmation.getValue());
            dump.append("]");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T getSpecificPacket(long packetKey) {
        this._rwLock.readLock().lock();
        try {
            block8: {
                long firstKeyInBacklog = this.getFirstKeyInBacklogInternal();
                long packetIndex = packetKey - firstKeyInBacklog;
                long size = this.calculateSizeUnsafe();
                if (packetIndex < size) {
                    ReadOnlyIterator<T> readOnlyIterator = this._backlogFile.readOnlyIterator(packetIndex);
                    IReplicationOrderedPacket firstPacket = (IReplicationOrderedPacket)readOnlyIterator.next();
                    if (firstPacket == null) break block8;
                    IReplicationOrderedPacket iReplicationOrderedPacket = firstPacket;
                    return (T)iReplicationOrderedPacket;
                    finally {
                        readOnlyIterator.close();
                    }
                }
            }
            T t = null;
            return t;
        }
        finally {
            this._rwLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<T> getSpecificPackets(long startPacketKey, long endPacketKey) {
        this._rwLock.readLock().lock();
        try {
            List<T> list = this.getSpecificPacketsUnsafe(startPacketKey, endPacketKey);
            return list;
        }
        finally {
            this._rwLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<T> getSpecificPacketsUnsafe(long startPacketKey, long endPacketKey) {
        long firstKeyInBacklog = this.getFirstKeyInBacklogInternal();
        long packetIndex = startPacketKey - firstKeyInBacklog;
        long size = this.calculateSizeUnsafe();
        LinkedList<IReplicationOrderedPacket> packets = new LinkedList<IReplicationOrderedPacket>();
        if (packetIndex < size) {
            try (ReadOnlyIterator<T> readOnlyIterator = this._backlogFile.readOnlyIterator(packetIndex);){
                while (readOnlyIterator.hasNext()) {
                    IReplicationOrderedPacket packet = (IReplicationOrderedPacket)readOnlyIterator.next();
                    if (packet.getKey() > endPacketKey) {
                        break;
                    }
                    packets.add(packet);
                }
            }
        }
        return packets;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<IReplicationOrderedPacket> getPacketsWithFullSerializedContent(long fromKey, long upToKey, int maxWeight) {
        LinkedList<IReplicationOrderedPacket> packets = new LinkedList<IReplicationOrderedPacket>();
        this._rwLock.readLock().lock();
        try {
            long firstKeyInBacklogInternal = this.getFirstKeyInBacklogInternal();
            long startIndex = Math.max(0L, fromKey - firstKeyInBacklogInternal);
            int weightSum = 0;
            try (ReadOnlyIterator<T> iterator = this.getBacklogFile().readOnlyIterator(startIndex);){
                while (iterator.hasNext() && weightSum < maxWeight) {
                    IReplicationOrderedPacket packet = (IReplicationOrderedPacket)iterator.next();
                    if (packet.getKey() > upToKey) {
                        break;
                    }
                    if (packet.getWeight() > maxWeight && weightSum == 0) {
                        if (this._logger.isLoggable(Level.WARNING)) {
                            this._logger.log(Level.WARNING, this.getLogPrefix() + "replicating a packet which is bigger than the batch size, [packet key=" + packet.getKey() + ", packet weight=" + packet.getWeight() + ", backlog batch size = " + maxWeight + "]\n" + this.getStatistics() + "]");
                        }
                    } else if (weightSum + packet.getWeight() > maxWeight) {
                        break;
                    }
                    weightSum += packet.getWeight();
                    packet = packet.clone();
                    IReplicationPacketData<?> data = packet.getData();
                    for (IReplicationPacketEntryData entryData : data) {
                        this.getDataProducer().setSerializeWithFullContent(entryData);
                    }
                    packets.add(packet);
                }
            }
        }
        finally {
            this._rwLock.readLock().unlock();
        }
        return packets;
    }

    private void setMarkerIfNeeded(ReplicationOutContext outContext) {
        String groupName = outContext.getAskedMarker();
        if (groupName != null) {
            IMarker marker = this.getNextPacketMarker(groupName);
            outContext.setMarker(marker);
        }
    }

    protected void insertReplicationOrderedPacketToBacklog(T packet, ReplicationOutContext outContext) {
        this.getBacklogFile().add(packet);
        this.increaseAllMembersWeight(packet.getWeight(), packet.getKey());
        this.setMarkerIfNeeded(outContext);
        if (outContext.getDirectPesistencySyncHandler() != null && outContext.getDirectPesistencySyncHandler().getBackLog() == null) {
            outContext.getDirectPesistencySyncHandler().setBackLog(this);
        }
    }

    @Override
    public void writeLock() {
        this._rwLock.writeLock().lock();
    }

    @Override
    public void freeWriteLock() {
        this._rwLock.writeLock().unlock();
    }

    @Override
    public long getWeight() {
        this._rwLock.readLock().lock();
        try {
            long l = this.getWeightUnsafe();
            return l;
        }
        finally {
            this._rwLock.readLock().unlock();
        }
    }

    private long getWeightUnsafe() {
        return this.getBacklogFile().getWeight();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getWeight(String memberName) {
        this._rwLock.readLock().lock();
        try {
            long l = this.getWeightUnsafe(memberName);
            return l;
        }
        finally {
            this._rwLock.readLock().unlock();
        }
    }

    public long getWeightUnsafe(String memberName) {
        return ((AbstractSingleFileConfirmationHolder)this._confirmationMap.get(memberName)).getCalculatedWeight();
    }

    @Override
    public void increaseWeight(String memberName, long weight, AbstractSingleFileConfirmationHolder confirmationHolder) {
        confirmationHolder.setWeight(confirmationHolder.getWeight() + weight);
    }

    @Override
    public void decreaseWeight(String memberName, long lastConfirmedKey, long newlyConfirmedKey, AbstractSingleFileConfirmationHolder confirmationHolder) {
        long weight = 0L;
        if (newlyConfirmedKey == -1L || newlyConfirmedKey - lastConfirmedKey <= 0L || newlyConfirmedKey > this.getLastInsertedKeyToBacklogUnsafe()) {
            return;
        }
        if (newlyConfirmedKey == this.getLastInsertedKeyToBacklogUnsafe()) {
            confirmationHolder.setWeight(0L);
            return;
        }
        weight = lastConfirmedKey < this.getFirstKeyInBacklogInternal() ? this.getWeightForRangeUnsafe(this.getFirstKeyInBacklogInternal(), newlyConfirmedKey) : this.getWeightForRangeUnsafe(lastConfirmedKey + 1L, newlyConfirmedKey);
        confirmationHolder.setWeight(confirmationHolder.getWeight() - weight);
    }

    protected void decreaseWeightToAllMembersFromOldestPacket(long toKey) {
        for (Map.Entry<String, CType> entry : this._confirmationMap.entrySet()) {
            String memberName = entry.getKey();
            AbstractSingleFileConfirmationHolder holder = (AbstractSingleFileConfirmationHolder)entry.getValue();
            this.decreaseWeight(memberName, this.getLastConfirmedKeyUnsafe(memberName), toKey, holder);
        }
    }

    private long getWeightForRangeUnsafe(long fromKey, long toKey) {
        if (this._groupConfigHolder.getConfig().getBacklogConfig().getBackLogWeightPolicy() instanceof FixedBacklogWeightPolicy) {
            return toKey - fromKey + 1L;
        }
        List<T> packets = this.getSpecificPacketsUnsafe(fromKey, toKey);
        long weight = 0L;
        for (IReplicationOrderedPacket packet : packets) {
            weight += (long)packet.getWeight();
        }
        return weight;
    }

    protected void increaseAllMembersWeight(long weight, long key) {
        for (Map.Entry<String, CType> entry : this._confirmationMap.entrySet()) {
            AbstractSingleFileConfirmationHolder confirmationHolder = (AbstractSingleFileConfirmationHolder)entry.getValue();
            if (confirmationHolder.getLastConfirmedKey() >= key) continue;
            this.increaseWeight(entry.getKey(), weight, confirmationHolder);
        }
    }

    public void printRedoLog(String _name, String from) {
        this._logger.info("----------------------------------------------");
        this._logger.info(from);
        this._logger.info("");
        ReadOnlyIterator<T> iterator = this._backlogFile.readOnlyIterator(0L);
        while (iterator.hasNext()) {
            IReplicationOrderedPacket t = (IReplicationOrderedPacket)iterator.next();
            System.out.println(t);
        }
        this._logger.info("");
        this._logger.info("confirmation map :");
        this._logger.info("");
        this.printConfirmationMap();
        this._logger.info("----------------------------------------------");
    }

    private void printConfirmationMap() {
        for (Map.Entry<String, CType> stringCTypeEntry : this._confirmationMap.entrySet()) {
            String mirror = String.valueOf(stringCTypeEntry.getKey().equalsIgnoreCase(this._mirrorMemberName) ? ", discarded count = " + ((AbstractSingleFileConfirmationHolder)stringCTypeEntry.getValue()).getDiscardedPacketsCount() : "");
            this._logger.info("target: " + stringCTypeEntry.getKey() + ", member limit = " + ((SourceGroupConfig)this.getGroupConfigSnapshot()).getBacklogConfig().getLimit(stringCTypeEntry.getKey()) + " weight = " + ((AbstractSingleFileConfirmationHolder)stringCTypeEntry.getValue()).getCalculatedWeight() + ", lastConfirmed = " + ((AbstractSingleFileConfirmationHolder)stringCTypeEntry.getValue()).getLastConfirmedKey() + mirror);
        }
    }

    public class CaluclateMinUnconfirmedKeyProcedure
    extends ICaluclateMinUnconfirmedKey {
        private long minUnconfirmedKey;

        @Override
        public void reset() {
            this.minUnconfirmedKey = Long.MAX_VALUE;
        }

        @Override
        public long getMinUnconfirmedNonMirrorKey() {
            return -1L;
        }

        @Override
        public long getMinUnconfirmedMirrorKey() {
            return -1L;
        }

        @Override
        public long getCalculatedMinimumUnconfirmedKey() {
            return this.minUnconfirmedKey;
        }

        @Override
        public boolean execute(String memberLookupName, CType confirmation) {
            if (AbstractSingleFileGroupBacklog.this._outOfSyncDueToDeletionTargets.contains(memberLookupName)) {
                return true;
            }
            long memberConfirmedKey = AbstractSingleFileGroupBacklog.this.getMemberUnconfirmedKey(confirmation);
            if (memberConfirmedKey == -1L) {
                this.minUnconfirmedKey = -1L;
                return false;
            }
            long memberUnconfirmed = memberConfirmedKey + 1L;
            if (memberUnconfirmed < this.minUnconfirmedKey) {
                this.minUnconfirmedKey = memberUnconfirmed;
            }
            return true;
        }
    }

    public class CompactionEnabledCaluclateMinUnconfirmedKeyProcedure
    extends ICaluclateMinUnconfirmedKey {
        private long minUnconfirmedNonMirrorKey;
        private long minUnconfirmedMirrorKey;

        @Override
        public void reset() {
            this.minUnconfirmedNonMirrorKey = Long.MAX_VALUE;
            this.minUnconfirmedMirrorKey = -1L;
        }

        @Override
        public long getCalculatedMinimumUnconfirmedKey() {
            if (this.minUnconfirmedNonMirrorKey < this.minUnconfirmedMirrorKey) {
                return this.minUnconfirmedNonMirrorKey;
            }
            return this.minUnconfirmedMirrorKey;
        }

        @Override
        public long getMinUnconfirmedNonMirrorKey() {
            return this.minUnconfirmedNonMirrorKey;
        }

        @Override
        public long getMinUnconfirmedMirrorKey() {
            return this.minUnconfirmedMirrorKey;
        }

        @Override
        public boolean execute(String memberLookupName, CType confirmation) {
            if (AbstractSingleFileGroupBacklog.this._outOfSyncDueToDeletionTargets.contains(memberLookupName)) {
                return true;
            }
            long memberConfirmedKey = AbstractSingleFileGroupBacklog.this.getMemberUnconfirmedKey(confirmation);
            if (memberLookupName.equals(AbstractSingleFileGroupBacklog.this._mirrorMemberName)) {
                this.minUnconfirmedMirrorKey = memberConfirmedKey == -1L ? -1L : memberConfirmedKey + 1L;
                return true;
            }
            if (memberConfirmedKey == -1L) {
                this.minUnconfirmedNonMirrorKey = -1L;
                return true;
            }
            long memberUnconfirmed = memberConfirmedKey + 1L;
            if (memberUnconfirmed < this.minUnconfirmedNonMirrorKey) {
                this.minUnconfirmedNonMirrorKey = memberUnconfirmed;
            }
            return true;
        }
    }

    public abstract class ICaluclateMinUnconfirmedKey
    implements MapProcedure<String, CType> {
        public abstract void reset();

        public abstract long getCalculatedMinimumUnconfirmedKey();

        public abstract long getMinUnconfirmedNonMirrorKey();

        public abstract long getMinUnconfirmedMirrorKey();

        @Override
        public abstract boolean execute(String var1, CType var2);
    }

    private abstract class SynchronizedGauge
    extends Gauge<Long> {
        private SynchronizedGauge() {
        }

        @Override
        public Long getValue() throws Exception {
            AbstractSingleFileGroupBacklog.this._rwLock.readLock().lock();
            try {
                Long l = this.getValueImpl();
                return l;
            }
            finally {
                AbstractSingleFileGroupBacklog.this._rwLock.readLock().unlock();
            }
        }

        protected abstract Long getValueImpl();
    }
}

