/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.cluster.node.impl.backlog;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.cluster.node.impl.backlog.BacklogMemberLimitationConfig;
import com.gigaspaces.internal.cluster.node.impl.backlog.BacklogWeightPolicy;
import com.gigaspaces.internal.cluster.node.impl.backlog.BacklogWeightPolicyFactory;
import com.j_spaces.core.cluster.RedoLogCompaction;
import com.j_spaces.core.cluster.ReplicationPolicy;
import com.j_spaces.core.cluster.SwapBacklogConfig;
import java.util.HashMap;
import java.util.Map;

@InternalApi
public class BacklogConfig {
    public static final long UNLIMITED = -1L;
    protected static final LimitReachedPolicy DEFAULT_BACKLOG_REACHED_POLICY = LimitReachedPolicy.BLOCK_NEW;
    private String DEFAULT_BACKLOG_WEIGHT_POLICY = "accumulated";
    private RedoLogCompaction DEFAULT_REDO_LOG_COMPACTION = ReplicationPolicy.DEFAULT_REDO_LOG_COMPACTION;
    private final Map<String, Long> _memberLimitDuringSynchronization = new HashMap<String, Long>();
    private final Map<String, Long> _membersLimit = new HashMap<String, Long>();
    private final Map<String, LimitReachedPolicy> _membersLimitReachedPolicy = new HashMap<String, LimitReachedPolicy>();
    private final Map<String, LimitReachedPolicy> _memberLimitDuringSynchronizationReachedPolicy = new HashMap<String, LimitReachedPolicy>();
    private int _limitedMemoryCapacity = -1;
    private SwapBacklogConfig _swapBacklogConfig = new SwapBacklogConfig();
    private String _policy;
    private String _mirrorMemberName = null;
    private BacklogWeightPolicy _backlogWeightPolicy;
    private RedoLogCompaction _redoLogCompaction = this.DEFAULT_REDO_LOG_COMPACTION;

    public BacklogConfig() {
        this.setBackLogWeightPolicy(this.DEFAULT_BACKLOG_WEIGHT_POLICY);
    }

    public void setLimit(String memberLookupName, long limit, LimitReachedPolicy limitReachedPolicy) {
        this._membersLimit.put(memberLookupName, limit);
        this._membersLimitReachedPolicy.put(memberLookupName, limitReachedPolicy);
    }

    public long getLimit(String memberLookupName) {
        Long memberLimit = this._membersLimit.get(memberLookupName);
        if (memberLimit == null) {
            return -1L;
        }
        return memberLimit;
    }

    public void setUnlimited(String memberLookupName) {
        this._membersLimit.remove(memberLookupName);
        this._membersLimitReachedPolicy.remove(memberLookupName);
    }

    public boolean isLimited(String memberLookupName) {
        return this._membersLimit.containsKey(memberLookupName);
    }

    public LimitReachedPolicy getLimitReachedPolicy(String memberLookupName) {
        LimitReachedPolicy limitReachedPolicy = this._membersLimitReachedPolicy.get(memberLookupName);
        if (limitReachedPolicy != null) {
            return limitReachedPolicy;
        }
        return DEFAULT_BACKLOG_REACHED_POLICY;
    }

    public void setUnlimitedDuringSynchronization(String memberName) {
        this._memberLimitDuringSynchronization.remove(memberName);
        this._memberLimitDuringSynchronizationReachedPolicy.remove(memberName);
    }

    public boolean isLimitedDuringSynchronization(String memberName) {
        return this._memberLimitDuringSynchronization.containsKey(memberName);
    }

    public void setLimitDuringSynchronization(String memberName, long limit, LimitReachedPolicy limitReachedPolicy) {
        this._memberLimitDuringSynchronization.put(memberName, limit);
        this._memberLimitDuringSynchronizationReachedPolicy.put(memberName, limitReachedPolicy);
    }

    public long getLimitDuringSynchronization(String memberName) {
        Long limit = this._memberLimitDuringSynchronization.get(memberName);
        if (limit == null) {
            return -1L;
        }
        return limit;
    }

    public LimitReachedPolicy getLimitDuringSynchronizationReachedPolicy(String memberLookupName) {
        LimitReachedPolicy limitReachedPolicy = this._memberLimitDuringSynchronizationReachedPolicy.get(memberLookupName);
        if (limitReachedPolicy != null) {
            return limitReachedPolicy;
        }
        return DEFAULT_BACKLOG_REACHED_POLICY;
    }

    public void setMemberBacklogLimitation(String memberName, BacklogMemberLimitationConfig memberLimitationConfig) {
        this.validate(memberName, memberLimitationConfig);
        if (memberLimitationConfig.isLimited()) {
            this.setLimit(memberName, memberLimitationConfig.getLimit(), memberLimitationConfig.getLimitReachedPolicy());
        } else {
            this.setUnlimited(memberName);
        }
        if (memberLimitationConfig.isLimitedDuringSynchronization()) {
            this.setLimitDuringSynchronization(memberName, memberLimitationConfig.getLimitDuringSynchronization(), memberLimitationConfig.getLimitReachedPolicyDuringSynchronization());
        } else {
            this.setUnlimitedDuringSynchronization(memberName);
        }
    }

    private void validate(String memberName, BacklogMemberLimitationConfig memberLimitationConfig) {
        if (!memberLimitationConfig.isLimitedDuringSynchronization()) {
            return;
        }
        if (!memberLimitationConfig.isLimited() || memberLimitationConfig.getLimit() > memberLimitationConfig.getLimitDuringSynchronization()) {
            throw new IllegalStateException("Illegal replication backlog limitations configuration for member [" + memberName + "], cannot specify backlog limitation during synchronization process [" + this.limitationToString(memberLimitationConfig.getLimitDuringSynchronization()) + "] which is lower than the global limitations [" + this.limitationToString(memberLimitationConfig.getLimit()) + "]");
        }
    }

    private String limitationToString(long limitDuringSynchronization) {
        return "" + (limitDuringSynchronization == -1L ? "UNLIMITED" : Long.valueOf(limitDuringSynchronization));
    }

    public BacklogMemberLimitationConfig getBacklogMemberLimitation(String memberName) {
        BacklogMemberLimitationConfig config = new BacklogMemberLimitationConfig();
        if (this.isLimited(memberName)) {
            config.setLimit(this.getLimit(memberName), this.getLimitReachedPolicy(memberName));
        } else {
            config.setUnlimited();
        }
        if (this.isLimitedDuringSynchronization(memberName)) {
            config.setLimitDuringSynchronization(this.getLimitDuringSynchronization(memberName), this.getLimitDuringSynchronizationReachedPolicy(memberName));
        } else {
            config.setUnlimitedDuringSynchronization();
        }
        return config;
    }

    public boolean isLimitedMemoryCapacity() {
        return (long)this._limitedMemoryCapacity != -1L;
    }

    public void setLimitedMemoryCapacity(int limitedMemoryCapacity) {
        this._limitedMemoryCapacity = limitedMemoryCapacity;
    }

    public int getLimitedMemoryCapacity() {
        return this._limitedMemoryCapacity;
    }

    public void setUnlimitedMemoryCapacity() {
        this._limitedMemoryCapacity = -1;
    }

    public void setSwapBacklogConfig(SwapBacklogConfig swapBacklogConfig) {
        this._swapBacklogConfig = swapBacklogConfig;
    }

    public String getMirrorMemberName() {
        return this._mirrorMemberName;
    }

    public void setMirrorMemberName(String _mirrorMemberName) {
        this._mirrorMemberName = _mirrorMemberName;
    }

    public RedoLogCompaction getRedoLogCompaction() {
        return this._redoLogCompaction;
    }

    public void setRedoLogCompaction(RedoLogCompaction _redoLogCompaction) {
        this._redoLogCompaction = _redoLogCompaction;
    }

    public SwapBacklogConfig getSwapBacklogConfig() {
        return this._swapBacklogConfig;
    }

    public BacklogConfig clone() {
        BacklogConfig clone = new BacklogConfig();
        clone.overrideWithOther(this);
        return clone;
    }

    public void removeMemberConfig(String memberName) {
        this._memberLimitDuringSynchronization.remove(memberName);
        this._membersLimit.remove(memberName);
        this._membersLimitReachedPolicy.remove(memberName);
        this._memberLimitDuringSynchronizationReachedPolicy.remove(memberName);
    }

    protected void overrideWithOther(BacklogConfig other) {
        this._membersLimit.putAll(other._membersLimit);
        this._memberLimitDuringSynchronization.putAll(other._memberLimitDuringSynchronization);
        this._membersLimitReachedPolicy.putAll(other._membersLimitReachedPolicy);
        this._memberLimitDuringSynchronizationReachedPolicy.putAll(other._memberLimitDuringSynchronizationReachedPolicy);
        this.setLimitedMemoryCapacity(other.getLimitedMemoryCapacity());
        this.setSwapBacklogConfig(other.getSwapBacklogConfig());
        this.setBackLogWeightPolicy(other._policy);
    }

    public String toString() {
        return "BacklogConfig [_memberLimitDuringSynchronization=" + this._memberLimitDuringSynchronization + ", _membersLimit=" + this._membersLimit + ", _membersLimitReachedPolicy=" + this._membersLimitReachedPolicy + ", _memberLimitDuringSynchronizationReachedPolicy=" + this._memberLimitDuringSynchronizationReachedPolicy + ", _limitedMemoryCapacity=" + this._limitedMemoryCapacity + ", _swapBacklogConfig=" + this._swapBacklogConfig + "]";
    }

    public BacklogWeightPolicy getBackLogWeightPolicy() {
        return this._backlogWeightPolicy;
    }

    public void setBackLogWeightPolicy(String policy) {
        if (this._policy == null || !this._policy.equals(policy)) {
            this._policy = policy;
            this._backlogWeightPolicy = BacklogWeightPolicyFactory.create(policy);
        }
    }

    public static enum LimitReachedPolicy {
        DROP_OLDEST(0),
        DROP_UNTIL_RESYNC(1),
        BLOCK_NEW(2),
        DROP_MEMBER(3);

        private final byte _code;

        private LimitReachedPolicy(byte code) {
            this._code = code;
        }

        public static LimitReachedPolicy fromCode(byte code) {
            switch (code) {
                case 0: {
                    return DROP_OLDEST;
                }
                case 1: {
                    return DROP_UNTIL_RESYNC;
                }
                case 2: {
                    return BLOCK_NEW;
                }
                case 3: {
                    return DROP_MEMBER;
                }
            }
            throw new IllegalArgumentException("illegal code " + code);
        }

        public byte getCode() {
            return this._code;
        }
    }
}

