/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.cluster.node.impl.backlog;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.cluster.node.impl.backlog.BacklogConfig;
import com.gigaspaces.internal.version.PlatformLogicalVersion;
import com.gigaspaces.lrmi.LRMIInvocationContext;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

@InternalApi
public class BacklogMemberLimitationConfig
implements Externalizable {
    private static final long serialVersionUID = 1L;
    private long _limit = -1L;
    private BacklogConfig.LimitReachedPolicy _limitReachedPolicy = BacklogConfig.LimitReachedPolicy.BLOCK_NEW;
    private long _limitDuringSynchronization = -1L;
    private BacklogConfig.LimitReachedPolicy _limitReachedPolicyDuringSynchronization = BacklogConfig.LimitReachedPolicy.BLOCK_NEW;

    public void setLimit(long limit, BacklogConfig.LimitReachedPolicy limitReachedPolicy) {
        this._limit = limit;
        this._limitReachedPolicy = limitReachedPolicy;
    }

    public void setUnlimited() {
        this._limit = -1L;
    }

    public boolean isLimited() {
        return this._limit != -1L;
    }

    public void setUnlimitedDuringSynchronization() {
        this._limitDuringSynchronization = -1L;
    }

    public boolean isLimitedDuringSynchronization() {
        return this._limitDuringSynchronization != -1L;
    }

    public void setLimitDuringSynchronization(long limit, BacklogConfig.LimitReachedPolicy limitReachedPolicy) {
        this._limitDuringSynchronization = limit;
        this._limitReachedPolicyDuringSynchronization = limitReachedPolicy;
    }

    public long getLimit() {
        return this._limit;
    }

    public long getLimitDuringSynchronization() {
        return this._limitDuringSynchronization;
    }

    public BacklogConfig.LimitReachedPolicy getLimitReachedPolicy() {
        return this._limitReachedPolicy;
    }

    public BacklogConfig.LimitReachedPolicy getLimitReachedPolicyDuringSynchronization() {
        return this._limitReachedPolicyDuringSynchronization;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeLong(this._limit);
        out.writeByte(this._limitReachedPolicy.getCode());
        out.writeLong(this._limitDuringSynchronization);
        if (LRMIInvocationContext.getEndpointLogicalVersion().greaterOrEquals(PlatformLogicalVersion.v9_7_0)) {
            out.writeByte(this._limitReachedPolicyDuringSynchronization.getCode());
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this._limit = in.readLong();
        this._limitReachedPolicy = BacklogConfig.LimitReachedPolicy.fromCode(in.readByte());
        this._limitDuringSynchronization = in.readLong();
        if (LRMIInvocationContext.getEndpointLogicalVersion().greaterOrEquals(PlatformLogicalVersion.v9_7_0)) {
            this._limitReachedPolicyDuringSynchronization = BacklogConfig.LimitReachedPolicy.fromCode(in.readByte());
        }
    }

    public String toString() {
        return "BacklogMemberLimitationConfig [_limit=" + this._limit + ", _limitReachedPolicy=" + (Object)((Object)this._limitReachedPolicy) + ", _limitDuringSynchronization=" + this._limitDuringSynchronization + ", _limitReachedPolicyDuringSynchronization=" + (Object)((Object)this._limitReachedPolicyDuringSynchronization) + "]";
    }
}

