/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.cluster.node.impl.backlog;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.cluster.node.impl.backlog.AbstractSingleFileGroupBacklog;
import com.gigaspaces.internal.cluster.node.impl.backlog.IReplicationGroupBacklog;
import com.gigaspaces.internal.cluster.node.impl.backlog.sync.IMarker;
import com.gigaspaces.internal.cluster.node.impl.backlog.sync.IMarkerWireForm;
import com.gigaspaces.internal.io.IOUtils;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Arrays;

@InternalApi
public class SingleFileBacklogGroupMarker
implements IMarker {
    private final AbstractSingleFileGroupBacklog<?, ?> _groupBacklog;
    private final String[] _memberNames;
    private final long _markedKey;

    public SingleFileBacklogGroupMarker(AbstractSingleFileGroupBacklog<?, ?> groupBacklog, String[] memberNames, long markedKey) {
        this._groupBacklog = groupBacklog;
        this._memberNames = memberNames;
        this._markedKey = markedKey;
    }

    @Override
    public boolean isMarkerReached() {
        for (String memberName : this._memberNames) {
            if (this._groupBacklog.isMarkerReached(memberName, this._markedKey)) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return "members=" + Arrays.toString(this._memberNames) + " key=" + this._markedKey;
    }

    @Override
    public IMarkerWireForm toWireForm() {
        return new SingleFileBacklogGroupMarkerWireForm(this._groupBacklog.getGroupName(), this._memberNames, this._markedKey);
    }

    public static class SingleFileBacklogGroupMarkerWireForm
    implements IMarkerWireForm {
        private static final long serialVersionUID = 1L;
        private String _groupName;
        private String[] _memberNames;
        private long _markedKey;

        public SingleFileBacklogGroupMarkerWireForm() {
        }

        public SingleFileBacklogGroupMarkerWireForm(String groupName, String[] memberNames, long markedKey) {
            this._groupName = groupName;
            this._memberNames = memberNames;
            this._markedKey = markedKey;
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            IOUtils.writeRepetitiveString(out, this._groupName);
            IOUtils.writeRepetitiveStringArray(out, this._memberNames);
            out.writeLong(this._markedKey);
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this._groupName = IOUtils.readRepetitiveString(in);
            this._memberNames = IOUtils.readRepetitiveStringArray(in);
            this._markedKey = in.readLong();
        }

        @Override
        public IMarker toFinalizedForm(IReplicationGroupBacklog backlog) {
            return new SingleFileBacklogGroupMarker((AbstractSingleFileGroupBacklog)backlog, this._memberNames, this._markedKey);
        }

        @Override
        public String getGroupName() {
            return this._groupName;
        }

        public String toString() {
            return "members=" + Arrays.toString(this._memberNames) + " key=" + this._markedKey;
        }
    }
}

